 
/*
 * $Id: convert.c,v 1.1 2001/09/26 14:06:47 simond Exp $
 */

#define _convert_c
#include <xmacros.h>
#include <tedsys.h>
#include <convert.h>
#include <convertp.h>

/* {{{ convert-tm-ver-info-list */

field_info convert_tmph_ver_info [] = {
  {CONVERT_TMPH_VER_CUR, "convert-tmph-cur-version"},
  {0, "convert-tmph-version-undefined"},
  {0, NULL}
  };

/* }}} */
/* {{{ convert-tm-type-info-list */

field_info convert_tmph_type_info [] = {
  {CONVERT_TMPH_TYPE_TC, "convert-tmph-type-telecommand-packet"},
  {CONVERT_TMPH_TYPE_TM, "convert-tmph-type-telemetry-packet"},
  {0, "convert-tmph-type-undefined"},
  {0, NULL}
  };

/* }}} */
/* {{{ convert-tm-pdh-flag-info-list */

field_info convert_tmph_pdf_header_flag_info [] = {
  {CONVERT_TMPH_PDF_FLAG_EMPTY, "convert-tmph-pdf-flag-empty-pdf"},
  {CONVERT_TMPH_PDF_FLAG_EXISTS, "convert-tmph-pdf-flag-pdf-exists"},
  {0, "convert-tmph-pdf-flag-pdf-undefined"},
  {0, NULL}
  };

/* }}} */
/* {{{ convert-tm-apid-info-list */

field_info convert_tmph_apid_info [] = {
  {CONVERT_TMPH_APID_HK, "convert-tmph-apid-hk-0x0701"},
  {CONVERT_TMPH_APID_N1, "convert-tmph-apid-n1-0x0703"},
  {CONVERT_TMPH_APID_N2, "convert-tmph-apid-n2-0x0703"},
  {CONVERT_TMPH_APID_N3, "convert-tmph-apid-n3-0x0703"},
  {CONVERT_TMPH_APID_B1, "convert-tmph-apid-b1-0x0714"},
  {CONVERT_TMPH_APID_B2, "convert-tmph-apid-b2-0x0724"},
  {CONVERT_TMPH_APID_B3, "convert-tmph-apid-b3-0x0734"},
  {0, "convert-tmph-apid-undefined"},
  {0, NULL}
  };

/* }}} */
/* {{{ convert-tm-segmentation-info-list */

field_info convert_tmph_seg_info [] = {
  {CONVERT_TMPH_SEG_FIRST, "convert-tmph-seg-first-of-2-or-more"},
  {CONVERT_TMPH_SEG_MIDDLE, "convert-tmph-seg-middle-of-3-or-more"},
  {CONVERT_TMPH_SEG_LAST, "convert-tmph-seg-last-of-2-or-more"},
  {CONVERT_TMPH_SEG_ALONE, "convert-tmph-seg-alone"},
  {0, "convert-tmph-seg-undefined"},
  {0, NULL}
  };

/* }}} */
/* {{{ convert-tmp-dfh-pfield-info-list */

field_info convert_tmp_dfh_pfield_info [] = {
  {CONVERT_TMP_PDF_PFIELD_20, "convert-tmp-pdf-pfield-0x20-tfield-1-0"},  
  {CONVERT_TMP_PDF_PFIELD_21, "convert-tmp-pdf-pfield-0x21-tfield-1-1"},
  {CONVERT_TMP_PDF_PFIELD_22, "convert-tmp-pdf-pfield-0x22-tfield-1-2"},  
  {CONVERT_TMP_PDF_PFIELD_23, "convert-tmp-pdf-pfield-0x23-tfield-1-3"},
  {CONVERT_TMP_PDF_PFIELD_24, "convert-tmp-pdf-pfield-0x24-tfield-2-0"},
  {CONVERT_TMP_PDF_PFIELD_25, "convert-tmp-pdf-pfield-0x25-tfield-2-1"},
  {CONVERT_TMP_PDF_PFIELD_26, "convert-tmp-pdf-pfield-0x26-tfield-2-2"},  
  {CONVERT_TMP_PDF_PFIELD_27, "convert-tmp-pdf-pfield-0x27-tfield-2-3"},
  {CONVERT_TMP_PDF_PFIELD_28, "convert-tmp-pdf-pfield-0x28-tfield-3-0"},  
  {CONVERT_TMP_PDF_PFIELD_29, "convert-tmp-pdf-pfield-0x29-tfield-3-1"},
  {CONVERT_TMP_PDF_PFIELD_2A, "convert-tmp-pdf-pfield-0x2a-tfield-3-2"},  
  {CONVERT_TMP_PDF_PFIELD_2B, "convert-tmp-pdf-pfield-0x2b-tfield-3-3"},
  {CONVERT_TMP_PDF_PFIELD_2C, "convert-tmp-pdf-pfield-0x2c-tfield-4-0"},  
  {CONVERT_TMP_PDF_PFIELD_2D, "convert-tmp-pdf-pfield-0x2d-tfield-4-1"},
  {CONVERT_TMP_PDF_PFIELD_2E, "convert-tmp-pdf-pfield-0x2e-tfield-4-2"},  
  {CONVERT_TMP_PDF_PFIELD_2F, "convert-tmp-pdf-pfield-0x2f-tfield-4-3"},
  {0, "convert-tmp-pdf-pfield-unknown"},
  {0, NULL}
  };

/* }}} */

/* {{{ convert-ddsp-spacecraft-info-list */

field_info convert_ddsp_spacecraft_info [] = {
  {CONVERT_CLUSTER_SCID_1, "convert-spacecraft-1"},
  {CONVERT_CLUSTER_SCID_2, "convert-spacecraft-2"},
  {CONVERT_CLUSTER_SCID_3, "convert-spacecraft-3"},
  {CONVERT_CLUSTER_SCID_4, "convert-spacecraft-4"},
  {0, "convert-spacecraft-unknown"},
  {0, NULL}
  };

/* }}} */
/* {{{ convert-ddsp-adid-info-list */

field_info convert_ddsp_adid_info [] = { 
  {CONVERT_DDSP_ADID_ECLUD001, "convert-ddsp-adid-eclud001"},
  {CONVERT_DDSP_ADID_ECLUD002, "convert-ddsp-adid-eclud002"},
  {CONVERT_DDSP_ADID_ECLUD003, "convert-ddsp-adid-eclud003"},
  {CONVERT_DDSP_ADID_ECLUD004, "convert-ddsp-adid-eclud004"},
  {CONVERT_DDSP_ADID_ECLUD005, "convert-ddsp-adid-eclud005"},
  {CONVERT_DDSP_ADID_ECLUD006, "convert-ddsp-adid-eclud006"},
  {CONVERT_DDSP_ADID_ECLUD007, "convert-ddsp-adid-eclud007"},

  /* AUX */                  
  {CONVERT_DDSP_ADID_ECLUA001, "convert-ddsp-adid-eclua001-1"},  /* LTOF */
  {CONVERT_DDSP_ADID_ECLUA002, "convert-ddsp-adid-eclua002-2"},  /* LTEF */
  {CONVERT_DDSP_ADID_ECLUA003, "convert-ddsp-adid-eclua003-3"},  /* STOF */
  {CONVERT_DDSP_ADID_ECLUA004, "convert-ddsp-adid-eclua004-4"},  /* STEF */
  {CONVERT_DDSP_ADID_ECLUA005, "convert-ddsp-adid-eclua005-5"},  /* SATT */
  {CONVERT_DDSP_ADID_ECLUA006, "convert-ddsp-adid-eclua006-6"},  /* TCAL */
  {CONVERT_DDSP_ADID_ECLUA007, "convert-ddsp-adid-eclua007-7"},  /* CMDH */

  {CONVERT_DDSP_ADID_ECLUP101, "convert-ddsp-adid-eclup101-200"},  /* HKEDI */
  {CONVERT_DDSP_ADID_ECLUP102, "convert-ddsp-adid-eclup102-201"},  /* HKFGM */
  {CONVERT_DDSP_ADID_ECLUP103, "convert-ddsp-adid-eclup103-202"}, /* HKCIS */
  {CONVERT_DDSP_ADID_ECLUP104, "convert-ddsp-adid-eclup104-203"}, /* HKPEACE */
  {CONVERT_DDSP_ADID_ECLUP105, "convert-ddsp-adid-eclup105-204"}, /* HKRAPID */
  {CONVERT_DDSP_ADID_ECLUP106, "convert-ddsp-adid-eclup106-205"}, /* HKWEC */
  {CONVERT_DDSP_ADID_ECLUP107, "convert-ddsp-adid-eclup107-206"}, /* HKASPOC */
  {CONVERT_DDSP_ADID_ECLUP108, "convert-ddsp-adid-eclup108-207"}, /* HKSC */
	                         
  {CONVERT_DDSP_ADID_ECLUP201, "convert-ddsp-adid-eclup201-208"},  /* HKEDI */
  {CONVERT_DDSP_ADID_ECLUP202, "convert-ddsp-adid-eclup202-209"},  /* HKFGM */
  {CONVERT_DDSP_ADID_ECLUP203, "convert-ddsp-adid-eclup203-210"}, /* HKCIS */
  {CONVERT_DDSP_ADID_ECLUP204, "convert-ddsp-adid-eclup204-211"}, /* HKPEACE */
  {CONVERT_DDSP_ADID_ECLUP205, "convert-ddsp-adid-eclup205-212"}, /* HKRAPID */
  {CONVERT_DDSP_ADID_ECLUP206, "convert-ddsp-adid-eclup206-213"}, /* HKWEC */
  {CONVERT_DDSP_ADID_ECLUP207, "convert-ddsp-adid-eclup207-214"}, /* HKASPOC */
  {CONVERT_DDSP_ADID_ECLUP208, "convert-ddsp-adid-eclup208-215"}, /* HKSC */

  {CONVERT_DDSP_ADID_ECLUP301, "convert-ddsp-adid-eclup301-216"},  /* HKEDI */
  {CONVERT_DDSP_ADID_ECLUP302, "convert-ddsp-adid-eclup302-217"},  /* HKFGM */
  {CONVERT_DDSP_ADID_ECLUP303, "convert-ddsp-adid-eclup303-218"}, /* HKCIS */
  {CONVERT_DDSP_ADID_ECLUP304, "convert-ddsp-adid-eclup304-219"}, /* HKPEACE */
  {CONVERT_DDSP_ADID_ECLUP305, "convert-ddsp-adid-eclup305-220"}, /* HKRAPID */
  {CONVERT_DDSP_ADID_ECLUP306, "convert-ddsp-adid-eclup306-221"}, /* HKWEC */
  {CONVERT_DDSP_ADID_ECLUP307, "convert-ddsp-adid-eclup307-222"}, /* HKASPOC */
  {CONVERT_DDSP_ADID_ECLUP308, "convert-ddsp-adid-eclup308-223"}, /* HKSC */

  {CONVERT_DDSP_ADID_ECLUP401, "convert-ddsp-adid-eclup401-224"},  /* HKEDI */
  {CONVERT_DDSP_ADID_ECLUP402, "convert-ddsp-adid-eclup402-225"},  /* HKFGM */
  {CONVERT_DDSP_ADID_ECLUP403, "convert-ddsp-adid-eclup403-226"}, /* HKCIS */
  {CONVERT_DDSP_ADID_ECLUP404, "convert-ddsp-adid-eclup404-227"}, /* HKPEACE */
  {CONVERT_DDSP_ADID_ECLUP405, "convert-ddsp-adid-eclup405-228"}, /* HKRAPID */
  {CONVERT_DDSP_ADID_ECLUP406, "convert-ddsp-adid-eclup406-229"}, /* HKWEC */
  {CONVERT_DDSP_ADID_ECLUP407, "convert-ddsp-adid-eclup407-230"}, /* HKASPOC */
  {CONVERT_DDSP_ADID_ECLUP408, "convert-ddsp-adid-eclup408-231"}, /* HKSC */
  
  /* NSD CLUSTER 0 */
  {CONVERT_DDSP_ADID_ECLUN001, "convert-ddsp-adid-eclun001--1"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUN002, "convert-ddsp-adid-eclun002--1"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUN003, "convert-ddsp-adid-eclun003--1"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUN004, "convert-ddsp-adid-eclun004--1"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUN005, "convert-ddsp-adid-eclun005--1"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUN006, "convert-ddsp-adid-eclun006--1"}, /* WEC */

  /* BSD CLUSTER 0 */
  {CONVERT_DDSP_ADID_ECLUB001, "convert-ddsp-adid-eclub001--1"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUB002, "convert-ddsp-adid-eclub002--1"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUB003, "convert-ddsp-adid-eclub003--1"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUB004, "convert-ddsp-adid-eclub004--1"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUB005, "convert-ddsp-adid-eclub005--1"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUB006, "convert-ddsp-adid-eclub006--1"}, /* WEC */

  /* HKD CLUSTER 0 */
  {CONVERT_DDSP_ADID_ECLUH001, "convert-ddsp-adid-ecluh001--1"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUH002, "convert-ddsp-adid-ecluh002--1"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUH003, "convert-ddsp-adid-ecluh003--1"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUH004, "convert-ddsp-adid-ecluh004--1"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUH005, "convert-ddsp-adid-ecluh005--1"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUH006, "convert-ddsp-adid-ecluh006--1"}, /* WEC */
  {CONVERT_DDSP_ADID_ECLUH007, "convert-ddsp-adid-ecluh007--1"}, /* ASPOC */
  {CONVERT_DDSP_ADID_ECLUH008, "convert-ddsp-adid-ecluh008--1"}, /* SC */
  
  /* NSD CLUSTER 1 */
  {CONVERT_DDSP_ADID_ECLUN101, "convert-ddsp-adid-eclun101-30"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUN102, "convert-ddsp-adid-eclun102-31"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUN103, "convert-ddsp-adid-eclun103-32"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUN104, "convert-ddsp-adid-eclun104-33"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUN105, "convert-ddsp-adid-eclun105-34"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUN106, "convert-ddsp-adid-eclun106-35"}, /* WEC */
  
  /* BSD CLUSTER 1 */
  {CONVERT_DDSP_ADID_ECLUB101, "convert-ddsp-adid-eclub101-37"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUB102, "convert-ddsp-adid-eclub102-38"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUB103, "convert-ddsp-adid-eclub103-39"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUB104, "convert-ddsp-adid-eclub104-40"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUB105, "convert-ddsp-adid-eclub105-41"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUB106, "convert-ddsp-adid-eclub106-42"}, /* WEC */
  
  /* HKD CLUSTER 1 */
  {CONVERT_DDSP_ADID_ECLUH101, "convert-ddsp-adid-ecluh101-44"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUH102, "convert-ddsp-adid-ecluh102-45"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUH103, "convert-ddsp-adid-ecluh103-46"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUH104, "convert-ddsp-adid-ecluh104-47"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUH105, "convert-ddsp-adid-ecluh105-48"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUH106, "convert-ddsp-adid-ecluh106-49"}, /* WEC */
  {CONVERT_DDSP_ADID_ECLUH107, "convert-ddsp-adid-ecluh107-50"}, /* ASPOC */
  {CONVERT_DDSP_ADID_ECLUH108, "convert-ddsp-adid-ecluh108-51"}, /* SC */
  
  /* NSD CLUSTER 2 */
  {CONVERT_DDSP_ADID_ECLUN201, "convert-ddsp-adid-eclun201-70"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUN202, "convert-ddsp-adid-eclun202-71"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUN203, "convert-ddsp-adid-eclun203-72"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUN204, "convert-ddsp-adid-eclun204-73"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUN205, "convert-ddsp-adid-eclun205-74"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUN206, "convert-ddsp-adid-eclun206-75"}, /* WEC */
  
  /* BSD CLUSTER 2 */
  {CONVERT_DDSP_ADID_ECLUB201, "convert-ddsp-adid-eclub201-77"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUB202, "convert-ddsp-adid-eclub202-78"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUB203, "convert-ddsp-adid-eclub203-79"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUB204, "convert-ddsp-adid-eclub204-80"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUB205, "convert-ddsp-adid-eclub205-81"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUB206, "convert-ddsp-adid-eclub206-82"}, /* WEC */
  
  /* HKD CLUSTER 2 */
  {CONVERT_DDSP_ADID_ECLUH201, "convert-ddsp-adid-ecluh201-84"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUH202, "convert-ddsp-adid-ecluh202-85"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUH203, "convert-ddsp-adid-ecluh203-86"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUH204, "convert-ddsp-adid-ecluh204-87"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUH205, "convert-ddsp-adid-ecluh205-88"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUH206, "convert-ddsp-adid-ecluh206-89"}, /* WEC */
  {CONVERT_DDSP_ADID_ECLUH207, "convert-ddsp-adid-ecluh207-90"}, /* ASPOC */
  {CONVERT_DDSP_ADID_ECLUH208, "convert-ddsp-adid-ecluh208-91"}, /* SC */
  
  /* NSD CLUSTER 3 */        
  {CONVERT_DDSP_ADID_ECLUN301, "convert-ddsp-adid-eclun301-110"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUN302, "convert-ddsp-adid-eclun302-111"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUN303, "convert-ddsp-adid-eclun303-112"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUN304, "convert-ddsp-adid-eclun304-113"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUN305, "convert-ddsp-adid-eclun305-114"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUN306, "convert-ddsp-adid-eclun306-115"}, /* WEC */
  
  /* BSD CLUSTER 3 */
  {CONVERT_DDSP_ADID_ECLUB301, "convert-ddsp-adid-eclub301-117"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUB302, "convert-ddsp-adid-eclub302-118"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUB303, "convert-ddsp-adid-eclub303-119"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUB304, "convert-ddsp-adid-eclub304-120"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUB305, "convert-ddsp-adid-eclub305-121"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUB306, "convert-ddsp-adid-eclub306-122"}, /* WEC */
  
  /* HKD CLUSTER 3*/
  {CONVERT_DDSP_ADID_ECLUH301, "convert-ddsp-adid-ecluh301-124"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUH302, "convert-ddsp-adid-ecluh302-125"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUH303, "convert-ddsp-adid-ecluh303-126"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUH304, "convert-ddsp-adid-ecluh304-127"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUH305, "convert-ddsp-adid-ecluh305-128"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUH306, "convert-ddsp-adid-ecluh306-129"}, /* WEC */
  {CONVERT_DDSP_ADID_ECLUH307, "convert-ddsp-adid-ecluh307-130"}, /* ASPOC */
  {CONVERT_DDSP_ADID_ECLUH308, "convert-ddsp-adid-ecluh308-131"}, /* SC */
  
  /* NSD CLUSTER 4 */
  {CONVERT_DDSP_ADID_ECLUN401, "convert-ddsp-adid-eclun401-150"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUN402, "convert-ddsp-adid-eclun402-151"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUN403, "convert-ddsp-adid-eclun403-152"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUN404, "convert-ddsp-adid-eclun404-153"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUN405, "convert-ddsp-adid-eclun405-154"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUN406, "convert-ddsp-adid-eclun406-155"}, /* WEC */
  
  /* BSD CLUSTER 4*/
  {CONVERT_DDSP_ADID_ECLUB401, "convert-ddsp-adid-eclub401-157"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUB402, "convert-ddsp-adid-eclub402-158"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUB403, "convert-ddsp-adid-eclub403-159"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUB404, "convert-ddsp-adid-eclub404-160"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUB405, "convert-ddsp-adid-eclub405-161"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUB406, "convert-ddsp-adid-eclub406-162"}, /* WEC */
  
  /* HKD CLUSTER 4*/
  {CONVERT_DDSP_ADID_ECLUH401, "convert-ddsp-adid-ecluh401-164"}, /* EDI */
  {CONVERT_DDSP_ADID_ECLUH402, "convert-ddsp-adid-ecluh402-165"}, /* FGM */
  {CONVERT_DDSP_ADID_ECLUH403, "convert-ddsp-adid-ecluh403-166"}, /* CIS */
  {CONVERT_DDSP_ADID_ECLUH404, "convert-ddsp-adid-ecluh404-167"}, /* PEACE */
  {CONVERT_DDSP_ADID_ECLUH405, "convert-ddsp-adid-ecluh405-168"}, /* RAPID */
  {CONVERT_DDSP_ADID_ECLUH406, "convert-ddsp-adid-ecluh406-169"}, /* WEC */
  {CONVERT_DDSP_ADID_ECLUH407, "convert-ddsp-adid-ecluh407-170"}, /* ASPOC */
  {CONVERT_DDSP_ADID_ECLUH408, "convert-ddsp-adid-ecluh408-171"}, /* SC */

  {0,			       "convert-ddsp-adid-unknown"},
  {0,				NULL}
  };

/* }}} */
/* {{{ convert-ddsp-stream-info-list */

field_info convert_ddsp_stream_info [] = {
  /* RT ::= REAL TIME */
  {CONVERT_DDSP_STREAM_RT_VC0, "convert-ddsp-stream-rt-vc0-0x00"},
  {CONVERT_DDSP_STREAM_RT_VC2, "convert-ddsp-stream-rt-vc2-0x02"},
  {CONVERT_DDSP_STREAM_RT_VC3, "convert-ddsp-stream-rt-vc3-0x03"},
  
  /* PB ::= PLAY BACK */
  {CONVERT_DDSP_STREAM_PB_VC0, "convert-ddsp-stream-pb-vc0-0x40"},
  {CONVERT_DDSP_STREAM_PB_VC2, "convert-ddsp-stream-pb-vc2-0x42"},
  {CONVERT_DDSP_STREAM_PB_VC3, "convert-ddsp-stream-pb-vc3-0x43"},
  
  /* RE ::= RECALL */
  {CONVERT_DDSP_STREAM_RE_VC0, "convert-ddsp-stream-re-vc0-0xf0"},
  {CONVERT_DDSP_STREAM_RE_VC2, "convert-ddsp-stream-re-vc2-0xf2"},
  {CONVERT_DDSP_STREAM_RE_VC3, "convert-ddsp-stream-re-vc3-0xf3"},
  
  /* RP ::= RECALL PLAY BACK */
  {CONVERT_DDSP_STREAM_RP_VC0, "convert-ddsp-stream-rp-vc0-0x4f"},
  {CONVERT_DDSP_STREAM_RP_VC2, "convert-ddsp-stream-rp-vc2-0xe2"},
  {CONVERT_DDSP_STREAM_RP_VC3, "convert-ddsp-stream-rp-vc3-0xe3"},
  
  /* INVALID */
  {CONVERT_DDSP_STREAM_NA,     "convert-ddsp-stream-na-0xff"},
  {0,			       "convert-ddsp-stream-unknown"},
  {0,				NULL}
  };

/* }}} */
/* {{{ convert-ddsp-tcal-info-list */

field_info convert_ddsp_tcal_info [] = {
  {CONVERT_DDSP_TCAL_NA,		"convert-ddsp-tcal-na"},
  {CONVERT_DDSP_TCAL_ACTUAL,		"convert-ddsp-tcal-actual-time"},
  {CONVERT_DDSP_TCAL_EXTRAPOLATED,	"convert-ddsp-tcal-extrapolated-time"},
  {CONVERT_DDSP_TCAL_CONTINGENCY,	"convert-ddsp-tcal-contingency-time"},
  {0,					"convert-ddsp-tcal-unknown"},
  {0,					 NULL}
};

/* }}} */
/* {{{ convert-ddsp-gsid-info-list */

field_info convert_ddsp_gsid_info [] = {
  {CONVERT_DDSP_GSID_ODENWALD,	"convert-ddsp-gsid-odenwald"},
  {CONVERT_DDSP_GSID_REDU,	"convert-ddsp-gsid-redu"},
  {CONVERT_DDSP_GSID_KOUROU,	"convert-ddsp-gsid-kourou"},
  {CONVERT_DDSP_GSID_PERTH,	"convert-ddsp-gsid-perth"},
  {CONVERT_DDSP_GSID_MALINDI,	"convert-ddsp-gsid-malindi"},
  {CONVERT_DDSP_GSID_CANBERRA,	"convert-ddsp-gsid-canberra"},
  {CONVERT_DDSP_GSID_GOLDSTONE,	"convert-ddsp-gsid-goldstone"},
  {CONVERT_DDSP_GSID_NA,	"convert-ddsp-gsid-not-applicable"},
  {0,				"convert-ddsp-gsid-undefined"},
  {0,				 NULL}
};

/* }}} */

/* {{{ ted-spacecraft-info-list */

field_info ted_spacecraft_info [] = {
  {CLUSTER_1, "ted-spacecraft-1"},
  {CLUSTER_2, "ted-spacecraft-2"},
  {CLUSTER_3, "ted-spacecraft-3"},
  {CLUSTER_4, "ted-spacecraft-4"},
  {0,	       NULL}
};

/* }}} */
/* {{{ ted-transmission-info-list */

field_info ted_transmission_info [] = {
  {TED_TRANSMISSION_REALTIME,		"ted-transmission-real-time"},
  {TED_TRANSMISSION_PLAYBACK,		"ted-transmission-playback"},
  {TED_TRANSMISSION_RECALL,		"ted-transmission-recall"},
  {TED_TRANSMISSION_RECALLPLAYBACK,	"ted-transmission-recall-playback"},
  {0,					"ted-transmission-unknown"},
  {0,					 NULL}
};

/* }}} */
/* {{{ ted-quality-info-list */

field_info ted_quality_info [] = {
  {TED_QUALITY_ACTUAL,		"ted-quality-actual-time"},
  {TED_QUALITY_EXTRAPOLATED,	"ted-quality-extrapolated-time"},
  {TED_QUALITY_CONTINGENCY,	"ted-quality-contingency-time"},
  {0,				"ted-quality-unknown"},
  {0,				 NULL}
};

/* }}} */
/* {{{ ted-ground-info-list */

field_info ted_ground_info [] = {
  {TED_GROUND_ODENWALD, "ted-ground-odenwald"},
  {TED_GROUND_REDU,	"ted-ground-redu"},
  {TED_GROUND_KOUROU,	"ted-ground-kourou"},
  {TED_GROUND_PERTH,	"ted-ground-perth"},
  {TED_GROUND_MALINDI,	"ted-ground-malindi"},
  {TED_GROUND_CANBERRA,	"ted-ground-canberra"},
  {TED_GROUND_GOLDSTONE,"ted-ground-goldstone"},
  {TED_GROUND_NA,	"ted-ground-not-applicable"},
  {0,			"ted-ground-undefined"},
  {0, 			 NULL}
};

/* }}} */
/* {{{ ted-status-response-info-list */

field_info ted_status_info [] = {
  {TED_OK,				"ted-no-error-identified"},
  {TED_UNIMPLEMENTED,			"ted-convert-unimplemented-feature"},
  {TED_MEMORY,				"ted-convert-memory-unavailable"},
  {TED_READ_SIZE,			"ted-convert-not-enough-data"},
  {TED_READ_EOF,			"ted-convert-reached-eof"},
  {TED_READ_FILE,			"ted-convert-error-reading-file"},
  {TED_CONVERT_SOURCEINVALID,		"ted-convert-source-or-adid-invalid"},
  {TED_CONVERT_SPACECRAFTINVALID,	"ted-convert-spacecraft-invalid"},
  {TED_CONVERT_SPACECRAFTMATCH,		"ted-convert-source-spaceraft-mismatch"},
  {TED_CONVERT_STREAMINVALID,		"ted-convert-stream-class-invalid"},
  {TED_CONVERT_GROUNDINVALID,		"ted-convert-ground-segment-invalid"},
  {TED_CONVERT_CHANNELTYPE_MATCH,	"ted-convert-stream-adid-mismatch"},
  {TED_CONVERT_QUALITYINVALID,		"ted-convert-time-quality-invalid"},
  {TED_CONVERT_SEQUENCEINVALID,		"ted-convert-tm-packet-spsc-invalid"},
  {TED_CONVERT_DDSP_WRITE_HEADER_ERR,	"ted-convert-dds-packet-header-write-failed"},
  {TED_CONVERT_DDSP_WRITE_DATA_ERR,	"ted-convert-dds-packet-data-write-failed"},
  {TED_CONVERT_TMP_WRITE_HEADER_ERR,	"ted-convert-tmp-packet-header-write-failed"},
  {TED_CONVERT_TMP_WRITE_DATA_ERR,	"ted-convert-tmp-packet-data-write-failed"},
  {TED_CONVERT_TOOLONG,			"ted-convert-tm-packet-length-too-long"},
  {TED_CONVERT_WRONGVERSION,		"ted-convert-tm-packet-version-wrong"},
  {TED_CONVERT_WRONGTYPE,		"ted-convert-tm-packet-wrong-type"},
  {TED_CONVERT_SEGWRONG, 		"ted-convert-tm-packet-segmentation-flag-wrong"},
  {TED_CONVERT_APIDINVALID,		"ted-convert-tm-packet-apid-wrong"},
  {TED_CONVERT_FLAGWRONG,		"ted-convert-tm-packet-pdf-header-flag-wrong"},
  {TED_CONVERT_PFIELDWRONG,		"ted-convert-tm-packet-pdfh-pfield-wrong"},
  {0,					"ted-status-undefined"},
  {0, 					 NULL}
};

/* }}} */

/* {{{ info-list-symbol-selection */

char * info_symbol_select (int index, field_info info [])
{
  int i;

  for (i = 0; info[i].desc != NULL; i++)
    if (info [ i ].value == index) 
      return info [ i ].desc;

  if (i > 0)
    return info [ i - 1 ].desc;
  else
    return NULL;
}

char * convert_symbol_select (int value, CONVERT_SYMBOL_TABLE table)
{
	switch (table)
	{
	case CONVERT_TMPH_VER_INFO:
		return (char *) info_symbol_select (value, convert_tmph_ver_info);
	case CONVERT_TMPH_TYPE_INFO:
		return (char *) info_symbol_select (value, convert_tmph_type_info);
	case CONVERT_TMPH_PDF_HEADER_FLAG_INFO:
		return (char *) info_symbol_select (value, convert_tmph_pdf_header_flag_info);
	case CONVERT_TMPH_APID_INFO:
		return (char *) info_symbol_select (value,convert_tmph_apid_info);
	case CONVERT_TMPH_SEG_INFO:
		return (char *) info_symbol_select (value,convert_tmph_seg_info);
	case CONVERT_TMP_DFH_PFIELD_INFO:
		return (char *) info_symbol_select (value,convert_tmp_dfh_pfield_info);
	case CONVERT_DDSP_ADID_INFO:
	    return (char *) info_symbol_select (value,convert_ddsp_adid_info);
	case CONVERT_DDSP_SPACECRAFT_INFO:
		return (char *) info_symbol_select (value,convert_ddsp_spacecraft_info);
	case CONVERT_DDSP_STREAM_INFO:
		return (char *) info_symbol_select (value,convert_ddsp_stream_info);
	case CONVERT_DDSP_TCAL_INFO:
		return (char *) info_symbol_select (value,convert_ddsp_tcal_info);
	case CONVERT_DDSP_GROUND_INFO:
		return (char *) info_symbol_select (value,convert_ddsp_gsid_info);
	default:
		return NULL;
	}
}

char * ted_symbol_select (int value, TED_SYMBOL_TABLE table)
{
	switch (table)
	   {
	   case TED_STATUS_INFO:
		return (char *) info_symbol_select (value, ted_status_info);
	   case TED_SPACECRAFT_INFO:
	   	return (char *) info_symbol_select (value, ted_spacecraft_info);
	   case TED_GROUND_INFO:
	   	return (char *) info_symbol_select (value, ted_ground_info);
	   case TED_TRANSMISSION_INFO:
	   	return (char *) info_symbol_select (value, ted_transmission_info);
	   case TED_QUALITY_INFO:
	   	return (char *) info_symbol_select (value, ted_quality_info);
	   default:
	   	 return NULL;
	   }
}

/* }}} */
/* {{{ info-list-value-selection */

int info_index_select (char * value, field_info info [])
{
  int i;

  for (i = 0; info [ i ].desc != NULL; i++)
    if (! strcmp (value, info [ i ].desc))
      return info [ i ].value;

  return -1;
}

/* }}} */
/* {{{ dump-char-[]-buffer-2-stderr */

void mdpb (unsigned char buf [], int len)
{
  int Index = 0;
  int Value = 0;

  for (Index = 0; Index < len; Index++)
    {
      if ((Index % 16) == 0)
	fprintf (stderr,"\n%8x   ",Index);

      if ((int) (buf[Index] & 0xff) < 0x10)
	fprintf (stderr,"0%x ",(int) (buf[Index] & 0xff));
      else
	fprintf (stderr,"%x ",(int)(buf[Index] & 0xff));
    }
  fprintf (stderr,"\n");
}

/* }}} */

/* {{{ convert-dds-source-or-adid-2-tmp-apid */

static CONVERT_TMPH_APID convert_ddsp_source_2_tmph_apid (CONVERT_DDS_PACKET fp)
{
  int adid;

  adid = CONVERT_DDSP_GET_SOURCE (fp);

       if (adid >= CONVERT_DDSP_SOURCE_SCID_4_OFF)
    adid -= CONVERT_DDSP_SOURCE_SCID_4_OFF;
  else if (adid >= CONVERT_DDSP_SOURCE_SCID_3_OFF)
    adid -= CONVERT_DDSP_SOURCE_SCID_3_OFF;
  else if (adid >= CONVERT_DDSP_SOURCE_SCID_2_OFF)
    adid -= CONVERT_DDSP_SOURCE_SCID_2_OFF;
  else if (adid >= CONVERT_DDSP_SOURCE_SCID_1_OFF)
    adid -= CONVERT_DDSP_SOURCE_SCID_1_OFF;
  else
    return CONVERT_TMPH_APID_NA;

       if (adid == (CONVERT_DDSP_SOURCE_HK_OFF + CONVERT_DDSP_SOURCE_WEC_OFF))
	 return CONVERT_TMPH_APID_HK;
  else if (adid == (CONVERT_DDSP_SOURCE_BM_OFF + CONVERT_DDSP_SOURCE_WEC_OFF))
    {
           if (CONVERT_DDSP_GET_TAM (fp) == CONVERT_DDSP_TAM_B1)
	return CONVERT_TMPH_APID_B1;
      else if (CONVERT_DDSP_GET_TAM (fp) == CONVERT_DDSP_TAM_B2)
	return CONVERT_TMPH_APID_B2;
      else if (CONVERT_DDSP_GET_TAM (fp) == CONVERT_DDSP_TAM_B3)
	return CONVERT_TMPH_APID_B3;
      else
	return CONVERT_TMPH_APID_NA;
    }
  else if (adid == CONVERT_DDSP_SOURCE_NM_OFF + CONVERT_DDSP_SOURCE_WEC_OFF)
    {
           if (CONVERT_DDSP_GET_TAM (fp) == CONVERT_DDSP_TAM_N1)
	return CONVERT_TMPH_APID_N1;
      else if (CONVERT_DDSP_GET_TAM (fp) == CONVERT_DDSP_TAM_N2)
	return CONVERT_TMPH_APID_N2;
      else if (CONVERT_DDSP_GET_TAM (fp) == CONVERT_DDSP_TAM_N3)
	return CONVERT_TMPH_APID_N3;
      else
	return CONVERT_TMPH_APID_NA;
    }
  else
    return CONVERT_TMPH_APID_NA;
}

/* }}} */
/* {{{ convert-dds-2-tm-segmentation-flag

 this should always be CONVERT_TMPH_SEG_ALONE as
 WEC TM Packet are always <= 64K (max tmp size) */

static CONVERT_TMPH_SEG convert_ddsp_2_tmph_seg (CONVERT_DDS_PACKET fp)
{
  if (CONVERT_DDSP_GET_LEN (fp) > CONVERT_TMP_MAX_LEN)
    return CONVERT_TMPH_SEG_NA;
  else
    return CONVERT_TMPH_SEG_ALONE;
}

/* }}} */
/* {{{ convert-dds-2-tm-spsc and return it

 no representation exists in a dds packet
 so internal counters are used */

static CONVERT_TMPH_SEQ convert_ddsp_2_tmph_sequence (CONVERT_DDS_PACKET fp,
						       int seq)
{
  static int convert_tmph_seq_hk = CONVERT_TMPH_SPSC_MIN;
  static int convert_tmph_seq_n1 = CONVERT_TMPH_SPSC_MIN;
  static int convert_tmph_seq_n2 = CONVERT_TMPH_SPSC_MIN;
  static int convert_tmph_seq_n3 = CONVERT_TMPH_SPSC_MIN;
  static int convert_tmph_seq_b1 = CONVERT_TMPH_SPSC_MIN;
  static int convert_tmph_seq_b2 = CONVERT_TMPH_SPSC_MIN;
  static int convert_tmph_seq_b3 = CONVERT_TMPH_SPSC_MIN;

  int *counter;


  if (seq == CONVERT_TMPH_SPSC_RESET)
    {
      convert_tmph_seq_hk = CONVERT_TMPH_SPSC_MIN;
      convert_tmph_seq_n1 = CONVERT_TMPH_SPSC_MIN;
      convert_tmph_seq_n2 = CONVERT_TMPH_SPSC_MIN;
      convert_tmph_seq_n3 = CONVERT_TMPH_SPSC_MIN;
      convert_tmph_seq_b1 = CONVERT_TMPH_SPSC_MIN;
      convert_tmph_seq_b2 = CONVERT_TMPH_SPSC_MIN;
      convert_tmph_seq_b3 = CONVERT_TMPH_SPSC_MIN;
    }

       if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_HK)
    counter = &convert_tmph_seq_hk;
  else if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_N1)
    counter = &convert_tmph_seq_n1;
  else if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_N2)
    counter = &convert_tmph_seq_n2;
  else if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_N3)
    counter = &convert_tmph_seq_n3;
  else if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_B1)
    counter = &convert_tmph_seq_b1;
  else if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_B2)
    counter = &convert_tmph_seq_b2;
  else if (convert_ddsp_source_2_tmph_apid (fp) == CONVERT_TMPH_APID_B3)
    counter = &convert_tmph_seq_b3;
  else
    counter = NULL;

  if (seq == CONVERT_TMPH_SPSC_INTERNAL)
    *counter = (*counter + 1) % CONVERT_TMPH_SPSC_RADIX;
  else
    *counter = seq % CONVERT_TMPH_SPSC_RADIX;

  return *counter;
}

/* }}} */
/* {{{ convert-dds-length-2-tm-length and return it

 WEC blocks are always <= 64K and do not
 need segmentation */

static CONVERT_TMPH_LEN  convert_ddsp_length_2_tmph_length (CONVERT_DDS_PACKET fp,
							     CONVERT_TMPH_PDF_FLAG pdf_flag)
{
  if (pdf_flag == CONVERT_TMPH_PDF_FLAG_EXISTS)
    return CONVERT_DDSP_GET_LEN (fp) - 1 + CONVERT_TMP_PDF_LEN;
  else
    return CONVERT_DDSP_GET_LEN (fp) - 1;
}

/* }}} */
/* {{{ convert-dds-time-2-tm-time and return it */

static CONVERT_TMP_PDF_TIME * convert_ddsp_time_2_tmp_pdf_time (CONVERT_DDS_PACKET fp)
{
  static CONVERT_TMP_PDF_TIME ct;
         CONVERT_DDSP_TIME ft;
         long fsecs;

  CONVERT_DDSP_GET_SCET (&ft, fp);

  ct.tv_sec  = 0;
  ct.tv_sec += ft.days * (60L * 60L * 24L);
  ct.tv_sec += ft.ms / 1000;
  ct.tv_sec -= CONVERT_TMP_DDSP_TIME_DIFF;

  ct.tv_usec  = 0;
  ct.tv_usec += (ft.ms % 1000) * 1000L;
  ct.tv_usec += ft.us;

  return &ct;
}

/* }}} */

/* {{{ convert-tm-time-2-dds-time and return it */

static CONVERT_DDSP_TIME * convert_tmp_pdf_time_2_ddsp_time (CONVERT_TM_PACKET tp)
{
  static CONVERT_DDSP_TIME time;

  long flight_secs,
       mod_day_secs,
       frac_sec_ms;
  
  time.days = (long) (CONVERT_TMP_GET_PDF_SEC (tp) +
                         CONVERT_TMP_DDSP_TIME_DIFF) / (long) (60L * 60L * 24L);
  
  flight_secs  = time.ms = (long) (CONVERT_TMP_GET_PDF_SEC (tp) +
				      CONVERT_TMP_DDSP_TIME_DIFF);

  mod_day_secs = flight_secs % (long) (60L * 60L * 24L);
  frac_sec_ms = (long) CONVERT_TMP_GET_PDF_USEC (tp) / 1000L;
  time.ms = (mod_day_secs * 1000L) + frac_sec_ms;
 
  time.us = (long) (CONVERT_TMP_GET_PDF_USEC (tp)) % 1000L;

  return &time;
}

/* }}} */
/* {{{ convert-tm-apid-and-scid-2-dds-source */

static CONVERT_DDSP_SOURCE convert_tmph_apid_2_ddsp_adid (CONVERT_CLUSTER_SCID sc,
							   CONVERT_TM_PACKET tp)
{
  int scid_off, exp_off, type_off, scid;
  

  /* SCID offset */
  switch (sc)
    {
    case CONVERT_CLUSTER_SCID_1: scid_off = CONVERT_DDSP_SOURCE_SCID_1_OFF; break;
    case CONVERT_CLUSTER_SCID_2: scid_off = CONVERT_DDSP_SOURCE_SCID_2_OFF; break;
    case CONVERT_CLUSTER_SCID_3: scid_off = CONVERT_DDSP_SOURCE_SCID_3_OFF; break;
    case CONVERT_CLUSTER_SCID_4: scid_off = CONVERT_DDSP_SOURCE_SCID_4_OFF; break;
    default: return CONVERT_DDSP_SOURCE_NA;	
    }
  

       if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_HK)
         type_off = CONVERT_DDSP_SOURCE_HK_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_N1)
         type_off = CONVERT_DDSP_SOURCE_NM_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_N2)
         type_off = CONVERT_DDSP_SOURCE_NM_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_N3)
         type_off = CONVERT_DDSP_SOURCE_NM_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_HK)
         type_off = CONVERT_DDSP_SOURCE_NM_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_B1)
         type_off = CONVERT_DDSP_SOURCE_BM_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_B2)
         type_off = CONVERT_DDSP_SOURCE_BM_OFF;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_B3)
         type_off = CONVERT_DDSP_SOURCE_BM_OFF;
  else return CONVERT_DDSP_SOURCE_NA;

  return scid_off + type_off + CONVERT_DDSP_SOURCE_WEC_OFF;
}

/* }}} */
/* {{{ convert-tm-apid-and-defined-stream-class-2-dds-stream */

static CONVERT_DDSP_STREAM convert_tmph_2_ddsp_stream (
					      CONVERT_DDSP_STREAM_CLASS stream,
					      CONVERT_TM_PACKET tp)
{
  CONVERT_TMPH_APID apid = CONVERT_TMPH_GET_APID(tp);

  switch (stream)
    {
    case CONVERT_DDSP_STREAM_RT_BASE:		
      if (apid == CONVERT_TMPH_APID_HK) return CONVERT_DDSP_STREAM_RT_VC0;
      if (apid == CONVERT_TMPH_APID_N1) return CONVERT_DDSP_STREAM_RT_VC2;
      if (apid == CONVERT_TMPH_APID_N2) return CONVERT_DDSP_STREAM_RT_VC2;
      if (apid == CONVERT_TMPH_APID_N3) return CONVERT_DDSP_STREAM_RT_VC2;
      if (apid == CONVERT_TMPH_APID_B1) return CONVERT_DDSP_STREAM_RT_VC3;
      if (apid == CONVERT_TMPH_APID_B2) return CONVERT_DDSP_STREAM_RT_VC3;
      if (apid == CONVERT_TMPH_APID_B3) return CONVERT_DDSP_STREAM_RT_VC3;
      break;

    case CONVERT_DDSP_STREAM_PB_BASE:
      if (apid == CONVERT_TMPH_APID_HK) return CONVERT_DDSP_STREAM_PB_VC0;
      if (apid == CONVERT_TMPH_APID_N1) return CONVERT_DDSP_STREAM_PB_VC2;
      if (apid == CONVERT_TMPH_APID_N2) return CONVERT_DDSP_STREAM_PB_VC2;
      if (apid == CONVERT_TMPH_APID_N3) return CONVERT_DDSP_STREAM_PB_VC2;
      if (apid == CONVERT_TMPH_APID_B1) return CONVERT_DDSP_STREAM_PB_VC3;
      if (apid == CONVERT_TMPH_APID_B2) return CONVERT_DDSP_STREAM_PB_VC3;
      if (apid == CONVERT_TMPH_APID_B3) return CONVERT_DDSP_STREAM_PB_VC3;
      break;

    case CONVERT_DDSP_STREAM_RE_BASE:
      if (apid == CONVERT_TMPH_APID_HK) return CONVERT_DDSP_STREAM_RE_VC0;
      if (apid == CONVERT_TMPH_APID_N1) return CONVERT_DDSP_STREAM_RE_VC2;
      if (apid == CONVERT_TMPH_APID_N2) return CONVERT_DDSP_STREAM_RE_VC2;
      if (apid == CONVERT_TMPH_APID_N3) return CONVERT_DDSP_STREAM_RE_VC2;
      if (apid == CONVERT_TMPH_APID_B1) return CONVERT_DDSP_STREAM_RE_VC3;
      if (apid == CONVERT_TMPH_APID_B2) return CONVERT_DDSP_STREAM_RE_VC3;
      if (apid == CONVERT_TMPH_APID_B3) return CONVERT_DDSP_STREAM_RE_VC3;
      break;

    case CONVERT_DDSP_STREAM_RP_BASE:
      if (apid == CONVERT_TMPH_APID_HK) return CONVERT_DDSP_STREAM_RP_VC0;
      if (apid == CONVERT_TMPH_APID_N1) return CONVERT_DDSP_STREAM_RP_VC2;
      if (apid == CONVERT_TMPH_APID_N2) return CONVERT_DDSP_STREAM_RP_VC2;
      if (apid == CONVERT_TMPH_APID_N3) return CONVERT_DDSP_STREAM_RP_VC2;
      if (apid == CONVERT_TMPH_APID_B1) return CONVERT_DDSP_STREAM_RP_VC3;
      if (apid == CONVERT_TMPH_APID_B2) return CONVERT_DDSP_STREAM_RP_VC3;
      if (apid == CONVERT_TMPH_APID_B3) return CONVERT_DDSP_STREAM_RP_VC3;
      break;

    default:
      return CONVERT_DDSP_STREAM_NA;
    }
}

/* }}} */
/* {{{ convert-tm-apid-2-dds-tam */

static CONVERT_DDSP_TAM convert_tmph_2_ddsp_tam (CONVERT_TM_PACKET tp)
{
       if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_HK)
	 return CONVERT_DDSP_TAM_HK;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_N1)
         return CONVERT_DDSP_TAM_N1;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_N2)
	 return CONVERT_DDSP_TAM_N2;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_N3)
         return CONVERT_DDSP_TAM_N3;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_B1)
         return CONVERT_DDSP_TAM_B1;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_B2)
         return CONVERT_DDSP_TAM_B2;
  else if (CONVERT_TMPH_GET_APID (tp) == CONVERT_TMPH_APID_B3)
         return CONVERT_DDSP_TAM_B3;
  else   return CONVERT_DDSP_TAM_NA;
}

/* }}} */

/* {{{ convert-check-dds-source */

int convert_isa_ddsp_source (CONVERT_DDSP_SOURCE source)
{
       if (source >= CONVERT_DDSP_SOURCE_SCID_4_OFF)
    source -= CONVERT_DDSP_SOURCE_SCID_4_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_SCID_3_OFF)
    source -= CONVERT_DDSP_SOURCE_SCID_3_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_SCID_2_OFF)
    source -= CONVERT_DDSP_SOURCE_SCID_2_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_SCID_1_OFF)
    source -= CONVERT_DDSP_SOURCE_SCID_1_OFF;
  else
    return 0;

      if (source >= CONVERT_DDSP_SOURCE_HK_OFF)
    source -= CONVERT_DDSP_SOURCE_HK_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_BM_OFF)
    source -= CONVERT_DDSP_SOURCE_BM_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_NM_OFF)
    source -= CONVERT_DDSP_SOURCE_NM_OFF;
  else
    return 0;

  switch (source)
    {
    case CONVERT_DDSP_SOURCE_EDI_OFF:
    case CONVERT_DDSP_SOURCE_FGM_OFF:
    case CONVERT_DDSP_SOURCE_CIS_OFF:
    case CONVERT_DDSP_SOURCE_PEA_OFF:
    case CONVERT_DDSP_SOURCE_RAP_OFF:
    case CONVERT_DDSP_SOURCE_WEC_OFF:
    case CONVERT_DDSP_SOURCE_ASP_OFF:
      return !0;
    }

  return 0;
}

/* }}} */
/* {{{ convert-check-dds-spacecraft */

int convert_isa_ddsp_scid (CONVERT_CLUSTER_SCID scid)
{
  switch (scid)
    {
    case CONVERT_CLUSTER_SCID_1:
    case CONVERT_CLUSTER_SCID_2:
    case CONVERT_CLUSTER_SCID_3:
    case CONVERT_CLUSTER_SCID_4:
      return !0;
    default:
      return 0;
    }
}

/* }}} */
/* {{{ convert-check-association-between-dds-scid-and-source */

int convert_ddsp_match_scid_and_source (CONVERT_CLUSTER_SCID scid,
					        CONVERT_DDSP_SOURCE source)
{
  if ((scid   == CONVERT_CLUSTER_SCID_4) &&
       (source >= CONVERT_DDSP_SOURCE_SCID_4_OFF))
    return !0;
  else if ((scid == CONVERT_CLUSTER_SCID_3) &&
	    ((source >= CONVERT_DDSP_SOURCE_SCID_3_OFF) &&
	      (source <  CONVERT_DDSP_SOURCE_SCID_4_OFF)))
    return !0;
  else if ((scid == CONVERT_CLUSTER_SCID_2) &&
	    ((source >= CONVERT_DDSP_SOURCE_SCID_2_OFF) &&
	      (source <  CONVERT_DDSP_SOURCE_SCID_3_OFF)))
    return !0;
  else if ((scid == CONVERT_CLUSTER_SCID_1) &&
	    ((source >= CONVERT_DDSP_SOURCE_SCID_1_OFF) &&
	      (source <  CONVERT_DDSP_SOURCE_SCID_2_OFF)))
    return !0;
  else
    return 0;
}

/* }}} */
/* {{{ convert-check-dds-stream */

int convert_isa_ddsp_stream (CONVERT_DDSP_STREAM stream)
{
  switch (stream)
    {
    case CONVERT_DDSP_STREAM_RT_VC0:
    case CONVERT_DDSP_STREAM_RT_VC2:
    case CONVERT_DDSP_STREAM_RT_VC3:
    case CONVERT_DDSP_STREAM_PB_VC0:
    case CONVERT_DDSP_STREAM_PB_VC2:
    case CONVERT_DDSP_STREAM_PB_VC3:
    case CONVERT_DDSP_STREAM_RE_VC0:
    case CONVERT_DDSP_STREAM_RE_VC2:
    case CONVERT_DDSP_STREAM_RE_VC3:
    case CONVERT_DDSP_STREAM_RP_VC0:
    case CONVERT_DDSP_STREAM_RP_VC2:
    case CONVERT_DDSP_STREAM_RP_VC3:
      return !0;
    default:
      return 0;
    }
}

/* }}} */
/* {{{ convert-check-dds-gsid */

int convert_isa_ddsp_ground (CONVERT_DDSP_GSID ground)
{
  switch (ground)
    {
    case CONVERT_DDSP_GSID_ODENWALD:
    case CONVERT_DDSP_GSID_REDU:
    case CONVERT_DDSP_GSID_KOUROU:
    case CONVERT_DDSP_GSID_PERTH:
    case CONVERT_DDSP_GSID_MALINDI:
    case CONVERT_DDSP_GSID_CANBERRA:
    case CONVERT_DDSP_GSID_GOLDSTONE:
      return !0;
    default:
      return 0;
    }
}

/* }}} */
/* {{{ convert-check-association-between-dds-source-and-stream */

int convert_match_ddsp_source_and_stream (CONVERT_DDSP_SOURCE source,
						  CONVERT_DDSP_STREAM stream)
{
 
       if (source >= CONVERT_DDSP_SOURCE_SCID_4_OFF)
	 source -= CONVERT_DDSP_SOURCE_SCID_4_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_SCID_3_OFF)
         source -= CONVERT_DDSP_SOURCE_SCID_3_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_SCID_2_OFF)
         source -= CONVERT_DDSP_SOURCE_SCID_2_OFF;
  else if (source >= CONVERT_DDSP_SOURCE_SCID_1_OFF)
         source -= CONVERT_DDSP_SOURCE_SCID_1_OFF;
  else return !0;

       if (source >= CONVERT_DDSP_SOURCE_HK_OFF)
    switch (stream)
      {
      case CONVERT_DDSP_STREAM_RT_VC0:
      case CONVERT_DDSP_STREAM_PB_VC0:
      case CONVERT_DDSP_STREAM_RE_VC0:   
      case CONVERT_DDSP_STREAM_RP_VC0:
	return !0;
      default:
	return 0;
      }
  else if (source >= CONVERT_DDSP_SOURCE_BM_OFF)
    switch (stream)
      {
      case CONVERT_DDSP_STREAM_RT_VC3:
      case CONVERT_DDSP_STREAM_PB_VC3:	 
      case CONVERT_DDSP_STREAM_RE_VC3:
      case CONVERT_DDSP_STREAM_RP_VC3:
	return !0;
      default:
	return 0;
      }
  else if (source >= CONVERT_DDSP_SOURCE_NM_OFF)
    switch (stream)
      {
      case CONVERT_DDSP_STREAM_RT_VC2:
      case CONVERT_DDSP_STREAM_PB_VC2:
      case CONVERT_DDSP_STREAM_RE_VC2:
      case CONVERT_DDSP_STREAM_RP_VC2:
	return !0;
      default:
	return 0;
      }
  else return 0;
}

/* }}} */
/* {{{ convert-check-dds-tcal */

int convert_isa_ddsp_tcal (CONVERT_DDSP_TCAL tcal)
{
  switch (tcal)
    {
    case CONVERT_DDSP_TCAL_ACTUAL:
    case CONVERT_DDSP_TCAL_EXTRAPOLATED:
    case CONVERT_DDSP_TCAL_CONTINGENCY:
      return !0;
    default:
      return 0;
    }
}

/* }}} */
/* {{{ convert-check-dds-tam */

int convert_isa_ddsp_tam (CONVERT_DDSP_TAM tam)
{
  if ((tam >= CONVERT_DDSP_TAM_MIN) && (tam <= CONVERT_DDSP_TAM_MAX))
    return !0;
  else
    return 0;
}

/* }}} */
/* {{{ convert-check-dds-length */

int convert_ddsp_too_long (CONVERT_DDSP_LEN len)
{
  if (len <= CONVERT_TMP_MAX_LEN)
    return !0;
  else
    return 0;
}

/* }}} */

/* {{{ convert-check-tm-pdfh-p-field */

static int convert_isa_tmp_pfield (CONVERT_TMP_PDF_PFIELD pdf)
{
  if (pdf == CONVERT_TMP_PDF_PFIELD_2F)
    return !0;
  else
    return 0;
}

/* }}} */
/* {{{ convert-check-tm-ver */

static convert_isa_tmph_version (CONVERT_TMPH_VER ver)
{
  if (ver == CONVERT_TMPH_VER_CUR) return !0;
  else return 0;
}

/* }}} */
/* {{{ convert-check-tm-type */

static int convert_isa_tmph_type (CONVERT_TMPH_TYPE type)
{
  if (type == CONVERT_TMPH_TYPE_TM) return !0;
  else return 0;
}

/* }}} */
/* {{{ convert-check-tm-pdf-flag */

static int convert_isa_tmph_pdf_flag (CONVERT_TMPH_PDF_FLAG flag)
{
  if (flag == CONVERT_TMPH_PDF_FLAG_EXISTS) return !0;
  else return 0;
}

/* }}} */
/* {{{ convert-check-tm-apid */

static int convert_isa_tmph_apid (CONVERT_TMPH_APID apid)
{
       if (apid == CONVERT_TMPH_APID_HK) return !0;
  else if (apid == CONVERT_TMPH_APID_N1) return !0;
  else if (apid == CONVERT_TMPH_APID_N2) return !0;
  else if (apid == CONVERT_TMPH_APID_N3) return !0;
  else if (apid == CONVERT_TMPH_APID_B1) return !0;
  else if (apid == CONVERT_TMPH_APID_B2) return !0;
  else if (apid == CONVERT_TMPH_APID_B3) return !0;
  else return 0;
}

/* }}} */
/* {{{ convert-check-tm-segmentation

 should always be CONVERT_TMPH_SEG_ALONE */

static int convert_isa_tmph_segment (CONVERT_TMPH_SEG seg)
{
  if (seg == CONVERT_TMPH_SEG_ALONE)
    return !0;
  else
    return 0;
}

/* }}} */
/* {{{ convert-check-tm-sequence-bounds */

static int convert_isa_tmph_sequence (CONVERT_TMPH_SEQ sequence)
{
  if ((sequence >= CONVERT_TMPH_SPSC_MIN) &&
       (sequence <= CONVERT_TMPH_SPSC_MAX))
    return !0;
  else
    return 0;
}

/* }}} */
/* {{{ convert-check-tm-length-bounds */

static int convert_tmph_length (CONVERT_TMPH_LEN len)
{
  if ((len >= CONVERT_TMPH_LEN_MIN) && (len <= CONVERT_TMPH_LEN_MAX))
    return !0;
  else
    return 0;
}

/* }}} */
/* {{{ convert-check-tm-fits-in-char-array */

static int convert_tmp_too_long ( CONVERT_TMP_LEN len)
{
  if ((len >= CONVERT_TMPH_LEN_MIN + CONVERT_TMPH_SIZE + 1) &&
       (len <= CONVERT_TMPH_LEN_MAX + CONVERT_TMPH_SIZE + 1))
    return !0;
  else
    return 0;
}

/* }}} */

/* {{{ convert-sis-packing-ratio */

int convert_packing_ratio (unsigned char *packet)
{
  int length = CONVERT_TMPH_GET_LEN (packet) + 1;

       if (length == CONVERT_SIS_TMP_HK_LEN) return CONVERT_SIS_TMP_HK_RATIO;
  else if (length == CONVERT_SIS_TMP_N1_LEN) return CONVERT_SIS_TMP_N1_RATIO;
  else if (length == CONVERT_SIS_TMP_N2_LEN) return CONVERT_SIS_TMP_N2_RATIO;
  else if (length == CONVERT_SIS_TMP_N3_LEN) return CONVERT_SIS_TMP_N3_RATIO;
  else if (length == CONVERT_SIS_TMP_B1_LEN) return CONVERT_SIS_TMP_B1_RATIO;
  else if (length == CONVERT_SIS_TMP_B2_LEN) return CONVERT_SIS_TMP_B2_RATIO;
  else if (length == CONVERT_SIS_TMP_B3_LEN) return CONVERT_SIS_TMP_B3_RATIO;
  else return CONVERT_SIS_TMP_DEFAULT_RATIO;
}

/* }}} */

/* ------------------- Module I/F routines below ----------------------*/

/* {{{ convert-display-dds-packet-time */

void convert_display_dds_packet_time (unsigned char * pkt)
{
  time_t secs = -1;
  long dy = -1;
  long ms = -1;
  long us = -1;
  struct tm * tim = NULL;

  if (pkt == NULL)
    return;

  dy = CONVERT_DDSP_GET_SCET_DAY (pkt);
  ms = CONVERT_DDSP_GET_SCET_MS (pkt);
  us = CONVERT_DDSP_GET_SCET_US (pkt);

  secs = (60 * 60 * 24 * dy) + (ms / 1000) - CONVERT_TMP_DDSP_TIME_DIFF;
  us += 1000L * (ms % 1000);

  tim = gmtime (&secs);

  fprintf (stderr,
	   "\
(convert-dds-packet-time\n\
 (dds-time-year %d)\n\
 (dds-time-day  %d)\n\
 (dds-time-hour %d)\n\
 (dds-time-min  %d)\n\
 (dds-time-sec  %2.6f)\n\
)",
	   tim->tm_year + 1900,
	   tim->tm_yday,
	   tim->tm_hour,
	   tim->tm_min,
           (double) tim->tm_sec + (double) ((double) us / 1000000.0));
}

/* }}} */
/* {{{ convert-display-tm-packet-time */

void convert_display_tm_packet_time (unsigned char *pkt)
{
  time_t sec;
  long usec;
  struct tm *tim = NULL;

  if (pkt == NULL)
    return;

  sec = CONVERT_TMP_GET_PDF_SEC(pkt);
  usec = CONVERT_TMP_GET_PDF_USEC(pkt);

  tim = gmtime (&sec);

  fprintf (stderr,
	   "\
(convert-tm-packet-time\n\
 (tm-time-year %d)\n\
 (tm-time-day  %d)\n\
 (tm-time-hour %d)\n\
 (tm-time-min  %d)\n\
 (tm-time-sec  %2.6f)\n\
)",
           tim->tm_year + 1900,
           tim->tm_yday,
           tim->tm_hour,
           tim->tm_min,
          (double) tim->tm_sec + (double) ((double) usec / 1000000));
}

/* }}} */
/* {{{ convert-display-dds-packet */

void convert_display_dds_packet (unsigned char * pkt)
{
  CONVERT_DDSP_TIME time;
  
  CONVERT_DDSP_GET_SCET (&time, pkt);	

  fprintf (stderr,
	   "\
(display-dds-packet\n\
 (dds-header\n");
  mdpb (pkt, CONVERT_DDSP_HEADER_SIZE);
  fprintf (stderr, ")\n");

  fprintf (stderr,
	   "\
 (dds-scet\n\
  (dds-scet-days %ld)\n\
  (dds-scet-ms %ld)\n\
  (dds-scet-us %ld)\n\
 )\n",
	   (long) CONVERT_DDSP_GET_SCET_DAY (pkt),
	   (long) CONVERT_DDSP_GET_SCET_MS  (pkt),
	   (long) CONVERT_DDSP_GET_SCET_US  (pkt));

  fprintf (stderr,
	   "\
 (dds-source %s)\n\
 (dds-length %ld)\n\
 (dds-spacecraft %s)\n\
 (dds-ground %s)\n\
 (dds-stream %s)\n\
 (dds-tcal %s)\n\
 (dds-tam %d)\n",
	   convert_ddsp_adid_symbol ((int) CONVERT_DDSP_GET_SOURCE (pkt)),
	   (int)  CONVERT_DDSP_GET_LEN (pkt),
	   convert_ddsp_scid_symbol ((int) CONVERT_DDSP_GET_SCID (pkt)),
	   convert_ddsp_ground_symbol ((int) CONVERT_DDSP_GET_GSID (pkt)),
	   convert_ddsp_stream_symbol ((int) CONVERT_DDSP_GET_STREAM (pkt)),
	   convert_ddsp_tcal_symbol ((int) CONVERT_DDSP_GET_TCAL (pkt)),
	   (int)  CONVERT_DDSP_GET_TAM (pkt));

 fprintf (stderr,
	  "\
 (dds-data\n");
  mdpb (pkt + CONVERT_DDSP_HEADER_SIZE,CONVERT_DDSP_GET_LEN (pkt));
  fprintf (stderr,
           "\
 )\n");
  fprintf (stderr,
           "\
)\n");
}

/* }}} */
/* {{{ convert-display-tm-packet */

void convert_display_tm_packet (unsigned char * esa)
{

  fprintf (stderr,
	   "\
(display-tm-packet\n\
 (tm-header\n");
  mdpb (esa, CONVERT_TMPH_SIZE);
  fprintf (stderr,
           "\
 )\n");

  fprintf (stderr,
           "\
 (tm-packet-version %s)\n\
 (tm-type %s)\n\
 (tm-data-field-header-flag %s)\n\
 (tm-application-identifier %s)\n\
 (tm-segmentation-flag %s)\n\
 (tm-source-packet-sequence-count %d)\n\
 (tm-length %d)\n",
	   convert_tmph_version_symbol (CONVERT_TMPH_GET_VER (esa)),
	   convert_tmph_type_symbol (CONVERT_TMPH_GET_TYPE (esa)),
	   convert_tmph_pdf_flag_symbol (CONVERT_TMPH_GET_PDF (esa)),
	   convert_tmph_apid_symbol (CONVERT_TMPH_GET_APID (esa)),
	   convert_tmph_seg_flag_symbol (CONVERT_TMPH_GET_SEG (esa)),
	   CONVERT_TMPH_GET_SEQ (esa),
	   CONVERT_TMPH_GET_LEN (esa));

  fprintf (stderr,
           "\
 (tm-data-field\n");
  fprintf (stderr,
           "\
  (tm-packet-data-field-header\n");
  mdpb (esa + CONVERT_TMPH_SIZE, CONVERT_TMP_PDF_LEN);
  fprintf (stderr,
           "\
  )\n");

  fprintf (stderr,
	   "\
  (spacecraft-elapsed-time\n\
   (time-format %s)\n\
   (time-sec-ut-epoch-1970 %ld)\n\
   (time-usec %ld)\n\
  )\n",
	   convert_tmp_dfh_pfield_symbol (CONVERT_TMP_GET_PDF_FORMAT (esa)),
	   CONVERT_TMP_GET_PDF_SEC (esa),
	   CONVERT_TMP_GET_PDF_USEC (esa));


  fprintf (stderr,
	   "\
  (tm-data\n");
  mdpb (esa + CONVERT_TMPH_SIZE + CONVERT_TMP_PDF_LEN,
       CONVERT_TMPH_GET_LEN (esa) + 1 - CONVERT_TMP_PDF_LEN);
  fprintf (stderr,
	   "\
   )\n\
  )\n\
 )\n\
)\n");
}

/* }}} */
/* {{{ convert-create-dds-packet */

CONVERT_DDS_PACKET convert_create_dds_packet (CONVERT_DDSP_TIME *time,
					       CONVERT_DDSP_ADID src,
					       CONVERT_DDSP_LEN len,
					       CONVERT_CLUSTER_SCID scid,
					       CONVERT_DDSP_GSID gsid,
					       CONVERT_DDSP_STREAM chan,
					       CONVERT_DDSP_TCAL tcal,
					       CONVERT_DDSP_TAM tam,
					       unsigned char * data)
{
  static unsigned char * esoc = NULL;

  if (esoc == NULL)
    if ((esoc = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return NULL;
  
  CONVERT_DDSP_SET_SCET (time, esoc);
  CONVERT_DDSP_SET_SOURCE (src, esoc);
  CONVERT_DDSP_SET_LEN (len, esoc);
  CONVERT_DDSP_SET_SCID (scid, esoc);
  CONVERT_DDSP_SET_GSID (gsid, esoc);
  CONVERT_DDSP_SET_STREAM (chan, esoc);
  CONVERT_DDSP_SET_TCAL (tcal, esoc);
  CONVERT_DDSP_SET_TAM (tam, esoc);
  CONVERT_DDSP_SET_DATA (data, len, esoc);

  return esoc;
}

/* }}} */
/* {{{ convert-create-tm-packet */

CONVERT_TM_PACKET convert_create_tm_packet (CONVERT_TMPH_VER ver,
					     CONVERT_TMPH_TYPE type,
					     CONVERT_TMPH_PDF_FLAG pdf,
					     CONVERT_TMPH_APID apid,
					     CONVERT_TMPH_SEG seg,
					     CONVERT_TMPH_SEQ count,
					     CONVERT_TMPH_LEN len,
					     CONVERT_TMP_PDF_TIME *time,
					     unsigned char * data)
{
  static unsigned char * esa = NULL;

  if (esa == NULL)
    if ((esa = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return NULL;
  
  CONVERT_TMPH_SET_VER (esa, ver);
  CONVERT_TMPH_SET_TYPE (esa, type);
  CONVERT_TMPH_SET_PDF (esa, pdf);
  CONVERT_TMPH_SET_APID (esa, apid);
  CONVERT_TMPH_SET_SEG (esa, seg);
  CONVERT_TMPH_SET_SEQ (esa, count);
  CONVERT_TMPH_SET_LEN (esa, len);
  CONVERT_TMP_SET_PDF (esa, time);
  CONVERT_TMP_SET_DATA (esa, data, len);
  
  return esa;
}

/* }}} */


/* {{{ ted-spacecraft-2-convert-scid */

CONVERT_CLUSTER_SCID ted_2_convert_spacecraft (TED_SPACECRAFT spacecraft)
{
  switch (spacecraft)
    {
    case CLUSTER_1:
      return CONVERT_CLUSTER_SCID_1;
    case CLUSTER_2:
      return CONVERT_CLUSTER_SCID_2;
    case CLUSTER_3:
      return CONVERT_CLUSTER_SCID_3;
    case CLUSTER_4:
      return CONVERT_CLUSTER_SCID_4;
    default:
      return CONVERT_CLUSTER_SCID_NA;
    }
}

/* }}} */
/* {{{ ted-ground-2-convert-gsid */

CONVERT_DDSP_GSID ted_2_convert_ground (TED_GROUND ground)
{
  switch (ground)
    {
    case TED_GROUND_ODENWALD:
      return CONVERT_DDSP_GSID_ODENWALD;
    case TED_GROUND_REDU:
      return CONVERT_DDSP_GSID_REDU;
    case TED_GROUND_KOUROU:
      return CONVERT_DDSP_GSID_KOUROU;
    case TED_GROUND_PERTH:
      return CONVERT_DDSP_GSID_PERTH;
    case TED_GROUND_MALINDI:
      return CONVERT_DDSP_GSID_MALINDI;
    case TED_GROUND_CANBERRA:
      return CONVERT_DDSP_GSID_CANBERRA;
    case TED_GROUND_GOLDSTONE:
      return CONVERT_DDSP_GSID_GOLDSTONE;
    case TED_GROUND_NA:
      return CONVERT_DDSP_GSID_NA;
    default:
      return CONVERT_DDSP_GSID_NA;
    }
}

/* }}} */
/* {{{ ted-transmission-2-convert-stream-class */

CONVERT_DDSP_STREAM_CLASS ted_2_convert_transmission_mode (TED_TRANSMISSION transmission)
{
  switch (transmission)
    {
    case TED_TRANSMISSION_REALTIME:
      return CONVERT_DDSP_STREAM_RT_BASE;
    case TED_TRANSMISSION_PLAYBACK:
      return CONVERT_DDSP_STREAM_PB_BASE;
    case TED_TRANSMISSION_RECALL:
      return CONVERT_DDSP_STREAM_RE_BASE;
    case TED_TRANSMISSION_RECALLPLAYBACK:
      return CONVERT_DDSP_STREAM_RP_BASE;
    default:
      return CONVERT_DDSP_STREAM_NA_BASE;
    }
}

/* }}} */
/* {{{ ted-tcal-2-convert-tcal */

CONVERT_DDSP_TCAL ted_2_convert_time_quality (TED_QUALITY quality)
{
  switch (quality)
    {
    case TED_QUALITY_ACTUAL:
      return CONVERT_DDSP_TCAL_ACTUAL;
    case TED_QUALITY_EXTRAPOLATED:
      return CONVERT_DDSP_TCAL_EXTRAPOLATED;
    case TED_QUALITY_CONTINGENCY:
      return CONVERT_DDSP_TCAL_CONTINGENCY;
    default:
      return CONVERT_DDSP_TCAL_NA;
    }
}

/* }}} */

#ifndef TED_NO_FD

/* {{{ ted-convert-read-dds-packet */

unsigned char * ted_convert_read_ddsp (int file)
{

  static unsigned char * packet = NULL;

  if (packet == NULL)
    if ((packet = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return NULL;

  if (read (file,
	      packet,
	      CONVERT_DDSP_HEADER_SIZE)
      != CONVERT_DDSP_HEADER_SIZE)
    return NULL;
  
  if (read (file,
	    packet + CONVERT_DDSP_HEADER_SIZE,
	    (int) CONVERT_DDSP_GET_LEN (packet))
      != (int) CONVERT_DDSP_GET_LEN (packet))
    return NULL;
  
  return packet;
}

/* }}} */
/* {{{ ted-convert-read-tm-packet */

unsigned char * ted_convert_read_tmp (int file)
{
  static unsigned char * packet = NULL;

  if (packet == NULL)
    if ((packet = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return NULL;
  
  if (read (file, packet, CONVERT_TMPH_SIZE) != CONVERT_TMPH_SIZE)
    return NULL;

  if (read (file, packet + CONVERT_TMPH_SIZE, CONVERT_TMPH_GET_LEN (packet) + 1) !=
      CONVERT_TMPH_GET_LEN (packet))
    return NULL;
  
  return packet;
}

/* }}} */
/* {{{ ted-convert-write-tm-packet */

TED_STATUS ted_convert_write_tmp (int file, unsigned char * packet)
{
  
  if (write (file, packet, CONVERT_TMPH_SIZE) != CONVERT_TMPH_SIZE)
    return TED_CONVERT_TMP_WRITE_HEADER_ERR;
  
  if (write (file,
	       packet + CONVERT_TMPH_SIZE,
	      (int) CONVERT_TMPH_GET_LEN (packet) + 1) !=
      (int) CONVERT_TMPH_GET_LEN (packet) + 1)
    return TED_CONVERT_TMP_WRITE_DATA_ERR;

  return TED_OK;
}

/* }}} */
/* {{{ ted-convert-write-dds-packet */

TED_STATUS ted_convert_write_ddsp (int file, unsigned char * packet)
{
  if (write (file, packet, CONVERT_DDSP_HEADER_SIZE) !=
                                    CONVERT_DDSP_HEADER_SIZE)
    return TED_CONVERT_DDSP_WRITE_HEADER_ERR;
  
  if (write (file,
	       packet + CONVERT_DDSP_HEADER_SIZE,
	      (int) CONVERT_DDSP_GET_LEN (packet))
      != (int) CONVERT_DDSP_GET_LEN (packet))
    return TED_CONVERT_DDSP_WRITE_DATA_ERR;
  
  return TED_OK;
}

/* }}} */

#endif /*!TED_NO_FD*/

/* {{{ ted-convert-stream-read-dds-packet */

TED_STATUS ted_convert_stream_read_ddsp (FILE * file, unsigned char ** packet)
{
  static unsigned char * pkt = NULL;

  if (pkt == NULL)
    if ((pkt = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return TED_MEMORY;

  if (fread (pkt,
	     CONVERT_ITEM_SIZE,
	     CONVERT_DDSP_HEADER_SIZE,
	     file)
      != CONVERT_DDSP_HEADER_SIZE)
    return TED_READ_FILE;
  
  if (fread (pkt + CONVERT_DDSP_HEADER_SIZE,
	     CONVERT_ITEM_SIZE,
	     (int) CONVERT_DDSP_GET_LEN (pkt),
	     file)
      != (int) CONVERT_DDSP_GET_LEN (pkt))
    return TED_READ_FILE;
  
  *packet = pkt;
  return TED_OK;
}

/* }}} */
/* {{{ ted-convert-stream-read-tm-packet */

TED_STATUS ted_convert_stream_read_tmp (FILE * file, unsigned char ** packet)
{
  static unsigned char * pkt = NULL;
  
  if (pkt == NULL)
    if ((pkt = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return TED_MEMORY;
  
  if (fread (pkt,
	     CONVERT_ITEM_SIZE,
	     CONVERT_TMPH_SIZE,
	     file) != CONVERT_TMPH_SIZE)
    return TED_READ_FILE;

  if (fread (pkt + CONVERT_TMPH_SIZE,
	     CONVERT_ITEM_SIZE,
	     CONVERT_TMPH_GET_LEN (pkt) + 1,
	     file) != CONVERT_TMPH_GET_LEN (pkt) + 1)
    return TED_READ_FILE;
  
  *packet = pkt;
  return TED_OK;
}

/* }}} */

/* {{{ ted-convert-sis-tm-patch */

TED_STATUS ted_convert_sis_tm_patch (unsigned char *hk,
				     unsigned char *sc)
{

  if (hk == NULL) return TED_MEMORY;
  if (sc == NULL) return TED_MEMORY;

  memcpy (CONVERT_TMP_GET_DATA(sc) - CONVERT_TMP_PDF_LEN,
	  CONVERT_TMP_GET_DATA(hk) - CONVERT_TMP_PDF_LEN,
	  CONVERT_TMP_PDF_LEN);

  return TED_OK;
}

/* }}} */
/* {{{ ted-convert-stream-read-sis-packet */

TED_STATUS ted_convert_stream_read_sis_tmp (
FILE * file,
unsigned char ** packet
)
{
  static unsigned char * pkt = NULL;
  static unsigned char * sis = NULL;

  if (pkt == NULL)
    if ((pkt = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return TED_MEMORY;

  if (sis == NULL)
    if ((sis = (unsigned char *) malloc((size_t) CONVERT_TMP_MAX_LEN)) == NULL)
      return TED_MEMORY;

  {
    int ratio = 0;
    int index = 0;

    int sis_data_len;
    int pkt_len;
    int new_pkt_len;

    do {
      if (fread (sis,
		 CONVERT_ITEM_SIZE,
		 CONVERT_TMPH_SIZE,
		 file) != CONVERT_TMPH_SIZE)
	return TED_READ_FILE;
      
      if (fread (sis + CONVERT_TMPH_SIZE,
		 CONVERT_ITEM_SIZE,
		 ((CONVERT_TMPH_GET_LEN (sis)) + 1),
		 file) != ((CONVERT_TMPH_GET_LEN (sis)) + 1))
	return TED_READ_FILE;

      if (index == 0) {
	ratio = convert_packing_ratio (sis);
	memset (pkt,0,CONVERT_TMP_MAX_LEN);
	memcpy (pkt,sis,CONVERT_TMPH_SIZE + (CONVERT_TMPH_GET_LEN (sis)) + 1);
      }
      else {
	if ((int) (CONVERT_TMPH_SIZE\
		   + CONVERT_TMPH_GET_LEN (pkt)\
		   + 1\
		   + CONVERT_TMPH_GET_LEN (sis)\
		   + 1\
		   - CONVERT_TMP_PDF_LEN) < CONVERT_TMP_MAX_LEN) {
	  memcpy (pkt\
		  + CONVERT_TMPH_SIZE\
		  + CONVERT_TMPH_GET_LEN (pkt)\
		  + 1,
		  (sis\
		   + CONVERT_TMPH_SIZE\
		   + CONVERT_TMP_PDF_LEN),
		  CONVERT_TMPH_GET_LEN (sis)\
		  + 1);

	  sis_data_len = CONVERT_TMPH_GET_LEN (sis) + 1 - CONVERT_TMP_PDF_LEN;
	  pkt_len = CONVERT_TMPH_GET_LEN (pkt);
	  new_pkt_len = pkt_len + sis_data_len; 
	  CONVERT_TMPH_SET_LEN(pkt,new_pkt_len);
	}
	else {
	  fprintf (stderr, "pacing error\n");
	  return TED_MEMORY;
	}
      }
    } while (++index < ratio);
  }
  *packet = pkt;
  return TED_OK;
}

/* }}} */

/* {{{ ted-convert-stream-write-tm-packet */

TED_STATUS ted_convert_stream_write_tmp (FILE * file, unsigned char * packet)
{
  
  if (fwrite (packet,
	     CONVERT_ITEM_SIZE,
	     CONVERT_TMPH_SIZE,
	     file) != CONVERT_TMPH_SIZE)
    return TED_CONVERT_TMP_WRITE_HEADER_ERR;
  
  if (fwrite (packet + CONVERT_TMPH_SIZE,
	      CONVERT_ITEM_SIZE,
	      (int) CONVERT_TMPH_GET_LEN (packet) + 1,
	      file) != (int) CONVERT_TMPH_GET_LEN (packet) + 1)
    return TED_CONVERT_TMP_WRITE_DATA_ERR;

  return TED_OK;
}

/* }}} */
/* {{{ ted-convert-stream-write-dds-packet */

TED_STATUS ted_convert_stream_write_ddsp (FILE * file, unsigned char * packet)
{
  if (fwrite (packet,
	      CONVERT_ITEM_SIZE,
	      CONVERT_DDSP_HEADER_SIZE,
	      file) != CONVERT_DDSP_HEADER_SIZE)
    return TED_CONVERT_DDSP_WRITE_HEADER_ERR;
  
  if (fwrite (packet + CONVERT_DDSP_HEADER_SIZE,
	      CONVERT_ITEM_SIZE,
	      (int) CONVERT_DDSP_GET_LEN (packet),
	      file) != (int) CONVERT_DDSP_GET_LEN (packet))
    return TED_CONVERT_DDSP_WRITE_DATA_ERR;
  
  return TED_OK;
}

/* }}} */

/* {{{ ted-convert-dds-packet-2-tm-packet */

TED_STATUS ted_convert_dds2esatm (unsigned char  *ddspacket,
				   unsigned char **esatmpacket,
				   int sequence_count)
{

  if (! convert_isa_ddsp_source (CONVERT_DDSP_GET_SOURCE (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_SOURCEINVALID; }

  if (! convert_isa_ddsp_scid (CONVERT_DDSP_GET_SCID (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_SPACECRAFTINVALID; }

  if (! convert_ddsp_match_scid_and_source (CONVERT_DDSP_GET_SCID (ddspacket),
			      CONVERT_DDSP_GET_SOURCE (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_SPACECRAFTMATCH; }

  if (! convert_isa_ddsp_stream (CONVERT_DDSP_GET_STREAM (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_STREAMINVALID; }

  if (! convert_isa_ddsp_ground (CONVERT_DDSP_GET_GSID (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_GROUNDINVALID; }

  if (! convert_match_ddsp_source_and_stream (
				 CONVERT_DDSP_GET_SOURCE (ddspacket),
				 CONVERT_DDSP_GET_STREAM (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_CHANNELTYPE_MATCH; }

  if (! convert_isa_ddsp_tcal (CONVERT_DDSP_GET_TCAL (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_QUALITYINVALID; }

  if (! convert_isa_ddsp_tam (CONVERT_DDSP_GET_TAM (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_SEQUENCEINVALID; }

  if (! convert_ddsp_too_long (CONVERT_DDSP_GET_LEN (ddspacket)))
    { *esatmpacket = NULL; return TED_CONVERT_TOOLONG; }

  /* convert the packet */
  *esatmpacket = convert_create_tm_packet (
	CONVERT_TMPH_VER_CUR,
	CONVERT_TMPH_TYPE_TM,
	CONVERT_TMPH_PDF_FLAG_EXISTS,
	convert_ddsp_source_2_tmph_apid ((CONVERT_DDS_PACKET) ddspacket),
	convert_ddsp_2_tmph_seg ((CONVERT_DDS_PACKET) ddspacket),
	convert_ddsp_2_tmph_sequence ((CONVERT_DDS_PACKET) ddspacket, sequence_count),
	convert_ddsp_length_2_tmph_length ((CONVERT_DDS_PACKET) ddspacket,
					     CONVERT_TMPH_PDF_FLAG_EXISTS),
	convert_ddsp_time_2_tmp_pdf_time ((CONVERT_DDS_PACKET) ddspacket),
	(unsigned char *) CONVERT_DDSP_GET_DATA (ddspacket));
  return TED_OK;
}

/* }}} */
/* {{{ ted-convert-tm-packet-2-dds-packet */

TED_STATUS ted_convert_esatm2dds (unsigned char  *esatmpacket,
				   unsigned char **ddspacket,
				   TED_SPACECRAFT spacecraft,
				   TED_TRANSMISSION transmission_mode,
				   TED_QUALITY time_quality,
				   TED_GROUND ground)
{

#if 0
  if (! convert_isa_tmph_version (CONVERT_TMPH_GET_VER (esatmpacket)))
    { *ddspacket = NULL; return TED_CONVERT_WRONGVERSION; }
#endif

  if (! convert_isa_tmph_type (CONVERT_TMPH_GET_TYPE (esatmpacket)))
    { *ddspacket = NULL; return TED_CONVERT_WRONGTYPE; }

  if (! convert_isa_tmph_segment (CONVERT_TMPH_GET_SEG (esatmpacket)))
    { *ddspacket = NULL; return TED_CONVERT_SEGWRONG; }


  if (! convert_isa_tmph_apid (CONVERT_TMPH_GET_APID (esatmpacket)))
    { *ddspacket = NULL; return TED_CONVERT_APIDINVALID; }

#if 0
  if (! convert_isa_tmph_pdf_flag (CONVERT_TMPH_GET_PDF (esatmpacket)))
    { *ddspacket = NULL; return TED_CONVERT_FLAGWRONG; }
#endif

  if (! convert_isa_tmp_pfield (CONVERT_TMP_GET_PDF_FORMAT (esatmpacket)))
    { *ddspacket = NULL; return TED_CONVERT_PFIELDWRONG; }

  *ddspacket = convert_create_dds_packet (
      convert_tmp_pdf_time_2_ddsp_time (esatmpacket),
      convert_tmph_apid_2_ddsp_adid (ted_2_convert_spacecraft (spacecraft), esatmpacket),
      CONVERT_TMP_GET_LEN (esatmpacket) + 1,
      ted_2_convert_spacecraft (spacecraft),
      ted_2_convert_ground (ground),
      convert_tmph_2_ddsp_stream (ted_2_convert_transmission_mode (transmission_mode), esatmpacket),
      ted_2_convert_time_quality (time_quality),
      convert_tmph_2_ddsp_tam (esatmpacket),
      (unsigned char *) CONVERT_TMP_GET_DATA (esatmpacket));

  return TED_OK;
}

/* }}} */

/* Local variables: */
/* folded-file: t */
/* end: */



