
%{

/**
 * $Id: calpoint.y,v 1.1 2001/09/26 14:07:14 simond Exp $
 */

#define _calpoint_y

#include <tedsys.h>
#include <calinf.h>
#include <calres.h>

static int    calpoint_interpolate(void);
static int    calpoint_range_set(double);
static int    calpoint_domain_set(long);

%}

%union {
  long   LONG;
  float  DBL;
  int    INT;
};

%token <LONG> CALPOINT_INTLIT
%token <DBL>  CALPOINT_REALIT

%type <INT> CALPOINT_COORDS
%type <INT> CALPOINT_COORD
%type <INT> CALPOINT_DOMAIN
%type <INT> CALPOINT_RANGE

%%

/* {{{ CALPOINT_COORDS */

CALPOINT_COORDS:
	  CALPOINT_COORD
	{
	  $$ = $1;
	}
	| CALPOINT_COORD ',' CALPOINT_COORDS
	{
	  $$ = $3;
	}
	;

/* }}} */
/* {{{ CALPOINT_COORD */

CALPOINT_COORD:
	  '(' CALPOINT_DOMAIN ',' CALPOINT_RANGE ')'
	{
	  $$ = calpoint_interpolate();
#ifdef _DEBUG_CALPOINT_
	  fprintf(stderr,
		  "calpoint_interpolate => %d,%d,%d %f %f %f\n",
		  X,X1,X2,Y,Y1,Y2);
#endif
	  if ($$ == CALINF_COORD_FOUND)
	    return 0;
	}
	;

/* }}} */
/* {{{ CALPOINT_DOMAIN */

CALPOINT_DOMAIN:
	  CALPOINT_INTLIT
	{
	  extern char yytext[];
	  int i;
	  if (sscanf(yytext,"%d",&i) != 1) return 0;
	  $$ = calpoint_domain_set(i);
	}
	;

/* }}} */
/* {{{ CALPOINT_RANGE */

CALPOINT_RANGE:
	  CALPOINT_INTLIT
	{
	  double r;
	  extern char yytext[];
	  if (sscanf(yytext,"%lf",&r) != 1) return 0;
	  $$ = calpoint_range_set(r); 

	}
	| '-' CALPOINT_INTLIT
	{
	  double r;
	  extern char yytext[];

	  if (sscanf(yytext,"%lf",&r) != 1) return 0;

	  r = -r;
#ifdef _DEBUG_CALPOINT_
	  fprintf(stderr,"CALPOINT_RANGE2: %s\n",yytext);
#endif
	  $$ = calpoint_range_set((double) r);
	}
	| CALPOINT_REALIT
	{
	  extern char yytext[];
	  double r;

	  if (sscanf(yytext,"%lf",&r) != 1) return 0;
#ifdef _DEBUG_CALPOINT_
	  fprintf(stderr,"CALPOINT_RANGE3: %s\n",yytext);
#endif
	  $$ = calpoint_range_set(r);
	}
	| '-' CALPOINT_REALIT
	{
	  extern char yytext[];
	  double r;

	  if (sscanf(yytext,"%lf",&r) != 1) return 0;
	  r = -r;
#ifdef _DEBUG_CALPOINT_
	  fprintf(stderr,"CALPOINT_RANGE4: %s\n",yytext);
#endif
	  $$ = calpoint_range_set(r);
	}
	;

/* }}} */

%%

static double Y1,Y2,Y;
static int X1,X2,X;
static int firstDomain;
static int firstRange;

/* {{{ int calpoint_wrap(void) */

int
calpoint_wrap(
void
)
{
  return 1;
}

/* }}} */
/* {{{ int calpoint_error(const char *s) */

int
calpoint_error(
const char *s
)
{
  /*
    if (s != NULL)
    fprintf(stderr,"calpoint %s\n",s);
  */
  return 0;
}

/* }}} */

/* {{{ static int    calpoint_interpolate(void) */

static
int
calpoint_interpolate(
void
)
{
  double t;
  double o;
  extern int X;
  extern int X1;
  extern int X2;

  if (X == X1) {
    Y = Y1;
    return CALINF_COORD_FOUND;
  }
  if (X == X2) {
    Y = Y2;
    return CALINF_COORD_FOUND;
  }

  if ((X1 < X) && (X < X2)) {
    t = (Y2 - Y1) / (X2 - X1);
    o = t * (X - X1);
    o += Y1;
    Y = o;
    return CALINF_COORD_FOUND;
  }

  return CALINF_COORD_NOT_FOUND;
}

/* }}} */
/* {{{ static int    calpoint_range_set(double) */

static
int
calpoint_range_set(
double y
)
{
#ifdef _DEBUG_CALPOINT_
  fprintf(stderr,"calpoint_range_set => %lf \n",y);
#endif
  if (firstRange) {
    firstRange = !firstRange;
    Y1 = Y2 = y;
  }
  else {
    Y1 = Y2;
    Y2 = y;
  }
  return CALINF_COORD_NOT_FOUND;
}

/* }}} */
/* {{{ static int    calpoint_domain_set(long) */

static
int
calpoint_domain_set(
long x
)
{
#ifdef _DEBUG_CALPOINT_
  fprintf(stderr,"calpoint_domain_set => %ld \n",x);
#endif

  if (firstDomain) {
    firstDomain = 0;
    X1 = X2 = x;
  }
  else {
    X1 = X2;
    X2 = x;
  }
  return CALINF_COORD_NOT_FOUND;
}

/* }}} */

/* {{{ int    calpoint_yacc_init(unsigned long,char *) */

int
calpoint_yacc_init(
unsigned long r,
char *text
)
{
  firstDomain = 1;
  firstRange  = 1;
  X = r;
#ifdef _DEBUG_CALPOINT_
  fprintf(stderr,"calpoint_yacc_init => %ld,%s\n",r,text);
#endif
  return calpoint_lex_init(text,strlen(text) + 1);
}

/* }}} */
/* {{{ int    calpoint_res_get(void) */

int
calpoint_res_get(
void
)
{
  extern YYSTYPE yyval;
  return yyval.INT;
}

/* }}} */
/* {{{ double calpoint_coord_get(void) */

double
calpoint_coord_get(
void
)
{
  return Y;
}

/* }}} */

/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */





