
%{

/**
 * $Id: calenum.y,v 1.2 2001/09/28 10:20:59 simond Exp $
 */
#define _calenum_y

#include <tedsys.h>
#include <calinf.h>
#include <calres.h>

enum CALENUM_DEBUG {
  DEBUG_CALENUM_NONE             =  0x00,
  DEBUG_CALENUM_ENUMERATE_1      =  0x01,
  DEBUG_CALENUM_ENUMERATE_2      =  0x02,
  DEBUG_CALENUM_NEXTSTATUSLHS_1  =  0x04,
  DEBUG_CALENUM_NEXTSTATUSRHS_1  =  0x08,
  DEBUG_CALENUM_YACCINIT_1       =  0x10,
  DEBUG_CALENUM_ENUMSTATUS_1     =  0x20,
  DEBUG_CALENUM_ENUMRES_1        =  0x40,
  DEBUG_CALENUM_RULE_LHS_1       =  0x80,
  DEBUG_CALENUM_RULE_RHS_1       = 0x100
};
static enum CALENUM_DEBUG debug = DEBUG_CALENUM_NONE;

static int calenum_enumerate(void);
static int calenum_next_lhs(unsigned int,unsigned int);
static int calenum_next_rhs(char []);

%}

%union {
  char   STRING[1023];
  int    INT;
};


%token <STRING> CALENUM_STRING
%type <INT> stats
%type <INT> status
%type <INT> statusLhs
%type <INT> statusRhs

%%

/* {{{ stats */

stats:
	  status
	{
	  $$ = $1;
	}
	| status ',' stats
	{
	  $$ = $1;
	}
	;

/* }}} */
/* {{{ status */

status:	statusLhs '=' statusRhs
	{
	  $$ = calenum_enumerate();
	  if ($$ == CALINF_STATUS_FOUND)
	    return 0;
	}
	;

/* }}} */
/* {{{ status-lhs */

statusLhs:
	CALENUM_STRING
	{
	  int min,max;
	  int count;

	  if (debug & DEBUG_CALENUM_RULE_LHS_1)
	    fprintf(stderr,"statusLhs(\"%s\") = %d\n",$1,$$);
	  
	  count = sscanf($1,"%i-%i",&min,&max);
	  if (count == 2) {
	    $$ = calenum_next_lhs(min,max);

	  }
	  else {
	    count = sscanf($1,"%i",&min);
	    if (count == 1) {
	      $$ = calenum_next_lhs(min,min);
	    }
	    else
	      return !0;
	  }
	}
	;

/* }}} */
/* {{{ status-rhs */

statusRhs:
	  CALENUM_STRING
	{
	  $$ = calenum_next_rhs($1);
	  if (debug & DEBUG_CALENUM_RULE_RHS_1)
	    fprintf(stderr,"statusRhs(\"%s\") = %d\n",$1,$$);
	}
	;

/* }}} */

%%


static int X1,X2,X;
char statusString[10240];
char    calString[10240];

/* {{{ int calenum_error(const char *) */

int calenum_error(const char *s)
{
  /*
   * if (s != NULL)
   * fprintf(stderr,"calenum %s\n",s);
   */
  return 1;
}

/* }}} */

/* {{{ static int calenum_enumerate(void) */

static
int
calenum_enumerate(
void
)
{
  if ((X >= X1) && (X <= X2)) {
    if (debug & DEBUG_CALENUM_ENUMERATE_1)
      fprintf(stderr,"enumerate = %s (X(%d) >= X1(%d)) && (X(%d) <= X2(%d)))\n","CALINF_STATUS_FOUND",X,X1,X,X2);
    return CALINF_STATUS_FOUND;
  }
  else {
    if (debug & DEBUG_CALENUM_ENUMERATE_2)
      fprintf(stderr,"enumerate = %s (X(%d) >= X1(%d)) && (X(%d) <= X2(%d)))\n","CALINF_STATUS_NOT_FOUND",X,X1,X,X2);
  }
  return CALINF_STATUS_NOT_FOUND;
}

/* }}} */
/* {{{ static int calenum_next_lhs(unsigned int,unsigned int) */

static
int
calenum_next_lhs(
unsigned int x1,
unsigned int x2
)
{
  X1 = x1;
  X2 = x2;

  if (debug & DEBUG_CALENUM_NEXTSTATUSLHS_1)
    fprintf(stderr,"nextStatusLhs(%d,%d)\n",x1,x2);

  return CALINF_STATUS_NOT_FOUND;
}

/* }}} */
/* {{{ static int calenum_next_rhs(char []) */

static
int
calenum_next_rhs(
char text[]
)
{
  strcpy(statusString,text);

  if (debug & DEBUG_CALENUM_NEXTSTATUSRHS_1)
    fprintf(stderr,"nextStatusRhs(\"%s\")\n",text);

  if ((X >= X1) && (X <= X2))
    return CALINF_STATUS_FOUND;
  else
    return CALINF_STATUS_NOT_FOUND;
}

/* }}} */

/* {{{ int     calenum_yacc_init(unsigned long,char *) */

int
calenum_yacc_init(
unsigned long r,
char *text
)
{
  if (debug & DEBUG_CALENUM_YACCINIT_1)
    fprintf(stderr,"calEnumYaccInit(%d,\"%s\")\n",r,text);
  strcpy(statusString,"");
  strcpy(calString,"");
  X = r;
  return calenum_lex_init(text,strlen(text) + 1);
}

/* }}} */
/* {{{ char * calenum_status_get(void) */

char *
calenum_status_get(
void
)
{
  if (debug & DEBUG_CALENUM_ENUMSTATUS_1)
    fprintf(stderr,"calEnumStatus(void) = \"%s\")\n",statusString);
  return statusString;
}

/* }}} */
/* {{{ int       calenum_res_get(void) */

int
calenum_res_get(
void
)
{
  extern YYSTYPE yyval;
  if (debug & DEBUG_CALENUM_ENUMRES_1)
    fprintf(stderr,"calEnumRes(%d)\n",yyval.INT);
  calenum_status_get();
  if (strlen(statusString) > 0)
    return CALINF_STATUS_FOUND;
  else
    return CALINF_STATUS_NOT_FOUND;
}

/* }}} */

/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */

