

%{

/**
 * $Id: alias.y,v 1.1 2001/09/26 14:07:12 simond Exp $
 */

#include <tedsys.h>
#include <hkextp.h>

extern char yytext[];

static HkextractSymbol * newSymbol = NULL;

%}
%union {
  HkextractSymbol *SYMBOL;
  char   STRING[1023];
  int    INT;
};

%token <STRING> ALIAS_STRING

%type  <SYMBOL> alias
%type  <STRING> wec
%type  <STRING> dds
%%

/* {{{ alias */

alias: wec dds
	{
	  $$ = (HkextractSymbol *) hkextractNewSymbol($1,
			HkextractSymbolTypeText,
			$2);
	}
	;

/* }}} */
/* {{{ wec */

wec:	ALIAS_STRING
	{
	  sprintf($$,"%s",yytext);
	}
	;

/* }}} */
/* {{{ dds */

dds:	  ALIAS_STRING
	{
	  sprintf($$,"%s",yytext);
	}
	;

/* }}} */

%%

int yyerror(const char *s) {
  if (s != NULL)
    fprintf(stderr,"alias %s\n",s);
  return 0;
}

static HkextractSymbol *aliasSymbol = NULL;

/* {{{ int alias_yacc_init(void *,char *) */

int 
alias_yacc_init(
void *pSymbol,
char *text
)
{
  if (pSymbol == NULL)
    return HkextractStatusParseAliasesArgs;

  if (text == NULL)
    return HkextractStatusParseAliasesArgs;

  aliasSymbol = (HkextractSymbol *) pSymbol;

  return alias_lex_init(text,strlen(text) + 1);
}

/* }}} */

/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */



