
%{

/**
 * $Id: calpoint.l,v 1.1 2001/09/26 14:07:11 simond Exp $
 */

#define _calpointl_c

#define YY_NO_INPUT
#define YY_INPUT calpoint_ip
#define YY_NO_UNPUT
#define YY_UNPUT calpoint_up

#ifdef  input
#undef  input
#endif
#ifdef  unput
#undef  unput
#endif

#include <calinf.h>
#include <calpoint.h>

%}

integer		-?[0-9]+
real		-?([0-9]+\.[0-9]+)([eE][-+]?[0-9]+)?
eol		\n

%%

\(		{ return '('; }
\)		{ return ')'; }
\,		{ return ','; }
{integer} {
#ifdef _DEBUG_CALPOINT_
 fprintf(stderr,"integer = %s\n",yytext);
#endif
 return CALPOINT_INTLIT;
}
{real} { 
#ifdef _DEBUG_CALPOINT_
  fprintf(stderr,"real = %s\n",yytext);
#endif
  return CALPOINT_REALIT;
}
{eol}		{ ; }
.		{ ; }

%%

static char *calPointStr;
static int   calPointIdx;
static int   calPointSize;

/* {{{ int  calpoint_ip() */

int calpoint_ip()
{
    if (calPointIdx < calPointSize)
	return calPointStr[calPointIdx++];
    return 0;
}

/* }}} */
/* {{{ void calpoint_up() */

void calpoint_up(int c) {
  if (calPointIdx > 0)
    calPointIdx--;
}

/* }}} */
/* {{{ int  calpoint_lex_init(char *,int) */

int calpoint_lex_init(char *str,int size)
{
    int i = 0;
    int j = 0;

#ifdef _DEBUG_CALPOINT_
    fprintf(stderr,"calpoint_lex_init => %ld,%s\n",size,str);
#endif
    for (i = 0; i < strlen(str); i++) {
	if (!isspace(str[i])) {
	    j = ~0;
	    break;
	}
    }

    if (j == 0)	return 0;

    calPointStr = str;
    calPointIdx = 0;
    calPointSize = size;
    return 1;
}

/* }}} */

/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */

