 
%{

/**
 * $Id: calinf.y,v 1.1 2001/09/26 14:07:10 simond Exp $
 */

#define _calinf_y

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <calres.h>

%}


%union {
  long   LONG;
  float  DBL;
  char   STRING[1023];
  int    INT;
};

%token <STRING> CALINF_STRING
%token <LONG>   CALINF_INTLIT
%token <DBL>    CALINF_REALIT

%type <INT> calinf

%type <INT> stats
%type <INT> status
%type <INT> statusLhs
%type <INT> statusRhs

%type <INT> coords
%type <INT> coord
%type <INT> domain
%type <INT> range

%%

/* {{{ calinf */

calinf:
	  coords
	{
	  if ($1 != CALINF_COORD_FOUND) {
	    $$  = CALINF_STATUS_NA;
	  }
	  else
	    $$ = $1;
	}
	| stats
	{
	  if ($$ != CALINF_STATUS_FOUND) {
	    $$ = CALINF_STATUS_NA;
	  }
	  else
	    $$ = $1;
	}
	;

/* }}} */

/* {{{ coords */

coords:
	  coord
	{
	  $$ = $1;
	}
	| coord ',' coords
	{
	  $$ = $3;
	}
	;

/* }}} */
/* {{{ coord */

coord:
	  '(' domain ',' range ')'
	{
	  $$ = interpolate();
	  if ($$ == CALINF_COORD_FOUND)
	    return 0;
	}
	;

/* }}} */
/* {{{ domain */

domain:
	  CALINF_INTLIT
	{
	  $$ = domain($1);
	}
	| CALINF_INTLIT '-' CALINF_INTLIT
	{
	  $$ = domain($1);
	  $$ = domain($3);
	}
	;

/* }}} */
/* {{{ range */

range:
	  CALINF_INTLIT
	{
	  $$ = range((double) $1);
	}
	| '-' CALINF_INTLIT
	{
	  $$ = range((double) -$2);
	}
	| CALINF_REALIT
	{
	  $$ = range($1);
	}
	| '-' CALINF_REALIT
	{
	  $$ = range(-$2);
	}
	;

/* }}} */

/* {{{ stats */

stats:
	  status
	{
	  $$ = $1;
	}
	| status ',' stats
	{
	  $$ = $3;
	}
	;

/* }}} */
/* {{{ status */

status:	statusLhs '=' statusRhs
	{
	  $$ = enumerate();
	  if ($$ == CALINF_STATUS_FOUND)
	    return 0;
	}
	;

/* }}} */
/* {{{ status-lhs */

statusLhs:
	CALINF_INTLIT
	{
	  $$ = nextStatusLhs($1,$1);
	}
	| CALINF_INTLIT '-' CALINF_INTLIT
	{ 
	  $$ = nextStatusLhs($1,$3);
	}
	;

/* }}} */
/* {{{ status-rhs */

statusRhs:
	  CALINF_STRING
	{
	  $$ = nextStatusRhs($1);
	}
	;

/* }}} */

%%

static double Y1,Y2,Y;
static int X1,X2,X;
static int firstDomain;
static int firstRange;

char statusString[1024];
int calStrPos;
char calString[1024];

/* {{{ int CALINF_YYWRAP(void) */

int CALINF_YYWRAP(void)
{
  return 1;
}

/* }}} */
/* {{{ int CALINF_YYERROR(void) */

int CALINF_YYERROR(void)
{
  return 1;
}

/* }}} */
/* {{{ interpolate */

int
interpolate(
void
)
{
  double t;
  double o;
  if (X == X1) {
    Y = Y1;
    return CALINF_COORD_FOUND;
  }
  if (X == X2) {
    Y = Y2;
    return CALINF_COORD_FOUND;
  }

  if ((X1 < X) && (X < X2)) {
    t = (Y2 - Y1) / (X2 - X1);
    o = t * (X - X1);
    o += Y1;
    Y = o;
    return CALINF_COORD_FOUND;
  }

  return CALINF_COORD_NOT_FOUND;
}

/* }}} */
/* {{{ range */

int
range(
double y
)
{
  if (firstRange) {
    firstRange = !firstRange;
    Y1 = Y2 = y;
  }
  else {
    Y1 = Y2;
    Y2 = y;
  }
  return CALINF_COORD_NOT_FOUND;
}

/* }}} */
/* {{{ domain */

int
domain(
long x
)
{
  if (firstDomain) {
    firstDomain = 0;
    X1 = X2 = x;
  }
  else {
    X1 = X2;
    X2 = x;
  }
  return CALINF_COORD_NOT_FOUND;
}

/* }}} */
/* {{{ enumerate */

int
enumerate(
void
)
{
  fprintf(stdout,"(enumerate %d %d %d %s)\n",X1,X2,X,statusString);

  if ((X >= X1) && (X <= X2)) {
    fprintf(stdout,"(enumerate found)\n");
    return CALINF_STATUS_FOUND;
  }
  else {
    return CALINF_STATUS_NOT_FOUND;
  }
}

/* }}} */
/* {{{ enumeration */

int
enumeration(
char *str
)
{
  strcpy(statusString,str);
  return CALINF_STATUS_NOT_FOUND;
}

/* }}} */
/* {{{ lhs */

int
nextStatusLhs(
unsigned int x1,
unsigned int x2
)
{
  X1 = x1;
  X2 = x2;

  return CALINF_STATUS_NOT_FOUND;
}

/* }}} */
/* {{{ rhs */

int
nextStatusRhs(
char text[]
)
{
  strcpy(statusString,text);
  if ((X >= X1) && (X <= X2))
    return CALINF_STATUS_FOUND;
  else
    return CALINF_STATUS_NOT_FOUND;
}

/* }}} */
/* {{{ calinfYaccInit */

void
calinfLexInit(
char *,
int
);

void
calinfYaccInit(
unsigned long r,
char *text
)
{
  firstDomain = 1;
  firstRange  = 1;
  strcpy(statusString," ");
  strcpy(calString," ");
  X = r;
  calinfLexInit(text,strlen(text) + 1);
}

/* }}} */
/* {{{ calinfResString */

char *
calinfResString(
int res
)
{
  switch (res) {
  case CALINF_STATUS_NA:        return "CALINF_STATUS_NA";
  case CALINF_COORD_FOUND:      return "CALINF_COORD_FOUND";
  case CALINF_COORD_NOT_FOUND:  return "CALINF_COORD_NOT_FOUND";
  case CALINF_STATUS_FOUND:     return "CALINF_STATUS_FOUND";
  case CALINF_STATUS_NOT_FOUND: return "CALINF_STATUS_NOT_FOUND";
  default:                      return "CALINF_RES_UNDEFINED";
  }
}

/* }}} */
/* {{{ calinfRes */

int
calinfRes(
void
)
{
  return yyval.INT;
}

/* }}} */
/* {{{ calinfCoord */

double
calinfCoord(
void
)
{
  return Y;
}

/* }}} */
/* {{{ calinfStatus */

char *
calinfStatus(
void
)
{
  return statusString;
}

/* }}} */

#ifdef CAL_YACC

#include <stdlib.h>

/* {{{ main */

int
main(
int argc,
char *argv[]
)
{
  extern YYSTYPE yyval,yyval;

  if (argc >= 3) {
    fprintf(stdout,"%s\n",argv[1]);
    fprintf(stdout,"%s\n",argv[2]);
    calinfYaccInit(atoi(argv[1]),argv[2]);
    yyparse();
    switch (yyval.INT) {
    case CALINF_STATUS_FOUND:
      fprintf(stdout,"CALINF_STATUS_FOUND -> %s\n",calinfStatus());
      break;
    case CALINF_COORD_FOUND:
      fprintf(stdout,"CALINF_COORD_FOUND -> %f\n",calinfCoord());
      break;
    default:
      fprintf(stdout,"bugger!!!!!!!!!\n");
    }
  }
}

/* }}} */

#endif


/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */
