

%{

/**
 * $Id: calinf.l,v 1.1 2001/09/26 14:07:10 simond Exp $
 */

#include <calinf.h>

#if PLATFORM == SunOS
#undef input
#define input calinfInput
#undef unput
#define unput(a) calinfUnput(a)
#endif

extern YYSTYPE yyval;

%}

integer		[0-9]+
real		([0-9]+\.[0-9]+)([eE][-+]?[0-9]+)?
status		[a-zA-Z][a-zA-Z0-9 \'\!\@\#\$\%]*
ws		[ \t]
eol		\n

%%

\(		{ return '('; }
\)		{ return ')'; }
\-		{ return '-'; }
\=		{ return '='; }
\,		{ return ','; }
{integer}	{ sscanf(yytext,"%ld",&(yyval.LONG));
		  return TINTLIT; }
{real}		{ sscanf(yytext,"%f",&(yyval.DBL));
		  return TREALIT; }
{status}	{ strcpy(yyval.STRING,yytext);
		  return TSTRING; }
{ws}		{ ; }
{eol}		{ ; }
.		{ ; }

%%

static char *calStr;
static int calIdx;
static int calSize;

void calinfLexInit(char *str,int size) { calStr = str; calIdx = 0; calSize = size; }
int  YY_INPUT(void)  { if (calIdx < calSize) return calStr[calIdx++]; return 0; }
void YY_UNPUT(int c) { if (calIdx > 0)  calIdx--; }

#ifdef CAL_LEX

/* {{{ main */

int
main(
int argc,
char *argv[]
)
{
  int res;

  calinfLexInit(argv[1],strlen(argv[1]) + 1);

  while (res = yylex()) {
    switch(res) {
    case TSTRING:
      fprintf(stdout,"TSTRING: %s\n",yytext);
      break;
    case TINTLIT:
      fprintf(stdout,"TINTLIT: %s\n",yytext);
      break;
    case TREALIT:
      fprintf(stdout,"TREALIT: %s\n",yytext);
      break;
    default:
      fprintf(stdout,"undefined: %s\n",yytext);
      break;
    }
  }
}

/* }}} */
/* {{{ yywrap */

int
yywrap(
void
)
{
  return 1;
}

/* }}} */

#endif

/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */
