
%{
/**
 * $Id: calenum.l,v 1.1 2001/09/26 14:07:09 simond Exp $
 */

#define _calenum_l

#define YY_NO_INPUT
#define YY_INPUT calenum_ip
#define YY_NO_UNPUT
#define YY_UNPUT calenum_up

#ifdef input
#undef input
#endif

#ifdef unput
#undef unput
#endif

#include <calinf.h>
#include <calenum.h>

%}

string		[^=,]+

%%

\=		{ return '='; }
\,		{ return ','; }
{string}	{ strcpy(yylval.STRING,yytext); return CALENUM_STRING; }

%%

static char *calEnumStr;
static int   calEnumIdx;
static int   calEnumSize;

/* {{{ int calenum_lex_init(char *,int) */

int
calenum_lex_init(
char *str,
int size
)
{
    int i = 0;
    int j = 0;

    calEnumStr = str;
    calEnumIdx = 0;
    calEnumSize = size;

    if (str != NULL)
	if (strlen(str) < 1)
	    return j;

    for (i = 0; i < size; i++) {
	if (!isspace(str[i])) {
	    j = ~0;
	    break;
	}
    }

    return j;
}

/* }}} */
/* {{{ int calenum_wrap(void) */

int calenum_wrap(void) {  return 1; }

/* }}} */
/* {{{ int  calenum_ip() */

int
calenum_ip(
)
{
  extern int calEnumSize;

  if (calEnumIdx < strlen(calEnumStr)) {
    return calEnumStr[calEnumIdx++];
  }
  return 0;
}

/* }}} */
/* {{{ void calenum_up() */

void
calenum_up(
)
{
  if (calEnumIdx > 0)
    calEnumIdx--;
}

/* }}} */

/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */
