 
/* $Id: main.c,v 1.3 2001/09/26 15:56:36 simond Exp $ */

#define _hkm_c

#define REQUIRED_LIB_VERSION  4
#define EXPECTED_LIB_REVISION 4

#include <stdio.h>
#include <ted.h>
#include <hkext.h>

/* {{{ DDSP */

typedef struct DDSP_TIME {
    unsigned long days;
    unsigned long ms;
    unsigned int  us;
} ddspTime;

#define ddspHeaderLen 15

typedef struct DDSP {
  unsigned char header[ddspHeaderLen];
  unsigned char *buffer;
  unsigned long bufferSize;
  unsigned long bufferUsed;
} DDSP;

/* {{{ unsigned char * ddspPacket(DDSP *this) */

unsigned char * ddspPacket(DDSP *this)
{
  if (this != NULL)
    return this->buffer;
  return NULL;
}

/* }}} */
/* {{{ int               ddspInit(DDSP *this) */

int ddspInit(DDSP *this)
{
  this->buffer = NULL;
  this->bufferSize = 0;
  this->bufferUsed = 0;
  return !0;
}

/* }}} */
/* {{{ int               ddspRead(DDSP *this,FILE *pFILE) */

int ddspRead(DDSP *this,FILE *pFILE)
{

  if (this != NULL) {
    if (pFILE != NULL) {
      unsigned long size;
      long pos = ftell(pFILE);
      if (fread(this->header,
		sizeof(unsigned char),
		ddspHeaderLen,
		pFILE) == ddspHeaderLen) {
	size = ddspHeaderLen + hkextractDdspGetLen(this->header);
	if (this->bufferSize < size) {
	  free(this->buffer);
	  this->buffer = NULL;
	  this->bufferSize = 0;
	  this->bufferUsed = 0;
	}
	else
	  this->bufferUsed = 0;

	if (this->buffer == NULL) {
	  this->buffer = (unsigned char *) calloc(size,sizeof(char));
	  if (this->buffer != NULL) {
	    this->bufferSize = size;
	  }
	  else {
	    this->bufferSize = 0;
	    this->bufferUsed = 0;
	    return 0;
	  }
	}

	{
	  memcpy(this->buffer,this->header,ddspHeaderLen);
	  if (fread(this->buffer + ddspHeaderLen,
		    sizeof(unsigned char),
		    size - ddspHeaderLen,
		    pFILE) != (size - ddspHeaderLen)) {
	    this->bufferUsed = 0;
	    fseek(pFILE,0L,SEEK_SET);
	    return 0;
	  }
	  else {
	    this->bufferUsed += (size - ddspHeaderLen);
	    return !0;
	  }
	}
      }
      else
	return 0;
    }
    else
      return 0;
  }
  else
    return 0;
}

/* }}} */

/* }}} */
/* {{{ FILE * print_calibration(FILE *os,TED_HKEXTRACT_CALIBRATED_VALUE *pCalVal) */

FILE *
print_calibration(
FILE *os,
TED_HKEXTRACT_CALIBRATED_VALUE *pCalVal
)
{
  if (os == NULL) return NULL;
  if (pCalVal == NULL) return NULL;

  fprintf(os,"\n<hkm-calibration>");

  fprintf(os,"\n<raw><value><integer>%u</integer></value></raw>",pCalVal->raw);
  switch (pCalVal->wasCalibrated)
  {
  case TED_HKEXTRACT_CALIBRATED_YES: fprintf(os,"\n<was-calibrated><value><string>yes</string></value></was-calibrated>"); break;
  case TED_HKEXTRACT_CALIBRATED_NO:  fprintf(os,"\n<was-calibrated><value><string>no</string></value></was-calibrated>"); break;
  default:                           fprintf(os,"\n<was-calibrated><value><undefined/></value></was-calibrated>"); break; 
  }

  switch(pCalVal->Type) {
  case TED_HKEXTRACT_VALUE_TYPE_REAL: fprintf(os,"\n<result><value><real>%f</real></value></result>"    ,pCalVal->HKEXTRACT_SYMBOL_VALUE_u.Real); break;
  case TED_HKEXTRACT_VALUE_TYPE_TEXT: fprintf(os,"\n<result><value><string>%s</string></value></result>",pCalVal->HKEXTRACT_SYMBOL_VALUE_u.Text); break;
  default:                            fprintf(os,"\n<result><value><undefined/></value></result>"); break;
  }
  if (strlen(pCalVal->pMNEM))  fprintf(os,"\n<mnem><value><string>%s</string></value></mnem>"    ,pCalVal->pMNEM);
  if (strlen(pCalVal->pUNIT))  fprintf(os,"\n<unit><value><string>%s</string></value></unit>"    ,pCalVal->pUNIT);
  if (strlen(pCalVal->pCATEG)) fprintf(os,"\n<categ><value><string>%s</string></value></categ>"  ,pCalVal->pCATEG);
  if (strlen(pCalVal->pDESCR)) fprintf(os,"\n<descr><value><string>%s</string></value></descr>"  ,pCalVal->pDESCR);
  if (strlen(pCalVal->pCALIB)) fprintf(os,"\n<calinf><value><string>%s</string></value></calinf>",pCalVal->pCALIB);
  fprintf(os,"\n</hkm-calibration>");
  return os;
}

/* }}} */
/* {{{ OPTIONS */

#define mnemMaxIndex 256	/* # mnemonics available */
#define mnemMaxLen 20		/* length of each mnemonic */

enum OPTION_TASK
{
  OPTION_TASK_DO,
  OPTION_TASK_PRINT,
  OPTION_TASK_NA
};
typedef enum OPTION_TASK OPTION_TASK;

struct OPTIONS
{
  FILE *m_Hpd;			/* WEC HPD */
  FILE *m_Ali;			/* ALIAS */
  FILE *m_Hkd;			/* WEC HKD */
  FILE *m_Op;			/* Results */
  FILE *m_Wec;			/* WEC HPD */
  FILE *m_Par;			/* Mnemonics to be monitored */
  OPTION_TASK m_Task;
  TED_HPD_TABLE *HPD;		/* the table pointer */
  TED_HKEXTRACT_CALIBRATED_VALUE calVal; /* result table */
  char mnems[mnemMaxIndex][mnemMaxLen];	/* mnemonic array */
  DDSP * m_DDSP;
  char *buffer;
  int bufferSize;
  int bufferUsed;
  int print;
};
typedef struct OPTIONS OPTIONS;

/* {{{ void optionsUsage(OPTIONS *,int,char *[],FILE *) */

void
optionsUsage(
OPTIONS *this,
int argc,
char *argv[],
FILE *p_FILE
)
{
  fprintf(p_FILE,
	  "USAGE:\n\
\t%s -?\n\
\t%s [\n\
\t    [-a <alias file>]\n\
\t     -d <hpd file>\n\
\t     -h <hkd file>\n\
\t     -p <param file>\n\
\t   { -m <op file>\n\
\t   | -M\n\
\t   | -q <op file>\n\
\t   | -Q\n\
\t   }\n\
\t   ]\n ",
	  argv[0],
	  argv[0]
	  );
}

/* }}} */

/* {{{ int    optionsReadAliases(OPTIONS *,FILE *) */

int
optionsReadAliases(
OPTIONS *this,
FILE *pFILE
)
{
  long l_size = 0;

  if (this == NULL)    return 0;
  if (pFILE == NULL)   return 0;

  rewind(pFILE);

  if (fseek(pFILE,0L,SEEK_END) != -1)
    {
      l_size = ftell(pFILE);
      rewind(pFILE);
    }
  else
    return 0;

  if (this->buffer != NULL)
    {
      if (this->bufferSize < l_size)
	{
	  free(this->buffer);
	  this->buffer = NULL;
	  this->bufferSize = 0;
	  this->bufferUsed = 0;
	}
      else
	this->bufferUsed = 0;
    }

  if (this->buffer == NULL)
    {
      this->buffer = (char *) calloc(l_size + 1,sizeof(char));
      if (this->buffer != NULL)
	{
	  this->bufferSize = l_size + 1;
	  this->bufferUsed = 0;
	}
      else
	{
	  this->bufferSize = 0;
	  this->bufferUsed = 0;
	  return 0;
	}
    }

  {
    int len;
    len = fread(this->buffer,sizeof(char),l_size,pFILE);
    if (len > 0)
      this->bufferUsed = len;
    else
      {
	this->bufferUsed = 0;
	return 0;
      }

    if (len < l_size) return 0;
    this->buffer[l_size + 1] = '\0';
    return !0;
  }
}

/* }}} */
/* {{{ int optionsReadParameters(OPTIONS *,FILE *) */

int
optionsReadParameters(
OPTIONS *this,
FILE *pFILE
)
{
  long size;
  int index;
  char buffer[1024];

  if (this == NULL)    return 0;
  if (pFILE == NULL)   return 0;

  rewind(pFILE);

  for (index = 0; index < mnemMaxIndex; index++)
    {
      if (fgets(buffer,1024,pFILE) == NULL)
	{
	  if (!feof(pFILE)) return 0;
	  else return !0;
	}
    else
      {
	if ((int) strlen(buffer) > mnemMaxLen - 1)
	  return 0;
	else
	  {
	    sscanf(buffer,"%s",this->mnems[index]);
	  }
      }
    }

  if (this->buffer != NULL)
    {
      if (this->bufferSize < size)
	{
	  free(this->buffer);
	  this->buffer = NULL;
	  this->bufferSize = 0;
	  this->bufferUsed = 0;
	}
      else
	this->bufferUsed = 0;
    }

  if (this->buffer == NULL)
    {
      this->buffer = (char *) calloc(size,sizeof(char));
    if (this->buffer != NULL) {
      this->bufferSize = size;
      this->bufferUsed = 0;
    }
    else {
      this->bufferSize = 0;
      this->bufferUsed = 0;
      return 0;
    }
  }

  {
    int len;
    len = fread(this->buffer,sizeof(char),size,pFILE);
    if (len > 0)
      this->bufferUsed = len;
    else
      this->bufferUsed = 0;
  
    if (len < size)
      return 0;
    else
      return !0;
  }
}

/* }}} */
/* {{{ int        optionsAliFile(OPTIONS *,char []) */

int
optionsAliFile(
OPTIONS *this,
char filename[]
)
{
  this->m_Ali = fopen(filename,"r");
  if (this->m_Ali == NULL) return 0;
  return 1;
}

/* }}} */
/* {{{ int        optionsHpdFile(OPTIONS *,char []) */

int
optionsHpdFile(
OPTIONS *this,
char filename[]
)
{
  this->m_Hpd = fopen(filename,"r");
  if (this->m_Hpd == NULL) return 0;
  return !0;
}

/* }}} */
/* {{{ int        optionsHkdFile(OPTIONS *,char []) */

int
optionsHkdFile(
OPTIONS *this,
char filename[]
)
{
  this->m_Hkd = fopen(filename,"r");
  if (this->m_Hkd == NULL) return 0;
  return !0;
}

/* }}} */
/* {{{ int        optionsParFile(OPTIONS *,char []) */

int
optionsParFile(
OPTIONS *this,
char filename[]
)
{
  this->m_Par = fopen(filename,"r");
  if (this->m_Par == NULL) return 0;
  return !0;
}

/* }}} */
/* {{{ int             optionsDo(OPTIONS *,char []) */

int
optionsDo(
OPTIONS *this,
const char *p_char
)
{
  if (this->m_Op == NULL)
  {
         if (p_char == NULL)             { this->m_Op = stdout; }
    else if (strncmp(p_char,"-",1) == 0) { this->m_Op = stdout; }
    else
    {
      this->m_Op = fopen(p_char,"w");
      if (this->m_Op == NULL) return 0;
    }
  }
  this->m_Task = OPTION_TASK_DO;
  return !0;
}

/* }}} */
/* {{{ int          optionsPrint(OPTIONS *,char []) */

int
optionsPrint(
OPTIONS *this,
char *p_char
)
{
  int status;
  char *buffer = NULL;
  char *statusString = NULL;

  if (this->m_Op == NULL)
  {
           if (p_char == NULL)          { this->m_Op = stdout; }
      else if (strcmp("-",p_char) == 0) { this->m_Op = stdout; }
      else
      {
	this->m_Op = fopen(p_char,"w");
	if (this->m_Op == NULL) return 0;
      }
      this->m_Task = OPTION_TASK_PRINT;
      return !0;
    }
  return 0;
}

/* }}} */
/* {{{ int        optionsProcess(OPTIONS *) */

int
optionsProcess(
OPTIONS *this
)
{
  int status;
  char *buffer = NULL;
  char *statusString = NULL;

  if (this->m_Op == NULL) this->m_Op = stdout;

  /* {{{ HPD */

  {
    if (this->m_Hpd == NULL) return !0;
    if (this->m_DDSP == NULL) return !0;
    if (ddspRead(this->m_DDSP,this->m_Hpd) == 0)
      {
	fprintf(stderr,"error while reading an HPD Packet\n");
	return (0);
      }
  }

  /* }}} */
  /* {{{ ALI */

  {
    if (this->m_Ali != NULL)
      {
	status = optionsReadAliases(this,this->m_Ali);
	if (status == 0)
	  {
	    fprintf(stderr,"error loading lias test file\n");
	    return 0;
	  }
      }
  }

  /* }}} */
  /* {{{ PARSE TREE */

  {
    status = ted_hkextract_parse_and_build(&(this->HPD),
					   (unsigned char *) ddspPacket(this->m_DDSP),
					   (char *) this->buffer);
    if (status != TED_OK)
      {
	fprintf(stderr,"error constructing the HPD Table\n");
	return (status);
      }
  }

  /* }}} */
  /* {{{ PAR */

  {
    status = optionsReadParameters(this,this->m_Par);
    if (status == 0)
      {
	fprintf(stderr,"error read loading parameters\n");
	return (status);
      }
  }

  /* }}} */
  /* {{{ PROCESS */

  {
    /* {{{ HEADER */

    {
      int ted_version, ted_revision, ted_patch, ted_userpatch;
      int lib_version, lib_revision, lib_patch, lib_userpatch;
    
      fprintf(this->m_Op,"<?xml version=\"1.0\" encoding=\"US-ASCII\"?>");
      (void) ted_version_ted(&ted_version,&ted_revision,&ted_patch,&ted_userpatch);
      fprintf(this->m_Op,"\n<!-- TED Package %s -->",
	     VersionToString(ted_version,
			     ted_revision,
			     ted_patch,
			     ted_userpatch));
      
      (void) ted_version_lib(&lib_version,&lib_revision,&lib_patch,&lib_userpatch);
      
      if (lib_version == REQUIRED_LIB_VERSION) {
	if (lib_revision >= EXPECTED_LIB_REVISION)
	  fprintf(this->m_Op,"\n<!-- Using TED Library %s -->",
		 VersionToString(lib_version,
				 lib_revision,
				 lib_patch,
				 lib_userpatch));
      }
      else {
	if (lib_version == REQUIRED_LIB_VERSION)
	  fprintf(this->m_Op,"\n<!-- Warning: TED Library %s is older than expected %d.%d -->",
		 VersionToString(lib_version,
				 lib_revision,
				 lib_patch,
				 lib_userpatch),
		 REQUIRED_LIB_VERSION,
		 EXPECTED_LIB_REVISION);
	else {
	  fprintf(this->m_Op,"\n<!-- Requires TED Library Version %d.x found %s -->",
		 REQUIRED_LIB_VERSION,
		 VersionToString(lib_version,
				 lib_revision,
				 lib_patch,
				 lib_userpatch));
	  return 1;
	}
      }
    }

    /* }}} */

    switch (this->m_Task)
      {
      case OPTION_TASK_DO:
	fprintf(this->m_Op,"\n<!--<!DOCTYPE hkm SYSTEM \"hkm.dtd\">-->");
	fprintf(this->m_Op,"\n<hkm>");
	while (ddspRead(this->m_DDSP,this->m_Hkd) != 0)
	  {
	    int index = 0;
	    for (index = 0; strlen(this->mnems[index]) > 0;index++)
	    {
	      fprintf(this->m_Op,"\n<hkm-monitor name=\"%s\">",this->mnems[index]);
	      status = ted_hkextract_extract((unsigned char *)ddspPacket(this->m_DDSP),
					     this->mnems[index],
					     this->HPD,
					     &(this->calVal));
	      ted_toolbox_status2string(status,&statusString);
	      switch(status)
	      {
	      case TED_HKEXTRACT_EXTRACT_CALIBRATE:
	      case TED_OK:
		print_calibration(this->m_Op,&(this->calVal));
		break;
	      default:
		fprintf(this->m_Op,"\n<status><value><string>%s</string></value></status>",(char *) statusString);
		break;
	      }
	      fprintf(this->m_Op,"\n</hkm-monitor>");

	    }
	  }
	fprintf(this->m_Op,"\n</hkm>");
	return 0;
      case OPTION_TASK_PRINT:
	fprintf(this->m_Op,"\n<hkm>");
	ted_hkextract_display_hpd_table(this->m_Op,this->HPD);
	fprintf(this->m_Op,"\n</hkm>");
	return 0;
      default:
	return !0;
      }
  }

/* }}} */
}

/* }}} */
/* {{{ int           optionsInit(OPTIONS *) */

int
optionsInit(
OPTIONS *this
)
{
  int index;

  this->m_Hpd  = NULL;	/* Housekeeping Parameter Definition File */
  this->m_Ali  = NULL;	/* Housekeeping PDE Alias File */
  this->m_Hkd  = NULL;	/* Housekeeping Telemetry File */
  this->m_Op   = NULL;  /* Results */
  this->m_Wec  = NULL;	/* WEC Housekeeping PDE File */
  this->m_Par  = NULL;	/* Mnemonics to be monitored */
  this->HPD    = NULL;	/* the table pointer */
  this->buffer = NULL;
  this->bufferSize = 0;
  this->bufferUsed = 0;
  this->m_Task = OPTION_TASK_NA;
  for (index = 0; index < mnemMaxIndex; index++) strcpy(this->mnems[index],"");

  return !0;
}

/* }}} */
/* {{{ int          optionsFinal(OPTIONS *) */

int
optionsFinal(
OPTIONS *this
)
{
  int index;

  if (this->m_Hpd != NULL)  { fclose(this->m_Hpd); this->m_Hpd = NULL; }
  if (this->m_Hkd != NULL)  { fclose(this->m_Hkd); this->m_Hkd = NULL; }
  if (this->m_Op  != NULL)  { if (this->m_Op != stdout) { fclose(this->m_Op); } }
  if (this->m_Par != NULL)  { fclose(this->m_Par); this->m_Par = NULL; }
  if (this->m_Ali != NULL)  { fclose(this->m_Ali); this->m_Ali = NULL; }
  this->m_Wec = NULL;
  if (this->HPD != NULL)    { ted_hkextract_freetable(&(this->HPD)); }
  if (this->buffer != NULL) { free(this->buffer); this->buffer = NULL; }

  return !0;
}

/* }}} */
/* {{{ int           optionsRead(OPTIONS *,DDSP *,int,char *[]) */

int
optionsRead(
OPTIONS *this,
DDSP *ddsp,
int argc,
char *argv[]
)
{
  if (ddsp != NULL) { this->m_DDSP = ddsp; }
  if (argc >  1)
    /* {{{ process cli options */

    {
      extern char *optarg;
      extern int optind;
      char *l_options = "a:d:p:h:m:p:q:MQ?";
      int c;
      while ((c = getopt(argc,argv,l_options)) != EOF)
	{
	  switch (c)
	    {
	    case 'a':
	      /* {{{ aliases */
	    {
	      if (optionsAliFile(this,optarg) == 0)
		{
		  fprintf(stderr,"error opening alias test file\n");
		  exit(1);
		}
	    }	  
	    /* }}} */
	    break;
	    case 'd':
	      /* {{{ hpd */
	    {
	      if (optionsHpdFile(this,optarg) == 0)
		{
		  fprintf(stderr,"error opening hpd test file\n");
		  exit(1);
		}
	    }	  
	    /* }}} */
	    break;
	    case 'h':
	      /* {{{ hkd */
	    {
	      if (optionsHkdFile(this,optarg) == 0)
		{
		  fprintf(stderr,"error open hkd test file\n");
		  exit(1);
		}
	    }
	    /* }}} */
	    break;
	    case 'm':
	      /* {{{ do */
	    {
	      if (optionsDo(this,optarg) == 0)
		{
		  fprintf(stderr,"error opening parameter test file\n");
		  exit(1);
		} 
	    }

	    /* }}} */
	    break;
	    case 'M':
	      /* {{{ do */

	    {
	      if (optionsDo(this,"-") == 0)
		{
		  fprintf(stderr,"error opening parameter test file\n");
		  exit(1);
		} 
	    }

	    /* }}} */
	    break;
	    case 'p':
	      /* {{{ par */
	    {
	      if (optionsParFile(this,optarg) == 0)
		{
		  fprintf(stderr,"error opening parameter test file\n");
		  exit(1);
		}
	    }
	    /* }}} */
	    break;
	    case 'q':
	      /* {{{ print */

	    {
	      if (optionsPrint(this,optarg) == 0)
		{
		  fprintf(stderr,"error opening parameter test file\n");
		  exit(1);
		} 
	    }

	    /* }}} */
	    break;
	    case 'Q':
	      /* {{{ print */
	    {
	      if (optionsPrint(this,"-") == 0)
		{
		  fprintf(stderr,"error opening parameter test file\n");
		  exit(1);
		} 
	    }

	    /* }}} */
	    break;
	    case '?':
	      optionsUsage(this,argc,argv,stdout);
	      exit(0);
	    default:
	      optionsUsage(this,argc,argv,stderr);
	      return !0;
	    }
	}
    }

    /* }}} */
  else
    /* {{{ process stdin */

    {
      int LineLen = 256;
      char line[256];
      char command[80];
      char argument[80];
      int args;
      while (fgets(line,LineLen,stdin) == line)
	{
	  args = sscanf(line,"%s %s",command,argument);
	  if (args == 2)
	    /* {{{  */

            {
	    if (strcmp(command,"hpd") == 0)
	    {
	      /* {{{  */
	      fprintf(stderr,"opening hpd file %s\n",argument);
	      if (optionsHpdFile(this,argument) == 0)
	      {
		fprintf(stderr,"error opening hpd test file\n");
		exit(1);
	      }
	      fprintf(stderr,"%s %s\n",command,argument);
	      /* }}} */
	      continue;
	    }
	    if (strcmp(command,"hkd") == 0)
	    {
	      /* {{{  */

	      fprintf(stderr,"opening hkd file %s\n",argument);
	      if (optionsHkdFile(this,argument) == 0)
	      {
		fprintf(stderr,"error open hkd test file\n");
		exit(1);
	      }
	      fprintf(stderr,"%s %s\n",command,argument);
	      /* }}} */
	      continue;
	    }
	    if (strcmp(command,"ali") == 0)
	    {
	      /* {{{  */

	      fprintf(stderr,"opening ali file %s\n",argument);
	      if (optionsAliFile(this,argument) == 0)
	      {
		fprintf(stderr,"error opening alias test file\n");
		exit(1);
	      }
	      fprintf(stderr,"%s %s\n",command,argument);
	      /* }}} */
	      continue;
	    }
	    if (strcmp(command,"par") == 0)
	    {
	      /* {{{  */
	      fprintf(stderr,"opening par file %s\n",argument);
	      if (optionsParFile(this,argument) == 0) {
		fprintf(stderr,"error opening parameter test file\n");
		exit(1);
	      }
	      fprintf(stderr,"%s %s\n",command,argument);
	      /* }}} */
	      continue;
	    }
	    if (strcmp(command,"do") == 0)
	    {
	      fprintf(stderr,"%s %s\n",command,argument);
	      return optionsDo(this,argument);
	    } 
	    }

	    /* }}} */
	  if (args == 1)
	    /* {{{  */

            {
	      if (strcmp(command,"do") == 0)
		{
		  fprintf(stderr,"processing data\n");
		  fprintf(stderr,"%s \n",command);
		  return optionsDo(this,"-");
		}
	      if (strcmp(command,"print") == 0)
		{
		  fprintf(stderr,"printing parameter table\n");
		  fprintf(stderr,"%s \n",command);
		  return optionsPrint(this,"-");
		}
	    }

	  /* }}} */
	}
    }      

    /* }}} */
  return !0;
}

/* }}} */

/* }}} */
/* {{{ int main(int,char *[]) */

int
main(
int argc,
char *argv[]
)
{

  {
    OPTIONS options;
    DDSP ddsp;

    ddspInit(&ddsp);
    optionsInit(&options);
    optionsRead(&options,&ddsp,argc,argv);
    optionsProcess(&options);
    optionsFinal(&options);
    return (0);
  }
}

/* }}} */


/* Local variables: */
/* mode: c */
/* folded-file: t */
/* end: */
