 
/**
 * $Id: main.c,v 1.1 2001/09/26 14:06:40 simond Exp $
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <ted.h>
#include <xmacros.h>
#include <unpack.h>
#include <show.h>
#include <dsd.h>

/* Maximum length of science packet (inc timetag) in words */
#define SCIENCEPACKET_MAX ((474-1)*62)

/* Maximum length of DSD Header in words */
#define DSDHEADER_MAX 32

/* Length of DSD Headers (they're all the same!) in bytes */
#define DSDHEADERLEN 64

#define USAGE "Usage: dumpone <lv1 file> | -f <lv1 file>\n"

/* {{{ static long remaining(int) */

static
long
remaining(
int fd
)
{
  off_t bytes, pos;

  pos = lseek(fd, (off_t)0, SEEK_CUR);
  bytes = lseek(fd, (off_t)0, SEEK_END);
  lseek(fd, pos, SEEK_SET);

  return (bytes - pos);
}

/* }}} */
/* {{{ static void must_read(int,char *,int) */

static
void
must_read(
int fd,
char *buf,
int nbyte
)
{
  if (read(fd, buf, nbyte) != nbyte)
    {
      perror("Failed reading file");
      exit(1);
    }
}

/* }}} */
/* {{{ int getpacket(char **,int) */

int
getpacket(
char **packetp,
int fd
)
{
  char packet[(SCIENCEPACKET_MAX+DSDHEADER_MAX-1)*2];
  int rem;
  rem = remaining(fd);
  if (rem  < DSDHEADERLEN) return 1;

  must_read(fd, packet, DSDHEADERLEN);
  rem = remaining(fd);
  if (rem < dsd_length(packet) * 2) return 1;
  must_read(fd, packet + DSDHEADERLEN, dsd_length(packet) * 2);
  *packetp = packet;  
  return TED_OK;
}

/* }}} */
/* {{{ int main(int,char *[]) */

int
main(
int   argc,
char *argv[]
)
{
  char *packet;
  char *filename = NULL;
  int txt = 1;
  /* {{{ ERROR */

  if (argc < 2)
    {
      fprintf(stdout, USAGE);
      return 1;
    }

/* }}} */
  /* {{{ JUST FILE */

  if (argc == 2)
    {
      filename = argv[1];
    }

/* }}} */
  /* {{{ OPTIONS */

  if (argc > 2)
    {
      extern char *optarg;		/* For getopt() */
      extern int optind;		/* For getopt() */
      extern int opterr;		/* For getopt() */
      char c;
      opterr = 0;
      while ((c = (char)getopt(argc, argv, "f:x")) != -1)
	{
	  switch (c) {
	  case 'x':
	    txt = 0;
	    break;
	  case 'f':
	    if (filename != NULL)
	      free(filename);
	    filename = strdup(optarg);
	    break;
	  }
	}
    }

/* }}} */

  /* {{{ HEADER */

  if (txt)
    fprintf(stdout, "DUMPONE Version %s\n", "0.2");
  else
    fprintf(stdout, "\n<dumpone version=\"%s\">","0.2");

/* }}} */
  /* {{{ BODY */

  if (filename != NULL)
    {
      int fd = open(filename, O_RDONLY);
      if (fd < 0)
	{
	  perror(filename);
	}
      else
	{
	  while (getpacket(&packet,fd) == 0)
	    {
	      if (txt)
		{
		  fprintf(stdout, "--------------------------------------------------\n");
		  dsdheader_txt((BYTE *)packet,stdout);
		}
	      else
		{
		  dsdheader_xml((BYTE *)packet,stdout);
		}
	    }
	}
    }

/* }}} */
  /* {{{ TRAILER */

  if (!txt)
    fprintf(stdout, "\n<dumpone version=\"%s\">","0.2");

/* }}} */
  return 0;
}

/* }}} */

/* Local variables: */
/* folded-file: t */
/* end: */
