 
/**
 * $Id: unpack.h,v 1.1 2001/09/26 14:07:06 simond Exp $
 */

#ifndef _unpack_unpack_h
#define _unpack_unpack_h

#define CL_WEC_TED_146
#define CL_WEC_TED_147
#include <ted.h>

enum {
  INSTRUMENT_EFW = 1,
  INSTRUMENT_STAFFSA = 2,
  INSTRUMENT_STAFFMWF = 4,
  INSTRUMENT_WHISPER = 8,
  INSTRUMENT_WBD = 16,
  INSTRUMENT_DWP = 32
};

enum  TED_UNPACK_DIAGCODE
{
  TED_DIAG_DDSSOURCEINVALID,
  TED_DIAG_DDSSPACECRAFTINVALID,
  TED_DIAG_DDSSPACECRAFTMATCH,
  TED_DIAG_DDSSTREAMINVALID,
  TED_DIAG_DDSGROUNDINVALID,
  TED_DIAG_DDSCHANNELTYPEMATCH,
  TED_DIAG_DDSQUALITYINVALID,
  TED_DIAG_DDSSEQUENCEINVALID,
  TED_DIAG_DDSSPACECRAFTWRONG,
  TED_DIAG_DDSDATATYPEWRONG,
  TED_DIAG_DDSTIMESAME,
  TED_DIAG_HKLENGTHWRONG,
  TED_DIAG_HKEW5MOTAGINVALID,
  TED_DIAG_HKEW5MOTAGMATCH,
  TED_DIAG_DATALENGTHWRONG,
  TED_DIAG_MPTRUNCATED,
  TED_DIAG_MPSOURCEINVALID,
  TED_DIAG_MPSOURCEWRONG,
  TED_DIAG_MPCOUNTWRONG,
  TED_DIAG_MPLENGTHEXTENDS,
  TED_DIAG_MPMIDDLEFOUND,
  TED_DIAG_SPTOOLONG,
  TED_DIAG_HKTCORERROR,
  TED_DIAG_MPLENGTHZERO
};
typedef enum TED_UNPACK_DIAGCODE TED_UNPACK_DIAGCODE;

struct TED_UNPACK_DIAG
{
  TED_TIME time;		/* SCET of relevant packet */
  TED_UNPACK_DIAGCODE code;	/* Diagnostic code */
  char *details;		/* Details or NULL */
};
typedef struct TED_UNPACK_DIAG TED_UNPACK_DIAG; 

#ifndef _unpack_unpack_c

#include <hktim.h>
extern TED_STATUS ted_unpack_hktim(TED_HKTIM_MODE);

extern TED_STATUS ted_unpack_hktcor(char *path);

extern TED_STATUS ted_unpack_debug(int debug_level);

extern TED_STATUS ted_unpack_init(
TED_SPACECRAFT spacecraft,
int instruments,
int ccs_converted,
int model_tag_table[]
);				  

extern TED_STATUS ted_unpack_decom(
char *exppacket,
char *hkpacket,
int *gotscience,
TED_DSD_ITEMS **items,
char **hkblock,
char **sciencedata,
int *again
);

extern TED_STATUS ted_unpack_diagnostic(
TED_UNPACK_DIAG **diagnostic
);

extern TED_STATUS ted_unpack_hk_timestamp(
char **timestamp
);

extern TED_STATUS ted_unpack_diagcode2string(
TED_UNPACK_DIAGCODE diagcode,
char **string
);

extern TED_STATUS ted_unpack_diag2string(
TED_UNPACK_DIAG diag,
char **string
);

#endif
#endif

/* Local variables: */
/* folded-file: t */
/* end: */

