/* Header file for HK_TCOR module */
/* Keith Yearby, 2006 May 5 */

/* Define HK_TCOR status codes */
#define TCOR_STAT_INFO     100
#define TCOR_STAT_NOPATH   TCOR_STAT_INFO+1
#define TCOR_STAT_PRECOR   TCOR_STAT_INFO+2
#define TCOR_STAT_BEFORE   TCOR_STAT_INFO+3
#define TCOR_STAT_ENDIDX   TCOR_STAT_INFO+4
#define TCOR_STAT_ERROR    200
#define TCOR_STAT_EOF      TCOR_STAT_ERROR+1
#define TCOR_STAT_FORMAT   TCOR_STAT_ERROR+2
#define TCOR_STAT_NOFILE   TCOR_STAT_ERROR+3
#define TCOR_STAT_NOINDEX  TCOR_STAT_ERROR+4
#define TCOR_STAT_AFTER    TCOR_STAT_ERROR+6
#define TCOR_STAT_NOID     TCOR_STAT_ERROR+9

/* If not using Microsoft C, define maximum path and filename length */
#ifndef _MSC_VER
#define _MAX_PATH 512
#define _MAX_FNAME 512
#endif

/* Structure to hold HK_TCOR state for each stream */
struct tcor_struct {
	int status;
	FILE *index_fp;
	int index_scid;
	int path_specified;
	double last_scet;
	char tcor_path[_MAX_PATH];
	char tcor_name[_MAX_FNAME];
	FILE *tcor_fp;
	double scet_1;
	double scet_2;
	double offset;
	double diff_1, diff_2;
} ;

/* API function prototypes */
void hk_tcor_init (struct tcor_struct *tcp);
void hk_tcor_fini (struct tcor_struct *tcp);
void hk_tcor_path (struct tcor_struct *tcp, char *tcor_path);
void hk_tcor_stat (struct tcor_struct *tcp, FILE *fp);
int  hk_tcor_appl (struct tcor_struct *tcp, unsigned char *ddshead);
