<?xml version="1.0" encoding="iso-8859-1"?>

<!-- @version:  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>
  <xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="fold">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="scm">
</xsl:template>

<xsl:template match="ref">
<b>
<xsl:apply-templates/>
</b>
</xsl:template>

<xsl:template match="institution">
<br/>
<br/>
<br/>
<br/>
<br/>
<h2>
<font size="5">
<xsl:value-of select="."/>
</font>
</h2>
</xsl:template>

<xsl:template match="title">
<font size="4">
<xsl:apply-templates/>
</font>
</xsl:template>

<xsl:template match="issue">
<font size="3">
Issue
<xsl:apply-templates/>
</font>
</xsl:template>

<xsl:template match="prepared">
<left>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
Prepared by:<br/>
<xsl:value-of select="."/>
</left>
<br/>
<br/>
<br/>
<br/>
<br/>
</xsl:template>

<xsl:template match="approved">
</xsl:template>
<xsl:template match="author">
<center>
<p/>
<xsl:apply-templates/>
<p/>
</center>
</xsl:template>
<xsl:template match="descr">
<p/>
<xsl:apply-templates/>
<p/>
</xsl:template>
<xsl:template match="date">
<left>
<br/>
<b>
<xsl:apply-templates/>
</b>
</left>
</xsl:template>

<xsl:template match="document">
<html>
<xsl:apply-templates/>
</html>
</xsl:template>

<xsl:template match="head">
<head>
<xsl:apply-templates/>
</head>
</xsl:template>

<xsl:template match="body">
<body>
<xsl:apply-templates/>
</body>
</xsl:template>

<xsl:template match="center">
<center>
<xsl:apply-templates/>
</center>
</xsl:template>

<xsl:template match="list">
<ul>
<xsl:apply-templates/>
</ul>
</xsl:template>

<xsl:template match="listitem">
<li>
<xsl:apply-templates/>
</li>
</xsl:template>

<xsl:template match="section">
<hr/>
<br/>
<h2>
<xsl:value-of select="@id"/>
<xsl:value-of select="@title"/>
</h2>
<p/>
<xsl:apply-templates/>
<p/>
</xsl:template>

<xsl:template match="subsection">
<br/>
<h3>
<xsl:value-of select="@id"/>
<xsl:value-of select="@title"/>
</h3>
<p/>
<xsl:apply-templates/>
<p/>
</xsl:template>

<xsl:template match="p">
<p/>
</xsl:template>
<xsl:template match="br">
<br/>
</xsl:template>

<xsl:template match="hr">
<hr/>
</xsl:template>

<xsl:template match="anchor">
<a>
<xsl:attribute name="href">
<xsl:value-of select="@href"/>
</xsl:attribute>
<xsl:apply-templates/>
</a>
</xsl:template>

<xsl:template match="contact">
<p/>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="name">
<br/>
<xsl:value-of select="."/>
</xsl:template>
<xsl:template match="address">
<br/>
<xsl:apply-templates/>
</xsl:template>
<xsl:template match="tel">
<br/>
<xsl:apply-templates/>
</xsl:template>
<xsl:template match="fax">
<br/>
<xsl:apply-templates/>
</xsl:template>
<xsl:template match="email">
<br/>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="dcr-form">
<center>
<p/>
<table border="1">
<tr><td>DOCUMENT STATUS SHEET</td></tr>
<tr><td>1.DOCUMENT TITLE: <xsl:value-of select="@title"/></td></tr>
<tr><td><xsl:apply-templates/></td></tr>
</table>
</center>
</xsl:template>

<xsl:template name="dss-records" match="dss-records">
<table border="1">
<tr><td>2. ISSUE</td><td>3. REVISION</td><td>4. DATE</td><td>5. REASON FOR CHANGE</td></tr>
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="dss-entry">   <tr><xsl:apply-templates/></tr></xsl:template>
<xsl:template match="dss-issue">   <td><xsl:apply-templates/></td></xsl:template>
<xsl:template match="dss-revision"><td><xsl:apply-templates/></td></xsl:template>
<xsl:template match="dss-date">    <td><xsl:apply-templates/></td></xsl:template>
<xsl:template match="dss-text">    <td><xsl:apply-templates/></td></xsl:template>

<xsl:template match="references">
References:
<br/>
<xsl:apply-templates/>
</xsl:template>
<xsl:template match="reference">
<ul>
</ul>

<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>

<!-- Local variables -->
<!-- folded-file: t -->
<!-- end: -->
