; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
;+
; NAME:
;     SPLIT
;
; IDENT:
;     $Id: split_hdf.pro,v 1.1 2003/02/14 20:20:07 glennh Exp $
;
; PURPOSE:
;     Just like perl.  Splits a string into an array of strings.
;
; AUTHOR:
;     Ed Santiago
;
; CALLING SEQUENCE:
;     stringarr = split(delimiter, string)
;
; INPUTS:
;     delimiter  -- character to split on
;     string     -- string to split
;
; OUTPUTS:
;     an array of strings
;
; SIDE EFFECTS:
;
; EXAMPLE:
;     IDL> x=split(',', 'this,is,a,test')
;     IDL> print, N_Elements(x), x
;           4 this is a test
;
;-


FUNCTION split, delimiter, string	; Just like perl
  arr     = [ 'x' ] ; sigh

  len     = strlen(string)
  lastpos = 0
  WHILE lastpos LT len DO BEGIN
      pos     = STRPOS(string, delimiter, lastpos)
      IF pos EQ -1 THEN pos = len
      arr     = [ arr, STRMID(string, lastpos, pos-lastpos) ]

      ; Collapse multiple spaces into one
      IF delimiter EQ ' ' THEN WHILE StrMid(string,pos+1,1) EQ ' ' DO pos=pos+1

      lastpos = pos+1
  ENDWHILE

  ; Always guaranteed at least one hit, unless string is null
  RETURN, arr[1:*]
END

