/* $Id: sepica_level2_data_1day.h,v 1.2 2001/07/03 00:03:54 steves Exp $ */


#include "hdfi.h"

struct SEPICA_data_1day {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 H1;
  float32 H2;
  float32 H3;

  float32 He1;
  float32 He2;
  float32 He3;
  float32 He4cal;		/* used in data version 3+ */
  float32 He5;
  float32 He6;
  float32 He7;			/* used in data version 3+ */
  float32 He8;			/* used in data version 3+ */
  float32 HeCAck;		/* used in data version 4+ */

  float32 ClowE;		/* used in data version 4+ */
  float32 C1;
  float32 C2;
  float32 C3;
  float32 C4;			/* used in data version 3+ */
  float32 C5;			/* used in data version 3+ */
  float32 C6;			/* used in data version 3+ */

  float32 OlowE;		/* used in data version 4+ */
  float32 O1;
  float32 O2;
  float32 O3;
  float32 O4;
  float32 O5;			/* used in data version 3+ */

  float32 Ne1;			/* used in data version 3+ */
  float32 Ne2;			/* used in data version 3+ */
  float32 Ne3;			/* used in data version 3+ */
  float32 Ne4;			/* used in data version 3+ */

  float32 Mg1;			/* used in data version 3+ */
  float32 Mg2;			/* used in data version 3+ */
  float32 Mg3;			/* used in data version 3+ */
  float32 Mg4;			/* used in data version 3+ */

  float32 Si1;			/* used in data version 3+ */
  float32 Si2;			/* used in data version 3+ */
  float32 Si3;			/* used in data version 3+ */
  float32 Si4;			/* used in data version 3+ */

  float32 FeloE;		/* used in data version 4+ */
  float32 Fe1;
  float32 Fe2;
  float32 Fe3;
  float32 Fe4;

  float32 unc_H1;
  float32 unc_H2;
  float32 unc_H3;

  float32 unc_He1;
  float32 unc_He2;
  float32 unc_He3;
  float32 unc_He4cal;		/* used in data version 3+ */
  float32 unc_He5;
  float32 unc_He6;
  float32 unc_He7;			/* used in data version 3+ */
  float32 unc_He8;			/* used in data version 3+ */
  float32 unc_HeCAck;		/* used in data version 4+ */

  float32 unc_ClowE;		/* used in data version 4+ */
  float32 unc_C1;
  float32 unc_C2;
  float32 unc_C3;
  float32 unc_C4;			/* used in data version 3+ */
  float32 unc_C5;			/* used in data version 3+ */
  float32 unc_C6;			/* used in data version 3+ */

  float32 unc_OlowE;		/* used in data version 4+ */
  float32 unc_O1;
  float32 unc_O2;
  float32 unc_O3;
  float32 unc_O4;
  float32 unc_O5;			/* used in data version 3+ */

  float32 unc_Ne1;			/* used in data version 3+ */
  float32 unc_Ne2;			/* used in data version 3+ */
  float32 unc_Ne3;			/* used in data version 3+ */
  float32 unc_Ne4;			/* used in data version 3+ */

  float32 unc_Mg1;			/* used in data version 3+ */
  float32 unc_Mg2;			/* used in data version 3+ */
  float32 unc_Mg3;			/* used in data version 3+ */
  float32 unc_Mg4;			/* used in data version 3+ */

  float32 unc_Si1;			/* used in data version 3+ */
  float32 unc_Si2;			/* used in data version 3+ */
  float32 unc_Si3;			/* used in data version 3+ */
  float32 unc_Si4;			/* used in data version 3+ */

  float32 unc_FeloE;		/* used in data version 4+ */
  float32 unc_Fe1;
  float32 unc_Fe2;
  float32 unc_Fe3;
  float32 unc_Fe4;

  float32 up_time_fraction; 
  int32   number_of_records_120s;
  int32   number_of_records_1hr;

};
