/* $Id: sepica_level2_data_120s.h,v 1.2 2001/07/03 00:02:17 steves Exp $ */

#include "hdfi.h"

struct SEPICA_data_120s {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 H1;
  float32 H2;
  float32 H3;

  float32 He1;
  float32 He2;
  float32 He3;
  float32 He4cal;		/* used in data version 3+ */
  float32 He5;
  float32 He6;
  float32 He7;			/* used in data version 3+ */
  float32 He8;			/* used in data version 3+ */
  float32 HeCAck;		/* used in data version 4+ */

  float32 unc_H1;
  float32 unc_H2;
  float32 unc_H3;

  float32 unc_He1;
  float32 unc_He2;
  float32 unc_He3;
  float32 unc_He4cal;		/* used in data version 3+ */
  float32 unc_He5;
  float32 unc_He6;
  float32 unc_He7;			/* used in data version 3+ */
  float32 unc_He8;			/* used in data version 3+ */
  float32 unc_HeCAck;		/* used in data version 4+ */

  float32 up_time_fraction; 
  int32   number_of_records_120s;
  int32   number_of_records_1hr;

};
