/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id: swepam_level2_data_1day.h,v 1.1 2000/08/02 00:53:03 asc Exp  */

#include "swepam_level2_data_1day.h"
#include "df.h"

int32 vgrp_id_swepam_level2_all_1day;
static int32 vdata_id_swepam_level2_all_1day;

  /* 1618 is the size of swepam_level2_data_1day.h + 1 added line */
char Vgrp_descrp_SWEPAM_data_1day[1618];

/****----  init create function  ----****/

int32 init_cr_swepam_level2_all_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_swepam_level2_all_1day();

  void print_swepam_level2_all_1day_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_swepam_level2_all_1day = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_swepam_level2_all_1day, "VG_SWEPAM_data_1day"); 
  Vsetclass(vgrp_id_swepam_level2_all_1day, "VG_SWEPAM_LEVEL2_DATA_1DAY");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SWEPAM_data_1day" )) ==FAIL) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_swepam_level2_all_1day(Vgrp_descrp_SWEPAM_data_1day);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SWEPAM_data_1day, sizeof(Vgrp_descrp_SWEPAM_data_1day))) ==FAIL) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_swepam_level2_all_1day = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_swepam_level2_all_1day, "SWEPAM_data_1day");
  VSsetclass(vdata_id_swepam_level2_all_1day, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_swepam_level2_all_1day, vdata_id_swepam_level2_all_1day)) ==FAIL) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "year", DFNT_INT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "day", DFNT_INT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "hr", DFNT_INT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "min", DFNT_INT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "sec", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fp_year", DFNT_FLOAT64, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "proton_density", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define proton_density");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "proton_temp", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define proton_temp");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "He4toprotons", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define He4toprotons");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "proton_speed", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define proton_speed");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "x_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define x_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "y_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define y_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "z_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define z_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "x_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define x_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "y_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define y_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "z_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define z_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "x_dot_GSM", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define x_dot_GSM");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "y_dot_GSM", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define y_dot_GSM");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "z_dot_GSM", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define z_dot_GSM");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "pos_gse_x", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define pos_gse_x");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "pos_gse_y", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define pos_gse_y");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "pos_gse_z", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define pos_gse_z");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "pos_gsm_x", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define pos_gsm_x");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "pos_gsm_y", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define pos_gsm_y");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "pos_gsm_z", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define pos_gsm_z");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "Electron_temp", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define Electron_temp");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_proton_density", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_proton_density");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_proton_temp", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_proton_temp");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_He4toprotons", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_He4toprotons");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_proton_speed", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_proton_speed");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "fraction_time_Electron_temp", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define fraction_time_Electron_temp");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_all_1day, "weight", DFNT_INT32, (1) )) {
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSfdefine: Couldn't define weight");
    retval = -1;
  }

  if (VSsetfields(vdata_id_swepam_level2_all_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, proton_density, proton_temp, He4toprotons, proton_speed, x_dot_GSE, y_dot_GSE, z_dot_GSE, x_dot_RTN, y_dot_RTN, z_dot_RTN, x_dot_GSM, y_dot_GSM, z_dot_GSM, pos_gse_x, pos_gse_y, pos_gse_z, pos_gsm_x, pos_gsm_y, pos_gsm_z, Electron_temp, fraction_time_proton_density, fraction_time_proton_temp, fraction_time_He4toprotons, fraction_time_proton_speed, fraction_time_dot_GSE, fraction_time_dot_RTN, fraction_time_Electron_temp, weight")){
    print_swepam_level2_all_1day_error("init_cr_swepam_level2_all_1day -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_swepam_level2_all_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_swepam_level2_all_1day(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_swepam_level2_all_1day(struct SWEPAM_data_1day SWEPAM_data_1day_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_swepam_level2_all_1day_error();
void pack_swepam_level2_all_1day();

  odata = (uint8 *) malloc(sizeof(struct SWEPAM_data_1day));
  pack_swepam_level2_all_1day(odata, &SWEPAM_data_1day_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_swepam_level2_all_1day, recnum)==-1) {
		print_swepam_level2_all_1day_error("write_swepam_level2_all_1day -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_swepam_level2_all_1day, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_swepam_level2_all_1day_error("write_swepam_level2_all_1day -> VSwrite: Couldn't write data.");

  memset(&SWEPAM_data_1day_struc, 0, sizeof(struct SWEPAM_data_1day));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_swepam_level2_all_1day()
{
  VSdetach(vdata_id_swepam_level2_all_1day);
  Vdetach(vgrp_id_swepam_level2_all_1day);
}

/*----     init access function    ----*/

int32 init_acc_swepam_level2_all_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_swepam_level2_all_1day_error();


  if ((vdata_ref = VSfind(hdf_fp, "SWEPAM_data_1day")) <= 0 ) {
    print_swepam_level2_all_1day_error("init_acc_swepam_level2_all_1day -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_swepam_level2_all_1day = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_swepam_level2_all_1day_error("init_acc_swepam_level2_all_1day -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_swepam_level2_all_1day, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_swepam_level2_all_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, proton_density, proton_temp, He4toprotons, proton_speed, x_dot_GSE, y_dot_GSE, z_dot_GSE, x_dot_RTN, y_dot_RTN, z_dot_RTN, x_dot_GSM, y_dot_GSM, z_dot_GSM, pos_gse_x, pos_gse_y, pos_gse_z, pos_gsm_x, pos_gsm_y, pos_gsm_z, Electron_temp, fraction_time_proton_density, fraction_time_proton_temp, fraction_time_He4toprotons, fraction_time_proton_speed, fraction_time_dot_GSE, fraction_time_dot_RTN, fraction_time_Electron_temp, weight")) {
      print_swepam_level2_all_1day_error("init_acc_swepam_level2_all_1day -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_swepam_level2_all_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_swepam_level2_all_1day(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_swepam_level2_all_1day(struct SWEPAM_data_1day *SWEPAM_data_1day_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_swepam_level2_all_1day_error();
void unpack_swepam_level2_all_1day();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SWEPAM_data_1day));
  VSinquire(vdata_id_swepam_level2_all_1day, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_swepam_level2_all_1day, recnum_rd)==FAIL) {
          print_swepam_level2_all_1day_error("read_swepam_level2_all_1day -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_swepam_level2_all_1day, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_swepam_level2_all_1day_error("read_swepam_level2_all_1day -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_swepam_level2_all_1day(odata, SWEPAM_data_1day_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_swepam_level2_all_1day()
{
  VSdetach(vdata_id_swepam_level2_all_1day);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_swepam_level2_all_1day(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_swepam_level2_all_1day_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SWEPAM_data_1day" )) ==FAIL)
    print_swepam_level2_all_1day_error("rd_Vgrp_swepam_level2_all_1day -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_swepam_level2_all_1day_error("rd_Vgrp_swepam_level2_all_1day -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_swepam_level2_all_1day_error("rd_Vgrp_swepam_level2_all_1day -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_swepam_level2_all_1day_error("rd_Vgrp_swepam_level2_all_1day -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SWEPAM_data_1day, HDstrlen(Vgrp_descrp_SWEPAM_data_1day)) ==FAIL)
    print_swepam_level2_all_1day_error("rd_Vgrp_swepam_level2_all_1day -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SWEPAM_data_1day);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_swepam_level2_all_1day_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_swepam_level2_all_1day.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_swepam_level2_all_1day(uint8 *data, struct SWEPAM_data_1day *SWEPAM_data_1day_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SWEPAM_data_1day_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->proton_density, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->proton_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->He4toprotons, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->proton_speed, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->x_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->y_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->z_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->x_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->y_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->z_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->x_dot_GSM, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->y_dot_GSM, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->z_dot_GSM, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->pos_gse_x, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->pos_gse_y, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->pos_gse_z, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->pos_gsm_x, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->pos_gsm_y, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->pos_gsm_z, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->Electron_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_proton_density, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_proton_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_He4toprotons, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_proton_speed, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->fraction_time_Electron_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_data_1day_ptr->weight, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_swepam_level2_all_1day(uint8 *data, struct SWEPAM_data_1day *SWEPAM_data_1day_ptr)
{
int32 ptr=0;

   memcpy(&SWEPAM_data_1day_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWEPAM_data_1day_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWEPAM_data_1day_ptr->proton_density, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->proton_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->He4toprotons, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->proton_speed, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->x_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->y_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->z_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->x_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->y_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->z_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->x_dot_GSM, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->y_dot_GSM, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->z_dot_GSM, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->pos_gse_x, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->pos_gse_y, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->pos_gse_z, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->pos_gsm_x, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->pos_gsm_y, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->pos_gsm_z, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->Electron_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_proton_density, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_proton_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_He4toprotons, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_proton_speed, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->fraction_time_Electron_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_data_1day_ptr->weight, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_swepam_level2_all_1day() {return(vgrp_id_swepam_level2_all_1day);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_swepam_level2_all_1day(char *wr_strval)
{
  strcpy(wr_strval, "The file 'swepam_level2_data_1day.h' is shown below, it was used to create the data in the Vgroup named 'VG_SWEPAM_data_1day'.\n\n");
  strcat(wr_strval,"/* Id: swepam_level2_data_1day.h,v 1.1 2000/08/02 00:53:03 asc Exp $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SWEPAM_data_1day {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval," /* SWEPAM data */\n");
  strcat(wr_strval,"  float32 proton_density;\n");
  strcat(wr_strval,"  float32 proton_temp;\n");
  strcat(wr_strval,"  float32 He4toprotons;\n");
  strcat(wr_strval,"  float32 proton_speed;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 x_dot_GSE;\n");
  strcat(wr_strval,"  float32 y_dot_GSE;\n");
  strcat(wr_strval,"  float32 z_dot_GSE;\n");
  strcat(wr_strval,"  float32 x_dot_RTN;\n");
  strcat(wr_strval,"  float32 y_dot_RTN;\n");
  strcat(wr_strval,"  float32 z_dot_RTN;\n");
  strcat(wr_strval,"  float32 x_dot_GSM;\n");
  strcat(wr_strval,"  float32 y_dot_GSM;\n");
  strcat(wr_strval,"  float32 z_dot_GSM;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 pos_gse_x;\n");
  strcat(wr_strval,"  float32 pos_gse_y;\n");
  strcat(wr_strval,"  float32 pos_gse_z;\n");
  strcat(wr_strval,"  float32 pos_gsm_x;\n");
  strcat(wr_strval,"  float32 pos_gsm_y;\n");
  strcat(wr_strval,"  float32 pos_gsm_z;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Electron_temp;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 fraction_time_proton_density; \n");
  strcat(wr_strval,"  float32 fraction_time_proton_temp;\n");
  strcat(wr_strval,"  float32 fraction_time_He4toprotons;\n");
  strcat(wr_strval,"  float32 fraction_time_proton_speed;\n");
  strcat(wr_strval,"  float32 fraction_time_dot_GSE;\n");
  strcat(wr_strval,"  float32 fraction_time_dot_RTN;\n");
  strcat(wr_strval,"  float32 fraction_time_Electron_temp;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32   weight;\n");
  strcat(wr_strval,"};\n");
  return(0);
}
