/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "ss_level2_data_1day.h"
#include "df.h"

int32 vgrp_id_ss_level2_data_1day;
static int32 vdata_id_ss_level2_data_1day;

  /* 1930 is the size of ss_level2_data_1day.h + 1 added line */
char Vgrp_descrp_SS_data_1day[1930];

/****----  init create function  ----****/

int32 init_cr_ss_level2_data_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_ss_level2_data_1day();

  void print_ss_level2_data_1day_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_ss_level2_data_1day = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_ss_level2_data_1day, "VG_SS_data_1day"); 
  Vsetclass(vgrp_id_ss_level2_data_1day, "VG_SS_LEVEL2_DATA_1DAY");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SS_data_1day" )) ==FAIL) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_ss_level2_data_1day(Vgrp_descrp_SS_data_1day);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SS_data_1day, sizeof(Vgrp_descrp_SS_data_1day))) ==FAIL) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_ss_level2_data_1day = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_ss_level2_data_1day, "SS_data_1day");
  VSsetclass(vdata_id_ss_level2_data_1day, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_ss_level2_data_1day, vdata_id_ss_level2_data_1day)) ==FAIL) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_ss_level2_data_1day, "year", DFNT_INT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "day", DFNT_INT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "hr", DFNT_INT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "min", DFNT_INT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "sec", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "fp_year", DFNT_FLOAT64, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "nHe2", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define nHe2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "nHe2_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define nHe2_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_He", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_He");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "C6to4", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define C6to4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "C6to4_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define C6to4_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_C6to4", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_C6to4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "C6to5", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define C6to5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "C6to5_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define C6to5_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_C6to5", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_C6to5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "O7to6", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define O7to6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "O7to6_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define O7to6_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_O7to6", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_O7to6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqC", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqC");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqC_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqC_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_avqC", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_avqC");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_avqO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_avqO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqFe", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqFe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqFe_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqFe_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_avqFe", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_avqFe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqMg", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqMg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqMg_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqMg_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_avqMg", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_avqMg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqSi", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqSi");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "avqSi_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define avqSi_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_avqSi", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_avqSi");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "FetoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define FetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "FetoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define FetoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_FetoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_FetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "HetoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define HetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "HetoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define HetoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_HetoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_HetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "CtoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define CtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "CtoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define CtoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_CtoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_CtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "NtoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define NtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "NtoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define NtoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_NtoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_NtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "NetoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define NetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "NetoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define NetoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_NetoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_NetoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "MgtoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define MgtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "MgtoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define MgtoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_MgtoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_MgtoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "SitoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define SitoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "SitoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define SitoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_SitoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_SitoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "StoO", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define StoO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "StoO_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define StoO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_1day, "qf_StoO", DFNT_INT16, (1) )) {
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSfdefine: Couldn't define qf_StoO");
    retval = -1;
  }

  if (VSsetfields(vdata_id_ss_level2_data_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, nHe2, nHe2_err, qf_He, C6to4, C6to4_err, qf_C6to4, C6to5, C6to5_err, qf_C6to5, O7to6, O7to6_err, qf_O7to6, avqC, avqC_err, qf_avqC, avqO, avqO_err, qf_avqO, avqFe, avqFe_err, qf_avqFe, avqMg, avqMg_err, qf_avqMg, avqSi, avqSi_err, qf_avqSi, FetoO, FetoO_err, qf_FetoO, HetoO, HetoO_err, qf_HetoO, CtoO, CtoO_err, qf_CtoO, NtoO, NtoO_err, qf_NtoO, NetoO, NetoO_err, qf_NetoO, MgtoO, MgtoO_err, qf_MgtoO, SitoO, SitoO_err, qf_SitoO, StoO, StoO_err, qf_StoO")){
    print_ss_level2_data_1day_error("init_cr_ss_level2_data_1day -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_ss_level2_data_1day(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_ss_level2_data_1day(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_ss_level2_data_1day(struct SS_data_1day SS_data_1day_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_ss_level2_data_1day_error();
void pack_ss_level2_data_1day();

  odata = (uint8 *) malloc(sizeof(struct SS_data_1day));
  pack_ss_level2_data_1day(odata, &SS_data_1day_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_ss_level2_data_1day, recnum)==-1) {
		print_ss_level2_data_1day_error("write_ss_level2_data_1day -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_ss_level2_data_1day, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_ss_level2_data_1day_error("write_ss_level2_data_1day -> VSwrite: Couldn't write data.");

  memset(&SS_data_1day_struc, 0, sizeof(struct SS_data_1day));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_ss_level2_data_1day()
{
  VSdetach(vdata_id_ss_level2_data_1day);
  Vdetach(vgrp_id_ss_level2_data_1day);
}

/*----     init access function    ----*/

int32 init_acc_ss_level2_data_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_ss_level2_data_1day_error();


  if ((vdata_ref = VSfind(hdf_fp, "SS_data_1day")) <= 0 ) {
    print_ss_level2_data_1day_error("init_acc_ss_level2_data_1day -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_ss_level2_data_1day = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_ss_level2_data_1day_error("init_acc_ss_level2_data_1day -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_ss_level2_data_1day, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_ss_level2_data_1day,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, nHe2, nHe2_err, qf_He, C6to4, C6to4_err, qf_C6to4, C6to5, C6to5_err, qf_C6to5, O7to6, O7to6_err, qf_O7to6, avqC, avqC_err, qf_avqC, avqO, avqO_err, qf_avqO, avqFe, avqFe_err, qf_avqFe, avqMg, avqMg_err, qf_avqMg, avqSi, avqSi_err, qf_avqSi, FetoO, FetoO_err, qf_FetoO, HetoO, HetoO_err, qf_HetoO, CtoO, CtoO_err, qf_CtoO, NtoO, NtoO_err, qf_NtoO, NetoO, NetoO_err, qf_NetoO, MgtoO, MgtoO_err, qf_MgtoO, SitoO, SitoO_err, qf_SitoO, StoO, StoO_err, qf_StoO")) {
      print_ss_level2_data_1day_error("init_acc_ss_level2_data_1day -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_ss_level2_data_1day(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_ss_level2_data_1day(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_ss_level2_data_1day(struct SS_data_1day *SS_data_1day_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_ss_level2_data_1day_error();
void unpack_ss_level2_data_1day();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SS_data_1day));
  VSinquire(vdata_id_ss_level2_data_1day, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_ss_level2_data_1day, recnum_rd)==FAIL) {
          print_ss_level2_data_1day_error("read_ss_level2_data_1day -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_ss_level2_data_1day, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_ss_level2_data_1day_error("read_ss_level2_data_1day -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_ss_level2_data_1day(odata, SS_data_1day_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_ss_level2_data_1day()
{
  VSdetach(vdata_id_ss_level2_data_1day);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_ss_level2_data_1day(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_ss_level2_data_1day_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SS_data_1day" )) ==FAIL)
    print_ss_level2_data_1day_error("rd_Vgrp_ss_level2_data_1day -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_ss_level2_data_1day_error("rd_Vgrp_ss_level2_data_1day -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_ss_level2_data_1day_error("rd_Vgrp_ss_level2_data_1day -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_ss_level2_data_1day_error("rd_Vgrp_ss_level2_data_1day -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SS_data_1day, HDstrlen(Vgrp_descrp_SS_data_1day)) ==FAIL)
    print_ss_level2_data_1day_error("rd_Vgrp_ss_level2_data_1day -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SS_data_1day);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_ss_level2_data_1day_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_ss_level2_data_1day.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_ss_level2_data_1day(uint8 *data, struct SS_data_1day *SS_data_1day_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SS_data_1day_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->nHe2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->nHe2_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_He, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->C6to4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->C6to4_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_C6to4, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->C6to5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->C6to5_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_C6to5, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->O7to6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->O7to6_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_O7to6, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqC, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqC_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_avqC, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_avqO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqFe, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqFe_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_avqFe, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqMg, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqMg_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_avqMg, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqSi, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->avqSi_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_avqSi, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->FetoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->FetoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_FetoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->HetoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->HetoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_HetoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->CtoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->CtoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_CtoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->NtoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->NtoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_NtoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->NetoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->NetoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_NetoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->MgtoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->MgtoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_MgtoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->SitoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->SitoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_SitoO, ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->StoO, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->StoO_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_1day_ptr->qf_StoO, ((2)*(1)) );
   ptr+= ((2)*(1));
}

/*----   unpack function    ----*/

void unpack_ss_level2_data_1day(uint8 *data, struct SS_data_1day *SS_data_1day_ptr)
{
int32 ptr=0;

   memcpy(&SS_data_1day_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_data_1day_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_data_1day_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_data_1day_ptr->nHe2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->nHe2_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_He, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->C6to4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->C6to4_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_C6to4, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->C6to5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->C6to5_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_C6to5, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->O7to6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->O7to6_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_O7to6, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->avqC, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->avqC_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_avqC, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->avqO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->avqO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_avqO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->avqFe, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->avqFe_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_avqFe, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->avqMg, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->avqMg_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_avqMg, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->avqSi, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->avqSi_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_avqSi, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->FetoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->FetoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_FetoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->HetoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->HetoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_HetoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->CtoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->CtoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_CtoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->NtoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->NtoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_NtoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->NetoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->NetoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_NetoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->MgtoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->MgtoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_MgtoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->SitoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->SitoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_SitoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
   memcpy(&SS_data_1day_ptr->StoO, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->StoO_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_1day_ptr->qf_StoO, data+ptr,  ((2)*(1)) );
   ptr+= ((2)*(1));
}
int32 get_vgrp_id_ss_level2_data_1day() {return(vgrp_id_ss_level2_data_1day);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_ss_level2_data_1day(char *wr_strval)
{
  strcpy(wr_strval, "The file 'ss_level2_data_1day.h' is shown below, it was used to create the data in the Vgroup named 'VG_SS_data_1day'.\n\n");
  strcat(wr_strval,"/* Id:$ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SS_data_1day {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of each record */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds of minute */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of Year */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* these from nvt file */\n");
  strcat(wr_strval,"  float32 nHe2;\n");
  strcat(wr_strval,"  float32 nHe2_err;\n");
  strcat(wr_strval,"  int16 qf_He;    /* quality flags - see release notes */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* these from qratio file */\n");
  strcat(wr_strval,"  float32 C6to4;\n");
  strcat(wr_strval,"  float32 C6to4_err;\n");
  strcat(wr_strval,"  int16 qf_C6to4;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 C6to5;\n");
  strcat(wr_strval,"  float32 C6to5_err;\n");
  strcat(wr_strval,"  int16 qf_C6to5;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 O7to6;\n");
  strcat(wr_strval,"  float32 O7to6_err;\n");
  strcat(wr_strval,"  int16 qf_O7to6;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 avqC;\n");
  strcat(wr_strval,"  float32 avqC_err;\n");
  strcat(wr_strval,"  int16 qf_avqC;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 avqO;\n");
  strcat(wr_strval,"  float32 avqO_err;\n");
  strcat(wr_strval,"  int16 qf_avqO;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 avqFe;\n");
  strcat(wr_strval,"  float32 avqFe_err;\n");
  strcat(wr_strval,"  int16 qf_avqFe;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 avqMg;\n");
  strcat(wr_strval,"  float32 avqMg_err;\n");
  strcat(wr_strval,"  int16 qf_avqMg;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 avqSi;\n");
  strcat(wr_strval,"  float32 avqSi_err;\n");
  strcat(wr_strval,"  int16 qf_avqSi;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* from elem file */\n");
  strcat(wr_strval,"  float32 FetoO;\n");
  strcat(wr_strval,"  float32 FetoO_err;\n");
  strcat(wr_strval,"  int16 qf_FetoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 HetoO;\n");
  strcat(wr_strval,"  float32 HetoO_err;\n");
  strcat(wr_strval,"  int16 qf_HetoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 CtoO;\n");
  strcat(wr_strval,"  float32 CtoO_err;\n");
  strcat(wr_strval,"  int16 qf_CtoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 NtoO;\n");
  strcat(wr_strval,"  float32 NtoO_err;\n");
  strcat(wr_strval,"  int16 qf_NtoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 NetoO;\n");
  strcat(wr_strval,"  float32 NetoO_err;\n");
  strcat(wr_strval,"  int16 qf_NetoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 MgtoO;\n");
  strcat(wr_strval,"  float32 MgtoO_err;\n");
  strcat(wr_strval,"  int16 qf_MgtoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 SitoO;\n");
  strcat(wr_strval,"  float32 SitoO_err;\n");
  strcat(wr_strval,"  int16 qf_SitoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"  float32 StoO;\n");
  strcat(wr_strval,"  float32 StoO_err;\n");
  strcat(wr_strval,"  int16 qf_StoO;\n");
  strcat(wr_strval,"   \n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  return(0);
}
