/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "ss_level2_data_12min.h"
#include "df.h"

int32 vgrp_id_ss_level2_data_12min;
static int32 vdata_id_ss_level2_data_12min;

  /* 927 is the size of ss_level2_data_12min.h + 1 added line */
char Vgrp_descrp_SS_data_12min[927];

/****----  init create function  ----****/

int32 init_cr_ss_level2_data_12min(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_ss_level2_data_12min();

  void print_ss_level2_data_12min_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_ss_level2_data_12min = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_ss_level2_data_12min, "VG_SS_data_12min"); 
  Vsetclass(vgrp_id_ss_level2_data_12min, "VG_SS_LEVEL2_DATA_12MIN");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SS_data_12min" )) ==FAIL) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_ss_level2_data_12min(Vgrp_descrp_SS_data_12min);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SS_data_12min, sizeof(Vgrp_descrp_SS_data_12min))) ==FAIL) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_ss_level2_data_12min = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_ss_level2_data_12min, "SS_data_12min");
  VSsetclass(vdata_id_ss_level2_data_12min, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_ss_level2_data_12min, vdata_id_ss_level2_data_12min)) ==FAIL) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_ss_level2_data_12min, "year", DFNT_INT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "day", DFNT_INT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "hr", DFNT_INT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "min", DFNT_INT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "sec", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "fp_year", DFNT_FLOAT64, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "nH", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define nH");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "nH_err", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define nH_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "vH", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define vH");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_data_12min, "vthH", DFNT_FLOAT32, (1) )) {
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSfdefine: Couldn't define vthH");
    retval = -1;
  }

  if (VSsetfields(vdata_id_ss_level2_data_12min,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, nH, nH_err, vH, vthH")){
    print_ss_level2_data_12min_error("init_cr_ss_level2_data_12min -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_ss_level2_data_12min(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_ss_level2_data_12min(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_ss_level2_data_12min(struct SS_data_12min SS_data_12min_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_ss_level2_data_12min_error();
void pack_ss_level2_data_12min();

  odata = (uint8 *) malloc(sizeof(struct SS_data_12min));
  pack_ss_level2_data_12min(odata, &SS_data_12min_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_ss_level2_data_12min, recnum)==-1) {
		print_ss_level2_data_12min_error("write_ss_level2_data_12min -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_ss_level2_data_12min, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_ss_level2_data_12min_error("write_ss_level2_data_12min -> VSwrite: Couldn't write data.");

  memset(&SS_data_12min_struc, 0, sizeof(struct SS_data_12min));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_ss_level2_data_12min()
{
  VSdetach(vdata_id_ss_level2_data_12min);
  Vdetach(vgrp_id_ss_level2_data_12min);
}

/*----     init access function    ----*/

int32 init_acc_ss_level2_data_12min(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_ss_level2_data_12min_error();


  if ((vdata_ref = VSfind(hdf_fp, "SS_data_12min")) <= 0 ) {
    print_ss_level2_data_12min_error("init_acc_ss_level2_data_12min -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_ss_level2_data_12min = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_ss_level2_data_12min_error("init_acc_ss_level2_data_12min -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_ss_level2_data_12min, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_ss_level2_data_12min,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, nH, nH_err, vH, vthH")) {
      print_ss_level2_data_12min_error("init_acc_ss_level2_data_12min -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_ss_level2_data_12min(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_ss_level2_data_12min(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_ss_level2_data_12min(struct SS_data_12min *SS_data_12min_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_ss_level2_data_12min_error();
void unpack_ss_level2_data_12min();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SS_data_12min));
  VSinquire(vdata_id_ss_level2_data_12min, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_ss_level2_data_12min, recnum_rd)==FAIL) {
          print_ss_level2_data_12min_error("read_ss_level2_data_12min -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_ss_level2_data_12min, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_ss_level2_data_12min_error("read_ss_level2_data_12min -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_ss_level2_data_12min(odata, SS_data_12min_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_ss_level2_data_12min()
{
  VSdetach(vdata_id_ss_level2_data_12min);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_ss_level2_data_12min(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_ss_level2_data_12min_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SS_data_12min" )) ==FAIL)
    print_ss_level2_data_12min_error("rd_Vgrp_ss_level2_data_12min -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_ss_level2_data_12min_error("rd_Vgrp_ss_level2_data_12min -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_ss_level2_data_12min_error("rd_Vgrp_ss_level2_data_12min -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_ss_level2_data_12min_error("rd_Vgrp_ss_level2_data_12min -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SS_data_12min, HDstrlen(Vgrp_descrp_SS_data_12min)) ==FAIL)
    print_ss_level2_data_12min_error("rd_Vgrp_ss_level2_data_12min -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SS_data_12min);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_ss_level2_data_12min_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_ss_level2_data_12min.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_ss_level2_data_12min(uint8 *data, struct SS_data_12min *SS_data_12min_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SS_data_12min_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->nH, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->nH_err, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->vH, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_data_12min_ptr->vthH, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_ss_level2_data_12min(uint8 *data, struct SS_data_12min *SS_data_12min_ptr)
{
int32 ptr=0;

   memcpy(&SS_data_12min_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_data_12min_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_data_12min_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_data_12min_ptr->nH, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->nH_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->vH, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_data_12min_ptr->vthH, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_ss_level2_data_12min() {return(vgrp_id_ss_level2_data_12min);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_ss_level2_data_12min(char *wr_strval)
{
  strcpy(wr_strval, "The file 'ss_level2_data_12min.h' is shown below, it was used to create the data in the Vgroup named 'VG_SS_data_12min'.\n\n");
  strcat(wr_strval,"/* Id:$ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SS_data_12min {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of each record */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds of minute */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of Year */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* these from nvt file */\n");
  strcat(wr_strval,"  float32 nH;\n");
  strcat(wr_strval,"  float32 nH_err;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 vH;\n");
  strcat(wr_strval,"  float32 vthH;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  return(0);
}
