#include <stdio.h>
#include <string.h>
#include <time.h>


#include "cris_level2_data_1hr.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{

  int32 hdf_fp, sd_id, an_id;           /* HDF file pointer, scientific data id, annotation id */
  struct CRIS_data_1hr *testdata;
  int32 ii,nrec;
  
  void openhdf();
  void closehdf();

  testdata=malloc(sizeof(struct CRIS_data_1hr));
  memset(testdata,0,sizeof(struct CRIS_data_1hr));

  openhdf(argv[1],DFACC_CREATE,&hdf_fp,&sd_id,&an_id);

  nrec = atoi(argv[2]);

  /* initialize for write using perl generated code */
  init_cr_cris_level2_data_1hr(hdf_fp, sd_id, an_id, "ACE cris_level2_data 1hr");

  for (ii=0;ii<nrec;ii++) {
    testdata->fp_year = (float32)ii;
    if(write_cris_level2_data_1hr(testdata,-1)==FAIL) {
      fprintf(stderr,"ss2_level2_data_2hr: write error %d\n",ii);
      /* Reports HDF errors, then clears buffer */
      HEprint(stderr,0); HEclear(); 
      break;
    }
  }

  close_wr_cris_level2_data_1hr();
  closehdf(hdf_fp,an_id,sd_id);
  exit(0);
}


void openhdf(char *filenm, int mode, int32 *hdf_fp, int32 *sd_id, int32 *an_id)
{
  
  if ((*hdf_fp=Hopen(filenm, mode, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not create hdf file\n");
      exit(-1);
    }
  /* allow writing of V data using Vstart */
  if (Vstart(*hdf_fp) == FAIL) {
    fprintf(stderr,"Vstart: Couldn't Vstart %s\n",filenm);    
    exit(-1);
  }

  /* allow writing of SD data using SDstart */
  if ((*sd_id=SDstart(filenm, DFACC_RDWR))==FAIL) {
    fprintf(stderr,"SDstart: Couldn't SDstart %s\n",filenm);    
    exit(-1);
  }

 /*-- Start up the HDF Annotation interface --*/
  if ((*an_id = ANstart(*hdf_fp)) == FAIL) {
    fprintf(stderr,"ANstart: Couldn't ANstart %s\n",filenm);
    exit(-1);
  }
}

void closehdf(int32 hdf_fp, int32 an_id, int32 sd_id)
{
  if (ANend(an_id) == FAIL) {
    fprintf(stderr, "\nANend: could not close hdf file\n");
    exit(-1);
  }
  if (SDend(sd_id) == FAIL) {
    fprintf(stderr, "\nSDend: could not close hdf file\n");
    exit(-1);
  }
  if (Vend(hdf_fp) == FAIL) {
    fprintf(stderr, "\nVend: could not close hdf file\n");
    exit(-1);
  }
  if (Hclose(hdf_fp) == FAIL) {
    fprintf(stderr, "\nHclose: could not close hdf file\n");
    exit(-1);
  }
}
