#include <stdio.h>
#include <string.h>
#include <time.h>


#include "cris_level2_data_1hr.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct CRIS_data_1hr *testdata;
  int ii,jj,retval;
  int32 numrec;
  time_t tloc;
  char timestr[80];
  

  if (argc!=3) {
      printf("Usage: cris_l2_1hr_rd hdf_file one_of: B thru Ni, or all\n");
      exit(1);
  }

  if (
      (strcmp("B",argv[2])) &&
      (strcmp("C",argv[2])) &&
      (strcmp("N",argv[2])) &&
      (strcmp("O",argv[2])) &&
      (strcmp("F",argv[2])) &&
      (strcmp("Ne",argv[2])) &&
      (strcmp("Na",argv[2])) &&
      (strcmp("Mg",argv[2])) &&
      (strcmp("Al",argv[2])) &&
      (strcmp("Si",argv[2])) &&
      (strcmp("P",argv[2])) &&
      (strcmp("S",argv[2])) &&
      (strcmp("Cl",argv[2])) &&
      (strcmp("Ar",argv[2])) &&
      (strcmp("K",argv[2])) &&
      (strcmp("Ca",argv[2])) &&
      (strcmp("Sc",argv[2])) &&
      (strcmp("Ti",argv[2])) &&
      (strcmp("V",argv[2])) &&
      (strcmp("Cr",argv[2])) &&
      (strcmp("Mn",argv[2])) &&
      (strcmp("Fe",argv[2])) &&
      (strcmp("Co",argv[2])) &&
      (strcmp("Ni",argv[2])) &&
      (strcmp("all",argv[2]))
     ) {
      printf("Usage: cris_l2_1hr_rd hdf_file one_of: B thru Ni, or all\n");
      exit(1);
  }
     

  testdata=malloc(sizeof(struct CRIS_data_1hr));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
  }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
  }

  numrec=init_rd_cris_level2_data_1hr(hdf_fp, sd_id, "r");

  if( numrec<=0) {
      fprintf(stderr,"No cris level2 1hr data\n");
      exit(-1);
  }

  time(&tloc);
  strftime(timestr,79,"%c",localtime(&tloc));
  if (!strcmp("all",argv[2])) {
    printf("CRIS Hourly Averaged Cosmic Ray Element Fluxes\n");
    printf("Data downloaded from ACE Science Center on %s\n",timestr);
    printf("CRIS Team Software Version: 1.3\n");
    printf("CRIS Team Time/Date Processed: \n");
    printf("ACE Science Center Level2 Software Version: 1.4\n");
    printf("ACE Science Center Processing Date/Time: %s\n",timestr);
    printf("\n");
    printf("\n");
    printf("Note: All timestamps are UT, and refer to the start of the time period.\n");
    printf("year,day,hr,min,sec: year, day of year, hour of day, minutes, seconds.\n");
    printf("fp_year   : fractional year.\n");
    printf("fp_doy    : fractional day-of-year.\n");
    printf("ACEepoch  : seconds since Jan 1 00:00:00 UT 1996.\n");
    printf("flux_XX   : Element XX flux in 7 energy ranges, particles/(cm2 Sr sec MeV/nucleon).\n");
    printf("cnt_XX    : Number of counts for Element XX, unitless. 7 values.\n");
    printf("Energy ranges are different for each element. See supporting documentation.\n");
    printf("Flux or count values of -999.9 indicates bad or missing data.\n");
    printf("\n");
    printf("More Documentation of the ACE CRIS level 2 data is at this web site:\n");
    printf("http://www.srl.caltech.edu/ACE/ASC/level2/cris_l2desc.html\n");
    printf("\n");
    printf("year day hr min sec fp_year fp_doy ACEepoch flux_B(7 energies) flux_C(7 energies) flux_N(7 energies) flux_O(7 energies) flux_F(7 energies) flux_Ne(7 energies) flux_Na(7 energies) flux_Mg(7 energies) flux_Al(7 energies) flux_Si(7 energies) flux_P(7 energies) flux_S(7 energies) flux_Cl(7 energies) flux_Ar(7 energies) flux_K(7 energies) flux_Ca(7 energies) flux_Sc(7 energies) flux_Ti(7 energies) flux_V(7 energies) flux_Cr(7 energies) flux_Mn(7 energies) flux_Fe(7 energies) flux_Co(7 energies) flux_Ni(7 energies) cnt_B(7 energies) cnt_C(7 energies) cnt_N(7 energies) cnt_O(7 energies) cnt_F(7 energies) cnt_Ne(7 energies) cnt_Na(7 energies) cnt_Mg(7 energies) cnt_Al(7 energies) cnt_Si(7 energies) cnt_P(7 energies) cnt_S(7 energies) cnt_Cl(7 energies) cnt_Ar(7 energies) cnt_K(7 energies) cnt_Ca(7 energies) cnt_Sc(7 energies) cnt_Ti(7 energies) cnt_V(7 energies) cnt_Cr(7 energies) cnt_Mn(7 energies) cnt_Fe(7 energies) cnt_Co(7 energies) cnt_Ni(7 energies) livetime \n");
  }
  else {
    printf("Hourly %s Data extracted from HDF file on %s\n",argv[2],timestr);
    printf("HDF File: %s\n\n",argv[1]);
    printf("fpyear  day-of-year  7-fluxes 7-counts livetime\n");
  }

  ii=0;
  while( (retval = read_cris_level2_data_1hr(testdata,ii))!=-1 ) {
    if (!strcmp("all",argv[2])) {
      printf("%4d ",testdata->year);      /* integer year */
      printf("%3d ",testdata->day);       /* integer day of year */
      printf("%2d ",testdata->hr);        /* hour of day */
      printf("%2d ",testdata->min);       /* min of hour */
      printf("%6.3f ",testdata->sec);     /* seconds */
      printf("%13.8f ",testdata->fp_year);/* floating point year */
      printf("%10.6f ",testdata->fp_doy); /* floating point Day of YearDOY */ 
      printf("%13.3f ",testdata->ACEepoch);  /* UT time in sec since 1/1/96 */
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_B[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_C[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_N[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_O[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_F[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ne[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Na[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Mg[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Al[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Si[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_P[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_S[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Cl[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ar[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_K[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ca[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Sc[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ti[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_V[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Cr[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Mn[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Fe[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Co[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ni[jj]);

      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_B[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_C[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_N[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_O[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_F[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ne[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Na[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Mg[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Al[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Si[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_P[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_S[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Cl[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ar[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_K[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ca[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Sc[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ti[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_V[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Cr[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Mn[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Fe[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Co[jj]);
      for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ni[jj]);

      printf("% 11.4e\n",testdata->livetime);
    }
    else {
      printf("%13.8f %3d ",testdata->fp_year,testdata->day);
      if (!strcmp("B",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_B[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_B[jj]);
      }
      if (!strcmp("C",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_C[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_C[jj]);
      }
      if (!strcmp("N",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_N[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_N[jj]);
      }
      if (!strcmp("O",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_O[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_O[jj]);
      }
      if (!strcmp("F",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_F[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_F[jj]);
      }
      if (!strcmp("Ne",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ne[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ne[jj]);
      }
      if (!strcmp("Na",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Na[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Na[jj]);
      }
      if (!strcmp("Mg",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Mg[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Mg[jj]);
      }
      if (!strcmp("Al",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Al[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Al[jj]);
      }
      if (!strcmp("Si",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Si[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Si[jj]);
      }
      if (!strcmp("P",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_P[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_P[jj]);
      }
      if (!strcmp("S",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_S[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_S[jj]);
      }
      if (!strcmp("Cl",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Cl[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Cl[jj]);
      }
      if (!strcmp("Ar",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ar[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ar[jj]);
      }
      if (!strcmp("K",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_K[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_K[jj]);
      }
      if (!strcmp("Ca",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ca[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ca[jj]);
      }
      if (!strcmp("Sc",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Sc[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Sc[jj]);
      }
      if (!strcmp("Ti",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ti[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ti[jj]);
      }
      if (!strcmp("V",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_V[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_V[jj]);
      }
      if (!strcmp("Cr",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Cr[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Cr[jj]);
      }
      if (!strcmp("Mn",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Mn[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Mn[jj]);
      }
      if (!strcmp("Fe",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Fe[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Fe[jj]);
      }
      if (!strcmp("Co",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Co[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Co[jj]);
      }
      if (!strcmp("Ni",argv[2])) {
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ni[jj]);
	for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ni[jj]);
      }
      printf("% 7.4f\n",testdata->livetime);
    }
    
    ii++;
  }

  /* all done, close HDF file */

  close_rd_cris_level2_data_1hr();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
  }
  exit(0);
}


