/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id: swepam_level2_data_electron.h,v 1.1 2000/08/02 00:53:37 asc Exp  */

#include "swepam_level2_data_electron.h"
#include "df.h"

int32 vgrp_id_swepam_level2_data_electron;
static int32 vdata_id_swepam_level2_data_electron;

  /* 965 is the size of swepam_level2_data_electron.h + 1 added line */
char Vgrp_descrp_SWEPAM_electron[965];

/****----  init create function  ----****/

int32 init_cr_swepam_level2_data_electron(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_swepam_level2_data_electron();

  void print_swepam_level2_data_electron_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_swepam_level2_data_electron = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_swepam_level2_data_electron, "VG_SWEPAM_electron"); 
  Vsetclass(vgrp_id_swepam_level2_data_electron, "VG_SWEPAM_LEVEL2_DATA_ELECTRON");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SWEPAM_electron" )) ==FAIL) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_swepam_level2_data_electron(Vgrp_descrp_SWEPAM_electron);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SWEPAM_electron, sizeof(Vgrp_descrp_SWEPAM_electron))) ==FAIL) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_swepam_level2_data_electron = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_swepam_level2_data_electron, "SWEPAM_electron");
  VSsetclass(vdata_id_swepam_level2_data_electron, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_swepam_level2_data_electron, vdata_id_swepam_level2_data_electron)) ==FAIL) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "year", DFNT_INT32, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "day", DFNT_INT32, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "hr", DFNT_INT32, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "min", DFNT_INT32, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "sec", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "fp_year", DFNT_FLOAT64, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_swepam_level2_data_electron, "Electron_temp", DFNT_FLOAT32, (1) )) {
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSfdefine: Couldn't define Electron_temp");
    retval = -1;
  }

  if (VSsetfields(vdata_id_swepam_level2_data_electron,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, Electron_temp")){
    print_swepam_level2_data_electron_error("init_cr_swepam_level2_data_electron -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_swepam_level2_data_electron(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_swepam_level2_data_electron(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_swepam_level2_data_electron(struct SWEPAM_electron SWEPAM_electron_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_swepam_level2_data_electron_error();
void pack_swepam_level2_data_electron();

  odata = (uint8 *) malloc(sizeof(struct SWEPAM_electron));
  pack_swepam_level2_data_electron(odata, &SWEPAM_electron_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_swepam_level2_data_electron, recnum)==-1) {
		print_swepam_level2_data_electron_error("write_swepam_level2_data_electron -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_swepam_level2_data_electron, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_swepam_level2_data_electron_error("write_swepam_level2_data_electron -> VSwrite: Couldn't write data.");

  memset(&SWEPAM_electron_struc, 0, sizeof(struct SWEPAM_electron));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_swepam_level2_data_electron()
{
  VSdetach(vdata_id_swepam_level2_data_electron);
  Vdetach(vgrp_id_swepam_level2_data_electron);
}

/*----     init access function    ----*/

int32 init_acc_swepam_level2_data_electron(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_swepam_level2_data_electron_error();


  if ((vdata_ref = VSfind(hdf_fp, "SWEPAM_electron")) <= 0 ) {
    print_swepam_level2_data_electron_error("init_acc_swepam_level2_data_electron -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_swepam_level2_data_electron = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_swepam_level2_data_electron_error("init_acc_swepam_level2_data_electron -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_swepam_level2_data_electron, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_swepam_level2_data_electron,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, Electron_temp")) {
      print_swepam_level2_data_electron_error("init_acc_swepam_level2_data_electron -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_swepam_level2_data_electron(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_swepam_level2_data_electron(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_swepam_level2_data_electron(struct SWEPAM_electron *SWEPAM_electron_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_swepam_level2_data_electron_error();
void unpack_swepam_level2_data_electron();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SWEPAM_electron));
  VSinquire(vdata_id_swepam_level2_data_electron, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_swepam_level2_data_electron, recnum_rd)==FAIL) {
          print_swepam_level2_data_electron_error("read_swepam_level2_data_electron -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_swepam_level2_data_electron, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_swepam_level2_data_electron_error("read_swepam_level2_data_electron -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_swepam_level2_data_electron(odata, SWEPAM_electron_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_swepam_level2_data_electron()
{
  VSdetach(vdata_id_swepam_level2_data_electron);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_swepam_level2_data_electron(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_swepam_level2_data_electron_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SWEPAM_electron" )) ==FAIL)
    print_swepam_level2_data_electron_error("rd_Vgrp_swepam_level2_data_electron -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_swepam_level2_data_electron_error("rd_Vgrp_swepam_level2_data_electron -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_swepam_level2_data_electron_error("rd_Vgrp_swepam_level2_data_electron -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_swepam_level2_data_electron_error("rd_Vgrp_swepam_level2_data_electron -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SWEPAM_electron, HDstrlen(Vgrp_descrp_SWEPAM_electron)) ==FAIL)
    print_swepam_level2_data_electron_error("rd_Vgrp_swepam_level2_data_electron -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SWEPAM_electron);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_swepam_level2_data_electron_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_swepam_level2_data_electron.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_swepam_level2_data_electron(uint8 *data, struct SWEPAM_electron *SWEPAM_electron_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SWEPAM_electron_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWEPAM_electron_ptr->Electron_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_swepam_level2_data_electron(uint8 *data, struct SWEPAM_electron *SWEPAM_electron_ptr)
{
int32 ptr=0;

   memcpy(&SWEPAM_electron_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_electron_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_electron_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_electron_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_electron_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWEPAM_electron_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWEPAM_electron_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWEPAM_electron_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWEPAM_electron_ptr->Electron_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_swepam_level2_data_electron() {return(vgrp_id_swepam_level2_data_electron);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_swepam_level2_data_electron(char *wr_strval)
{
  strcpy(wr_strval, "The file 'swepam_level2_data_electron.h' is shown below, it was used to create the data in the Vgroup named 'VG_SWEPAM_electron'.\n\n");
  strcat(wr_strval,"/* Id: swepam_level2_data_electron.h,v 1.1 2000/08/02 00:53:37 asc Exp $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* swepam_level2_data_electron.h */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SWEPAM_electron {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* SWEPAM data */\n");
  strcat(wr_strval,"  float32 Electron_temp;\n");
  strcat(wr_strval,"};\n");
  return(0);
}
