;pro map_m6_to_m2_glint

common phasemod2,$
  phiveis_m2,theveis_m2,phistrl_m2,thestrl_m2,vunit_m2,vunitstrl_m2
common phasemod1,$
  phiveis_m1,theveis_m1,phistrl_m1,thestrl_m1,vunit_m1,vunitstrl_m1
 
loadct,18

dglint_m1_19970121,glnt
  
phasem1
phasem2

help,phiveis_m1,phiveis_m2
color_m1=(float([50,175,100,200,125,225])/255.)*float(!d.n_colors)
color_m2=(float([50,185,90,200,115,250,160,225])/255.)*float(!d.n_colors)
nsectors_m1=6
nsectors_m2=8
nvsteps=16

nphstps_m1=nsectors_m1*nvsteps
nphstps_m2=nsectors_m2*nvsteps

ndets=6
scimode=2;6
if scimode eq 6 then begin
  nsectors=nsectors_m1 
  nphstps=nphstps_m1
  phiveis=phiveis_m1
  color=color_m1
endif else if scimode eq 2 then begin
  nsectors=nsectors_m2
  nphstps=nphstps_m2
  phiveis=phiveis_m2
  color=color_m2
endif 

phasestep=intarr(ndets,nvsteps,nsectors)
for idet=0,ndets-1 do begin
  for isect=0,nsectors-1 do begin
    phasestep(idet,*,isect)=isect*nvsteps+indgen(nvsteps)
  endfor
endfor

 
yrange=[0,nphstps]
xrange=[0,360]
xticks=6
window,0,xsize=800,ysize=600

  
ngl=-1  
for idet=0,ndets-1 do begin
  
  plot,xrange,yrange,/nodata,xrange=xrange,xstyle=1,xticks=xticks,xminor=6,$
  yrange=yrange,ystyle=1,yticks=16,yminor=nsectors,yticklen=0.005,$
  title='mode '+string(scimode,format='(i1)')+$
  ' sampling  (vertical lines: sun glint)',$
  xtitle='spin phase angle',ytitle='spin phase step'
      
  for isect=0,nsectors-1 do begin
    oplot,phiveis(idet,*,isect),phasestep(idet,*,isect),psym=4,symsize=0.4,$
      color=color(isect)
    xyouts,phiveis(idet,0,isect),phasestep(idet,0,isect),/data,$
      string(isect,format='(i1)')  
  endfor

  xyouts,0.85,0.9,'det '+string(idet,format='(i1)'),/norm,charsize=1.5
  
  for isect=0,nsectors_m1-1 do for ivstep=0,nvsteps-1 do begin 
    if glnt(idet,ivstep,isect) eq -1 then begin
      ;plot the mode1 glint point
      oplot,[phiveis_m1(idet,ivstep,isect),phiveis_m1(idet,ivstep,isect)],$
        [isect*nvsteps+ivstep,isect*nvsteps+ivstep],$
        psym=2,color=color_m1(isect)
      ;draw a verical line through the glint point  
      oplot,[phiveis_m1(idet,ivstep,isect),phiveis_m1(idet,ivstep,isect)],$
        yrange,color=color_m1(isect) 
          
      print,'mode1 glint det,vstep,sect :',idet,ivstep,isect  
      ;stop                    
      ngl=ngl+1  
    endif
  endfor      
     
 
    
  
  stop  
  
endfor  
print,'ngl ',ngl
end  