;pro map_m1_to_m2_glint

common phasemod2,$
  phiveis_m2,theveis_m2,phistrl_m2,thestrl_m2,vunit_m2,vunitstrl_m2
common phasemod1,$
  phiveis_m1,theveis_m1,phistrl_m1,thestrl_m1,vunit_m1,vunitstrl_m1
 
loadct,18

dglint_m1_19960309,glnt
  
phasem1
phasem2

help,phiveis_m1,phiveis_m2
;color_m1=(float([50,100,125,175,200,225])/255.)*float(!d.n_colors)
;color_m2=(float([50,90,115,160,185,200,225,250])/255.)*float(!d.n_colors)
color_m1=(float([50,175,100,200,125,225])/255.)*float(!d.n_colors)
color_m2=(float([50,185,90,200,115,250,160,225])/255.)*float(!d.n_colors)
nsectors_m1=6
nsectors_m2=8
nphstps_m1=nsectors_m1*(16+1)
nphstps_m2=nsectors_m2*16

ndets=6
scimode=2;1
if scimode eq 1 then begin
  nsectors=nsectors_m1 
  nullstep=1
  nphstps=nphstps_m1
endif else if scimode eq 2 then begin
  nsectors=nsectors_m2
  nullstep=0
  nphstps=nphstps_m2
endif 
 
nsteps=nsectors*(16+nullstep)
yrange=[0,nsteps]
xrange=[0,360]
xticks=6
window,0,xsize=800,ysize=600  ;xsize=1100,ysize=850

ngl=-1  
for idet=0,ndets-1 do begin
  plot,xrange,yrange,/nodata,xrange=xrange,xstyle=1,xticks=xticks,xminor=6,$
  yrange=yrange,ystyle=1,yticks=16,yminor=nsectors,yticklen=0.005
    
  for isect=0,nsectors-1 do begin
    phasestep=isect*(16+nullstep)+indgen(16)
    if nsectors eq 6 then begin
      color=color_m1
      phiveis=phiveis_m1 
    endif else if nsectors eq 8 then begin
      color=color_m2
      phiveis=phiveis_m2
    endif  
    oplot,phiveis(idet,*,isect),phasestep,psym=4,symsize=0.4,$
      color=color(isect)
    xyouts,phiveis(idet,0,isect),phasestep(0),/data,$
      string(isect,format='(i1)')  
  endfor

  xyouts,0.85,0.9,'det '+string(idet,format='(i1)'),/norm,charsize=1.5
  
  for isect=0,nsectors_m1-1 do for ivstep=0,15 do begin 
    if glnt(idet,ivstep,isect) eq -1 then begin
      ;plot the mode1 glint point
      oplot,[phiveis_m1(idet,ivstep,isect),phiveis_m1(idet,ivstep,isect)],$
        [isect*(16+nullstep)+ivstep,isect*(16+nullstep)+ivstep]* $
        float(nphstps)/float(nphstps_m1),$
        psym=2,color=color_m1(isect)
      ;draw a verical line through the glint point  
      oplot,[phiveis_m1(idet,ivstep,isect),phiveis_m1(idet,ivstep,isect)],$
        yrange,color=color_m1(isect) 
          
      print,'mode1 glint det,vstep,sect :',idet,ivstep,isect  
      ;stop  
       
                  
      ngl=ngl+1  
    endif
  endfor      
     
 
    
  
  stop  
  
endfor  
print,'ngl ',ngl
end  