pro oppdet_phi,date,deltacounts,det,oppdet,phiveis,vsteps

common wstuff,wst

;plots veis counts DIFFERENCES data

hardcopy=0

yn=['no','yes']
clr=[225,125]

start:

if keyword_set(hardcopy) eq 0 then hardcopy=0
if hardcopy then begin
  pflnm=getenv('IDLSAV')+'idl.ps'
  print,' ' & print,'making hardcopy..... ' 
  set_plot,'ps'
  device,/inches,xoffset=1.0,yoffset=1.0,xsize=7.,ysize=8.,filename=pflnm
endif

!p.multi=[0,0,3,0,0]
!p.charsize=2.25
 
xtitle=[' ',' ','phi (look)']
ytitle=['counts diff','counts diff','counts diff']

stitle=[' ',' ',' ']

siz=size(deltacounts)
if siz(1) ne n_elements(det) then stop
nsteps=siz(2)
nsectors=siz(3)
nspns=siz(4)

if nsectors eq 6 then vlevel_low=17
if nsectors eq 8 then vlevel_low=17

nstdev=2.0  ;1.5  ;2.25  ;

new_glnt=1+intarr(6,nsteps,nsectors)

for istep=0,nsteps-1 do begin
  energy=volt_en(vsteps(istep),/en)
  print,' ' & print,'step  level  energy ',istep,vsteps(istep),energy
  y=fltarr(3,n_elements(det),nsectors)
  for idet=0,n_elements(det)-1 do for isect=0,nsectors-1 do begin
      result=moment(deltacounts(idet,istep,isect,*))
      y(0,idet,isect)=result(0)-nstdev*sqrt(result(1))
      y(1,idet,isect)=result(0)
      y(2,idet,isect)=result(0)+nstdev*sqrt(result(1))
  endfor

  select_sect=indgen(nsectors)  ;[0,1,2,3,4]  
  mny=min(y(0,*,select_sect))-0.1* $
    (max(y(2,*,select_sect))-min(y(0,*,select_sect)))
  mxy=max(y(2,*,select_sect))+0.1* $
    (max(y(2,*,select_sect))-min(y(0,*,select_sect)))
  

  for idet=0,n_elements(det)-1 do begin
    x=phiveis(idet,istep,*)    
    vlevel=vsteps(istep)
    
    xrange=[0,360]
    xticks=4
    xtickformat='(i3)'
    yrange=[mny,mxy]
    yticks=6
    ytickformat='(i8)'
    plot,xrange,yrange,/nodata,$
      title='det '+string(idet,format='(i1)')+'    '+$
            'oppdet '+string(oppdet(idet),format='(i1)')+'    '+$
          '    step '+string(istep,format='(i2)')+$
          '    vlevel '+string(vlevel,format='(i3)')+$
          '    energy '+string(energy,format='(i4)')+' ev',$
      xrange=xrange,xticks=xticks,xstyle=1,xtitle=xtitle(idet),$
      xtickformat=xtickformat,$
      yrange=yrange,yticks=yticks,ystyle=1,ytickformat=ytickformat,$
      ytitle=ytitle(idet),subtitle=stitle(idet)

    for isect=0,nsectors-1 do begin
      oplot,[x(isect),x(isect)],[y(0,idet,isect),y(2,idet,isect)],$
        psym=0,symsize=0.85,color=175
        xyouts,x(isect),y(1,idet,isect),/data,$
        string(isect,format='(i1)'),color=175
      if (y(0,idet,isect) ge 0 and y(2,idet,isect) ge 0) and $
      vlevel gt vlevel_low then begin
        new_glnt(idet,istep,isect)=-1 
        print,' new glint: det, step, sect ',idet,istep,isect
        print,' '
      endif
      if (y(0,idet,isect) le 0 and y(2,idet,isect) le 0) and $
      vlevel gt vlevel_low then begin
        new_glnt(oppdet(idet),istep,isect)=-1
        print,' new glint: det, step, sect ',oppdet(idet),istep,isect 
        print,' '
      endif
          
    endfor
    oplot,xrange,[0.,0.],linestyle=1 

  endfor
  print,'hit return to continue' & answ='' & read,answ & if answ ne '' then stop
endfor

;fine tune glint point selection
if nsectors eq 6 then begin
  ;addition of points to mask 
  new_glnt(3,8:10,5)=-1

  ;removal of points to mask
  new_glnt(1,6,3)=1
endif

wglnt=where(new_glnt eq -1,nglnt)
print,' '
print,'where(new_glnt eq -1) ',nglnt

if nsectors eq 6 then modn='_m1'
if nsectors eq 8 then modn='_m2'
filename=$
 getenv('GLINTPATH')+date+'_std'+string(nstdev,format='(f3.1)')+modn+'.glntmap'

print,'Do you want to save glnt array, number of points= '$
       ,nglnt,' filename ',filename, '? y/n'
answ='' & read,answ 
if answ eq 'y' then begin
  glnt=new_glnt
  save,filename=filename,glnt
endif


if hardcopy then begin   
  device,/close
  set_plot,'x'
  print,' ' & print,'printing hardcopy file ',pflnm
  spawn, 'lpr '+pflnm
  hardcopy=0
  goto,start
endif

!p.multi=0
!p.charsize=1.


end



;======================= MAIN: lzoppdet_diff ==================================



;reads and process a SWE lz file (RJF Jan95)

common lzstuff,lzfile,lundat,recn,fh,lz,ihk,sp,vsmjf,veis_hvtbl
common m2stuff,hkind,ghk,vblhsp,sblhsp
common m1stuff,hkm1,vsm1,vdatc,sdatc
common log_delog,comp_tbl,dcomp_tbl
common oastuff,atfile,tpb5_at,gse_ra,gse_dec
common magstuff,magfile,tpb5,bgse
common wstuff,wst
common swestuff,swest

print,$
 'Do you want to restore an existing opposing-detectors difference file? y/n'
answ='' & read,answ & if answ eq 'y' then goto,doanalysis



;initialize structures
  structuresw

;no background subtraction
  swest.subtrbkg='No'

wst.date_file='File'     

ctmmode=['u','m','s','e']
ctmrate=['s','f']
elecion=['electrons','ions']

det=[0,1,2]
oppdet=[5,4,3]


lpr=0
rfill=-1.0e31

;read compress/decompress tables
  decompress_tbl

;get indices of instrument housekeeping into mjf array, lz.mf   
  ihkmap,ihk 

;get mode1, mode2 tm map of science and genl hk data offsets into lz.mf
   mode1map,hkm1,fcblm1,vsm1,vdatc,sdatc
   mode2map,hkind,ghk,vblhsp,sblhsp

;get mode1 and mode2 sun phase angles of detectors, unit vectors, glint masks
   phasem1
   phasem2

;open LZ data file and read header, read mag, orb-att, background data
;  and process first two records to get spin period
  lzinput,err=err
  if err ne '' then stop,err


print,' '
print,'scimode ',vsmjf.scimode
print,'eleion_sweep: ',swest.swpmd(vsmjf.eleion_sweep)
print,' '

;determine science mode of first record
;  (this program is only intended to be applicable for ELECTRON data in the 
;   file that are in the SAME mode as the mode of first record)
  scimode_recn1=vsmjf.scimode
      
;get voltage steps, offsets into voltage table, for first spin in first record
;that is in the electron mode    
  if vsmjf.scimode eq 1 then vsteps_last=vsmjf.veistep
  if vsmjf.scimode eq 2 then begin
    welspin=where(vsmjf.eleion(0,*) eq 0)   ;welspi(0)=first electron spin
    if welspin(0) ne -1 then $
      vsteps_last=reform(vsmjf.veistep(*,0,welspin(0)))
    if total(vsmjf.eleion(*,welspin(0))) ne 0 then $
      stop,'mode2: first record in file is not in all-electron-spin mode'
  endif 

nfill=0l
spn=-1l
lastsec=0.d

;initialize sums
  
  deltacounts=lonarr(n_elements(det),vsmjf.n_vesteps,vsmjf.n_sectors,8*fh.nmf)
  numdelta=lonarr(n_elements(det),vsmjf.n_vesteps,vsmjf.n_sectors)

recn1=1 & recn2=fh.nmf  ;read entire file
;recn1=1 & recn2=100

if wst.lzdate eq '19951130' then recn2=540
if wst.lzdate eq '19960309' then recn1=50

print,'date, recn1, recn2 ',wst.lzdate,'  ',recn1,recn2
print,' ' 
print,'hit return to continue' & answ='' & read,answ & if answ ne '' then stop
 
for recn=recn1,recn2 do begin

;process selected lz record (set keyword lpr=1 to turn on print each record)
  proc_rec,date_time,tmmode_ihk=tmmode_ihk,lpr=0,$
    elec_ion_m1=elec_ion_m1

;determine whether in telemetry science mode
  tmmode_ihk=get_bits(lz.mf(ihk(2).offs),ihk(2).bv(1).p,ihk(2).bv(1).n)
  if tmmode_ihk ne 2 then begin
    print,' '&print,'tm not in science mode, tm mode = ',ctmmode(tmmode_ihk)
    goto,endrecordloop
  endif

;check data quality; if one mnf flag set, then skip entire record
  n_mnf=250
  if total(lz.qlty(0:n_mnf-1)) gt 0 then  goto, endrecordloop 

;check spinperiod
  if sp.spinp lt 0.9*3.05 or sp.spinp gt 1.1*3.05 then begin 
    print,'bad spinperiod'
    goto,endrecordloop
  endif

;science mode
  scimode_ihk=get_bits(lz.mf(ihk(2).offs),ihk(2).bv(0).p,ihk(2).bv(0).n)
  scimode1 = scimode_ihk eq 0 or scimode_ihk eq 1
  scimode2 = scimode_ihk eq 2 or scimode_ihk eq 11
  if not float(scimode1 or scimode2) then begin
    print,'not science mode 1 or science mode 2'
    goto,endrecordloop
  endif 


;---- ready to process mode1 or mode2 electrons ---------------------------
     
ndets=vsmjf.n_vdets
nvsteps=vsmjf.n_vesteps 
nsectors=vsmjf.n_sectors
nspins=vsmjf.n_spins
  
;print,sp.mfrecn,sp.mfyr,sp.mfdy,sp.mfms,sp.spinp

;start spin loop to find differences in counts between detector i (0,1,2) and 
;its opposite detector -i (5,4,3) versus the phase angle of detector i


  for ispin=0,nspins-1 do begin

   ;test for all electron mode (every sector in given spin)
      elemode=0
      if scimode1 then begin
        if vsmjf.eleion(0) eq 0 then elemode=1
      endif else if scimode2 then begin
        if total(vsmjf.eleion(*,ispin)) eq 0 then elemode=1      
      endif 
      if elemode eq 0 then begin
        ;print,'not in all electron mode,  ispin ',ispin
        goto,endspinloop
      endif

   ;voltage steps: offsets into voltage table 
   ;assumes all sectors electrons   
    if scimode1 then vsteps=vsmjf.veistep else $
    if scimode2 then vsteps=reform(vsmjf.veistep(*,0,ispin))

  ;test if there has been a change in voltage table
    if total(vsteps-vsteps_last) ne 0 then stop,'hv table change'
    vsteps_last=vsteps
 
  ;NOTE: 
  ;glint points (counts and f's) are negative their value

  spn=spn+1
  for isect=0,nsectors-1 do for istep=0,nvsteps-1 do $
  for idet=0,n_elements(det)-1 do begin
    deltacounts(det(idet),istep,isect,spn)=$
       deltacounts(det(idet),istep,isect,spn) + $
       abs(vsmjf.veis(   det(idet),istep,isect,ispin))-$
       abs(vsmjf.veis(oppdet(idet),istep,isect,ispin))
    numdelta(det(idet),istep,isect)=numdelta(det(idet),istep,isect) + 1
  endfor
  
  if lpr then $
        print,recn,ispin,vsmjf.tjd,vsmjf.sec,sec_pb5(vsmjf.suntim_vsbl(ispin))
  endspinloop:
  endfor  ;end spin loop
      

  skiprec=10
  if fix(recn/skiprec)*skiprec eq recn then  begin
     ;print,'lztim: recn,lz.recn,lz.yr,lz.dy,lz.ms,vsmjf.suntim_vsbl(0)'
     print, recn,lz.recn,lz.yr,lz.dy,ms_hhmmss(lz.ms)
  endif

  endrecordloop:

endfor     ;end record loop

nrec=long(spn+1)

deltacounts=deltacounts(*,*,*,0:nrec-1)

  
print,'lzoppdet_diff finished for date ',wst.lzdate


phiveis=vsmjf.phiveis
fname=wst.lzdate+'_'+strcompress('deltacounts'+'_'+$
 string(recn1,format='(i4)')+'_'+string(recn2,format='(i4)')+'.idlsav',$
 /remove_all)

filename=getenv('GLINTPATH')+'glint_diffcounts/'+fname
print,'Do you want to save ? y/n  ',filename
answ='' & read,answ & if answ eq 'y' then $
save,filename=filename,deltacounts,phiveis,vsteps,det,oppdet

stop
doanalysis:

 path=getenv('GLINTPATH')+'glint_diffcounts/'
 filename=pickfile(/read,get_path=path,path=path,$
               filter='*deltacounts*',$
               title='Det-Oppdet Difference Files')
deltacounts=0
restore,filename
date=strmid(filename,strlen(path),8)

window,0
oppdet_phi,date,deltacounts,det,oppdet,phiveis,vsteps

end



