;----- procedure to write a file associating each date with a
;------glint map file


;creates and updates a table associating an existing glint map file
;  with each day from nov 30 1994 to present

;the association is done by finding the date of background data 
;  which is closest to the date of lz data

datfiles_m1=findfile(getenv('WGGSBASE')+'swe/glint/dglint_m1_*.pro')
datdates_m1=strmid(datfiles_m1,strlen(getenv('WGGSBASE'))+20,6)

datfiles_m2=findfile(getenv('WGGSBASE')+'swe/glint/dglint_m2_*.pro')
datdates_m2=strmid(datfiles_m2,strlen(getenv('WGGSBASE'))+20,6)

day=[334+indgen(365-333),    1+indgen(365),    1+indgen(366),$
    1+indgen(365),    1+indgen(365),    1+indgen(365)]
year=[  replicate(94,32),replicate(95,365),replicate(96,366),$
replicate(97,365),replicate(98,365),replicate(99,365)]
ymdy=strarr(n_elements(day))

gfile_m1=strarr(n_elements(day))
gfile_m2=strarr(n_elements(day))

for i=0,n_elements(day)-1 do begin
  mdy=yrmoda([1900+year(i),day(i),0])

  ymdy(i)=strmid(mdy,strlen(mdy)-2,2)+strmid(mdy,0,2)+strmid(mdy,3,2)

  ;print,year(i),day(i),mdy,ymdy(i),format='(i2,i5,a12,a12)'

  mn=min(abs(long(datdates_m1)-long(ymdy(i))),mnindx)
  gfile_m1(i)=datdates_m1(mnindx(0))

  mn=min(abs(long(datdates_m2)-long(ymdy(i))),mnindx)
  gfile_m2(i)=datdates_m2(mnindx(0))
    
endfor

print,' '
print,'     date  m1 glint file  ';m2 glint file'
for i=0,n_elements(day)-1 do $
  print,i,' ',ymdy(i),'  ',gfile_m1(i);, '  ',gfile_m2(i)
print,'     date  m1 glint file';  m2 glint file'

openw,lun,getenv('GLINTPATH')+'glintdates_m1',/get_lun
for i=0,n_elements(day)-1 do printf,lun,ymdy(i),'  ',gfile_m1(i) 
free_lun,lun

;openw,lun,getenv('GLINTPATH')+'glintdates_m2',/get_lun
;for i=0,n_elements(day)-1 do printf,lun,ymdy(i),'  ',gfile_m2(i) 
;free_lun,lun

end


