;----- procedure to write a file associating each date with a
;------glint map file


;creates and updates a table associating an existing glint map file
;  with each day from nov 30 1994 to 2005 

;the association is done by finding the date of background data 
;  which is closest to the date of lz data

datfiles_m1=findfile(getenv('WGGSBASE')+'swe/cal/glint/dglint_m1_*.pro')
datdates_m1=strarr(n_elements(datfiles_m1))
for i=0,n_elements(datfiles_m1)-1 do $
datdates_m1(i)=strmid(datfiles_m1(i),strlen(datfiles_m1(i))-12,8)

datfiles_m2=findfile(getenv('WGGSBASE')+'swe/cal/glint/dglint_m2_*.pro')
datdates_m2=strarr(n_elements(datfiles_m2))
for i=0,n_elements(datfiles_m2)-1 do $
datdates_m2(i)=strmid(datfiles_m2(i),strlen(datfiles_m2(i))-12,8)

 
day=[334+indgen(365-333),    1+indgen(365),    1+indgen(366),$
           1+indgen(365),    1+indgen(365),    1+indgen(365),$
           1+indgen(366),    1+indgen(365),    1+indgen(365),$
           1+indgen(365),    1+indgen(366),    1+indgen(365)]
year=[  replicate(1994,32), replicate(1995,365),replicate(1996,366),$
        replicate(1997,365),replicate(1998,365),replicate(1999,365),$
        replicate(2000,366),replicate(2001,365),replicate(2002,365),$
        replicate(2003,365),replicate(2004,366),replicate(2005,365)]
        
ymdy=strarr(n_elements(day))

gfile_m1=strarr(n_elements(day))
gfile_m2=strarr(n_elements(day))

for i=0,n_elements(day)-1 do begin
  mdy=yrmoda([year(i),day(i),0])

  ymdy(i)=strmid(mdy,strlen(mdy)-4,4)+strmid(mdy,0,2)+strmid(mdy,3,2)

  ;print,year(i),day(i),mdy,ymdy(i),format='(i2,i5,a12,a12)'

  mn=min(abs(long(datdates_m1)-long(ymdy(i))),mnindx)
  gfile_m1(i)=datdates_m1(mnindx(0))

  mn=min(abs(long(datdates_m2)-long(ymdy(i))),mnindx)
  gfile_m2(i)=datdates_m2(mnindx(0))
    
endfor

print,' '
print,'     date  m1 glint file  ';m2 glint file'
for i=0,n_elements(day)-1 do $
  print,i,' ',ymdy(i),'  ',gfile_m1(i);, '  ',gfile_m2(i)
print,'     date  m1 glint file';  m2 glint file'

openw,lun,getenv('GLINTPATH')+'glintdates_m1',/get_lun
for i=0,n_elements(day)-1 do printf,lun,ymdy(i),'  ',gfile_m1(i) 
free_lun,lun

openw,lun,getenv('GLINTPATH')+'glintdates_m2',/get_lun
for i=0,n_elements(day)-1 do printf,lun,ymdy(i),'  ',gfile_m2(i) 
free_lun,lun

end


