

pro dglint_m1_universal,glnt,review=review

print,'enter dglint_m1_universal'

;============= array to identify glint data ===============================

restore,getenv('WGGSBASE')+'swe/cal/glint/universal_m1.glntmap'
;universal_m1.glntmap' is combined from all of glint map determinations
 
;fine-tuning (based on inspection of counts spectra and background spectra).....

;remove from original glint mask  
glnt(3, 14,                  0) =+1
glnt(0, [11,12,13,14,15],    1) =+1
glnt(0, [5,6],               2) =+1
glnt(2, [5,9],               2) =+1
glnt(0, [10,11,12,13,14,15], 3) =+1
glnt(1, [5,10,11],           3) =+1
glnt(5, [12,13,14,15],       5) =+1
glnt(3, 5,                   5) =+1

;add to original glint mask
glnt(1, 15,                  2) =-1
glnt(1, [5,6,7,8,9,10,11],   3) =-1   ;added jan 5, 1999 
glnt(3, 5,                   5) =-1   ;added jan 6, 1999      

help,glnt  
print,'number of glint points ',n_elements(where(glnt eq -1))

if keyword_set(review) ne 0 then begin
  for isect=0,5 do for idet=0,5 do for istep=0,15 do $
  if glnt(idet,istep,isect) eq -1 then $
  print,'glnt(', idet, ',  ', istep, ',  ',  isect, ' ) = -1'
endif



end
