; cread_themis_mag.pro 
; Loads spin resolution magnetometer data from all THEMIS spacecraft in GSE along with position, if iplot =1 the mag data from all spacecraft are plotted red-Bxgse, green-Bygse, blue-Bzgse, black-magniutde
timename='jd'
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
dt_sec=3.0
;start_time = '2007-02-26T00:00:00.000Z'
;stop_time = '2014-07-08T00:00:00.000Z'

start_time = '2014-02-10T15:30:00.000Z'
stop_time = '2014-02-10T17:30:00.000Z'

start_time = '2015-03-17T03:00:00.000Z'
stop_time = '2015-03-17T06:00:00.000Z'


;start_time = '2013-02-22T00:00:00.000Z'
;stop_time = '2013-02-23T00:40:00.000Z'
dates = [start_time, stop_time]

dataset_id = 'THA_L2_FIT'
vars = [ 'tha_fgs_sigma',  'tha_fgs_dsl',  'tha_fgs_gse',  'tha_fgs_gsm',  'tha_efs_sigma',  'tha_efs_dsl',  'tha_efs_0_dsl',  'tha_efs_dot0_dsl',  'tha_efs_gse',  'tha_efs_0_gse',  'tha_efs_dot0_gse',  'tha_efs_gsm',  'tha_efs_0_gsm',  'tha_efs_dot0_gsm',  'tha_fit_bfit',  'tha_fit_efit']
vars = ['tha_fgs_gse=bva']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'

dataset_id = 'THB_L2_FIT'
vars = [ 'thb_fgs_sigma',  'thb_fgs_dsl',  'thb_fgs_gse',  'thb_fgs_gsm',  'thb_efs_sigma',  'thb_efs_dsl',  'thb_efs_0_dsl',  'thb_efs_dot0_dsl',  'thb_efs_gse',  'thb_efs_0_gse',  'thb_efs_dot0_gse',  'thb_efs_gsm',  'thb_efs_0_gsm',  'thb_efs_dot0_gsm',  'thb_fit_bfit',  'thb_fit_efit']
vars = ['thb_fgs_gse=bvb']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'
 
dataset_id = 'THC_L2_FIT'
vars = [ 'thc_fgs_sigma',  'thc_fgs_dsl',  'thc_fgs_gse',  'thc_fgs_gsm',  'thc_efs_sigma',  'thc_efs_dsl',  'thc_efs_0_dsl',  'thc_efs_dot0_dsl',  'thc_efs_gse',  'thc_efs_0_gse',  'thc_efs_dot0_gse',  'thc_efs_gsm',  'thc_efs_0_gsm',  'thc_efs_dot0_gsm',  'thc_fit_bfit',  'thc_fit_efit']
vars = ['thc_fgs_gse=bvc']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'
 
dataset_id = 'THD_L2_FIT'
vars = [ 'thd_fgs_sigma',  'thd_fgs_dsl',  'thd_fgs_gse',  'thd_fgs_gsm',  'thd_efs_sigma',  'thd_efs_dsl',  'thd_efs_0_dsl',  'thd_efs_dot0_dsl',  'thd_efs_gse',  'thd_efs_0_gse',  'thd_efs_dot0_gse',  'thd_efs_gsm',  'thd_efs_0_gsm',  'thd_efs_dot0_gsm',  'thd_fit_bfit',  'thd_fit_efit']
vars = ['thd_fgs_gse=bvd']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'

dataset_id = 'THE_L2_FIT'
vars = ['the_fgs_sigma=the_fgs_sigmae', 'the_fgs_dsl=the_fgs_dsle', 'the_fgs_gse=the_fgs_gsee', 'the_fgs_gsm=the_fgs_gsme', 'the_efs_sigma=the_efs_sigmae', 'the_efs_dsl=the_efs_dsle', 'the_efs_0_dsl=the_efs_0_dsle', 'the_efs_dot0_dsl=the_efs_dot0_dsle', 'the_efs_gse=the_efs_gsee', 'the_efs_0_gse=the_efs_0_gsee', 'the_efs_dot0_gse=the_efs_dot0_gsee', 'the_efs_gsm=the_efs_gsme', 'the_efs_0_gsm=the_efs_0_gsme', 'the_efs_dot0_gsm=the_efs_dot0_gsme', 'the_fit_bfit=the_fit_bfite', 'the_fit_efit=the_fit_efite']
vars = ['the_fgs_gse=bve']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'

dataset_id='THA_L1_STATE'
 vars=[  'tha_pos_gse=pa']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'
dataset_id='THB_L1_STATE'
 vars=[  'thb_pos_gse=pb']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'
dataset_id='THC_L1_STATE'
 vars=[  'thc_pos_gse=pc']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'
dataset_id='THD_L1_STATE'
 vars=[  'thd_pos_gse=pd']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'
dataset_id='THE_L1_STATE'
 vars=[  'the_pos_gse=pe']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename,to_struct='th'

iplot=1
if keyword_set(iplot) then begin
cmb_set_up_colors
window,/free
!x.ticklen = -0.04
!y.ticklen = -0.012

nx = 1
ny = 5
ch = 0.1
pos = [0.085,0.085,0.97,0.96]

!x.ticklen = 0.08

dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
jdr = [min(jd),max(jd)]
;!p.charsize = 1.2
!p.charsize = 0
ip=0
cmb_mag_plot,jdr, th, 'b0a','bva','pa', 'THEMIS-A', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=0
cmb_mag_plot,jdr, th, 'b0b','bvb','pb', 'THEMIS-B', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
cmb_mag_plot,jdr, th, 'b0c','bvc','pc', 'THEMIS-C', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
cmb_mag_plot,jdr, th, 'b0d','bvd','pd', 'THEMIS-D', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
cmb_mag_plot,jdr, th, 'b0e','bve','pe', 'THEMIS-E', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),noerase=1
ip=0

cmb_create_plot_file,'THEMIS_spin_res_mag'

endif

end 
