; demo_rbsp
; Plots 60s binned RBSP A or B EMFISIS electric field power spectral density, HOPE proton, O+, and electron omni directional differential flux, this is an interactive demo where the user can select a point on the time series plot with their cursor, and electric field and particle spectra, and pitch angle phase space density plots are plotted at the selected time.
;plots spectrograms of EMFISIS and HOPE data, and then lets the user select spectral slices with cursor.
;id = 'A'  ; for RBSP-A
;id = 'B'  ; for RBSP-B

FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
if n_elements(HFR_Spectra) ne 0 then goto,skip


;  start_time = '2013-11-28T05:00:00.0Z'
;  stop_time  = '2013-11-28T13:00:00.0Z'
;  id = 'B' ; for RBSP-B

 
 ;start_time = '2012-11-28T05:00:00.0Z'
 ;stop_time  = '2012-11-28T13:00:00.0Z'
 ;id = 'B' ; for RBSP-B

 ;start_time = '2012-11-14T00:00:00.0Z'
 ;stop_time  = '2012-11-14T23:59:59.0Z'
 ;id = 'A'  ; for RBSP-A
 
  start_time = '2014-05-04T00:00:00.0Z'
  stop_time  = '2014-05-04T23:59:59.0Z'
  id = 'A'  ; for RBSP-A



 ;start_time = '2015-06-22T00:00:00.0Z'
 ;stop_time  = '2015-06-23T23:59:59.0Z'
 ;id = 'A'  ; for RBSP-A


dt=6.0d0 ;s
dates = [start_time, stop_time]
time_name='jd'

iburst=0
read,'input 1 to plot vertical dashed lines indicating when 6s WFR burst modes are occurring:',iburst

dataset_id='RBSP-' + id + '_HFR-SPECTRA-BURST_EMFISIS-L2'
vars=[ 'HFR_Spectra', 'HFR_bins', 'HBGain', 'HBSelect']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name

if iburst then begin
   dataset_id='RBSP-' + id + '_WFR-WAVEFORM-CONTINUOUS-BURST_EMFISIS-L2'
    vars=[ 'SCMGain']
    d = spdfgetdata( dataset_id, vars, dates) ;get burst times for WFR for this time interval
    if cmb_var_type(d) eq 'STRUCT' then $
    jdburst_times = cmb_epoch2jd( cmb_epoch_modify(d.epoch.dat)) ;convert long64 epoch to julian date
endif

dataset_id = 'RBSP-' + id + '_WFR-SPECTRAL-MATRIX-DIAGONAL_EMFISIS-L2'
vars=['EuEu','EvEv','EwEw','BuBu']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name

dataset_id = 'RBSP-' + id + '_MAGNETOMETER_4SEC-SM_EMFISIS-L3'
vars=['Magnitude=B0','coordinates=pos_sm']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name

dataset_id = 'RBSP' + id + '_REL03_ECT-HOPE-PA-L3' ;'RBSPA_REL03_ECT-HOPE-PA-L3'
vars = ['FPDU','FODU','FEDU','FPDO','FODO','FEDO']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name


if cmb_var_type(fpdu) eq 'UNDEFINED' then begin
   print,'HOPE data with dataset_id of ' + dataset_id + ' is not currently available for this time range try another time range.'
   stop
endif

;finished loading data
re = 6371.0


pos_sm = pos_sm/re

skip:

;form time axis labels
r = sqrt(total(pos_sm^2,1))
mlat = reform(!radeg*asin(pos_sm[2,*]/r))
mlt = reform((atan(pos_sm[1,*],pos_sm[0,*])*12/!pi + 12) mod 24)
lshell = r/cos(mlat/!radeg)^2
atimeaxis = {time:jd,r:r,lshell:lshell, mlat:mlat,mlt:mlt,labels:['hh:mm:ss','r(re)','l-shell','mlat(degrees)','mlt(hours)']}
dummy = cmb_label_date(xaxis_info=atimeaxis) ;store x axis information for labelling
if id eq 'A' then begin
  sat = strmid(cmbmeta.RBSP_A_WFR_SPECTRAL_MATRIX_DIAGONALS_EMFISIS_L2.eueu.LOGICAL_SOURCE,0,6)
  sathope = strmid(cmbmeta.RBSPA_REL03S_ECT_HOPE_PA_L3.fpdu.LOGICAL_SOURCE,0,5)
endif else begin
  sat = strmid(cmbmeta.RBSP_B_WFR_SPECTRAL_MATRIX_DIAGONALS_EMFISIS_L2.eueu.LOGICAL_SOURCE,0,6)
  sathope = strmid(cmbmeta.RBSPB_REL03S_ECT_HOPE_PA_L3.fpdu.LOGICAL_SOURCE,0,5)
endelse
help, sat, sathope

cmb_set_up_colors
xsize = 1000 
ysize = 1000
cmb_adjust_screen_size,xsize,ysize
window, 0, retain=2, xsize = xsize, ysize = ysize

;!p.charsize = 1.2
!p.charsize=0
!x.ticklen = -0.04
!y.ticklen = -0.012
nx = 1
ny = 5
ch = 0.005
pos = [.18,.2,.85,.9]
xrange = [min(jd),max(jd)]
title =  sat + ' EXAMPLE for ' + start_time + ' to '+ stop_time
xminor=3
xticks=8

ytitle='FREQUENCY (Hz)'
plot,xrange,[min(HFR_frequencies_Fixed),max(HFR_frequencies_Fixed)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,title=title,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch)
cmb_polyarea_tv,transpose(hfr_spectra),jd,HFR_frequencies_Fixed,fill=0.,/takelog,/add_colorbar,ctitle='Electric Field!cPOWER SPECTRAL DENSITY'

oplot,jd, 27.992364*b0, color=white ;electron cyclotron frequency
oplot,jd, 2*27.992364*b0, color=white,linestyle=2 ;2*electron cyclotron frequency

spd = transpose(eueu) +transpose(evev)
ytitle='FREQUENCY (Hz)'
plot,xrange,[min(WFR_frequencies_Fixed),max(WFR_frequencies_Fixed)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,title='',xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase
cmb_polyarea_tv,transpose(eueu+evev),jd,WFR_frequencies_Fixed,fill=0.,/takelog,/add_colorbar,ctitle='Eu+Ev!cPOWER SPECTRAL DENSITY'

white = !p.background

oplot,jd, 27.992364*b0, color=white ;electron cyclotron frequency
oplot,jd, 0.65326645*b0, color=white ;geometric mean of proton and electron cyclotron frequency, proxy for lower hybrid resonance
oplot,jd, 0.015245481*b0, color=white ;proton cyclotron frequency
oplot,jd, 0.015245481*b0/16.0, color=white ;O+ cyclotron frequency

ytitle='PROTON (eV)'
plot,xrange,[min(hope_energy_ion),max(hope_energy_ion)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,2,pos=pos,ch=ch),/noerase
jflux = transpose( fpdo )
ii=where(jflux eq 0)
jflux = alog10(jflux)
jflux[ii] = 0
energy = reform(hope_energy_ion[*,0])
is = sort(energy)
cmb_polyarea_tv,jflux[*,is],jd,energy[is],fill=0.,/add_colorbar,ctitle='FLUX'
oplot, jd, 30e3/lshell,color=white 

ytitle='O+ (eV)'
plot,xrange,[min(hope_energy_ion),max(hope_energy_ion)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,3,pos=pos,ch=ch),/noerase
jflux = transpose( fodo )
ii=where(jflux eq 0)
jflux = alog10(jflux)
jflux[ii] = 0
energy = reform(hope_energy_ion[*,0])
is = sort(energy)
cmb_polyarea_tv,jflux[*,is],jd,energy[is],fill=0.,/add_colorbar,ctitle='FLUX'

oplot, jd, 30e3/lshell,color=white ; Energy and which coerotation balances gradient and curvature drifts

ytitle='ELECTRON (eV)'
plot,xrange,[min(HOPE_ENERGY_Ele),max(HOPE_ENERGY_Ele)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_label_date',xtitle='  ',ytitle=ytitle,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,4,pos=pos,ch=ch),/noerase
jflux = transpose(fedo )
ii=where(jflux eq 0)
jflux = alog10(jflux)
jflux[ii] = 0
is = sort(HOPE_ENERGY_Ele)
energy = reform(hope_energy_ele[*,0])
is = sort(energy)
cmb_polyarea_tv,jflux[*,is],jd,energy[is],fill=0.,/add_colorbar,ctitle='FLUX'

cmb_label_pos_label,charsize=!p.charsize ;plot x-axis labels in lower left corner
plot,!x.crange,[0,1],/nodata,xstyle=5,ystyle=5,pos=pos,/noerase

if n_elements(jdburst_times) ne 0 then for iburst=0l,n_elements(jdburst_times)-1 do oplot,jdburst_times[iburst]*[1,1],!y.crange,linestyle=2,color=!p.background

cmb_window_plot_properties_save,'save'
iselect=0
nextspec: read,'input 1 to select HOPE spectra',ich
!p.charsize=0
!x.ticklen = -0.04
!y.ticklen = -0.012
if ich ne 1 then goto,exitdemo
iselect=iselect+1
wset,0
cmb_create_plot_file,'RBSP_multiple_spectrograms'
cmb_window_plot_properties_save,'restore'
read,'select time of spectra with cursor
cursor,jdc,dummy
wait,1
dt = min( abs(jdc-jd),i0)
oplot,jd[i0]*[1,1],!y.crange
xyouts,jd[i0], total(!y.crange)/2, string(iselect,format='(i2.2)')
cmb_create_plot_file,'RBSP_multiple_spectrograms'
print,'dt in sec:',dt*24*3600.0
date=cmb_date(jd[i0],/time_in_jul,format='yyyy ddd (mm/dd) hh:mm:ss')

; wave spectrum plot
window,/free
!x.ticklen = -0.02
!y.ticklen = -0.012
title= string(iselect,format='(i2.2,"   ")') + $
  sat + ' EMFISIS L2 ELECTRIC FIELD POWER SPECTRAL DENSITY at ' + date +' '+ $
  string('R=',r[i0],'R!dE!n MLAT=',mlat[i0],'!uo!n MLT=',mlt[i0],' Hrs L=',lshell[i0],format='(4(a,f6.2))')+'!c   '
;xr = data_range(/no, [wfr_frequencies_fixed, hfr_frequencies_fixed])
xr = [min( [wfr_frequencies_fixed, hfr_frequencies_fixed],max=smax),smax]
yr = [1e-17,1e-8]
plot,/nodata,xr,yr,/xtype,/ytype,pos=pos,title=title,xtitle='FREQUENCY (Hz)', ytitle='POWER SPECTRAL DENISITY (V!u2!n/m!u2!n/Hz )'
oplot, wfr_frequencies_fixed, reform((transpose(eueu) +transpose(evev))[i0,*])
oplot, hfr_frequencies_fixed, hfr_spectra[*,i0],color=250
oplot,27.992364*b0[i0]*[1,1],10^!y.crange,linestyle=1 ;electron cyclotron frequency
xyouts,27.992364*b0[i0]*[1,1],total(10^!y.crange)/2,'ELECTRON CYCLOTRON FREQ.' ;'F!dcE!n'
oplot,0.65326645*b0[i0]*[1,1],10^!y.crange,linestyle=1 ;geometric mean of proton and electron cyclotron frequency, proxy for lower hybrid resonance
xyouts,0.65326645*b0[i0]*[1,1],total(10^!y.crange)/2,'LHR FREQ.' ;'F!dLHR!n'

oplot,0.015245481*b0[i0]*[1,1],10^!y.crange,linestyle=1 ;proton cyclotron frequency
xyouts,0.015245481*b0[i0]*[1,1],total(10^!y.crange)/2,'PROTON CYCLOTRON FREQ.';'F!dcH+!n'

oplot,0.015245481/16.0*b0[i0]*[1,1],10^!y.crange,linestyle=1 ;O+ cyclotron frequency
xyouts,0.015245481/16.0*b0[i0]*[1,1],total(10^!y.crange)/2,'O+ CYCLOTRON FREQ.' ;'F!dcO+!n'

print,'SELECT POINT ON THE FREQUENCY SPECTRUM WHERE YOU THINK THE UPPER HYBRID RESONANCE or UPPER HISS BAND IS LOCATED'
cursor,fuhr,dummy
wait, 1
fce = 27.992364*b0[i0] ;electron cyclotron frequency
if fuhr gt fce then begin
   fpe = sqrt( fuhr^2-fce^2) ;plasma frequency
endif else begin
   print,'You selectedi a frequency is below fce, so assume you selected the upper cutoff of HISS'
   fpe = fuhr
   fuhr = sqrt( fce^2 + fpe^2)
endelse
dene = ( fpe/9000.)^2 ;density im cm-3.
va = 22.0*b0[i0]/sqrt(dene)
va1 = 22.0*b0[i0]/sqrt(dene*(0.9 + 0.1*16.0)) ;10% O+, 90% H+
eproton = ( va/13.8)^2 ;eV
eproton1 = ( va1/13.8)^2 ;eV
; wave spectrum plot
print,'estimated upper hybrid resonance frequency    :', fuhr,' Hz'
print,'estimated plasma frequency                    :', fpe, ' Hz'
print,'estimated electron density                    :', dene,' cm-3'
print,'estimated Aflven velocity (100% protons)      :', va,  ' km/s'
print,'estimated Aflven velocity (90% protons,10% O+):', va1, ' km/s'

print,'estimated proton aflven energy (100% protons) :',eproton, ' eV, 1/2*M*VA^2'
print,'estimated O+ aflven energy (100% protons)     :',eproton*16.0, ' eV, 1/2*M*VA^2'

text = 'upper hybrid resonance frequency: ' + strtrim(string( fuhr),2) + ' Hz, ' $
     + 'plasma frequency: '+ strtrim(string(fpe),2) + ' Hz, ' $
     + 'electron density: ' + strtrim(string(dene),2) + ' cm!u-3!n, ' $
     + '!c!celectron cyclotron frequency: '+ strtrim(string(27.992364*b0[i0]),2) + ' Hz, ' $
     + 'lower hybrid frequency: '+ strtrim(string(0.65326645*b0[i0]),2) + ' Hz (geometric mean), ' $
     + 'proton cyclotron frequency: '+ strtrim(string(0.015245481*b0[i0]),2) + ' Hz, ' $
     + '!c!cestimated Aflven velocity (100% protons): '+ strtrim(string(va),2) + ' km/s, ' $
     + 'estimated Aflven velocity (90% protons,10% O+): '+ strtrim(string(va1),2) + ' km/s, ' 

oplot,fuhr*[1,1],10^!y.crange,linestyle=1; upper hybrid frequency
xyouts,fuhr, total(10^!y.crange)/2,'UPPER HYBRID FREQUENCY'
xyouts,/norm, 0.01,pos[1]-0.09, text
cmb_create_plot_file,'RBSP_EMFISIS_'+string(iselect,format='(i2.2)')



; particle spectrum plot
window,/free
nx=3
ny=2
charsize=0
ch=0.075
title= string(iselect,format='(i2.2,"   ")') + $
  sat + ' ECT-HOPE L3 OMNI DIRECTIONAL DATA at ' + date +' '+ $
  string('R=',r[i0],'R!dE!n MLAT=',mlat[i0],'!uo!n MLT=',mlt[i0],' Hrs L=',lshell[i0],format='(4(a,f5.2))')
xtickname=replicate(' ',30)
;differential flux
jflux = transpose( fpdo )
ii=where(jflux[i0,*] gt 0)
plot, hope_energy_ion[ii], jflux[i0,ii],xtitle='',ytitle='Differential Proton Flux' $
     ,/xtype,/ytype,charsize=charsize,pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch),xtickname=xtickname
oplot,30e3/lshell[i0]*[1,1],10^!y.crange,linestyle=2
xyouts,30e3/lshell[i0],total(10^!y.crange)/2,' 30 keV/LSHELL'
oplot,eproton*[1,1],10^!y.crange,linestyle=2
xyouts,eproton,total(10^!y.crange)/4,' ALFVEN ENERGY'

jflux = transpose( fodo )
ii=where(jflux[i0,*] gt 0)
plot, hope_energy_ion[ii], jflux[i0,ii],xtitle='',ytitle='Differential O+ Flux' $
     ,/xtype,/ytype,charsize=charsize,pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase,xtickname=xtickname
oplot,30e3/lshell[i0]*[1,1],10^!y.crange,linestyle=2
xyouts,30e3/lshell[i0],total(10^!y.crange)/2,' 30 keV/LSHELL'
oplot,eproton*16.0*[1,1],10^!y.crange,linestyle=2
xyouts,eproton*16.0,total(10^!y.crange)/4,' ALFVEN ENERGY'

jflux = transpose( fedo )
ii=where(jflux[i0,*] gt 0)
plot, HOPE_ENERGY_Ele[ii], jflux[i0,ii],xtitle='',ytitle='Differential Electron Flux' $
     ,/xtype,/ytype,charsize=charsize,pos=cmb_pp_pos_b(nx,ny,2,pos=pos,ch=ch),/noerase,xtickname=xtickname

;phase space density
i90 = where( pitch_angle eq 90.) & i90=i90[0]
psd =cmb_flux2psd( fpdo[*,i0], hope_energy_ion/1e3,amu=1.0)
psd90 =cmb_flux2psd( fpdu[*,i90,i0], hope_energy_ion/1e3,amu=1.0)
;psd90a=cmb_flux2psd( fpdu[*,*,i0], hope_energy_ion/1e3,amu=1.0) & psd90a=psd90a[*,i90]
ii=where(psd gt 0)
plot, hope_energy_ion[ii], psd[ii],xtitle='',ytitle='PSD Proton' $
     ,/xtype,/ytype,charsize=charsize,pos=cmb_pp_pos_b(nx,ny,3,pos=pos,ch=ch),/noerase

oplot,hope_energy_ion[ii], psd90[ii],color=250
oplot,30e3/lshell[i0]*[1,1],10^!y.crange,linestyle=2
xyouts,30e3/lshell[i0],total(10^!y.crange)/2,' 30 keV/LSHELL'
oplot,eproton*[1,1],10^!y.crange,linestyle=2
xyouts,eproton,total(10^!y.crange)/4,' ALFVEN ENERGY'
oplot,eproton1*[1,1],10^!y.crange,linestyle=2
xyouts,eproton1,total(10^!y.crange)/8,' ALFVEN ENERGY 10% O+'

psd =cmb_flux2psd( fodo[*,i0], hope_energy_ion/1d3,amu=16.0)
ii=where(psd gt 0)
plot, hope_energy_ion[ii], psd[ii],xtitle='Energy (eV)',ytitle='PSD O+' $
     ,/xtype,/ytype,charsize=charsize,pos=cmb_pp_pos_b(nx,ny,4,pos=pos,ch=ch),/noerase
oplot,30e3/lshell[i0]*[1,1],10^!y.crange,linestyle=2
xyouts,30e3/lshell[i0],total(10^!y.crange)/2,' 30 keV/LSHELL'
oplot,eproton*16.0*[1,1],10^!y.crange,linestyle=2
xyouts,eproton*16.0,total(10^!y.crange)/4,' ALFVEN ENERGY'
oplot,eproton1*16.0*[1,1],10^!y.crange,linestyle=2
xyouts,eproton1*16.0,total(10^!y.crange)/8,' ALFVEN ENERGY 10% O+'

ie=where( HOPE_ENERGY_Ele[10,*] eq median( HOPE_ENERGY_Ele[10,*]) ) & ie=ie[0]
psd =cmb_flux2psd( fedo[*,i0], HOPE_ENERGY_Ele[*,ie]/1d3,amu=1/1836.0)
ii=where(psd gt 0)
plot, HOPE_ENERGY_Ele[ii,ie], psd[ii],xtitle='',ytitle='PDS Electron' $
     ,/xtype,/ytype,charsize=charsize,pos=cmb_pp_pos_b(nx,ny,5,pos=pos,ch=ch),/noerase

plot,/noerase,/nodata,xstyle=5,ystyle=5,[0.,1.],[0.,1],title=title

cmb_create_plot_file,'RBSP_HOPE_OMNIDIR_'+string(iselect,format='(i2.2)')

;pitch angle plots
window,/free
!x.ticklen = -0.02
!y.ticklen = -0.012
nx=3
ny=2
charsize=0
ch=0.075
title= string(iselect,format='(i2.2,"   ")') + $
  sat + ' HOPE L2 OMNI DIR. DATA at ' + date +' '+ $
  string('R=',r[i0],'R!dE!n MLAT=',mlat[i0],'!uo!n MLT=',mlt[i0],' Hrs L=',lshell[i0],format='(4(a,f5.2))')


xr = [min(hope_energy_ion),max(hope_energy_ion)]
yr = [0,1]*180.

flux = fpdu[*,*,i0]
psd = cmb_flux2psd(flux,hope_energy_ion/1000.)
plot,xr,yr,/nodata,/xtype, yticks=6, yminor = 6,xtitle='ENERGY (eV)',ytitle='PITCH ANGLE (degrees)',title='PROTONS',xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch)
cmb_polyarea_tv,psd,hope_energy_ion,pitch_angle,fill=0.,/takelog,/add_colorbar,ctitle='H+ PHASE SPACE DENSITY (s!u3!n/km!u6!n)'


flux = fodu[*,*,i0]
psd = cmb_flux2psd(flux,hope_energy_ion/1000.)
plot,xr,yr,/nodata,/xtype, yticks=6, yminor = 6,xtitle='ENERGY (eV)',ytitle='PITCH ANGLE (degrees)',title='O+',xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase
cmb_polyarea_tv,psd,hope_energy_ion,pitch_angle,fill=0.,/takelog,/add_colorbar,ctitle='O+ PHASE SPACE DENSITY (s!u3!n/km!u6!n)'


flux = fedu[*,*,i0]
psd = cmb_flux2psd(flux,hope_energy_ele[*,ie]/1000.)
plot,xr,yr,/nodata,/xtype, yticks=6, yminor = 6,xtitle='ENERGY (eV)',ytitle='PITCH ANGLE (degrees)',title='ELECTRONS',xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,2,pos=pos,ch=ch),/noerase
cmb_polyarea_tv,psd,hope_energy_ele[*,ie],pitch_angle,fill=0.,/takelog,/add_colorbar,ctitle='e- PHASE SPACE DENSITY (s!u3!n/km!u6!n)'
plot,/noerase,/nodata,xstyle=5,ystyle=5,[0.,1.],[0.,1],title=title

!x.ticklen = 0
!y.ticklen = 0
cmb_create_plot_file,'RBSP_HOPE_PITCH_ANGLE_'+string(iselect,format='(i2.2)')

goto,nextspec
exitdemo:
!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
end
