; demo_polar_3_hires_sets
; Plots 60s binned POLAR spacecraft TIMAS H+, PWI Plasma wave (up to 2.4 s res.) electric dynamic spectra, vector magnetic field measurements with IGRF field subtracted.
;This demo repeats the demo_cdaweb_get_polar_3sets demo, but the high resolution plasma wave data is used instead of the
;low resolution (5 min) plasma wave data that is used in the other demo.
;The high resolution wave data consists of 5 receiver channels, each one with a different time tag and set of frequencies.
;These 5 channels of 32,32,32,64,64 frequency measurements are binned into a common timeseries and one channel of 224 frequencies.
; The variable 'Flux_HQ', for example, has dependencies Flux_HQ(time, energy_bin, pitch_angle)
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
start_time = '1996-04-25T10:30:00.0Z'
stop_time  = '1996-04-25T12:30:00.0Z'
dt_sec =60.;seconds, size of a time bin
time_name='j_day' ;center time of bins in Julian day

dataset_id = 'PO_H0_TIM'
vars = ['Flux_HQ', 'Flux_OQ'];; cdf variable names, note to rename FLux_HQ to say proton_flux, set vars = ['Flux_HQ=proton_flux', 'Flux_OQ']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

dataset_id = 'PO_H1_PWI'
vars = ['SFR1A','SFR2A','SFR3A','SFR4A','SFR5A','SFRA_Antenna','SFR1B','SFR2B','SFR3B','SFR4B','SFR5B','SFRB_Antenna']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

dataset_id = 'PO_K0_MFE'
vars = ['B_SM','MBCIGRF_SM','POS_SM'];; cdf variable names, note to save as components, set vars = ['B_SM=Bx,By,Bz','MBCIGRF_SM','POS_SM=X,Y,Z']
;d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=time_name

; average differential ion flux over pitch angle.
ii=where(flux_hq lt 0)
a = flux_hq & a[ii] = 0.
b = flux_hq*0 +1 & b[ii] =0.
; Note that the "total" function is summing on the second (pitch-angle) index. 
fluxave = total(a,2)/total(b,2)
fluxave= transpose(fluxave)
colorbar_title_flux = cmbmeta.PO_H0S_TIM.FLUX_HQ.fieldnam + '!c' + cmbmeta.PO_H0S_TIM.FLUX_HQ.UNITS


;combine PWI frequency channels
frequency = [frequency1,frequency2,frequency3,frequency4,frequency5]
sfra = [ sfr1a,sfr2a,sfr3a,sfr4a,sfr5a]
sfra_nbin = [ sfr1a_nbin,sfr2a_nbin,sfr3a_nbin,sfr4a_nbin,sfr5a_nbin]

sfrb = [ sfr1b,sfr2b,sfr3b,sfr4b,sfr5b]
sfra_nbin = [ sfr1b_nbin,sfr2b_nbin,sfr3b_nbin,sfr4b_nbin,sfr5b_nbin]

colorbar_title_wave = cmbmeta.PO_H1S_PWI.SFR1a.fieldnam + '!c' + cmbmeta.PO_H1S_PWI.SFR1a.units


;compute difference of magnetic field with IGRF model and field magnitude
db0 = sqrt(total((b_sm-mbcigrf_sm)^2,1))
b0 = sqrt(total((b_sm)^2,1))


;form time axis labels
r = sqrt(total(pos_sm^2,1))
mlat = reform(!radeg*asin(pos_sm[2,*]/r))
mlt = reform((atan(pos_sm[1,*],pos_sm[0,*])*12/!pi + 12) mod 24)
lshell = r/cos(mlat/!radeg)^2
atimeaxis = {time:j_day,r:r,lshell:lshell, mlat:mlat,mlt:mlt,labels:['hh:mm:ss','r(re)','l-shell','mlat(degrees)','mlt(hours)']}

dummy = cmb_label_date(xaxis_info=atimeaxis) ;store x axis information for labelling

cmb_set_up_colors
;xsize = 1000  & ysize = 1000 & cmb_adjust_screen_size,xsize,ysize
window, 3, retain=2;, xsize = xsize, ysize = ysize
;cgerase

;!p.charsize = 1.2
!p.charsize = 0
!x.ticklen = -0.04
!y.ticklen = -0.012
nx = 1
ny = 3
ch = 0.005
pos = [.18,.2,.85,.9]
xrange = [min(j_day),max(j_day)]
title = 'POLAR EXAMPLE for ' + start_time + ' to '+ stop_time
ytitle=cmbmeta.PO_H0S_TIM.energy.fieldnam +' ('+cmbmeta.PO_H0S_TIM.energy.units+')'
xminor=3
xticks=8


plot,xrange,[min(energy),max(energy)],/nodata,ytype=1, xticks=xticks, xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,title=title,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,0,pos=pos,ch=ch)
cmb_polyarea_tv, fluxave,j_day,energy,fill=0.,/takelog,/add_colorbar,ctitle=colorbar_title_flux

ytitle='Frequency (Hz)'

plot,xrange,[min(frequency),max(frequency)],/nodata,ytype=1, xticks=xticks,xminor = xminor,xtickformat='cmb_nonames',xtitle='  ',ytitle=ytitle,xstyle=1,ystyle=1,pos=cmb_pp_pos_b(nx,ny,1,pos=pos,ch=ch),/noerase
cmb_polyarea_tv,transpose(sfra),j_day,frequency,fill=0.,/takelog,/add_colorbar,ctitle=colorbar_title_wave,zr=[-19.,-9.]

oplot,j_day,0.015245481*b0,color=!p.background ; proton cyclotron frequency
oplot,j_day,0.015245481*b0*sqrt(1836.1),color=!p.background ;proxy for lower hybrid frequency
oplot,j_day,0.015245481*b0*1836.1,color=!p.background ;electron cycltron frequency

ytitle='B-B_IGRF SM (nT)'
plot,xrange,[-1,1]*max(db0),/nodata, xticks=xticks,xminor = xminor,xtickformat='cmb_label_date',xtitle='  ',ytitle=ytitle,xstyle=1,pos=cmb_pp_pos_b(nx,ny,2,pos=pos,ch=ch),/noerase
cmb_label_pos_label,charsize=!p.charsize ;plot x-axis labels in lower left corner
oplot,j_day,db0
oplot,j_day,-db0,linestyle=1

colors= [250, 120,  85]
for ic=0,2 do oplot,j_day, b_sm[ic,*]-mbcigrf_sm[ic,*], color=colors[ic]

!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
end
