;demo_omni5min.pro
; 5 minute binned OMNI solar wind speed, proton density, IMF Bz, SYM-H, ASYM-A, and AE are plotted.
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
start_time = '2012-11-14T00:00:00.0Z'
stop_time  = '2012-11-14T23:59:59.0Z'
dt=60d0*5 ;s
dates = [start_time, stop_time]
time_name='jd'

dataset_id='OMNI_HRO_5MIN'
;dataset_id='OMNI_HRO_1MIN'  not valid id
 ;          OMNI Combined, Definitive, 1AU 5minute IMF and Plasma data  - J.H. King, N. Papatashvilli (AdnetSystems, NASA GSFC)
vars=[ 'IMF', 'PLS', 'IMF_PTS', 'PLS_PTS', 'percent_interp', 'Timeshift', 'RMS_Timeshift', $
  'Time_btwn_obs', 'F', 'BX_GSE', 'BY_GSE', 'BZ_GSE', 'BY_GSM', 'BZ_GSM', 'RMS_SD_B', $
  'RMS_SD_fld_vec', 'flow_speed', 'Vx', 'Vy', 'Vz', 'proton_density', 'T', 'Pressure', $
  'E', 'Beta', 'Mach_num', 'Mgs_mach_num', 'x', 'y', 'z', 'BSN_x', 'BSN_y', 'BSN_z', $
  'AE_INDEX', 'AL_INDEX', 'AU_INDEX', 'SYM_D', 'SYM_H', 'ASY_D', 'ASY_H', 'PC_N_INDEX', $
  'PR-FLX_10', 'PR-FLX_30', 'PR-FLX_60']
  
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt,time_name=time_name,to_struct='o',/keep ; ,/autobad,sigmul=3

d = spdfgetdata(dataset_id, vars, [start_time,stop_time])
;help,o
;print,'binned data in structure "o"'

cmb_set_up_colors
xsize = 900  & ysize = 900 ; &  cmb_adjust_screen_size,xsize,ysize
window, 2, retain=2, xsize = xsize, ysize = ysize

!x.ticklen = -0.04
!y.ticklen = -0.012

nx = 1
ny = 7
ch = 0.01
pos = [0.085,0.085,0.97,0.96]

!x.ticklen = 0.08

dummy = LABEL_DATE(DATE_FORMAT='%H:%I')
title = 'OMNI EXAMPLE for ' + start_time + ' to '+ stop_time
;!p.charsize = 1.2
!p.charsize = 0
;cmbmeta.OMNI2_H0S_MRG1HR.DST180
ip=0

plot,o.jd,o.pressure,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='SW PRESS (nPa)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)
title=''


plot,o.jd,o.flow_speed,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='SW V (km/s)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
title=''

plot,o.jd,o.proton_density,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='SW N!dP!n (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
title=''

plot,o.jd,o.Bz_gsm,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='IMF Bz (nT)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,!x.crange,[1,1]*0.

plot,o.jd,o.sym_h,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='SYM-H (nT)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

plot,o.jd,o.asy_h,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='ASYM-H (nT)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
oplot,!x.crange,[1,1]*0.

plot,o.jd,o.ae_index,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (HR:MIN)',ytitle='AE (nT)',xstyle=1,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase
!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0

cmb_create_plot_file,'demo_omni_5min'

end