; demo_of_autobad_with_Ulysses_Swoops
; Example of using the autobad spike filter using Ulysses Swoops data.
;In this demo we use cmb_autobad.pro called internally by cdaweb_get_bin to filter the data.
FORWARD_FUNCTION cmb_epoch_modify, cmb_var_type, cmb_date, cmb_label_date, cmb_epoch2jd, cmb_pp_pos_b, cmb_flux2psd, spdfgetdata
dataset_id='UY_M0_BAI'
;          Ulysses BAI 4-8 minute average. - D McComas (Southwest Research Institute, USA)
vars=[ 'Density=den_filtered', 'Temperature=temp_filtered', 'Velocity=vel_filtered']

;t_init=1990-11-18T00:33:48.000Z
;t_final=2009-06-30T15:54:12.000Z

t_init='1997-03-25T00:00:00.000Z'
t_final='1997-09-18T00:00:00.000Z'

dt_sec=600.0 ;seconds
time_name='j_day'
;d = spdfGetData(dataset_id, vars, [t_init, t_final])
;call cdaweb_get_bin with filter no by setting autobad to 1 and sigmul=5 which is the default
sigmul=5.0

print,'sigmul - multiplicative factor of standard devidation in each sub array: 5 (default).'
print,'           Absolute values of the (data - mean) > sigmul*standard_deviation' 
print,'           will be flagged as bad (0), if less than then flagged as good (1).'

read,'input sigmul:', sigmul
keep=1
cdaweb_get_bin,dataset_id,vars, t_init, t_final,dt_sec,time_name=time_name,/autobad, sigmul=sigmul,keep=keep

;call without filtering for comparision with case when filtering set
vars1= ['Density=den', 'Temperature=temp', 'Velocity=vel']
cdaweb_get_bin,dataset_id,vars1, t_init, t_final,dt_sec,time_name=time_name,keep=keep


speed = sqrt(total(vel^2,1))
speed_filtered = sqrt(total(vel_filtered^2,1)) ;vel values with fill will become NaN

cmb_set_up_colors
;cmb_adjust_screen_size,xsize,ysize
window, 2, retain=2;, xsize = xsize, ysize = ysize
fillval=-1e31
;!p.charsize = 1.2
!p.charsize = 0
!x.ticklen = -0.04
!y.ticklen = -0.012

nx = 1
ny = 6
ch = 0.025
pos = [0.085,0.085,0.97,0.92]

!p.charsize = 1.2
!x.ticklen = -0.08

dummy = LABEL_DATE(DATE_FORMAT='%n:%d')
title = 'ULYSSES EXAMPLE for ' + t_init + ' to '+ t_final + '!c Time Average in seconds =' + strtrim(string(dt_sec),2)
ip=0
i=where(den[0,*] ne fillval)
plot,j_day[i],den[0,i],xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Np (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch)

i=where(den[1,*] ne fillval)
plot,j_day[i],den[1,i],xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Nalpha (cm!u-3!n)',xstyle=1,xtitle=xtitle,title='', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

plot,j_day,speed,xtickunit='time',xminor = 4,xtickformat='cmb_nonames',xtitle='',ytitle='Velocity (km/s)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

title='autobad=1, sigmul=' + strtrim(string(sigmul))
i=where(den_filtered[0,*] ne fillval)
plot,j_day[i],den_filtered[0,i],xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Np (cm!u-3!n)',xstyle=1,xtitle=xtitle,title=title, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

i=where(den_filtered[1,*] ne fillval)
plot,j_day[i],den_filtered[1,i],xtickunit='time',xminor = 4,xtickformat='cmb_nonames',ytitle='Nalpha (cm!u-3!n)',xstyle=1,xtitle=xtitle,title='', pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

plot,j_day,speed_filtered,xtickunit='time',xminor = 4,xtickformat='label_date',xtitle='Time (mo:day)',ytitle='Velocity (km/s)',xstyle=1, pos=cmb_pp_pos_b(nx,ny,ip,pos=pos,ch=ch),/noerase

!p.charsize = 0
!x.ticklen = 0
!y.ticklen = 0
end
