; cread_mms4_example.pro
; loads fast FPI data, electric&magnetic field data and bin at 4.5 s
; Dataset_id: MMS4_FPI_FAST_L2_DIS-MOMS
;          MMS Satellite Number 4 Dual Ion Spectrometer Fast Survey-resolution distribution moments - J. Burch, C. Pollock (SwRI, NASA/GSFC)
; TIME SPAN of dataset:  2015-09-01T09:46:45.000Z - 2015-12-31T21:59:56.000Z
; note the above estimate was made looking at a small data sample
timename='jd'
dt_sec=  4.5000000d0
start_time = '2015-10-07T13:00:05.000Z'
stop_time = '2015-10-07T15:59:59.999Z'
if n_elements(dene4) eq 0 then begin ; load data

; load FPI IONs
dataset_id = 'MMS4_FPI_FAST_L2_DIS-MOMS'
vars = [ 'mms4_dis_numberdensity_dbcs_fast=deni4', 'mms4_dis_bulkspeed_dbcs_fast=vi4', 'mms4_dis_bulkazimuth_dbcs_fast=azi4', 'mms4_dis_bulkzenith_dbcs_fast=thi4']
; d = spdfgetdata( dataset_id, vars, [start_time, stop_time],/keep) 
 cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

; load FPI electrons
dataset_id = 'MMS4_FPI_FAST_L2_DES-MOMS'
vars = [ 'mms4_des_numberdensity_dbcs_fast=dene4', 'mms4_des_bulkspeed_dbcs_fast=ve4', 'mms4_des_bulkazimuth_dbcs_fast=aze4', 'mms4_des_bulkzenith_dbcs_fast=the4']
; d = spdfgetdata( dataset_id, vars, [start_time, stop_time],/keep) 
 cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename
;timename='jdm'

; load mag data
dataset_id = 'MMS4_FGM_SRVY_L2'
print,' dataset_id:', dataset_id,format='(2a)'
vars = ['mms4_fgm_b_gse_srvy_l2=bgse4', 'mms4_fgm_b_dmpa_srvy_l2=bdmpa4',  'mms4_fgm_flag_srvy_l2=qfgm4', 'mms4_fgm_r_gse_srvy_l2=pgse4' ]
; d = spdfgetdata( dataset_id, vars, [start_time, stop_time]) 
 cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

; load spacecraft potential
dataset_id= 'MMS4_EDP_FAST_L2_SCPOT'
;          MMS 4 dual probe scpot (fast), Spacecraft potential - J.Burch, R.Ergun, P.Lindqvist. (SWRI, LASP, KTH)
; Time range: 2015-09-01T00:00:00.000Z - 2016-02-13T23:59:59.000Z
vars= ['mms4_edp_scpot_fast_l2=scpot4'] ;, 'mms4_edp_psp_fast_l2', 'mms4_edp_dcv_fast_l2']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename

; load electric field double probe 
dataset_id= 'MMS4_EDP_FAST_L2_DCE'
;          MMS4 L2 (fast mode), 3D Electric field - J.Burch, R.Ergun, P.Lindqvist. (SWRI, LASP, KTH)
; Time range: 2015-09-01T00:00:00.000Z - 2016-02-12T23:59:59.000Z
vars= ['mms4_edp_dce_gse_fast_l2=eflgse4', 'mms4_edp_quality_fast_l2=qefl']
cdaweb_get_bin,dataset_id,vars,start_time, stop_time,dt_sec,time_name=timename
pgse4 =pgse4/6371.2
endif

;compute EXB drift
veb = cmb_crossp( eflgse4, bgse4[0:2,*])
veb = sqrt( total(veb^2,1))/bgse4[3,*]^2*1000. ;km/s
phi = azi4/!radeg
theta = thi4/!radeg

;compute perpendicular & parallel components of flow velocity to B
vihat= transpose([[cos(phi)*sin(theta)],[sin(phi)*sin(theta)],[cos(theta)]])
angvb = cmb_angle_dot(vihat,bgse4[0:2,*])
vperp = abs( vi4*sin(angvb))
vparai = abs( vi4*cos(angvb))

phi = aze4/!radeg
theta = the4/!radeg
vehat= transpose([[cos(phi)*sin(theta)],[sin(phi)*sin(theta)],[cos(theta)]])
angvb = cmb_angle_dot(vehat,bgse4[0:2,*])
vperpe = abs( ve4*sin(angvb))

va = 22.*bgse4[3,*]*sqrt(deni4) ; Alfven speed 100% protons in km/s

; start of plot

;form time axis labels
r = sqrt(total(pgse4^2,1))
alat = reform(!radeg*asin(pgse4[2,*]/r))
alt = reform((atan(pgse4[1,*],pgse4[0,*])*12/!pi + 12) mod 24)
atimeaxis = {time:jd,r:r, alat:alat,alt:alt,labels:['hh:mm:ss','r(re)','lat(degrees)','lt(hours)']}
dummy = cmb_label_date(xaxis_info=atimeaxis) ;store x axis information for labelling

cmb_plotsetup
window,/free,xsize=800,ysize=800
nx=1
ny=5
pos = [.14,.1,.94,.9]
ch = 0.02
!x.ticklen = -1/20.
!y.ticklen = -1/40.
dates = cmb_date( cmb_minmax(jd),/time,format='yyyy ddd (mm/dd) hh:mm:ss')
title='MMS4!C ' + dates[0] + ' to ' + dates[1]
ip=0
ytitle='|Ne-Ni|!c______!c|Ne+Ni|'
plot,jd, abs(dene4-deni4)/abs(dene4+deni4), ytitle=ytitle, title=title $
    , pos = cmb_pp_pos_b(nx,ny,ch=ch, pos=pos,ip),xstyle=1 $
    , xtickformat='cmb_nonames'    
noerase=1
plot,jd, dene4, ytitle='density (cm!u-3!n)', pos = cmb_pp_pos_b(nx,ny,ch=ch, pos=pos,ip),noerase=noerase,xstyle=1 $
    , xtickformat='cmb_nonames'
oplot,jd,deni4, color=250
plot,jd, ve4, ytitle='velocity (km/s)', pos = cmb_pp_pos_b(nx,ny,ch=ch, pos=pos,ip),noerase=noerase,xstyle=1 $
    , xtickformat='cmb_nonames'
oplot,jd,vi4, color=250

plot,jd, veb, ytitle='E/B (km/s)', pos = cmb_pp_pos_b(nx,ny,ch=ch, pos=pos,ip),noerase=noerase,xstyle=1 $
    , xtickformat='cmb_nonames'
oplot,jd,veb, color=80
oplot,jd,vperp,color=250
oplot,jd,vperpe

plot, jd, vi4/va, ytitle='EST. DOPPLER SHIFT !c at 1 Hz (Hz)', pos = cmb_pp_pos_b(nx,ny,ch=ch, pos=pos,ip),noerase=noerase,xstyle=1 $
    , xtickformat='cmb_label_date'

cmb_label_pos_label,charsize=!p.charsize ;plot x-axis labels in lower left corner
cmb_create_plot_file,'cread_mms4_examples'

; list meta data (attributes)
cmb_meta_list,cmbmeta
end 
