      SUBROUTINE TAB7                                                   00000010
C                                                                       00000020
C   SETS UP EVENT TABLE FOR IMP-7 COUNTS TAPE ALBUMS AS INPUT TO        00000030
C   IMP RATES PLOT PROGRAM.                                             00000040
C     ITAB(IENTRY):  IENTRY=1, 1ST SSHOT OF 2ND ALBUM.                  00000050
C                          =2-16, 2ND-16TH SSHOTS OF 1ST ALBUM.         00000060
C                          =17,  SECTORED, 2ND ALBUM (P. 0), REAL.      00000070
C                          =18-20, SECTORED, 1ST ALBUM (PP. 1-3), REAL. 00000080
C                          =21,  SECTORED, 2ND ALBUM (P.0), FAIL.       00000090
C                          =22-24, SECTORED, 1ST ALBUM (PP 1-3), FAIL.  00000100
C                          =2,  COORDINATE INFORMATION.                 00000110
C                                                                       00000120
C   MODIFY BY HENRY LO ON 9/90                                                  
C   CHANGE EQUIVALENCE STATEMENT TO CONFORM WITHVS-FORTRAN                      
C   COMPILER SYNTAX                                                             
C                                                                               
c   1/96
c
c   convert the ibm real number to ieee real number
c   because the imp-7 cnts data in ibm format
c
c   1/96
c
c   comment the call q9ie32
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000130
      COMMON /BOUNDS/ ISTART,IYR1,ISTOP,IYR2,NORM2,M,N,IXRANG           00000140
CLO   COMMON /EXPON/ QEVTON(6),QEVCHK                                           
      COMMON /EXPON/  QEVTON(250),QEVCHK                                00000145
      COMMON /FERMSG/ IMES(26)                                          00000150
      COMMON /KOUNTS/ KCNT(373,2,3),IRATE(2,3)                          00000160
CLO   COMMON /PARS/ IEVENT(6),ISECTR(6),MAP(6),IPLTPT(6),IMP(6),INOEV           
      COMMON /PARS/ IEVENT(250),ISECTR(250),MAP(6),IPLTPT(6),IMP(250),          
     *              INOEV                                                       
      COMMON /QTABS/  QTAB(3)                                           00000180
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00000190
      COMMON /SEKOPT/ QFAILS,QSUN0S                                     00000200
      COMMON /TABS7/  ITAB(21),ITABT(21),ITABMX,IENT                    00000210
      COMMON /TAPE/   ITAPE,INUNIT(3)                                   00000220
      INTEGER ISNAP(16)/0,51,102,154,205,256,307,358,                   00000230
     *                  410,464,512,563,614,666,717,768/                00000240
      INTEGER ISECTT(4)/102,307,512,717/                                00000250
      INTEGER IPAGE(4)/0,205,410,614/                                   00000260
      INTEGER INO(16)/2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,1/           00000270
      DIMENSION ICNT(373,2),CNT(373,2),HCNT(746,2)                      00000280
CLO   EQUIVALENCE (KCNT(747),ICNT(1),CNT(1),HCNT(1))                    00000290
      EQUIVALENCE (KCNT(1,1,2),ICNT(1,1),CNT(1,1),HCNT(1,1))            00000290
C                                                                       00000300
C   'KERROR' ACCUMULATES THE NUMBER OF INPUT READ ERRORS IN SUCCESSION. 00000310
      KERROR = 0                                                        00000320
      DO 10 I=1,297                                                     00000330
 10      ICNT(I,1) = ICNT(I,2)                                          00000340
      IRATE(1,2) = IRATE(2,2)                                           00000350
C   READ IN NEW ALBUM.                                                  00000360
 15   CALL FREAD(ICNT(1,2),INUNIT(2),LEN,&20,&500)                      00000370
C   CHECK ON/OFF STATUS OF EXPERIMENTS  (2 = IMP-7)                     00000372
      IF (QEVCHK) CALL ONOFF(2)                                         00000374
      GOTO 25                                                           00000380
 20   CALL PMOUNT(2,2,QDAT(2))                                          00000390
      IF (.NOT.QDAT(2)) GOTO 200                                        00000400
      GOTO 15                                                           00000410
 25   IF (.NOT.QTAB(2)) GOTO 29                                         00000420
         QTAB(2) = .FALSE.                                              00000430
         QSECT = .FALSE.                                                00000440
         DO 27 K=1,INOEV                                                00000450
            IF (IMP(K).NE.2) GOTO 27                                    00000460
            IF (IEVENT(K).GT.50) QSECT = .TRUE.                         00000470
 27         CONTINUE                                                    00000480
         IRATE(1,2) = 1                                                 00000490
         IF (IGET(ICNT(3,1),0,0).EQ.1) IRATE(1,2) = 4                   00000500
 29   ITABMX = 16                                                       00000510
      IRATE(2,2) = 1                                                    00000520
      IF (IGET(ICNT(3,2),0,0).EQ.1) IRATE(2,2) = 4                      00000530
      IBASE = ISTART + IDIFF(ICNT(1,1),ICNT(24,1),ISTART,IYR1)          00000540
C   PROCESS SNAPSHOT TIMES.                                             00000550
      DO 40 I=1,16                                                      00000560
         ITABT(I) = ISNAP(I)*IRATE(1,2) + IBASE                         00000570
         ITAB(I) = INO(I)                                               00000580
 40      CONTINUE                                                       00000590
      IGAP = IDIFF(ICNT(1,2),ICNT(24,2),ICNT(1,1),ICNT(24,1))           00000600
      IF (IGAP.GT.830*IRATE(1,2)) ITABT(16)=IBASE+IGAP-26*IRATE(2,2)    00000610
      IF (.NOT.QSECT) GOTO 100                                          00000620
C   NOW PROCESS SECTORED DATA TIMES.                                    00000630
C   1ST ALBUM - TEST FOR FAIL DATA.                                     00000640
      IF (HCNT(423,1).EQ.1) GOTO 60                                     00000650
C   OA REAL.                                                            00000660
      DO 50 I=1,3                                                       00000670
         SPIN = CNT(285+4*I,1)                                          00000680
c
c
C   REJECT IF SPIN NOT POSITIVE OR TOO BIG (SLOWER THAN 42.3 RPM).      00000690
         IF (SPIN.LE.0.0.OR.SPIN.GE.1.418) GOTO 50                      00000700
         SUN = CNT(282+4*I,1)                                           00000710
c
c
c
C   CHECK FOR NONPOSITIVE SUN TIMES.                                    00000720
         IF (SUN.LT.0.0) GOTO 50                                        00000730
         IF (SUN.EQ.0.AND.QSUN0S) GOTO 50                               00000740
         SPIN4 = SPIN/4.0                                               00000750
         DIFF = AMOD(SUN,SPIN4)                                         00000760
         ISPIN = 10.0*(7.0*SPIN + DIFF)                                 00000770
         ITIMS = IBASE + IPAGE(I)*IRATE(1,2) + ISPIN                    00000780
         IF (DIFF.LE.SPIN/8.) ITIMS = ITIMS + 10.0*SPIN4                00000790
         CALL PSORT(ITIMS,I+17,ITAB,ITABT,ITABMX)                       00000800
 50      CONTINUE                                                       00000810
      GOTO 80                                                           00000820
C   1ST ALBUM, FAIL DATA.                                               00000830
 60   IF (QFAILS) GOTO 80                                               00000840
      DO 70 I=1,3                                                       00000850
         ITIMS = IBASE + ISECTT(I)*IRATE(1,2)                           00000860
 70      CALL PSORT(ITIMS,I+21,ITAB,ITABT,ITABMX)                       00000870
C   2ND ALBUM.                                                          00000880
 80   CONTINUE                                                          00000890
      IF (HCNT(423,2).EQ.1) GOTO 90                                     00000900
C   2ND ALBUM, REAL OA.                                                 00000910
      SPIN = CNT(285,2)                                                 00000920
c
C   TEST SPIN AGAIN.                                                    00000930
      IF (SPIN.LE.0.OR.SPIN.GE.1.418) GOTO 100                          00000940
      SUN = CNT(282,2)                                                  00000950
c
c
      IF (SUN.LT.0.0) GOTO 100                                          00000960
      IF (SUN.EQ.0.0.AND.QSUN0S) GOTO 100                               00000970
      SPIN4 = SPIN/4.0                                                  00000980
      DIFF = AMOD(SUN,SPIN4)                                            00000990
      ISPIN = 10.0*(7.0*SPIN + DIFF)                                    00001000
      ITIMS = IBASE + 614*IRATE(1,2) + ISPIN                            00001010
      IF (DIFF.LE.SPIN/8.0) ITIMS = ITIMS + 10.0*SPIN4                  00001020
      CALL PSORT(ITIMS,17,ITAB,ITABT,ITABMX)                            00001030
      GOTO 100                                                          00001040
C   2ND ALBUM, FAIL DATA.                                               00001050
 90   IF (.NOT.QFAILS) CALL PSORT(717*IRATE(1,2)+IBASE,21,              00001060
     *                            ITAB,ITABT,ITABMX)                    00001070
100   IENT = 1                                                          00001080
      RETURN                                                            00001090
200   PRINT 2000                                                        00001100
2000  FORMAT('1ERROR IN PMOUNT CALLED BY TAB7')                         00001110
      GOTO 600                                                          00001120
500   PRINT 2001,IMES                                                   00001130
2001  FORMAT(' READ ERROR ON INPUT TAPE FROM TAB7.'/                    00001140
     *1X,Z8,I6,20A4,4(1X,Z8))                                           00001150
      KERROR = KERROR + 1                                               00001160
      IF (KERROR.LT.10) GOTO 15                                         00001170
600   CALL PMOUNT(3,2,QDAT(2))                                          00001180
      STOP                                                              00001190
      END                                                               00001200
