      SUBROUTINE ACC7                                                   00000010
C                                                                       00000020
C   ACCUMULATES IMP-7 INPUT TAPE DATA FOR THE IMP PLOT PROGRAM.         00000030
C   ALL PLOT TYPES EXCEPT EVERY READOUT.                                00000040
C                                                                       00000050
C   MODIFY BY HENRY LO ON 9/90                                                  
C   CHANGE EQUIVALENCE STATEMENTS TO CONFORM WITH VS-FROTRAN                    
C   COMPILER SYNTAX                                                             
C                                                                               
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000060
CLO   COMMON /ACCCUM/ VALS(6),DENS(6),INT                               00000070
CLO                                                                     00000080
      COMMON /ACCCUM/ VALS(250),DENS(250),RDENS(250),INT                00000090
CLO                                                                     00000100
      COMMON /ALTITP/ GSEXYZ(4,2,3),PHI(2,3),THETA(2,3)                 00000110
      COMMON /BOUNDS/ ISTART,IYR1,ISTOP,IYR2,NORM2,M,N,IXRANG           00000120
CLO   COMMON /EXPON/ QEVTON(6),QEVCHK                                           
CLO                                                                             
      COMMON /EXPON/  QEVTON(250),QEVCHK                                00000130
      COMMON /FERMSG/ IMES(26)                                          00000140
      COMMON /FIRST/  QFIRST(4)                                         00000150
      COMMON /KOUNTS/ KCNT(373,2,3),IRATE(2,3)                          00000160
CLO   COMMON /PARS/ IEVENT(6),ISECTR(6),MAP(6),IPLTPT(6),IMP(6),INOEV           
      COMMON /PARS/ IEVENT(250),ISECTR(250),MAP(6),IPLTPT(6),IMP(250),          
     *              INOEV                                                       
      COMMON /PERIGK/ IUP(100),IDN(100),IUPNO,IDNNO,QPER(250),QANA(250) 00000190
CLO   COMMON /POINTS/ Y(250,6),YDEL(250,6),ITIME(250),IPTS,             00000200
CLO  *                JTIME(250,3),JPTS(3),Z(250,6),ZDEL(250,6),        00000210
CLO  *                IFUNCT(6),IARG1(6),IARG2(6),IFRMS,QSINGL,QEVERY   00000220
CLO                                                                     00000230
      COMMON /POINTS/ Y(250,250),YDEL(250,250),ITIME(250),IPTS,         00000240
     *                JTIME(250,3),JPTS(3),Z(250,6),ZDEL(250,6),                
     *                IFUNCT(6),IARG1(6),IARG2(6),IFRMS,QSINGL,QEVERY   00000260
CLO                                                                             
      REAL RATECT(250,250),RATELV(250,250)                                      
      COMMON /PPRATE/ RATECT,RATELV                                             
CLO                                                                             
CLO                                                                     00000270
      COMMON /REKORD/ KSMCT(615,3)                                      00000280
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00000290
      COMMON /TABS7/  ITAB(21),ITABT(21),ITABMX,IENT                    00000300
      COMMON /TAPE/   ITAPE,INUNIT(3)                                   00000310
      DIMENSION ICNT(373,2),CNT(373,2),HCNT(746,2),GSE(4)               00000320
      DIMENSION ISMCT(615),SMCT(615)                                    00000330
CLO   EQUIVALENCE (KCNT(747),ICNT(1),CNT(1),HCNT(1))                    00000340
CLO   EQUIVALENCE (KSMCT(616),ISMCT(1),SMCT(1))                         00000350
      EQUIVALENCE (KCNT(1,1,2),ICNT(1,1),CNT(1,1),HCNT(1,1))            00000340
      EQUIVALENCE (KSMCT(1,2),ISMCT(1),SMCT(1))                         00000350
C                                                                       00000360
      KERROR = 0                                                        00000370
      QSEXYZ = .FALSE.                                                  00000380
      DO 10 I=1,4                                                       00000390
        DO 10 J=1,2                                                     00000400
 10       GSEXYZ(I,J,2) = 0.0                                           00000410
C   SET START TIMES.                                                    00000420
      IF (ITAPE.EQ.2) MTIME = ISTART +                                  00000430
     *      IDIFF(ISMCT(1)+4500,ISMCT(24),ISTART,IYR1)                  00000440
      IF (ITAPE.EQ.2.OR..NOT.QFIRST(2)) GOTO 36                         00000450
C   SET UP COUNTS TAPES ARRAYS FOR FIRST TIME THROUGH.                  00000460
      DO 20 J=1,297                                                     00000470
 20      ICNT(J,2) = ISMCT(J)                                           00000480
 21   CALL TAB7                                                         00000490
      DO 23 J=1,ITABMX                                                  00000500
         IF (ITABT(J).LT.ISTART) GOTO 23                                00000510
         IENT = J                                                       00000520
         MTIME = ITABT(IENT)                                            00000530
         GOTO 36                                                        00000540
 23      CONTINUE                                                       00000550
      GOTO 21                                                           00000560
 36   IDEL = INT/2                                                      00000570
      DO 200 ITM=1,IPTS                                                 00000580
 40      IF (MTIME.GE.ITIME(ITM)+IDEL) GOTO 150                         00000590
C   SET ANALOG TRANSMITTER FLAGS.                                       00000600
      IF (ITAPE.EQ.2.AND.IGET(ISMCT(178),24,31).EQ.1) QANA(ITM) = .TRUE.00000610
      IF (ITAPE.EQ.1.AND.IENT.EQ.2.AND.HCNT(424,1).EQ.1)QANA(ITM)=.TRUE.00000620
      DO 50 K=1,4                                                       00000630
        IF (ITAPE.EQ.1) GSE(K) = CNT(K+10,1)                            00000640
        IF (ITAPE.EQ.2) GSE(K) = SMCT(K+10)                             00000650
 50     CONTINUE                                                        00000660
      IF (QSEXYZ) GOTO 80                                               00000670
      DO 60 K=1,4                                                       00000680
 60     GSEXYZ(K,1,2) = GSE(K)                                          00000690
      QSEXYZ = .TRUE.                                                   00000700
 80   CONTINUE                                                          00000710
         IF (ITAPE.EQ.1) CALL ACC7C                                     00000720
         IF (ITAPE.EQ.2) CALL ACC7S                                     00000730
CLO                                                                             
CLO   COLLECT RATE COUNT AND RATE LIVETIME                                      
CLO                                                                             
      DO 190 IR = 1,INOEV                                                       
      RATECT(ITM,IR) = VALS(IR)                                                 
      RATELV(ITM,IR) = RDENS(IR)                                                
190   CONTINUE                                                                  
CLO                                                                             
         IF (ITAPE.EQ.1) GOTO 100                                       00000740
 90      CALL FREAD(ISMCT(1),INUNIT(2),LEN,&91,&600)                    00000750
C   CHECK FOR EXPERIMENTS ON (2 = IMP-7)                                00000760
         IF (QEVCHK) CALL ONOFF(2)                                      00000770
         MTIME = ISTART + IDIFF(ISMCT(1)+4500,ISMCT(24),ISTART,IYR1)    00000780
         GOTO 40                                                        00000790
 91      CALL PMOUNT(2,2,QDAT(2))                                       00000800
         IF (.NOT.QDAT(2)) GOTO 650                                     00000810
         GOTO 90                                                        00000820
100      IENT = IENT + 1                                                00000830
         IF (IENT.GT.ITABMX) CALL TAB7                                  00000840
         MTIME = ITABT(IENT)                                            00000850
         GOTO 40                                                        00000860
C   TRANSFER DATA; SET UP NEW AVERAGE INTERVAL.                         00000870
150      DO 160 J=1,INOEV                                               00000960
            IF (IMP(J).NE.2) GOTO 160                                   00001000
            IF (DENS(J).LE.0.0) GOTO 155                                00001010
            Y(ITM ,J) = VALS(J)/DENS(J)                                 00001020
            YDEL(ITM ,J) = SQRT(VALS(J))/DENS(J)                        00001030
155         VALS(J) = 0.0                                               00001040
            DENS(J) = 0.0                                               00001050
CLO                                                                             
           RDENS(J) = 0.0                                                       
CLO                                                                             
160         CONTINUE                                                    00001060
200   CONTINUE                                                          00001070
      DO 210 K=1,4                                                      00001080
210     GSEXYZ(K,2,2) = GSE(K)                                          00001090
      RETURN                                                            00001100
600   PRINT 2000,IMES                                                   00001110
2000  FORMAT(' READING ERROR ON INPUT IMP-7 TAPE.'/                     00001120
     *1X,Z8,I6,20A4,4(1X,Z8))                                           00001130
      KERROR = KERROR + 1                                               00001140
      IF (KERROR.LT.10) GOTO 90                                         00001150
      GOTO 990                                                          00001160
650   PRINT 2001                                                        00001170
2001  FORMAT('1ERROR IN PMOUNT CALLED BY ACC7. DROPPING DATA.')         00001180
990   CALL PMOUNT(3,2,QDAT(2))                                          00001190
      RETURN                                                            00001200
      END                                                               00001210
