CH1   SUBROUTINE FLXPST(NSTAT,IAVLEN,KIMP,QBOX)                         00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   PRODUCES FLUX CALCULATION STATISTICS.                             00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPA                                           00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  NONE                                          00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000110
CH5   IAVLEN         I*4    I    AVERAGING PERIOD, DECISEC              00000120
CH5   KIMP           I*4    I    IMP NUMBER (1=6,2=7,3=8)               00000130
CH5   QBOX(500,3)    L*1    I    BOX REQUEST FLAG ARRAY                 00000140
CH5   NSTAT(10,500)  I*4    I    STATISTICS ARRAY. IF I=FIRST ARRAY     00000150
CH5                              INDEX, THEN:                           00000160
CH5                              I=1, NUMBER OF INTERVALS PROCESSED     00000170
CH5                              I=2, NUMBER REJECTED, READOUTS = 0     00000180
CH5                              I=3, NUMBER WITH MATRIX COUNTS = 0     00000190
CH5                              I=4, NUMBER WITH RATE COUNTS = 0       00000200
CH5                              I=5, NUMBER WITH BOX COUNTS = 0        00000210
CH                                                                      00000220
CH6  METHOD:                                                            00000230
CH6   PRINTS OUT THE NUMBER OF PROCESSED RECORDS,                       00000240
CH6              THE NUMBER OF REJECTED RECORDS,                        00000250
CH6              THE NUMBER REJECTED DUE TO ZERO RATE READOUTS,         00000260
CH6              THE NUMBER REJECTED DUE TO ZERO MATRIX COUNTS,         00000270
CH6              THE NUMBER WITH ZERO RATE COUNTS, AND                  00000280
CH6              THE NUMBER WITH ZERO BOX COUNTS.                       00000290
CH                                                                      00000300
CH7  PROGRAMMER:  J. CHILDS, 7/78.                                      00000310
CH                                                                      00000320
CH8  MODIFICATION  P.SCHUSTER, 10/86   REDIMENSION                      00000330
CH                                                                      00000340
CH                                                                      00000350
CH9  IMP-6/7/8, FLUX PLOT, FLXPST, V2.                                  00000360
CH**********************************************************************00000370
C                                                                       00000380
      SUBROUTINE FLXPST(NSTAT,IAVLEN,KIMP,QBOX)                         00000390
C                                                                       00000400
      IMPLICIT LOGICAL*1(Q)                                             00000410
      COMMON /LOOPS/ ICOUNT(50),I144,I25,I50,I6,IFR80                   00000420
      INTEGER*4 P1,P2,P3,P4,P5                                          00000430
      DIMENSION NSTAT(10,500),QBOX(500,3),KLABEL(3)                     00000440
      CHARACTER*4 KKLAB(3)                                                      
      DATA KKLAB /'IMP6','IMP7','IMP8'/                                 00000450
      EQUIVALENCE (KLABEL(1),KKLAB(1))                                          
C                                                                       00000460
CP  GET PERIOD TIME IN MINUTES (FROM INPUT IN DECISECONDS)              00000470
      ILEN = IAVLEN/600                                                 00000480
C                                                                       00000490
CP  PRINT LABELS AND HEADER                                             00000500
      PRINT 1000, KLABEL(KIMP),ILEN                                     00000510
1000  FORMAT(//1X,10('*'),A4,' STATISTICS FOR AVERAGING PERIOD WITH ',  00000520
     *'LENGTH OF',                                                      00000530
     *I6,' MINUTES ',50('*')/ 8X,'*'/                                   00000540
     *3X,'BOX',2X,'*',4X,'TOTAL',10X,'TOTAL',9X,'REJECTED:',            00000550
     *10X,'REJECTED:',4X,'ACCEPTED:',12X,'ACCEPTED:'/                   00000560
     *4X,'ID',2X,'*',2X,'PROCESSED',7X,'REJECTED',4X,'RATE READOUTS=0', 00000570
     *7X,'MATRIX = 0',3X,'RATE COUNT = 0',8X,'BOX = 0'/ 8X,'*')         00000580
C                                                                       00000590
CP  DO FOR EACH BOX REQUESTED                                           00000600
      DO 100 I=1,I144                                                   00000610
      IF (.NOT.QBOX(I,KIMP)) GOTO 100                                   00000620
      P1 = 0                                                            00000630
      P2 = 0                                                            00000640
      P3 = 0                                                            00000650
      P4 = 0                                                            00000660
      P5 = 0                                                            00000670
      NREJ = NSTAT(2,I) + NSTAT(3,I)                                    00000680
      N = NSTAT(1,I)                                                    00000690
      IF (N.EQ.0) GOTO 50                                               00000700
      P1 = (100*NREJ      )/N                                           00000710
      P2 = (100*NSTAT(2,I))/N                                           00000720
      P3 = (100*NSTAT(3,I))/N                                           00000730
      P4 = (100*NSTAT(4,I))/N                                           00000740
      P5 = (100*NSTAT(5,I))/N                                           00000750
50    CONTINUE                                                          00000760
C                                                                       00000770
CP     PRINT OUT STATISTICS                                             00000780
      PRINT 2000, I,NSTAT(1,I),NREJ,P1,NSTAT(2,I),P2,NSTAT(3,I),P3,     00000790
     *NSTAT(4,I),P4,NSTAT(5,I),P5                                       00000800
2000  FORMAT(3X,I3,2X,'*',I9,2X,5(I9,'  (',I3,'%)'))                    00000810
CP OD                                                                   00000820
100   CONTINUE                                                          00000830
C                                                                       00000840
      PRINT 3000                                                        00000850
3000  FORMAT(//)                                                        00000860
C                                                                       00000870
      RETURN                                                            00000880
      END                                                               00000890
