CH1   SUBROUTINE FLXPAB(RJAY,DELJAY)                                    00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2    COMBINES CORRESPONDING IMP-8 ALPHA BOX FLUXES AND ERRORS.        00000040
CH                                                                      00000050
CH3  CALLING ROUTINES:  FLXPA                                           00000060
CH                                                                      00000070
CH4  SUBROUTINES CALLED:  NONE                                          00000080
CH                                                                      00000090
CH5  VARIABLE CROSS REFERENCE:                                          00000100
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000110
CH5 HMP8ST(500)      I*2    I   TABLE OF RELATED ALPHA BOX NUMBERS      00000120
CH5 QBOX(500,3)      L*1    I   ARRAY OF REQUESTED BOXES                00000130
CH5 RJAY(500)        R*4   I,O  ARRAY OF 'FLUX' FOR EACH BOX            00000140
CH5 DELJAY(500)      R*4   I,O  ARRAY OF 'FLUX' ERRORS FOR EACH BOX.    00000150
CH5    WHERE 'FLUX' ARE NORMALIZED MATRIX COUNTS, VIZ.,                 00000160
CH5                 (BOX COUNTS) / (MATRIX COUNTS) * RATE               00000170
CH                                                                      00000180
CH6  METHOD:                                                            00000190
CH5   BACKGROUND:  THE IMP-8 ALPHA EVENTS ARE MEASURED UNDER TWO        00000200
CH5   GENERAL CONDITIONS.  THE FIRST CONDITION IS THE NORMAL HIGH       00000210
CH5   GAIN RATE (A.-B.-C OR A.B.-C FOR LED, D.E.-F.-G FOR MED).         00000220
CH5   THE SECOND IS AN 'ALPHA ONLY' CONDITION, CHARACTERIZED BY         00000230
CH5   A SLANT THRESHHOLD THAT GATES OUT ALL BUT ALPHA-TYPE              00000240
CH5   EVENTS ( (A+B)2.-B.-C OR (A+B)2.B.-C FOR LED,                     00000250
CH5   (D+E)1.E.-F.-G FOR MED).  THUS, TO PROPERLY ACCOUNT FOR           00000260
CH5   IMP-8 ALPHA FLUX IN THE ENERGY RANGE 1 - 82 MEV/N,                00000270
CH5   ONE MUST CALCULATE A COMBINATION OF THESE TWO EVENTS.             00000280
CH6     ASSUME:   J0  = RJAY(I)    = NORMAL ALPHA FLUX                  00000290
CH6               DJ0 = DELJAY(I)  = NORMAL ALPHA FLUX ERROR            00000300
CH6               J1  = RJAY(I1)   = 'ALPHA ONLY' ALPHA FLUX            00000310
CH6               DJ1 = DELJAY(I1) = (D+E)1.E.-F.-G ALPHA FLUX ERROR    00000320
CH6 FOR EACH ALPHA BOX PAIR REQUESTED,                                  00000330
CH6       RJAY(I)   = (J0*DJ1**2 + J1*DJ0**2) / (DJ0**2 + DJ1**2)       00000340
CH6       DELJAY(I) = ABS(J0-J1)*DJ0*DJ1 / (DJ0**2 + DJ1**2)            00000350
CH6              OR = DJ0*DJ1 / SQRT(DJ0**2 + DJ1**2),                  00000360
CH6                   WHICHEVER IS LARGER.                              00000370
CH6                   (IE, FIRST ERROR DEPENDS ON FLUX DIFFERENCE,      00000380
CH6                    SECOND ON INDIVIDUAL FLUX ERRORS)                00000390
CH                                                                      00000400
CH7  PROGRAMMER:  E. ENG, 2/77.                                         00000410
CH                                                                      00000420
CH8  MODIFICATION:  J. CHILDS, 5/79 -- CORRECTLY ACCOUNTS FOR EITHER    00000430
CH8                                    FLUX BEING ZERO.                 00000440
CH                                                                      00000450
CH8  MODIFICATION:  P. SCHUSTER, 10/86 -- IMPLEMENT R. MCGUIRE          00000460
CH8                 REQUESTED CHANGES ; REDIMENSION 144->500 ONLY       00000470
CH8                 CHANGE FOR THIS ROUTINE                             00000480
CH9  IMP-6/7/8, FLUX PLOT, FLXPAB, V2.                                  00000490
CH**********************************************************************00000500
C                                                                       00000510
      SUBROUTINE FLXPAB(RJAY,DELJAY)                                    00000520
C                                                                       00000530
      IMPLICIT REAL*8(D),INTEGER*2(H),LOGICAL*1(Q)                      00000540
      REAL*4 DELJAY(500)                                                00000550
      DIMENSION RJAY(500)                                               00000560
C*******     144 -> 500                                                 00000570
      COMMON /GEOMF / GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   00000580
     *                KEVENT(500,3),HMP8ST(500)                         00000590
C*******  25 -> 100   144 -> 500                                        00000600
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00000610
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00000620
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00000630
C                                                                       00000640
C                                                                       00000650
CP  FOR EACH LED AND MED STOPPING ALPHA BOX REQUESTED                   00000660
      DO 300 I=1,78                                                     00000670
         IF(HMP8ST(I).EQ.0)GO TO 300                                    00000680
C   SKIP IF BOX NOT REQUESTED BY THIS RUN.                              00000690
         IF(.NOT.QBOX(I,3))GO TO 300                                    00000700
         I1 = HMP8ST(I)                                                 00000710
CP     IF 'ALPHA ONLY' 'FLUX' IS ZERO                                   00000720
         IF (RJAY(I1).EQ.0.0) GOTO 300                                  00000730
CP        IF USUAL ALPHA 'FLUX' IS ZERO                                 00000740
         IF (RJAY(I).GT.0.0) GOTO 200                                   00000750
CP           RESET USUAL TO ALPHA ONLY                                  00000760
            RJAY(I)   = RJAY(I1)                                        00000770
            DELJAY(I) = DELJAY(I1)                                      00000780
            GOTO 300                                                    00000790
CP        ELSE                                                          00000800
CP           CALCULATE NEW FLUX AND ERROR (SEE METHOD ABOVE).           00000810
200      CONTINUE                                                       00000820
         SQDJ0  = DELJAY(I)*DELJAY(I)                                   00000830
         SQDJ1  = DELJAY(I1)*DELJAY(I1)                                 00000840
         SMDJSQ = SQDJ0 + SQDJ1                                         00000850
         IF(SMDJSQ .EQ. 0.0) GO TO 300                                  00000860
C   CALCULATE ERROR TERMS.                                              00000870
         RDJ1 = (ABS(RJAY(I1) - RJAY(I))*DELJAY(I)*DELJAY(I1))/SMDJSQ   00000880
         RDJ2 = DELJAY(I)*DELJAY(I1)/SQRT(SMDJSQ)                       00000890
         DELJAY(I) = RDJ1                                               00000900
         IF (DELJAY(I).LT.RDJ2) DELJAY(I) = RDJ2                        00000910
C   CALCULATE AVERAGE FLUX.                                             00000920
         RJAY(I) =(RJAY(I)*SQDJ1 + RJAY(I1)*SQDJ0)/SMDJSQ               00000930
C                                                                       00000940
CP        FI                                                            00000950
CP     FI                                                               00000960
  300 CONTINUE                                                          00000970
C                                                                       00000980
      RETURN                                                            00000990
      END                                                               00001000
