CH1   SUBROUTINE FLXPMS(JARG1,JARG2,JERRNO)                             00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   WRITES ERROR MESSAGES FOR FLUX PLOT PROGRAM.                      00000035
CH                                                                      00000040
CH3  CALLING ROUTINES:  FLXPIN                                          00000050
CH                                                                      00000060
CH4  SUBROUTINES CALLED:  NONE                                          00000070
CH                                                                      00000080
CH5  VARIABLE CROSS REFERENCE:                                          00000090
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000100
CH5   JARG1         ---     I        VARIABLE THAT CAUSED ERROR.        00000101
CH5   JARG2         ---     I        VARIABLE THAT CAUSED ERROR.        00000104
CH5   JERRNO        I*4     I        ERROR INDEX NUMBER                 00000107
CH                                                                      00000110
CH6  METHOD:                                                            00000120
CH6   A CALL TO FLXPMS REQUIRES AN ERROR NUMBER (JERRNO).  THE          00000121
CH6   ERROR NUMBER DETERMINES WHICH MESSAGE GETS PRINTED.  THE          00000122
CH6   OPTIONAL ARGUMENTS (JARG1, JARG2) ARE PRINTED ALONG WITH          00000123
CH6   THE MESSAGE IF APPROPRIATE.  CONTROL RETURNS TO THE               00000124
CH6   CALLING PROGRAM, OR PROCESSING IS TERMINATED, WHICHEVER           00000125
CH6   IS APPROPRIATE.                                                   00000126
CH                                                                      00000130
CH7  PROGRAMMER:  J. CHILDS  AND E. ENG, 2/77.                          00000140
CH                                                                      00000150
CH8  MODIFICATION:  J. CHILDS, 2/79 -- JERRNO INTRODUCED DUE TO         00000151
CH8                 CALCULATION ON IERRNO.                              00000152
CH                                                                      00000153
CH9  IMP-6/7/8, FLUX PLOT, FLXPMS, V1.                                  00000160
CH**********************************************************************00000170
C                                                                       00000175
      SUBROUTINE FLXPMS(JARG1,JARG2,JERRNO)                             00000180
C                                                                       00000350
      EQUIVALENCE(IARG1,ARG1),(IARG2,ARG2)                              00000360
      IERRNO = JERRNO                                                   00000380
      IARG1 = JARG1                                                     00000390
      IARG2 = JARG2                                                     00000400
      IF(IERRNO.GT.16)GO TO 1000                                        00000410
      IF(IERRNO.GT.10)GO TO 5                                           00000420
CP  DOCASE (ERROR NUMBER = 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)      00000425
      GO TO (10,20,30,40,50,60,70,80,90,100),IERRNO                     00000430
    5 IERRNO = IERRNO-10                                                00000440
      GO TO (110,120,130,140,150,160),IERRNO                            00000450
C                                                                       00000460
   10 PRINT 15,IARG1                                                    00000470
   15 FORMAT(1X,'BIN NUMBER ERROR.  ',I3,' NOT BETWEEN 1-100.')         00000480
      GO TO 999                                                         00000490
C                                                                       00000500
   20 PRINT 25,IARG1                                                    00000510
   25 FORMAT(1X,'BIN NUMBER ERROR.  ',I3,'GREATER THAN 6 FOR TIME-',    00000520
     *       'HISTORY PLOT.')                                           00000530
      GO TO 999                                                         00000540
C                                                                       00000550
   30 PRINT 35,IARG1                                                    00000560
   35 FORMAT(1X,'RANGE UNIT ERROR.  ',I3,' NOT BETWEEN 1-3.')           00000570
      GO TO 999                                                         00000580
C                                                                       00000590
   40 PRINT 45,IARG1                                                    00000600
   45 FORMAT(1X,'NORANU ERROR.  ',I3,' LESS THAN 1.')                   00000610
      GO TO 999                                                         00000620
C                                                                       00000630
   50 CONTINUE                                                          00000640
      GO TO 999                                                         00000650
C                                                                       00000660
   60 PRINT 65,IARG1,IARG2                                              00000670
   65 FORMAT(1X,'SCALING ERROR.  MINFLX = ',I5,' NOT LESS THAN ',       00000680
     *       'MAXFLX = ',I5,'.')                                        00000690
      GO TO 999                                                         00000700
C                                                                       00000710
   70 PRINT 75,IARG1,IARG2                                              00000720
   75 FORMAT(1X,'SCALING ERROR.  MINEN = ',I5,' NOT LESS THAN MAXEN',   00000730
     *       ' = ',I5,'.')                                              00000740
      GO TO 999                                                         00000750
C                                                                       00000760
   80 PRINT 85,IARG1                                                    00000770
   85 FORMAT(1X,'IMP NUMBER ERROR.  ',I2,' NOT 6, 7, OR 8.')            00000780
      GO TO 999                                                         00000790
C                                                                       00000800
   90 PRINT 95,IARG1,IARG2                                              00000810
   95 FORMAT(1X,'ILLEGAL BOX NUMBER.  CANNOT USE ',I3,' BOX FOR IMP-',  00000820
     *       I1,'.')                                                    00000830
      GO TO 999                                                         00000840
C                                                                       00000850
  100 PRINT 105,IARG1,IARG2                                             00000860
  105 FORMAT(1X,'PERIODIC SPECTRAL PLOT INPUT ERROR.  ILLEGAL IPRDU = ',00000870
     *       I5,' OR NOPRDU = ',I5,'.')                                 00000880
      GO TO 999                                                         00000890
C                                                                       00000900
  110 PRINT 115,IARG1                                                   00000910
  115 FORMAT(1X,'ILLEGAL TIME SPECIFICATION.  UNIDENTIFIED MONTH - ',   00000920
     *       A3,'.')                                                    00000930
      GO TO 999                                                         00000940
C                                                                       00000950
  120 PRINT 125                                                         00000960
  125 FORMAT(1X,'ILLEGAL TIME SPECIFIED.')                              00000970
      GO TO 999                                                         00000980
C                                                                       00000990
  130 PRINT 135,IARG1,IARG2                                             00001000
  135 FORMAT(1X,'SCALING ERROR.  MINFLX = ',I5,' OR MAXFLX = ',I5,      00001010
     *       ' OUT OF RANGE (+ OR -9).')                                00001020
      GO TO 999                                                         00001030
C                                                                       00001040
  140 PRINT 145,IARG1,IARG2                                             00001050
  145 FORMAT(1X,'SCALING ERROR.  MINEN = ',I5,' OR MAXEN = ',I5,        00001060
     *       ' OUT OF RANGE (+ OR -9).')                                00001070
      GO TO 999                                                         00001080
C                                                                       00001090
  150 PRINT 155                                                         00001100
155   FORMAT(1X,'**** WARNING: BIN HAS BOXES WITH DIFFERENT PARTICLE ', 00001110
     *'TYPE LABELS.  PROCESSING CONTINUES.')                            00001120
      GO TO 2000                                                        00001130
C                                                                       00001140
  160 PRINT 165,IARG1,IARG2                                             00001150
  165 FORMAT(1X,'A TIME HISTORY PLOT RANGE OF ',I10,' DECISECONDS IS ', 00001160
     *'TOO LARGE FOR AN AVERAGING PERIOD OF ',I10, 'DECISECONDS.')      00001170
      GOTO 999                                                          00001180
C                                                                       00001190
 1000 PRINT 1005,IERRNO,IARG1,IARG2                                     00001200
 1005 FORMAT(' *****ERROR NUMBER',I5,', ARGUMENTS:',2Z10)               00001210
CP  ESACOD                                                              00001215
CP  TERMINATE PROCESSING IF APPROPRIATE                                 00001216
  999 CONTINUE                                                          00001220
      STOP                                                              00001230
CP  CONTINUE PROCESSING IF APPROPRIATE                                  00001235
2000  RETURN                                                            00001240
      END                                                               00001250
