CH1   SUBROUTINE FLXPIN(QDONE,QNWPLT,QOTAPE)                            00010005
CH                                                                      00020005
CH2  FUNCTIONAL DESCRIPTION:                                            00030005
CH2  READS INPUT PARAMETER CARDS FOR IMP FLUX PLOT PROGRAM.             00040005
CH                                                                      00050005
CH3  CALLING ROUTINES:  FLXPMN                                          00060005
CH                                                                      00070005
CH4  SUBROUTINES CALLED:  FLXPBX, FLXPMS                                00080005
CH                                                                      00090005
CH5  VARIABLE CROSS REFERENCE:                                          00100000
CH5    NAME         TYPE   I/O        DESCRIPTION                       00110005
CH5  ELOBN(25)       R*4     I    LOWER BIN ENERGY, MEV                 00120005
CH5  EUPBN(25)       R*4     I    UPPER BIN ENERGY, MEV                 00130005
CH5  GEOM(25)        R*4     I    GEOMETRY FACTOR, STER*CM**2           00140005
CH5  IAVLEN          I*4     I    AVERAGING INTERVAL, DECISEC           00150005
CH5  IAVMIN          I*4     I    AVERAGING TIME, MINUTES               00160005
CH5  IBEGIN,IYEAR1   I*4     I    START TIME REQUESTED                  00170005
CH5  IEND,IYEAR2     I*4     I    END TIME REQUESTED                    00180005
CH5  IFRMAX          I*4     I    NUMBER OF DIFFERENT FRAMES RES'D      00190005
CH5  IMP(25)         I*4     I    IMP NUMBER (1=6,2=7,3=8)              00200000
CH5  IPTS            I*4    I,O   NUMBER OF POINTS PER FRAME            00210005
CH5  JAVER           I*4     I    PLOT POINT SIZE, DECISECONDS          00220005
CH5  JBOX(10,25)     I*4     I    BOX NUMBER REQUEST ARRAY              00230005
CH5  JCHAR(25)       I*4     I    PLOT POINT CHARACTERS                 00240005
CH5  JKEY            I*4     I    INPUT KEY PARAMETER                   00250005
CH5  JOLD            I*4     I    PERVIOUS INPUT KEY PARAMETER          00260005
CH5  JRANGE          I*4     I    FRAME RANGE SIZE, DECISEC             00270005
CH5  JRANUN          I*4     I    UNIT OF RANGE SPECIFICATION           00280005
CH5  JTITLE(20)      I*4     I    USER TITLE                            00290005
CH5  MAXENG          I*4     I    MAX ENERGY AXIS VALUE (POWER OF 10)   00300000
CH5  MAXFLX          I*4     I    MAX FLUX AXIS VALUE (POWER OF 10)     00310005
CH5  MINENG          I*4     I    MIN ENERGY AXIS VALUE (POWER OF 10)   00320005
CH5  MINFLX          I*4     I    MIN FLUX AXIS VALUE (POWER OF 10)     00330005
CH5  NUMBIN          I*4     I    NUMBER OF REQUESTED BINS              00340005
CH5  ORIGIN(4)       R*4     I    SD-4060 PLOT FRAME LIMITS, RASTERS    00350005
CH5  QBOX(144,3)     L*1     I    BOX REQUEST FLAG ARRAY                00360005
CH5  QDAT(3)         L*1     I    SATELLITE REQUEST FLAG ARRAY          00370005
CH5  QDEBUG          L*1     I    DEBUG REQUEST FLAG                    00380005
CH5  QFILTR          L*1     I    IMP-6 PERIGEE FILTER FLAG             00390005
CH5  QNWPLT          L*1     I    NEW PLOT FLAG                         00400000
CH5  QSAT(3)         L*1     I    SATELLITE REQUEST FLAG                00410005
CH5  QSTAT           L*1     I    STATISTICS PRINTOUT REQUEST FLAG      00420005
CH5  QTHIST          L*1     I    T=TIME HIST; F=SPECTRAL               00430005
CH5  XPERIG          R*4     I    IMP-6 PERIGEE ALTITUDE, METERS        00440005
CH5  QDONE           L*1     O    DONE WITH INPUT FLAG                  00450005
CH5  IFR80           I*4     O    MICROFICHE FRAME NUMBER BALANCER      00460005
CH5                                  FOR FR80 HEADER PAGES/DATA         00470005
CH5                                  FRAME ALLIGNMENT                   00480005
CH                                                                      00490005
CH6  METHOD:                                                            00500000
CH6 THE USER MAY SPECIFY EITHER (1) TIME HISTORY OR (2) SPECTRAL PLOTS. 00510005
CH6 (1) WITH THE TIME HISTORY OPTION, UP TO 6 DIFFERENT BINS MAY BE     00520005
CH6     PLOTTED, ON UP TO 6 DIFFERENT FRAMES.                           00530005
CH6 (2) WITH THE SPECTRAL PLOT OPTION, UP TO 25 DIFFERENT BINS MAY      00540005
CH6     BE PLOTTED, ON UP TO 6 DIFFERENT FRAMES.                        00550005
CH6 EACH BIN CONSISTS OF FROM 1 TO 10 PREDEFINED BOXES.                 00560005
CH6      IMP(I), I=1,6 IS THE SATELLITE NUMBER FOR THE ITH RATE,        00570005
CH6      WHERE THE VALUE IS 1 FOR IMP-6, 2 FOR IMP-7, AND 3 FOR IMP-8.  00580005
CH6                                                                     00590005
CH7  PROGRAMMER:  J. CHILDS, 7/77.                                      00600000
CH                                                                      00610005
CH8  MODIFICATION:  J. CHILDS, 11/77 -- READS IN DATA AVERAGING TIME    00620005
CH8                 AND STATISTICS FLAG INSTEAD OF TAPE UNIT CARD.      00630005
CH8                 J. CHILDS, 2/79 -- USER INPUT OPTION ON FRAME SIZE  00640005
CH                                                                      00650005
CH8                  P. SCHUSTER 2/80 -- COMMON /DECICK/ GIVES          00660005
CH8                  USER OPTION OF DECISECOND CHECK FOR IMP 6          00670005
CH                                                                      00680005
CH8    BEGIN MODIFICATION 10/86   P. SCHUSTER                           00690005
CH8    AS SPECIFIED BY R. MCGUIRE DOCUMENT                              00700000
CH8                                                                     00710005
CH8    MOD TO GO WITH MEMBER FLXPSSN, THIS VSN READS IN FLUX CRITERIA   00720005
CH                                                                      00730005
CH9  IMP-6/7/8, FLUX PLOT, FLXPIN, V2.                                  00740005
CH**********************************************************************00750005
C                                                                       00760005
      SUBROUTINE FLXPIN(QDONE,QNWPLT,QOTAPE)                            00770005
C                                                                       00780005
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H),REAL*8(D)                      00790005
      CHARACTER*1 ESS/'S'/,JPLOT                                        00800005
      INTEGER ISEC /0/                                                  00810005
      COMMON /EXCLCR/ IXCBOX,EXCVAL,IAVTIM                              00820005
      COMMON /AVE/    IAVLEN,QSTAT                                      00830005
C*******  25 -> 100   144 -> 500                                        00840000
C                                                                       00850005
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00860005
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00870005
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00880005
C                                                                       00890005
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00900005
C          TO 50 (FRAMES)                                               00910005
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00920005
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00930005
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00940000
C                                                                       00950005
      COMMON /GAP/    JOLD                                              00960005
C                                                                       00970005
C*******     144 -> 500                                                 00980005
C                                                                       00990005
      COMMON /GEOMF / GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   01000005
     *                KEVENT(500,3),HMP8ST(500)                         01010005
C                                                                       01020005
      COMMON /LIMITS/ IBEGIN,IYEAR1,IEND,IYEAR2,IBEGIP(3),IYEAP1(3)     01030005
      COMMON /MONTH/  MONAT(12)                                         01040000
      COMMON /PERIGE/ XPERIG,JUP,IUP(100),JDN,IDN(100),QFILTR,QPER(250) 01050005
C*******  LOOP INDEX BECOMES I144 VARIABLE FROM NEW COMMON BLOCK LOOPS  01060005
      COMMON/LOOPS/ICOUNT(50),I144,I25,I50,I6,IFR80                     01070005
C*******   ICOUNT COUNTS THE NUMBER OF DATA ITEMS FOR EACH SPECIFIED    01080005
C*******  THRESH 25 -> 100                                              01090005
C                                                                       01100005
      COMMON /PLOT/   MODE(200),ORIGIN(4),PLIMIT(4),THRESH(2,100),      01110005
     *                HORIZ(150)                                        01120005
C                                                                       01130005
C*******   S, SDEL 25 ->100 ; Y , YDEL 6 ->100                          01140000
C                                                                       01150005
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        01160005
     *                ITIME(250),IPTS,JKEY,QTHIST                       01170005
C                                                                       01180005
      COMMON /PRINTS/ QPRINT                                            01190005
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   01200005
      COMMON /SIZE/   XMAXX                                             01210005
      COMMON /TREND / TCFACT,QTC,QDEBUG                                 01220005
      COMMON /USRTTL/ JTITLE(20)                                        01230005
      COMMON /DECICK/ QTIMCK                                            01240000
C*******   144 -> 500                                                   01250005
C                                                                       01260005
      INTEGER MAXBOX(3)/500,500,500/,JTIMEU(4)/1,864000,36000,600/      01270005
C                                                                       01280005
C*******  KCHAR USEAGE (6,50)  MAX OF 6 QUANTITIES PER FRAME,           01290005
C         FOR TIME HISTORY MODE ONLY -                                  01300005
C         AND 50 FRAMES  -  DEFAULT CHARACTER ASSIGNMENTS               01310005
C         USE THESE SYMBOLS ONE AT A TIME IN ORDER TO PLACE             01320000
C            DEFAULT CHARS INTO FRAMES                                  01330005
      EQUIVALENCE (KCHAR(1),CKHAR(1))                                   01340005
      INTEGER KCHAR(25)                                                 01350005
      CHARACTER*4 JJTIT(20)
      EQUIVALENCE (JTITLE(1),JJTIT(1))
      CHARACTER*4  CKHAR(25)/'A','C','D','E','+','G',                   01360005
     X 'H','I','J','K','L','#','N','O','P',                             01370005
     X 'S','T','*','U','V','W','X','Y','Z','$'/                         01380005
      CHARACTER*4 CBLANK                                                01390005
      INTEGER BLANK                                                     01400005
      EQUIVALENCE (CBLANK,BLANK)                                        01410005
      DATA CBLANK/'    '/                                               01420005
C          FRAME AND IS THE BASIS OF DEFAULT CHARACTER ASSIGM.          01430005
      DATA QKEY/.TRUE./                                                 01440005
C                                                                       01450005
      QDONE = .FALSE.                                                   01460005
C                                                                       01470000
C   IF A NEW PLOT IS REQUESTED, READ TITLE CARD; ELSE READ TIME CARD.   01480005
C                                                                       01490005
CP IF (FIRST TIME)                                                      01500005
      IF(QKEY) GO TO 10                                                 01510005
C  NEW TITLE CARD DENOTED BY BLANK BETWEEN DECKS (SEE LABEL 300)        01520005
C                                                                       01530005
      QNWPLT = .FALSE.                                                  01540005
      GOTO 300                                                          01550005
C                                                                       01560005
CP 10  READ AND ECHO THE TITLE CARD                                     01570000
C                                                                       01580005
 10   READ(5,1000,ERR=450,END=400)(JTITLE(I),I=1,20)                    01590005
C  ALLOW POUND OR ASTERISK IN COL 1  FOR READ HERE TO BE COMMENT        01580005
C  WILL ALLOW CARDS AFTER BLANK TIME CARD , WHICH BRANCHES HERE         01580005
      IF ( (JJTIT(1)(1:1) .EQ. CKHAR(12))  .OR.
     X     (JJTIT(1)(1:1) .EQ. CKHAR(18)) ) GO TO 10
1000  FORMAT(20A4)                                                      01600005
      PRINT 999                                                         01610005
999   FORMAT(1H1)                                                       01620005
      PRINT 2000,(JTITLE(I),I=1,20)                                     01630005
2000  FORMAT(1X,20A4)                                                   01640005
C     SET QKEY (FIRST CALL FLAG) = FALSE                                01650005
      QKEY = .FALSE.                                                    01660005
C   SET JKEY TO ZERO FOR FIRST CALL TO AN INPUT DECK (JOLD SET)         01670000
      JKEY = 0                                                          01680005
C                                                                       01690005
C   READ IN AVERAGING INTERVAL FOR DATA ACCUMULATION, IN MINUTES.       01700005
C   IAVLEN IS SEC*10.  ZERO OR NEG MEANS AVERAGE OVER FULL TIME.        01710005
C   ALSO READ IN OPTIONAL FRAME SIZE IN RASTER UNITS.                   01720005
C     (DEFAULT IS X=205 TO 4049, Y=300 TO 2700)                         01730005
CP     READ AND ECHO THE AVERAGING CARD                                 01740005
      IAVGS = 0                                                         01750005
C                                                                       01760005
      READ (5,1002) IAVMIN,QSTAT,QDEBUG,QTIMCK,IAVGS,                   01770005
     X    XMIN0,XMAXX0,YMIN0,YMAX0                                      01780005
1002  FORMAT(I5,4X,3L1,3X,I1,4X,4F5.1)                                  01790000
      PRINT 2002,IAVMIN,QSTAT,QDEBUG,QTIMCK,IAVGS,                      01800005
     X    XMIN0,XMAXX0,YMIN0,YMAX0                                      01810005
2002  FORMAT(1X,I5,4X,3L1,3X,I1,4X,4F5.1)                               01820005
      IAVLEN = IAVMIN*600                                               01830005
C--------------------------------------------------------------------   01840005
C--------------------------------------------------------------------   01850005
CPAS  UTILIZE IAVLEN READ-IN POSITION VALUE, BUT DISABLE                01860005
CPAS  AVERAGING CAPABILITY  - DO CHECK OF FLUXES AS IF WHOLE TIME       01870005
CPAS  YET HAVING THE QCRIT CHECKING DONE AS IF IAVMIN LENGHT CHECKING   01880005
CPAS  1/95  INSERT IAVGS PARM AND TEST SUBSUMS FLUX CODE -KEEP IF       01890005
CPAS  IT DOES THE SAME AS THE ORIGINAL CRITERION PROGRAM.               01900005
      IAVTIM = 0                                                        01910005
      IF (IAVGS .NE. 0) IAVTIM = IAVLEN                                 01920005
      IF( IAVGS .NE. 0)  WRITE(6,2003) IAVGS,IAVMIN                     01930005
      IF( IAVGS .NE. 0)  WRITE(6,2003) IAVGS,IAVMIN                     01940005
2003  FORMAT(1H ,' ***** NOTE THAT FLUXES WILL BE MADE FROM SUBSUMS'    01950005
     X  ,/8X,'IAVGS = ',2I6)                                            01960005
C--------------------------------------------------------------------   01970005
C--------------------------------------------------------------------   01980005
C   SET FRAME SIZE TO DEFAULT VALUES.                                   01990005
      ORIGIN(1) =  205.                                                 02000005
      ORIGIN(2) = 4049.                                                 02010005
      ORIGIN(3) =  300.                                                 02020005
      ORIGIN(4) = 2700.                                                 02030005
      XMAXX     = 4049.                                                 02040005
C   SET TO INPUTTED VALUES IF NOT ZERO                                  02050000
      IF (XMIN0+XMAXX0+YMIN0+YMAX0.EQ.0.0) GOTO 200                     02060005
          ORIGIN(1) = XMIN0                                             02070005
          ORIGIN(2) = XMAXX0                                            02080005
          ORIGIN(3) = YMIN0                                             02090005
          ORIGIN(4) = YMAX0                                             02100005
          XMAXX     = XMAXX0                                            02110005
200   CONTINUE                                                          02120005
C                                                                       02130005
CP     READ AND ECHO THE PLOT PARAMETER CARD                            02140005
C                                                                       02150000
      READ(5,1001) NUMBIN,JPLOT,QFILTR,QPRINT,QLINES,QTC,QOTAPE,XPERIG, 02160005
     *TCFACT                                                            02170005
1001  FORMAT(I3,A1,5L1,2X,F8.2,2X,F5.0)                                 02180005
      PRINT 2001,  NUMBIN,JPLOT,QFILTR,QPRINT,QLINES,QTC,QOTAPE,XPERIG, 02190005
     *TCFACT                                                            02200005
2001  FORMAT(' ',I3,A1,5L1,2X,F8.2,2X,F5.0)                             02210005
CP     CHECK ON PLOT PARAMETERS                                         02220005
C   CHECK NUMBIN; SET PLOT TYPE.                                        02230005
      IF (NUMBIN.LT.1.OR.NUMBIN.GT.100) CALL FLXPMS(NUMBIN,0,1)         02240005
      QTHIST = .TRUE.                                                   02250000
      IF (JPLOT.EQ.ESS) QTHIST = .FALSE.                                02260005
      IF (XPERIG.EQ.0.0) XPERIG = 70000.                                02270005
      QLINEX = .FALSE.                                                  02280005
      IF (QLINES) QLINEX = .TRUE.                                       02290005
C   DEFAULT TREND CHECK FACTOR IS 100.  CANNOT BE < 15.0                02300005
      IF (QTC.AND.TCFACT.LT.15.0) TCFACT = 100.0                        02310005
C                                                                       02320005
CP     READ AND ECHO BIN CARDS                                          02330005
C                                                                       02340005
      DO 203 I=1,I144                                                   02350000
        DO 203 J=1,3                                                    02360005
203       QBOX(I,J) = .FALSE.                                           02370005
      DO 204 I=1,10                                                     02380005
        DO 204 J=1,I25                                                  02390005
204       JBOX(I,J) = 0                                                 02400005
      DO 205 I=1,3                                                      02410005
205     QSAT(I) = .FALSE.                                               02420005
      IFRMAX = 0                                                        02430005
C                                                                       02440005
      NCHARS = 0                                                        02450000
         DO 207 II = 1,I50                                              02460005
            ICOUNT(II) = 0                                              02470005
207      CONTINUE                                                       02480005
      DO 250 J=1,NUMBIN                                                 02490005
        READ(5,210) JIMP,JFRAME(J),JCHAR(J),XNORM(J),                   02500005
     *              (JBOX(K,J),K=1,10)                                  02510005
210     FORMAT(I1,I2,A1,F7.2,10I3)                                      02520005
        PRINT 211,   JIMP,JFRAME(J),JCHAR(J),XNORM(J),                  02530005
     *              (JBOX(K,J),K=1,10)                                  02540005
211     FORMAT(' ',I1,I2,A1,G11.2,10I3)                                 02550000
CP     CHECK ON BIN PARAMETERS                                          02560005
        IF (JIMP.LT.6.OR.JIMP.GT.8) CALL FLXPMS(JIMP,0,8)               02570005
        IMP(J) = JIMP - 5                                               02580005
        QSAT(IMP(J)) = .TRUE.                                           02590005
       IF (XNORM(J).EQ.0.0) XNORM(J) = 1.0                              02600005
        L = IMP(J)                                                      02610005
C*******  BEGIN CHANGES FOR CHARACTER ASSIGNMENTS                       02620005
         IF(JFRAME(J) .EQ. 0) GO TO 230                                 02630005
            ICOUNT(JFRAME(J)) = ICOUNT(JFRAME(J)) + 1                   02640005
            IF( .NOT. QTHIST) GO TO 220                                 02650000
C           IF QTHIST HAVE LIMIT OF 6 QUANTITIES PER FRAME              02660005
C           FOR PLOT LABELLING PURPOSES ONLY                            02670005
            IF(ICOUNT(JFRAME(J)) .LE. 6) GO TO 220                      02680005
               PRINT 215, JFRAME(J)                                     02690005
215      FORMAT(1H ,'WARNING ***** TOO MANY DATA QUANTITIES',           02700005
     X              ' REQUESTED FOR FRAME  ',I3,'  FOR THIST MODE')     02710005
          STOP                                                          02720005
220   CONTINUE                                                          02730005
         NCHARS = NCHARS + 1                                            02740005
         IF(NCHARS .GT. 25) NCHARS = 1                                  02750000
        IF (JCHAR(J) .EQ. BLANK) JCHAR(J) = KCHAR(NCHARS)               02760005
230   CONTINUE                                                          02770005
C*******  END CHARACTER ASSIGNMENTS                                     02780005
        JPRTBN(J) = IPART(JBOX(1,J),L)                                  02790005
        IF (JFRAME(J).GT.IFRMAX) IFRMAX = JFRAME(J)                     02800005
        EUPBN(J) = 0.0                                                  02810005
        ELOBN(J) = 99999.                                               02820005
        DO 240 K=1,10                                                   02830005
          KBOX = JBOX(K,J)                                              02840005
          IF (KBOX.EQ.0) GOTO 250                                       02850000
          IF (KBOX.GT.MAXBOX(L)) CALL FLXPMS(KBOX,JIMP,9)               02860005
          QBOX(KBOX,L) = .TRUE.                                         02870005
          IF((L.EQ.3).AND.(HMP8ST(KBOX).NE.0))                          02880005
     *       QBOX(HMP8ST(KBOX),L)=.TRUE.                                02890005
          IF (ELO(KBOX,L).LT.ELOBN(J)) ELOBN(J) = ELO(KBOX,L)           02900005
          IF (EUP(KBOX,L).GT.EUPBN(J)) EUPBN(J) = EUP(KBOX,L)           02910005
          IF (IPART(KBOX,L).NE.JPRTBN(J))                               02920005
     *                      CALL FLXPMS(IPART(KBOX,L),JPRTBN(J),15)     02930005
240       CONTINUE                                                      02940005
250     CONTINUE                                                        02950000
C   CALL BIN INTEGRITY ROUTINE.                                         02960005
CP     CHECK ON BIN INTEGRITY AND PENETRATING BOXES                     02970005
      CALL FLXPBX                                                       02980005
C                                                                       02990005
CP     READ AND ECHO PLOT SCALING CARD                                  03000005
C                                                                       03010005
      READ(5,260)MNFLX,MXFLX,MNENG,MXENG,JRANUN,NORANU,IAVU,NOAVU,      03020005
     X NFRAME,NFR80                                                     03030005
260   FORMAT(10I5)                                                      03040005
      PRINT 261, MNFLX,MXFLX,MNENG,MXENG,JRANUN,NORANU,IAVU,NOAVU,      03050000
     X NFRAME,NFR80                                                     03060005
261   FORMAT(' ',10I5)                                                  03070005
      IF (IFRMAX.EQ.0) GOTO 270                                         03080005
      IFR80 = NFR80                                                     03090005
      IF(NFR80 .EQ.0) IFR80 = 7                                         03100005
      IF (MNFLX.GE.MXFLX) CALL FLXPMS(MNFLX,MXFLX,6)                    03110005
      IF (MNFLX.LT.-9.OR.MXFLX.GT.9) CALL FLXPMS(MNFLX,MXFLX,13)        03120005
      IF (.NOT.QTHIST.AND.(MNENG.LT.-9.OR.MXENG.GT.9))                  03130005
     *                                 CALL FLXPMS(MNENG,MXENG,14)      03140005
      IF(.NOT.QTHIST.AND.MNENG.GT.MXENG) CALL FLXPMS(MNENG,MXENG,7)     03150000
       IF(NFRAME .LT. 2) GO TO 265                                      03160005
        IF(NFRAME .NE. IFRMAX) PRINT 262, NFRAME,IFRMAX                 03170005
262            FORMAT(1H ,'WARNING *****  NFRAME DOES NOT',             03180005
     X         ' MATCH IFRMAX OF REQUESTED DATA ',2I5)                  03190005
        IF(NFRAME .NE. IFRMAX) STOP                                     03200005
C   THIS BRANCH WILL LOOK FOR ADDITIONAL CARDS WITH Y SCALING           03210005
C   SPECIFIED FOR EACH FRAME REQUESTED                                  03220005
             MINFLX(1) = MNFLX                                          03230005
             MAXFLX(1) = MXFLX                                          03240005
             MINENG(1) = MNENG                                          03250000
             MAXENG(1) = MXENG                                          03260005
          DO 263 II=2,NFRAME                                            03270005
      READ(5,260)MNFLX,MXFLX,MNENG,MXENG                                03280005
      WRITE(6,261)MNFLX,MXFLX,MNENG,MXENG                               03290005
      IF (MNFLX.GE.MXFLX) CALL FLXPMS(MNFLX,MXFLX,6)                    03300005
      IF (MNFLX.LT.-9.OR.MXFLX.GT.9) CALL FLXPMS(MNFLX,MXFLX,13)        03310005
      IF (.NOT.QTHIST.AND.(MNENG.LT.-9.OR.MXENG.GT.9))                  03320005
     *                                 CALL FLXPMS(MNENG,MXENG,14)      03330005
      IF(.NOT.QTHIST.AND.MNENG.GT.MXENG) CALL FLXPMS(MNENG,MXENG,7)     03340005
             MINFLX(II) = MNFLX                                         03350000
             MAXFLX(II) = MXFLX                                         03360005
             MINENG(II) = MNENG                                         03370005
             MAXENG(II) = MXENG                                         03380005
263     CONTINUE                                                        03390005
        GO TO 269                                                       03400005
265    CONTINUE                                                         03410005
       IF(IFRMAX .EQ. 0) GO TO 270                                      03420005
C   THIS BRANCH SETS ALL FRAME LIMITS TO FIRST SPECIFIED VALUES         03430005
         DO 266 II=1,50                                                 03440005
             MINFLX(II) = MNFLX                                         03450000
             MAXFLX(II) = MXFLX                                         03460005
             MINENG(II) = MNENG                                         03470005
             MAXENG(II) = MXENG                                         03480005
266      CONTINUE                                                       03490005
269    CONTINUE                                                         03500005
C   1=MONTH, 2=DAY, 3=HOUR, 4=MINUTE.                                   03510005
270   IF (.NOT.QTHIST) GOTO 300                                         03520005
C   FOR TIME HISTORY PLOTS, CALCULATE PLOT RANGE AND DATA POINT         03530005
C   AVERAGING PERIOD IN DECISECONDS.  CHECK FOR OVERFLOW IN DATA        03540005
C   POINTS PER FRAME (MAXIMUM IS 250).                                  03550000
      IF (JRANUN.LT.1.OR.JRANUN.GT.3) CALL FLXPMS(JRANUN,0,3)           03560005
      IF (NORANU.LT.1)                CALL FLXPMS(NORANU,0,4)           03570005
      JRANGE = NORANU*JTIMEU(JRANUN)                                    03580005
      JAVER  = NOAVU *JTIMEU(  IAVU)                                    03590005
      JRANGC = JRANGE                                                   03600005
      IF (JRANUN.EQ.1) JRANGC = NORANU*26784000                         03610005
      IF (JAVER.EQ.0.OR.JRANGC/JAVER.GT.250)                            03620005
     *                                CALL FLXPMS(JRANGC,JAVER,16)      03630005
C                                                                       03640005
CP  FI                                                                  03650000
CP  READ AND ECHO TIME CARD                                             03660005
C   READ TIME CARD FOR TIME HISTORY PLOT.  IF ZERO INPUT, THEN NEXT     03670005
C   CARD IS TITLE CARD.                                                 03680005
C                                                                       03690005
300   JOLD = JKEY                                                       03700005
      READ(5,305,ERR=450,END=400) JKEY,IDAY1,MON1,IYEAR1,IHR1,IMIN1,    03710005
     *            IDAY2,MON2,IYEAR2,IHR2,IMIN2,IPRDU,NOPRDU,            03720005
     *            CRIT                                                  03730005
305   FORMAT(I1,2(1X,I2,1X,A3,3(1X,I2)),2X,2I5,2X,E10.3)                03740005
      PRINT 306,  JKEY,IDAY1,MON1,IYEAR1,IHR1,IMIN1,IDAY2,MON2,         03750005
     *            IYEAR2,IHR2,IMIN2,IPRDU,NOPRDU,                       03760000
     *            CRIT                                                  03770005
C 2/1/93  GET RAW FLUX FROM CRITERION, FOR FLXPSS                       03780005
            IF(CRIT .GT. 0.0 .AND. CRIT .LE. 1.0E-09) CALL ABEND(90)    03790005
            IF(CRIT .GE. 1.0E+09) CALL ABEND(91)                        03800005
            KIMPI = IMP(1)                                              03810005
            CALL RAWFLX(JBOX(1,1),KIMPI,EXCVAL,CRIT,ELOBN(1),EUPBN(1))  03820005
            IXCBOX = 0                                                  03830005
            IF (EXCVAL .GT. 0.0) IXCBOX = JBOX(1,1)                     03840005
306   FORMAT(' ',I1,2(1X,I2,1X,A3,3(1X,I2)),2X,2I5,2X,E10.3)            03850005
CP  IF (YEAR IS ZERO)                                                   03860005
      IF (IYEAR1.NE.0) GOTO 320                                         03870005
CP     JUMP TO 10                                                       03880005
      QNWPLT = .TRUE.                                                   03890005
      PRINT 310                                                         03900005
310   FORMAT(' INITIALIZATION FOR NEXT SET OF INPUT CARDS.')            03910005
      GOTO 10                                                           03920005
CP  FI                                                                  03930005
CP  CHECK ON TIME DATA                                                  03940000
320   IF (QTHIST.OR.JKEY.NE.2) GOTO 340                                 03950005
C   TEST ON PERIODIC SPECTRAL PLOT INFORMATION.                         03960005
      IF (IPRDU.LT.1.OR.IPRDU.GT.4.OR.NOPRDU.LT.1)                      03970005
     *            CALL FLXPMS(IPRDU,NOPRDU,10)                          03980005
      JRANUN = IPRDU                                                    03990005
      JRANGE = NOPRDU*JTIMEU(IPRDU)                                     04000005
C   SET START AND STOP YEARS AND CHECK FOR LEGAL MONTHS.                04010005
340   IMON1 = 0                                                         04020005
      IMON2 = 0                                                         04030005
      IYEAR1 = IYEAR1 + 1900                                            04040000
      IYEAR2 = IYEAR2 + 1900                                            04050005
      DO 50 I=1,12                                                      04060005
        IF (MONAT(I).EQ.MON1) IMON1 = I                                 04070005
        IF (MONAT(I).EQ.MON2) IMON2 = I                                 04080005
 50     CONTINUE                                                        04090005
      IF (IMON1.EQ.0) CALL FLXPMS(MON1,0,11)                            04100005
      IF (IMON2.EQ.0) CALL FLXPMS(MON2,0,11)                            04110005
C   GET 10THS OF SEC OF YEAR FOR START AND STOP TIMES.                  04120005
      CALL PACK(IYEAR1,IBEGIN,IMON1,IDAY1,IHR1,IMIN1,ISEC,Q1)           04130005
      CALL PACK(IYEAR2,IEND  ,IMON2,IDAY2,IHR2,IMIN2,ISEC,Q2)           04140000
C   MAKE SURE TIME IN BOUNDS.                                           04150005
      IF (.NOT.Q1.OR..NOT.Q2) CALL FLXPMS(0,0,12)                       04160005
C  FOR SPECTRAL PLOT SET JRANGE TO IAVLEN FOR 11/70 OPTION              04170005
C  AVERAGING INTERVAL                                                   04180005
C OLD  IF(.NOT. QTHIST .AND. JKEY .NE. 2) JRANGE = IAVLEN               04190006
       IF(.NOT. QTHIST .AND. JKEY .NE. 2) JRANGE = IAVTIM               04191006
C                                                                       04200005
      RETURN                                                            04210005
C                                                                       04220005
400   PRINT 1060                                                        04230005
1060  FORMAT('1EOF ON UNIT 5.')                                         04240000
      GOTO 500                                                          04250005
450   PRINT 1065                                                        04260005
1065  FORMAT('1I/O ERROR ON UNIT 5.')                                   04270005
500   QDONE = .TRUE.                                                    04280005
      RETURN                                                            04290005
      END                                                               04300005
      SUBROUTINE RAWFLX(IBOX,KIMPI,EXCVAL,CRIT,ELOB,EUPB)               04320005
C 2/1/93  GET RAW FLUX FROM CRITERION, FOR FLXPSS                       04310005
C                                                                       04330005
      COMMON /GEOMF / GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   04340005
     *                KEVENT(500,3),HMP8ST(500)                         04350005
      INTEGER*2 HMP8ST                                                  04360005
C                                                                       04370005
      GEOMTY = GEOM(IBOX,KIMPI)                                         04380005
      DELE   = EUPB- ELOB                                               04390005
      EXCVAL = CRIT * GEOMTY * DELE                                     04400005
      WRITE(9,10) CRIT,EXCVAL,ELOB,EUPB,IBOX                            04410005
 10   FORMAT(1H ,'FLXPIN INFO ', 4(1PE10.3,2X),3X,I4)                   04420005
      RETURN                                                            04430005
      END                                                               04440005
