CH1   SUBROUTINE FLXPSS(DELJAY,RJAY,NOREC,IUPPER,IAVLEN,NSTAT,          00000010
CH1  *KIMP,IDAT)                                                        00000020
CH                                                                      00000030
CH2  FUNCTIONAL DESCRIPTION:     FOR FLEXPLOT PROGRAM                   00000040
CH2   CALCULATES FLUX OVER AVERAGING INTERVALS.                         00000050
CH                                                                      00000060
CH3  CALLING ROUTINES:  FLXPA                                           00000070
CH                                                                      00000080
CH4  SUBROUTINES CALLED:  FLXPAA, FLXPTC, FLXPMT                        00000090
CH                                                                      00000100
CH5  VARIABLE CROSS REFERENCE:                                          00000110
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000120
CH5  DELJAY(500,3)   R*4    I,O   'FLUX' ERROR                          00000130
CH5  HLGRAT(18,3)    I*2     I    DOUBLE RATE ID INDEX                  00000140
CH5  IAVEND          I*4     O    END OF AVERAGING PERIOD, DECISEC      00000150
CH5  IAVLEN          I*4     I    AVERAGING INTERVAL, DECISEC           00000160
CH5  IFLUX(150,3)    I*4     I    FLUX TAPE RECORDS                     00000170
CH5  INUNIT(3)       I*4     I    INPUT FLUX TAPE UNITS                 00000180
CH5  IRECTM          I*4          CURRENT FLUX RECORD TIME, DECISE      00000190
CH5  IUPPER          I*4          AVERAGING PERIOD UPPER TIME           00000200
CH5  IYR1            I*4     I    YEAR AT START OF FRAME                00000210
CH5  JAVER           I*4     I    PLOT POINT SIZE, DECISECONDS          00000220
CH5  JKEY            I*4     I    INPUT KEY PARAMETER                   00000230
CH5  JOLD            I*4     I    PREVIOUS INPUT KEY PARAMETER          00000240
CH5  KEVENT(500,3)   I*4     I    BOX EVENT NUMBER                      00000250
CH5  NSTAT(10,500)   I*4     O    STATISTICS ACCUMULATION ARRAYS        00000260
CH5  QBOX(500,3)     L*1     I    BOX REQUEST FLAG ARRAY                00000270
CH5  QDAT(3)         L*1     I    SATELLITE REQUEST FLAG ARRAY          00000280
CH5  QDEBUG          L*1     I    DEBUG REQUEST FLAG                    00000290
CH5  QFAIL           L*1          TREND CHECK FAIL FLAG                 00000300
CH5  QFILTR          L*1     I    IMP-6 PERIGEE FILTER FLAG             00000310
CH5  QPER(250)       L*1     I    IMP-6 PERIGEE FLAG                    00000320
CH5  QTC             L*1     I    TREND CHECK REQUEST FLAG              00000330
CH5  QTHIST          L*1     I    T=TIME HIST; F=SPECTRAL               00000340
CH5  RJAY(500,3)     R*4     O    'FLUX' FOR AVERAGING PERIOD           00000350
CH5  TACCUM(18,3)    R*4     I    EVENT-TYPE RATE ACCUMULATION TIMES    00000360
CH5  TCFACT          R*4     I    TREND CHECK FACTOR                    00000370
CH5  XPERIG          R*4     I    IMP-6 PERIGEE ALTITUDE, METERS        00000380
CH5  ZMATR(500)      R*4          ACCUMULATOR FOR MATRIX COUNTS         00000390
CH5  ZNOBOX(500)     R*4          ACCUMULATOR FOR BOX COUNTS            00000400
CH5  ZPATCT(500)     R*4          ACCUMULATOR FOR LOW GAIN RATE COUNTS  00000410
CH5  ZPATED(500)     R*4          ACCUMULATOR FOR LOW GAIN RATE TIME    00000420
CH5  ZRATCT(500)     R*4          ACCUMULATOR FOR RATE COUNTS           00000430
CH5  ZRATED(500)     R*4          ACCUMULATOR FOR RATE TIME             00000440
CH                                                                      00000450
CH6  METHOD:                                                            00000460
CH6   SUBROUTINE FOR IMP FLUX PLOT PROGRAM.   ACCUMULATES FLUX DATA     00000470
CH6   OFF IMP INTERMEDIATE FLUX TAPES.  DATA ACCUMULATED OVER AVERAGING 00000480
CH6   PERIODS.  AVERAGING PERIODS ARE ACCUMULATED OVER PLOT POINTS.     00000490
CH6   AN AVERAGING PERIOD IS LESS OR EQUAL TO THE PLOT POINT INTERVAL.  00000500
CH                                                                      00000510
CH7  PROGRAMMER:  J. CHILDS  AND E. ENG, 2/77.                          00000520
CH                                                                      00000530
CH8  MODIFICATION:  J. CHILDS, 4/79 -- RATES ACCUMULATION TIMES         00000540
CH8                 CORRECTED FOR ALPHA-ONLY RATES.                     00000550
CH8                 J. CHILDS, 5/79 -- ACCUMULATION PROBLEM CORRECTED.  00000560
CH8      P. SCHUSTER, 10/09/79, REJECT DATA RECORDS IF SINGLES RATES    00000570
CH8                   C (LED) OR D1+E (MED) ARE ZERO, IMPLYING OFF      00000580
CH8                   SUPOSSEDLY DONE IN DBG PRODUCTION                 00000590
CH8                         11/86  IMP-8 LED OFF CRITERIA BECOMES       00000600
CH8                         B SINGLES RATE    P. SCHUSTER               00000610
CH8     P. SCHUSTER,12/20/79, RELATIVE TO IMP 6 DATABASE YEAR           00000620
CH8                 PROBLEM: ADDED CHECK FOR BAD YEARS, RECORDS         00000630
CH8                 HAVING BAD YEARS ARE BYPASSED, A MESSAGE IS         00000640
CH8                 PRINTED OUT                                         00000650
CH                                                                      00000660
CH8       1/22/80  P. SCHUSTER  ADDITIONAL TIME CHECKING CODE           00000670
CH8                ADDED, TO TRY TO VERIFY CONTINUITY IN DECISECOND     00000680
CH8                RECORD DATA, AS WELL AS IN YEARS                     00000690
CH8                 FLUX DATA BASE SURVEY OF IMP6,7,8 SHOWS             00000700
CH8                 ONLY IMP 6 WITH RECORD TIME PROBLEMS                00000710
CH                                                                      00000720
CH8      4/80   DEAD TIME CORRECTION INCORPORATED                       00000730
CH8  MODIFICATION 11/86, P. SCHUSTER;  IMPLEMENT MCGUIRE TASK           00000740
CH8                                    CHANGES                          00000750
CH                                                                      00000760
CH8  MODIFICATION 8/87  CHANGE ON/OFF CRITERIA AS PER MCGUIRE           00000761
CH8                     REQUEST(SEE BELOW)  - PAS                       00000762
CH9  IMP-6/7/8, FLUX PLOT, FLXPSS, V2A.  USING FLEX DATABASE            00000770
CH**********************************************************************00000780
C                                                                       00000790
      SUBROUTINE FLXPSS(DELJAY,RJAY,NOREC,IUPPER,IAVLEN,NSTAT,          00000800
     *KIMP,IDAT)                                                        00000810
C                                                                       00000820
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000830
      DIMENSION HFLUX(300,3),RFLUX(150,3)                               00000840
      DIMENSION NSTAT(10,500)                                           00000850
      CHARACTER*4 CFLUX(150,3)
      INTEGER ILEN(3)                                                           
      INTEGER KCLC
      DATA ILEN /452,520,588/                                           00000850
      DIMENSION IRSTOR(7,3)                                             00000860
C     ABOVE IS STORAGE FOR SINGLES RATES A - G FOR DEBUG PRINTOUT       00000870
      DIMENSION IARATE(3),IBRATE(3),ICRATE(3),IDRATE(3),IERATE(3)       00000883
      DIMENSION IABNC(3),IDEFNG(3),IDENFG(3)                            00000886
      DIMENSION STIMES(3,3),IFRATE(3),IGRATE(3),ICHRT(3),               00000890
     *   IFHRT(3),IGHRT(3)                                              00000900
      REAL*4 DELJAY(500)                                                00000910
      DIMENSION IRDOT(500),RJAY(500),NOREC(500)                         00000920
      DIMENSION ZNOBOX(500),ZMATR(500),ZRATCT(500),ZRATED(500)          00000930
      DIMENSION ZPATED(500),ZPATCT(500)                                 00000940
      DIMENSION KLABEL(3),L1(3),L2(3),L3(3),L4(3)                       00000950
      CHARACTER*4 CKLABL(3)                                                     
      CHARACTER*4 EOF /'$EOF'/  , CHKEOF
      CHARACTER*8 EOV /'$EOF$EOF'/  , CHKEOV
      EQUIVALENCE (KLABEL(1),CKLABL(1))                                         
      DATA CKLABL/'IMP6','IMP7','IMP8'/                                 00000930
      DATA L1/33,39,33/,L2/66,100,106/,L3/105,122,125/,L4/16,19,16/     00000970
C   DATA FOR SINGLES RATES CHECKS                                       00001011
      DATA IARATE/0,37,40/,IBRATE/0,39,42/,IDRATE/0,43,46/              00001012
C           SINGLES  A               B      D                           00001013
      DATA IERATE/0,45,48/, ICRATE/0,41,44/, IABNC/0,25,24/             00001014
C                E                 C              A.B.^C                00001015
      DATA IFRATE/0,47,50/, IGRATE/0,49,52/, IDEFNG/0,33,34/            00001016
C              F               G              D.E.F.^G                  00001017
      DATA IDENFG/0,31,32/                                              00001018
C           D.E.^F.^G                                                   00001019
C  SET RATE ACCUM TIMES FOR DEAD TIME CORRECTION                        00001020
      DATA STIMES/0.,0.,0.,6*10.24/                                     00001030
C  SET HALFWORD ENTRIES                                                 00001060
      DATA ICHRT/0,83,89/,IFHRT/0,95,101/,IGHRT/0,99,105/               00001070
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00001080
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00001090
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00001100
C*******   CHANGE MINENG,MAXENG,MINFLX,MAXFLX, TO BE DIMENSIONED        00001110
C          TO 50 (FRAMES)                                               00001120
      COMMON /FRAME / ISTART,IYR1,ISTOP,IYR2,NORM2,MINENG(50),          00001130
     *                MAXENG(50),MINFLX(50),MAXFLX(50),                 00001140
     *                JRANGE,JRANUN,JAVER,NOAVU,IAVU,IFRMAX,QLINEX      00001150
      COMMON /GAP/    JOLD                                              00001160
C*******     144 -> 500                                                 00001170
      COMMON /GEOMF / GEOM(500,3),ELO(500,3),EUP(500,3),IPART(500,3),   00001180
     *                KEVENT(500,3),HMP8ST(500)                         00001190
      COMMON /MISC/   TACCUM(18,3),ZK(500,3),HLGRAT(18,3)               00001200
      COMMON /PERIGE/ XPERIG,JUP,IUP(100),JDN,IDN(100),QFILTR,QPER(250) 00001210
C*******  LOOP INDEX BECOMES I144 VARIABLE FROM NEW COMMON BLOCK LOOPS  00001220
      COMMON/LOOPS/ICOUNT(50),I144,I25,I50,I6                           00001230
C*******   ICOUNT COUNTS THE NUMBER OF DATA ITEMS FOR EACH SPECIFIED    00001240
C*******   S, SDEL 25 ->100 ; Y , YDEL 6 ->100                          00001250
      COMMON /POINTS/ S(100),SDEL(100),Y(250,100),YDEL(250,100),        00001260
     *                ITIME(250),IPTS,JKEY,QTHIST                       00001270
      COMMON /REKORD/ IFLUX(150,3)                                      00001280
      COMMON /SATLIT/ QSAT(3),QDAT(3)                                   00001290
      COMMON /TAPE  / INUNIT(3)                                         00001300
      COMMON /TREND / TCFACT,QTC,QDEBUG                                 00001310
      COMMON /DECICK/ QTIMCK                                            00001320
C                                                                       00001330
      EQUIVALENCE (IFLUX(1,1),HFLUX(1,1),RFLUX(1,1),CFLUX(1,1))
C     VARIABLES FOR TIME CHECKING                                       00001350
      INTEGER QGOOD, QONE, QTWO, QZERO, QSJOB                                   
      DATA QGOOD/0/,QONE/1/,QTWO/2/,QZERO/0/                            00001290
C     FIRST RECORD IN JOB FLAG                                          00001300
      DATA QSJOB/0/, QSTOPA/.FALSE./                                    00001310
C   CHECK ADDED TO PREVENT LOOPING IF I/O ERRORS ON DISK DATA          00001470
      IEOFER=0                                                          00001500
C   THE VARIABLES QSTOPA AND QSTOPB ARE ARRANGED TO AVOID               00001390
C   DUPLICATE (AND THUS MISLEADING) PRINT OUT MESSAGES                  00001400
C   REGARDING TIME CHECK CODE; THIS CAN OCCUR AT THE END                00001410
C   OF AN AVERAGING PERIOD/PLOT POINT PERIOD DUE TO                     00001420
C   THE NATURE OF THE FLXPLOT PROGRAM DETERMINING WHEN                  00001430
C   IT IS FINISHED FOR THE AVERAGING / PLOT POINT PERIOD .              00001440
C   THIS GENERAL FLXPLOT METHOD INVOLVES ENTRY-REENTRY INTO             00001450
C   FLXPSS  WITHOUT READING ANY NEW DATA INTO THE ARRAY                 00001460
C   IFLUX                                                               00001470
C   EXERCISE CAUTION IN ANY LOGIC MODIFICATIONS REGARDING               00001480
C   TIME AND THE DIFFERENT FLXPLOT OPTIONS                              00001490
C                                                                       00001500
C                                                                       00001510
C   SEE COMMENTS IN FLXTCK REGARDING TIME CHECKING                      00001520
C                                                                       00001530
C                                                                       00001540
C                                                                       00001550
C  INITIALIZE AT EACH ENTRY FOR TIME CHECKING WITHIN PLOT POINT         00001560
      IBADYR=0                                                          00001570
      NYRCNG=0                                                          00001580
      IBADDC=0                                                          00001590
      IBTWO=0                                                           00001600
      IBTHRE=0                                                          00001610
       QSTOPB=.FALSE.                                                   00001620
C                                                                       00001630
C   INITIALIZE STATISTICS ARRAYS, UNLESS CASE OF SPECTRUM OF MORE THAN  00001640
C   ONE TIME PERIOD, AND SOME DATA ALREADY ACCUMULATED.                 00001650
C                                                                       00001660
CP  IF (NO CURRENT DATA ACCUMULATED)                                    00001670
      IF (JOLD.EQ.1) GOTO 7                                             00001680
CP     ZERO OUT STATISTICS ARRAYS                                       00001690
      DO 5 I=1,10                                                       00001700
         DO 5 J=1,I144                                                  00001710
CP  FI                                                                  00001720
5           NSTAT(I,J) = 0                                              00001730
7     CONTINUE                                                          00001740
C                                                                       00001750
CP  INITIALIZE STOP TIME FOR AVERAGING PERIOD LOOP                      00001760
      IF (QTHIST) IAVEND = IUPPER - JAVER                               00001770
      IF (.NOT.QTHIST) IAVEND = ISTART                                  00001780
C                                                                       00001790
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00001800
C   START OF LOOP OVER PLOT POINT INTERVAL.                             00001810
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00001820
C                                                                       00001830
CP  DO FOR ALL DATA IN PLOT POINT                                       00001840
CP     GET RECORD TIME WITH RESPECT TO IYR1                             00001850
 10   IRECTM = IFLUX(1,KIMP)                                            00001860
      IRECY=HFLUX(3,KIMP)                                               00001870
      IRECD=IFLUX(1,KIMP)                                               00001880
C     IF (.NOT.QDEBUG) GO TO 6005                                       00001890
C           PRINT 6000,IRECTM,HFLUX(3,KIMP),IUPPER,QDAT(KIMP)           00001900
C6000       FORMAT(1H ,'FLXPSS STMT 6000',I15,5X,I5,5X,I15,5X,L1)       00001910
C6005       CONTINUE                                                    00001920
C                                                                       00001930
C   BEGIN TIME CHECKING CODE SECTION                                    00001940
C                                                                       00001950
      IF(QSJOB.NE.QZERO) GO TO 420                                      00001960
C   FIRST TIME JOB ENTRY FO FLXPSS ASSUMES RECORD IS OK, IT SHOULD      00001970
C   BE BECAUSE FLXPMT STOPS ONLY WHEN IT HAS FOUND YEAR AND DECISECS    00001980
C   AS GOOD                                                             00001990
      QSJOB=QONE                                                        00002000
      QGOOD=QTWO                                                        00002010
      IGYR=HFLUX(3,KIMP)                                                00002020
      IGDECI=IFLUX(1,KIMP)                                              00002030
C  FIRST TIME, BRANCH AROUND COMPARISON SECTION                         00002040
      GO TO 499                                                         00002050
 420  CONTINUE                                                          00002060
      IF(HFLUX(3,KIMP).EQ.IYR1 .AND. IRECTM.GE.IUPPER)QSTOPB=.TRUE.     00002070
      IF(QSTOPB) GO TO 20                                               00002080
C  NEED YEAR CHECK BELOW BECAUSE MAY HAVE 'NEXT YEAR' WITHIN            00002090
C  AVE PERIOD AND IRECTM CHECK AT STMT 20 NEEDS TO USE MODIFIED         00002100
C  RECORD DECISECS TO CORRECTLY COMPARE AT 20                           00002110
C                                                                       00002120
      IF(HFLUX(3,KIMP).EQ.IYR1.AND.QSTOPA) GO TO 20                     00002130
      IBRNCH=3                                                          00002140
      IF(HFLUX(3,KIMP).EQ.IYR1)IBRNCH=2                                 00002150
      IF (HFLUX(3,KIMP).EQ.IYR1) GOTO 399                               00002160
C  RECORD TIME DOES NOT EQUAL REQUESTED PLOT POINT START YEAR           00002170
C  IS THE YEAR ONE GREATER?                                             00002180
      IYRF=IYR1+1                                                       00002190
      IF(HFLUX(3,KIMP).EQ.IYRF) IBRNCH=1                                00002200
      IF(HFLUX(3,KIMP) .EQ.IYRF) GO TO 450                              00002210
C  YEAR IS PROBABLY BAD.  DECISECS MAY NOT BE MEANINGFUL  OR MAY BE     00002220
C       A DUPLICATE RECORD: BYPASS THE RECORD, FREAD THE NEXT           00002230
      IBADYR=IBADYR+1                                                   00002240
      QGOOD=QZERO                                                       00002250
      IBYR=HFLUX(3,KIMP)                                                00002260
      IBDECI=IFLUX(1,KIMP)                                              00002270
      PRINT 401, HFLUX(3,KIMP),IFLUX(1,KIMP),IGYR,IGDECI,IYR1,IBADYR    00002280
 401  FORMAT(1H ,'FLXPSS BAD YEAR FOUND- RECORD =',I6,5X,'DECISECS =',  00002290
     X I15,5X,'PREVIOUS GOOD=',I6,2X,I15,/1X,'REQUESTED IYR1 = ',I6,2X, 00002300
     XI10)                                                              00002310
      CALL PDUMP(IFLUX(1,KIMP),150,1,5,0)
      GO TO 210                                                         00002330
 450  CONTINUE                                                          00002340
C  PROBABLE YEAR CHANGE                                                 00002350
        IRECTM = IRECTM + 315360000                                     00002360
        IF (MOD(IYR1,4).EQ.0) IRECTM = IRECTM + 864000                  00002370
C                                                                       00002380
       IF(IRECTM.GE.IUPPER) QSTOPB=.TRUE.                               00002390
       IF(QSTOPB) GO TO 20                                              00002400
       IF(QSTOPA) GO TO 20                                              00002410
C                                                                       00002420
C   THE PREVIOUSLY STORED YEAR AND DECISEC MAY OR MAY NOT BE IN THE     00002430
C   'NEXT' YEAR FOR THIS AVERAGING PERIOD/PLOT POINT                    00002440
C   COUNT THE NUMBER OF ENTRIES TO THIS BRANCH OF CODE                  00002450
C                                                                       00002460
      NYRCNG=NYRCNG+1                                                   00002470
C      IS 'PREVIOUS' ALSO A YEAR CHANGE                                 00002480
C      BRANCH FOR DECISECOND CHECK ACCORDING TO QGOOD                   00002490
 399   CONTINUE                                                         00002500
       IF(KIMP.NE.1) GO TO 499                                          00002510
       IF(.NOT.QTIMCK) GO TO 499                                        00002520
      ICALL=1                                                           00002530
      CALL FLXTCK(IYR1,IRECTM,IBRNCH,ICALL,IBYR,IBDECI,IGYR,            00002540
     X     IGDECI,IRECY,IRECD,IBTWO,IBTHRE,IBADDC,IRET,QSJOB,QGOOD)     00002550
      IF(IRET.EQ.1) GO TO 210                                           00002560
C                                                                       00002570
 499   CONTINUE                                                         00002580
C   END OF TIME CHECK CODE                                              00002590
C                                                                       00002600
C                                                                       00002610
C                                                                       00002620
CP     IF (DATA TIME > POINT STOP TIME OR NO MORE DATA) EXIT            00002630
 20   IF (IRECTM.GE.IUPPER.OR..NOT.QDAT(KIMP)) GOTO 500                 00002640
C                                                                       00002650
CP     INITIALIZE BOX ARRAYS FOR ACCUMULATING DATA OVER THE AVERAGE     00002660
CP     INTERVAL.                                                        00002670
C   SKIP THIS IF CASE OF SPECTRUM OF MANY TIME PERIODS,                 00002680
C   SOME DATA ACCUMULATED ALREADY, AND ENTIRE TIME TO BE AVERAGED.      00002690
C                                                                       00002700
      IF (JOLD.EQ.1.AND.IAVLEN.EQ.0) GOTO 35                            00002710
      DO 30 I=1,I144                                                    00002720
         ZRATED(I) = 0.0                                                00002730
         ZNOBOX(I) = 0.0                                                00002740
         ZMATR(I)  = 0.0                                                00002750
         ZRATCT(I) = 0.0                                                00002760
         ZPATCT(I) = 0.0                                                00002770
         ZPATED(I) = 0.0                                                00002780
30       CONTINUE                                                       00002790
C    ZERO COUNTERS FOR DEAD TIME CORRECTION                             00002800
      CSUM=0.                                                           00002810
      CTSUM=0.                                                          00002820
      FSUM=0.                                                           00002830
      FTSUM=0.                                                          00002840
      GSUM=0.                                                           00002850
      GTSUM=0.                                                          00002860
      IF(.NOT.QDEBUG) GO TO 8000                                        00002870
      PRINT 8001                                                        00002880
8001  FORMAT(1H ,'FLXPSS - COUNTERS ZEROED AT 35')                      00002890
8000  CONTINUE                                                          00002900
35    CONTINUE                                                          00002910
C                                                                       00002920
CP     SET STOP TIME FOR AVERAGING INTERVAL.                            00002930
C   IF FLUX AVERAGE OVER ALL TIME (IAVLEN .LE. 0) THEN SET IUPPER       00002940
C   AS END ACCUMULATION TIME.                                           00002950
      IF (IAVLEN.EQ.0) IAVEND = IUPPER                                  00002960
C   IF AVERAGING PERIOD < POINT TIME, THEN END ACCUMULATION TIME        00002970
C   IS START PLUS AVERAGING INTERVAL.                                   00002980
      IF (IAVLEN.GT.0) IAVEND = IAVEND + IAVLEN                         00002990
C   IF NEW END TIME BEYOND END POINT TIME, RESET TO END POINT TIME.     00003000
      IF (IAVEND.GT.IUPPER) IAVEND = IUPPER                             00003010
      QSTOPA=.FALSE.                                                    00003020
C                                                                       00003030
C-----------------------------------------------------------------------00003040
C   START OF LOOP OVER AVERAGING PERIOD.                                00003050
C-----------------------------------------------------------------------00003060
C                                                                       00003070
CP     DO FOR ALL DATA IN AVERAGING TIME                                00003080
CP        GET RECORD TIME WITH RESPECT TO IYR1.                         00003090
40    IRECTM = IFLUX(1,KIMP)                                            00003100
      IRECY=HFLUX(3,KIMP)                                               00003110
      IRECD=IFLUX(1,KIMP)                                               00003120
C     IF(.NOT.QDEBUG) GO TO 6010                                        00003130
C        PRINT 6009,IRECTM,HFLUX(3,KIMP),IAVEND,IUPPER                  00003140
C6009    FORMAT(1H ,'FLXPSS STMT 6009',I15,5X,I5,5X,2I15)               00003150
C6010    CONTINUE                                                       00003160
C   IF FIRST RECORD OF JOB BYPASS TIME COMPARISON                       00003170
         IF(QSJOB.EQ. QONE) GO TO 799                                   00003180
C CHECK FOR END OF AVE PERIOD, AVOID DOUBLE P.O. FROM TIME CHECK        00003190
      IF(HFLUX(3,KIMP).EQ.IYR1.AND.IRECTM.GE.IAVEND)QSTOPA=.TRUE.       00003200
      IF(QSTOPA) GO TO 250                                              00003210
      IBRNCH=3                                                          00003220
      IF(HFLUX(3,KIMP).EQ.IYR1) IBRNCH=2                                00003230
      IF(HFLUX(3,KIMP).EQ.IYR1) GO TO 789                               00003240
C  RECORD TIME DOES NOT EQUAL REQUESTED PLOT POINT START YEAR           00003250
C  IS THE YEAR ONE GREATER?                                             00003260
      IYRF=IYR1+1                                                       00003270
      IF(HFLUX(3,KIMP).EQ.IYRF)IBRNCH=1                                 00003280
      IF(HFLUX(3,KIMP).EQ.IYRF) GO TO 451                               00003290
C  YEAR IS PROBABLY BAD.  DECISECS MAY NOT BE MEANINGFUL  OR MAY BE     00003300
C       A DUPLICATE RECORD: BYPASS THE RECORD, FREAD THE NEXT           00003310
      IBADYR=IBADYR+1                                                   00003320
      QGOOD=QZERO                                                       00003330
      IBYR=HFLUX(3,KIMP)                                                00003340
      IBDECI=IFLUX(1,KIMP)                                              00003350
      PRINT 401, HFLUX(3,KIMP),IFLUX(1,KIMP),IGYR,IGDECI,IYR1,IBADYR    00003360
      CALL PDUMP(IFLUX(1,KIMP),150,1,5,0)
      GO TO 210                                                         00003380
 451  CONTINUE                                                          00003390
C  PROBABLE YEAR CHANGE                                                 00003400
        IRECTM = IRECTM + 315360000                                     00003410
        IF (MOD(IYR1,4).EQ.0) IRECTM = IRECTM + 864000                  00003420
      IF(IRECTM.GE.IAVEND)QSTOPA=.TRUE.                                 00003430
      IF(QSTOPA) GO TO 250                                              00003440
C                                                                       00003450
C   THE PREVIOUSLY STORED YEAR AND DECISEC MAY OR MAY NOT BE IN THE     00003460
C   'NEXT' YEAR FOR THIS AVERAGING PERIOD/PLOT POINT                    00003470
C   COUNT THE NUMBER OF ENTRIES TO THIS BRANCH OF CODE                  00003480
C                                                                       00003490
      NYRCNG=NYRCNG+1                                                   00003500
 789   CONTINUE                                                         00003510
       IF(KIMP.NE.1) GO TO 799                                          00003520
       IF(.NOT.QTIMCK) GO TO 799                                        00003530
      ICALL=2                                                           00003540
      CALL FLXTCK(IYR1,IRECTM,IBRNCH,ICALL,IBYR,IBDECI,IGYR,            00003550
     X    IGDECI,IRECY,IRECD,IBTWO,IBTHRE,IBADDC,IRET,QSJOB,QGOOD)      00003560
      IF(IRET.EQ.1) GO TO 210                                           00003570
C                                                                       00003580
 799   CONTINUE                                                         00003590
C   END OF TIME CHECK CODE                                              00003600
C                                                                       00003610
C                                                                       00003620
C                                                                       00003630
C                                                                       00003640
CP        IF (DATA TIME > AVERAGING END TIME) EXIT                      00003650
C   EXIT FROM AVERAGING LOOP IF RECORD TIME OUTSIDE OF AVERAGING PERIOD.00003660
50     IF (IRECTM.GE.IAVEND) GOTO 250                                   00003670
C                                                                       00003680
CP        CHECK FOR CROSSING IMP-6 PERIGEE ALTITUDE                     00003690
      IF (KIMP.NE.1) GOTO 60                                            00003700
      IF (QTHIST) CALL FLXPAA                                           00003710
C   IF SUBPERIGEE AND QFILTR IS ON, SKIP TO NEXT INPUT DATA RECORD      00003720
      IF (.NOT.QFILTR.OR.RFLUX(5,1).GT.XPERIG) GOTO 60                  00003730
         QPER(IDAT) = .TRUE.                                            00003740
         GOTO 210                                                       00003750
C                                                                       00003760
CP        PERFORM TREND CHECK ON RATES IF REQUESTED.                    00003770
C   IF ANY RATE FAILS TREND CHECK, SKIP 5-MINUTE FLUX RECORD.           00003780
60    IF (QTC) CALL FLXPTC(KIMP,TCFACT,QFAIL)                           00003790
      IF (QTC.AND.QFAIL) GOTO 210                                       00003800
C                                                                       00003810
C                                                                       00003820
       IF(KIMP.EQ.1) GO TO 99                                           00003830
C     IF(.NOT.QDEBUG) GO TO 99                                          00003840
C     IRSTOR(1,1)=0                                                     00003850
C     CALL FMOVE(IRSTOR(2,1),80,IRSTOR(1,1))                            00003860
  99  CONTINUE                                                          00003870
C  IF IMP 6  BYPASS THIS SINGLES RATE CHECK                             00003880
      IF(KIMP.EQ.1) GO TO 105                                           00003890
C                                                                       00003900
C   FOR IMP 7 & 8 USE LEVENT TO DETERMINE IF THIS RATE IS LED OR MED.   00003910
C   USE SUM OF A+B+C+(A.B.^C) RATES FOR LED  OR                         00003915
C   SUM OF D+E+F+G+(D.E.F.^G)+(D.E.^F.^G) RATES FOR MED  TO GATE OUT    00003925
C   RECORDS THAT MAY BE 'OFF'                                           00003940
C   FOR IMP 7    LED  EVENT TYPES HAVE LEVENT = 1-4                     00003950
C                MED    "    "     "     "    = 5-8                     00003960
C   FOR IMP 8    LED    "    "     "     "    = 1-6                     00003970
C                MED    "    "     "     "    = 7-11                    00003980
C                                                                       00003990
C                                                                       00004000
C   FOR THE USE OF FLUXPLOT(DISPLACEMENT INTO FLUX RECORD), SINGLES     00004010
C      RATES USE EVENT TYPES :                                          00004020
C     FOR IMP-7  9-11  A,B,C                                            00004030
C                12-15   D,E,F,G                                        00004040
C     FOR IMP-8  12-14 A,B,C                                            00004050
C                15-18   D,E,F,G                                        00004060
C     FOR THESE CASES LEVEL WILL BE SET AS 12(IMP-7) OR                 00004070
C                                          15(IMP-8)                    00004080
C   IT IS ASSUMED THAT IF SINGLES RATES ARE REFERENCED, THAT            00004090
C   NO BOX COUNTS OR MATRIX COUNTS WILL BE AVAILABLE TO ACCUMULATE      00004100
C                                                                       00004110
C                                                                       00004120
      IATHIS = IFLUX(IARATE(KIMP),KIMP)                                 00004124
      IBTHIS = IFLUX(IBRATE(KIMP),KIMP)                                 00004128
      ICTHIS = IFLUX(ICRATE(KIMP),KIMP)                                 00004132
      IA1HIS = IFLUX(IABNC(KIMP),KIMP)                                  00004136
      IDTHIS = IFLUX(IDRATE(KIMP),KIMP)                                 00004140
      IETHIS = IFLUX(IERATE(KIMP),KIMP)                                 00004144
      IFTHIS = IFLUX(IFRATE(KIMP),KIMP)                                 00004148
      IGTHIS = IFLUX(IGRATE(KIMP),KIMP)                                 00004152
      IE1HIS = IFLUX(IDEFNG(KIMP),KIMP)                                 00004156
      IE2HIS = IFLUX(IDENFG(KIMP),KIMP)                                 00004160
      IRTHIS = IATHIS + IBTHIS + ICTHIS + IA1HIS                        00004161
      IRTHI2 = IDTHIS + IETHIS + IFTHIS + IGTHIS + IE1HIS + IE2HIS      00004162
C      LED CHECK                                                        00004210
      QLED=.TRUE.                                                       00004220
      IF(IRTHIS .GT.0) QLED=.FALSE.                                     00004230
C      MED CHECK                                                        00004240
      QMED=.TRUE.                                                       00004250
      IF(IRTHI2.GT.0) QMED=.FALSE.                                      00004260
 105   CONTINUE                                                         00004270
C   ADD UP SINGLES RATES FOR DEAD TIME CORRECTION                       00004280
C  DO NOT ADD UP IF RECORD FOR LED OR MED HAS BEEN ELIMINATED           00004290
C  ON THE BASIS OF THE IMMEDIATELY ABOVE CRITERION                      00004300
C  IF RECORD IS ACCEPTED ON ABOVE BASIS FOR LED                         00004310
       IF(QLED) GO TO 106                                               00004320
        CSUM=CSUM+ IFLUX(ICRATE(KIMP),KIMP)                             00004330
        CTSUM=CTSUM +HFLUX(ICHRT(KIMP),KIMP) * STIMES(1,KIMP)           00004340
C  FI                                                                   00004350
C  IF  ACCEPTED FOF MED                                                 00004360
 106   CONTINUE                                                         00004370
        IF(QMED) GO TO 110                                              00004380
      FSUM=FSUM + IFLUX(IFRATE(KIMP),KIMP)                              00004390
       FTSUM=FTSUM + HFLUX(IFHRT(KIMP),KIMP) * STIMES(2,KIMP)           00004400
      GSUM=GSUM+ IFLUX(IGRATE(KIMP),KIMP)                               00004410
      GTSUM=GTSUM + HFLUX(IGHRT(KIMP),KIMP) * STIMES(3,KIMP)            00004420
C  FI                                                                   00004430
 110   CONTINUE                                                         00004440
      LEVEL=5                                                           00004450
      IF(KIMP.EQ.3) LEVEL=7                                             00004460
      IF(KIMP .EQ.2 .AND. LEVENT .GT. 8) LEVEL = 12                     00004470
      IF(KIMP .EQ.3 .AND. LEVENT .GT.11) LEVEL = 15                     00004480
C   ACCUMULATE FLUX CALCULATION PARAMETERS FOR ALL REQUIRED BOXES.      00004490
C     ZNOBOX = COUNTS IN FLUX BOX      ZMATR = COUNTS IN EVENT MATRIX   00004500
C     ZRATED = RATE TIME, SEC.         ZRATCT = RATE COUNTS             00004510
C                                                                       00004520
CP        DO FOR ALL REQUESTED BOXES                                    00004530
      DO 100 I=1,I144                                                   00004540
        IF (.NOT.QBOX(I,KIMP)) GOTO 100                                 00004550
        LEVENT = KEVENT(I,KIMP)                                         00004560
          IF(LEVENT .EQ.0) GO TO 100                                    00004570
C   APPLY SINGLES CHECK                                                 00004580
      IF(KIMP.EQ.1) GO TO 114                                           00004590
      IF(LEVENT.GE.LEVEL.AND. QMED) GO TO 100                           00004600
      IF(LEVENT.LT.LEVEL .AND. QLED) GO TO 100                          00004610
 114   CONTINUE                                                         00004620
C                                                                       00004630
C  END CHECK FOR SINGLES RATES                                          00004640
CP           ACCUMULATE RATE READ OUT TIMES                             00004650
        ZRATED(I) = ZRATED(I) + HFLUX(L1(KIMP)+LEVENT*4,KIMP)           00004660
     *                                       *TACCUM(LEVENT,KIMP)       00004670
CP           ACCUMULATE RATE COUNTS                                     00004680
        ZRATCT(I) = ZRATCT(I) + IFLUX(L4(KIMP)+LEVENT*2,KIMP)           00004690
CP           ACCUMULATE BOX COUNTS                                      00004700
C      AGAIN, IF SINGLES RATES ARE REFERENCED, NO DATA APPLIES          00004710
            IF(KIMP.EQ.1 .AND. LEVENT .GT. 8) GO TO 98                  00004720
            IF(KIMP.EQ.2 .AND. LEVENT .GT. 8) GO TO 98                  00004730
            IF(KIMP.EQ.3 .AND. LEVENT .GT. 11) GO TO 98                 00004740
C                                                                       00004750
C      FOR ZNOBOX ACCUMULATION, +I IS ADDED TO L2(KIMP) TO OBTAIN       00004760
C      DISPLACEMENT INDEX INTO FLUX RECORD.  FOR BOXES GREATER THAN     00004770
C      144, THIS CALC. IS INVALID. AS OF 4/87 NO PHA BOXES GREATER      00004780
C      THAN 144 EXIST.  IF SUCH DID EXIST, A VIRTUAL BOX CROSS          00004790
C       REFERENCE COULD BE MADE, IE, II=VIRBOX(I), AND                  00004800
C      DISPLACEMENT = L2(KIMP)+II                                       00004810
        ZNOBOX(I) = ZNOBOX(I) + HFLUX(L2(KIMP)+I       ,KIMP)           00004820
CP           ACCUMULATE MATRIX COUNTS                                   00004830
        ZMATR(I)  = ZMATR(I)  + IFLUX(L3(KIMP)+LEVENT  ,KIMP)           00004840
98    CONTINUE                                                          00004850
C                                                                       00004860
C   IF EVENT TYPE REQUIRES RATE DIFFERENCE, ACCUMULATE LOW GAIN RATE.   00004870
C  'MEVENT' IS LOW GAIN RATE FOR EVENT RATE 'LEVENT'.                   00004880
CP           IF (BOX REQUIRES LOW GAIN RATE)                            00004890
        MEVENT = HLGRAT(LEVENT,KIMP)                                    00004900
        IF (MEVENT.EQ.0) GOTO 100                                       00004910
CP              ACCUMULATE LOW GAIN RATE READ OUT TIMES                 00004920
        ZPATED(I) = ZPATED(I) + HFLUX(L1(KIMP)+MEVENT*4,KIMP)           00004930
     *                                       *TACCUM(MEVENT,KIMP)       00004940
CP              ACCUMULATE LOW GAIN RATE COUNTS                         00004950
        ZPATCT(I) = ZPATCT(I) + IFLUX(L4(KIMP)+MEVENT*2,KIMP)           00004960
CP           FI                                                         00004970
CP        OD                                                            00004980
100     CONTINUE                                                        00004990
C                                                                       00005000
C   PRINT OUT RATES IF DEBUG OPTION IS ON                               00005010
C                                                                       00005020
      IF(KIMP.EQ.1) GO TO 101                                           00005030
C     IF(.NOT. QDEBUG) GO TO 101                                        00005040
C     PRINT 107,KIMP,IRECTM                                             00005050
C107  FORMAT(1H ,'SINGLES RATES FOR IMP',I3,'      TIME(DECISECONDS)=', 00005060
C    X I15)                                                             00005070
C     ISTRT=IARATE(KIMP)                                                00005080
C     ISTP = ISTRT + 12                                                 00005090
C     IPLACE=0                                                          00005100
C     DO 103 IRATE=ISTRT,ISTP,2                                         00005110
C                 IPLACE=IPLACE+1                                       00005120
C                IRSTOR(IPLACE,1) = IFLUX(IRATE,KIMP)                   00005130
C                IRSTOR(IPLACE,2) = HFLUX( (2*IRATE+1),KIMP)            00005140
C                IRSTOR(IPLACE,3) = HFLUX( (2*IRATE+2),KIMP)            00005150
C103  CONTINUE                                                          00005160
C     PRINT 104,((IRSTOR(IP1,IP2),IP2=1,3),IP1=1,7)                     00005170
C104  FORMAT(1X ,3(I15,2I10),/1X,3(I15,2I10),/1X,I15,2I10)              00005180
 101  CONTINUE                                                          00005190
C                                                                       00005200
C                                                                       00005210
C                                                                       00005220
C   READ NEXT DATA RECORD.                                              00005230
CP        READ NEXT DATA RECORD                                         00005240
210   CALL FREAD(IFLUX(1,KIMP),INUNIT(KIMP),LEN,*220,*211)              00005250
C                                                                               
      LENF = ILEN(KIMP)                                                         
C                                                                               
C                                                                               
C     CHECK FOR LOGICAL END OF FILE ON  DISK FILE                               
      CALL FMOVE(CHKEOV,8,CFLUX(1,KIMP))
      CALL CNVEBC(CHKEOV,8)
      IEOV   = KCLC(CHKEOV,1,EOV,1,8)
      IF (IEOV .EQ. 0)  GO TO 220
      CALL FMOVE(CHKEOF,4,CFLUX(1,KIMP))
      CALL CNVEBC(CHKEOF,4)
      IEOF   = KCLC(CHKEOF,1,EOF,1,4)
      IF (IEOF .EQ. 0)  GO TO 220
C                                                                       00001160
180   CONTINUE
C    GET TIME FOR TESTING
      ITTTT = IFLUX(1,KIMP)
      IYYYY = HFLUX(3,KIMP)
      IOOOO = HFLUX(4,KIMP)
C                                                                               
         ICNT = ICNT + 1                                                        
C    FIXUP FOR RECORDS WITH BAD DECISECS - PAS - 9/87                   00005251
              IF(IFLUX(1,KIMP) .GT. 316224000) PRINT 213                00005252
213   FORMAT(1H ,'FLXPSS(FLEXPLOT) *** WARNING *** SKIPPING',           00005253
     X ' RECORD BECAUSE DECISECS VALUE IS BAD ' )                       00005254
              IF(IFLUX(1,KIMP) .GT. 316224000) GO TO 210                00005257
C     SET QSJOB  FOR PART OF TIME CHECK CODE LOGIC                      00005260
         QSJOB=QTWO                                                     00005270
      GOTO 40                                                           00005280
C                                                                       00005290
C   I/O ERROR READING INPUT RECORD.                                     00005300
211   PRINT 212, KLABEL(KIMP)                                           00005310
212   FORMAT(' I/O ERROR ON ',A4,' FLUX TAPE.')                         00005320
      GOTO 210                                                          00005330
220   CALL FLXPMT(2,KIMP,QDATA)                                         00005340
C      IF(.NOT.QDEBUG) GO TO 6020                                       00005350
         PRINT 6019,QDATA                                               00005360
 6019    FORMAT(1H ,'FLXPSS -  FLXPMT JUST CALLED, QDATA= ',L1)         00005370
      CALL UNPACK(IYYYY,ITTTT,IMO,IDAYM,IHR,IMIN,ISEC)
      IYY = IYYYY - 1900
CP        PRINT MESSAGE                                                 00001370
      WRITE(6,1000)KIMP,IMO,IDAYM,IYY,IHR,IMIN,ISEC, IOOOO
1000  FORMAT('     IMP-',I1,' TIME FOR RECORD AT EOF    ',
     *I2,'/',I2,'/',I2,I3,':',I2,':',I2,3X,I5)
 6020    CONTINUE                                                       00005380
      IF (QDATA) GOTO 210                                               00005390
      QDAT(KIMP) = .FALSE.                                              00005400
      GOTO 250                                                          00005410
CP     OD        (END OF DATA AVERAGING INTERVAL LOOP)                  00005420
C-----------------------------------------------------------------------00005430
C   END OF LOOP OVER AVERAGING PERIOD.                                  00005440
C-----------------------------------------------------------------------00005450
C                                                                       00005460
250   CONTINUE                                                          00005470
      IF (.NOT.QDEBUG) GOTO 251                                         00005480
C                                                                       00005490
CP     DEBUG PRINTOUT IF REQUESTED                                      00005500
C   TEST PRINTOUT *********************************************         00005510
      DO 2000 I=1,I144                                                  00005520
         IF (.NOT.QBOX(I,KIMP)) GOTO 2000                               00005530
         PRINT 2001,I,ZRATED(I),ZNOBOX(I),ZMATR(I),ZRATCT(I),           00005540
     *              ZPATCT(I),ZPATED(I)                                 00005550
2001     FORMAT(5X,I3,5X,6E15.8)                                        00005560
2000     CONTINUE                                                       00005570
      IF(KIMP.EQ.1) GO TO 111                                           00005580
      PRINT 2002,CSUM,CTSUM,FSUM,FTSUM,GSUM,GTSUM                       00005590
2002   FORMAT(1H ,'C,F,G DEAD TIME SUMS',5X,6E15.8)                     00005600
 111   CONTINUE                                                         00005610
C   END TEST PRINTOUT *****************************************         00005620
C                                                                       00005630
251   CONTINUE                                                          00005640
C    ADD (AFTER FLUXPLOT)  TO HANDLE EOF RECORDS
      IF (.NOT. QDAT(KIMP)) GO TO 588
      IF(IRECTM .LT. IUPPER  .AND. IAVLEN .EQ. 0) GO TO 35
588   CONTINUE
C   IF CURRENT DATA IS TO BE ADDED TO (JKEY=1) AND AVERAGING IS OVER    00005660
C   ALL REQUESTED TIMES, EXIT ROUTINE FOR NEW TIME PERIOD.              00005670
CP     IF (MORE DATA TO READ FROM INPUT CARDS) EXIT                     00005680
      IF (JKEY.EQ.1.AND.IAVLEN.EQ.0) GOTO 500                           00005690
C                                                                       00005700
C   CALCULATE AVERAGING SUMS.                                           00005710
C  GET DEAD TIME CORRECTION FACTORS                                     00005720
      IF(KIMP.EQ.1) GO TO 112                                           00005730
      DEADK= 7.0 / (10.**6)                                             00005740
C                                                                       00005750
C  LED DEAD TIME                                                        00005760
      CDCOR=1.0                                                         00005770
       IF(CTSUM .GT. 0.0) CDEAD= CSUM/CTSUM                             00005780
       IF(CTSUM .GT. 0.0) CDEADT=CDEAD * DEADK                          00005790
       IF(CTSUM .GT. 0.0) CDCOR = 1.0 / (1.0 - CDEADT)                  00005800
C                                                                       00005810
C  MED CORRECTIONS                                                      00005820
      GFCOR=1.0                                                         00005830
       IF(GTSUM.GT. 0.0) GDEAD= GSUM/GTSUM                              00005840
       IF(FTSUM.GT. 0.0) FDEAD= FSUM/FTSUM                              00005850
C                                                                       00005860
C   CORRECTION FOR D-E-F'-G'  EVENTS  FOR IMP8 EVENT TYPES 8,10,11      00005870
C                                         IMP7  "      "   6,8          00005880
       IF(GTSUM.GT.0.0 .AND.FTSUM.GT.0.0) GFDEAD= (GDEAD+FDEAD)* DEADK  00005890
       IF(GTSUM.GT.0.0 .AND.FTSUM.GT.0.0) GFCOR= 1.0 / (1.0 - GFDEAD)   00005900
C                                                                       00005910
C   CORRECTION FOR D-E-F-G'  EVENTS   FOR IMP8 EVENT TYPE 9             00005920
C                                         IMP7  "     "   7             00005930
      GDCOR=1.0                                                         00005940
       IF(GTSUM.GT. 0.0) GDEADT= GDEAD * DEADK                          00005950
       IF(GTSUM.GT. 0.0) GDCOR= 1.0 / (1.0- GDEADT)                     00005960
           IF(.NOT.QDEBUG) GO TO 117                                    00005970
             PRINT 2003,CDCOR,GFCOR,GDCOR                               00005980
 2003        FORMAT(1H ,'DEAD TIME CORRECTIONS' ,3E15.8)                00005990
 117        CONTINUE                                                    00006000
 112   CONTINUE                                                         00006010
C                                                                       00006020
CP     DO FOR EACH BOX REQUESTED                                        00006030
         WRITE(6,368)                                                           
C        WRITE(9,368)
368      FORMAT(1H ,'FLXPSS   FLUX CODE ENTERED ')                      00002720
      DO 270 I=1,I144                                                   00006040
         IF (.NOT.QBOX(I,KIMP)) GOTO 270                                00006050
         LEVENT = KEVENT(I,KIMP)                                        00006060
         IF(LEVENT .EQ. 0) GO TO 270                                    00006070
C                                                                       00006080
CP        IF (ZERO RATE READOUTS)  SKIP THE BOX                         00006090
C                                                                       00006100
C        NSTAT(1,I) = # PERIODS PROCESSED.                              00006110
         NSTAT(1,I) = NSTAT(1,I) + 1                                    00006120
C                                                                       00006130
         IF (ZRATED(I).GT.0.0) GOTO 280                                 00006140
C           NSTAT(2,I) = # PERIODS REJECTED DUE TO ZERO RATE READOUTS   00006150
            NSTAT(2,I) = NSTAT(2,I) + 1                                 00006160
            GOTO 270                                                    00006170
C                                                                       00006180
C  FOR BOXES 401-418:                                                   00006190
C  BOX STORAGE AREAS IN THIS PROGRAM ARE NOW REFERENCED TO              00006200
C  EVENT TYPES AS CODED IN THE MEMBER FLXPBL:COMMON/KEVENT/             00006210
C  ACTUAL BOXES FOR 401-418 ARE NOT DEFINED (THISDATE=10/18/79)         00006220
C  AND IT WAS DESIRED TO HAVE ACCESS TO RATES AS WELL AS FLUXES         00006230
C  IN THE OUTPUT TAPES OF THE FLXPLOT PROGRAM.                          00006240
C  THERE MAY BE OTHER IMPLICATIONS OF THIS CHANGE, AS WOULD BE          00006250
C  REFLECTED IN THE POSITIONS CORRESPONDING TO BOXES 401-418, IN OTHER  00006260
C  OF THE COMMON BLOCKS IN MEMBER FLXPBL.  THIS LIKELYHOOD NEEDS TO     00006270
C  BE THOUGHT THROUGH FOR SURE!                                         00006280
C                                                                       00006290
C  FOLLOWING CODE WAS ADDED:                                            00006300
C                                                                       00006310
C  LOGIC FOR RATE BOXES (ADDED 10/01/79 BY R. MCGUIRE)                  00006320
CP        IF(RATE BOXES 401-418 SELECTED) CALCULATE CTS/SEC AND ERROR   00006330
CP             AND SKIP FLUX CALCULATION.                               00006340
280       IF(I .LE. 400 .OR. I .GT. 418) GO TO 253                      00006350
          RATE = ZRATCT(I)/ZRATED(I)                                    00006360
          ERRATE = 1.0                                                  00006370
          IF(ZRATCT(I).GT.0.) ERRATE = 1./SQRT(ZRATCT(I))               00006380
          RJAY(I) = RJAY(I) + RATE                                      00006390
          NOREC(I) = NOREC(I) + 1                                       00006400
          DELJAY(I) = DELJAY(I) + ERRATE*ERRATE*RATE*RATE               00006410
          GO TO 270                                                     00006420
C                                                                       00006430
C                                                                       00006440
CP        IF (MATRIX COUNTS = 0 AND RATE COUNTS > 0)  SKIP BOX          00006450
253      IF (ZMATR(I).GT.0.0) GOTO 256                                  00006460
C           NSTAT(3,I) = # PERIODS WITH ZERO MATRIX COUNTS              00006470
            NSTAT(3,I) = NSTAT(3,I) + 1                                 00006480
            IF (ZRATCT(I).GT.0.0) GOTO 270                              00006490
C                                                                       00006500
C        NSTAT(4,I) = # PERIODS WITH ZERO RATE COUNTS                   00006510
256      IF (ZRATCT(I).EQ.0.0) NSTAT(4,I) = NSTAT(4,I) + 1              00006520
C                                                                       00006530
C        NSTAT(5,I) = # PERIODS WITH ZERO BOX COUNTS                    00006540
         IF (ZNOBOX(I).EQ.0.0) NSTAT(5,I) = NSTAT(5,I) + 1              00006550
C                                                                       00006560
CP        CALCULATE RATE AND ERROR IN RATE                              00006570
         RATE = ZRATCT(I)/ZRATED(I)                                     00006580
         ERRATE = 1.0                                                   00006590
         IF (ZRATCT(I).GT.0.0) ERRATE = 1.0/SQRT(ZRATCT(I))             00006600
CP        IF RATE DIFFERENCE REQUIRED, SUBTRACT CORRESP. LOW GAIN RATE. 00006610
         IF (HLGRAT(LEVENT,KIMP).EQ.0.OR.ZPATED(I).EQ.0.0) GOTO 260     00006620
         PRMRAT = ZPATCT(I)/ZPATED(I)                                   00006630
         ERRATE = SQRT(RATE/ZRATED(I) + PRMRAT/ZPATED(I))               00006640
         IF (RATE.GT.PRMRAT) RATE = RATE - PRMRAT                       00006650
         IF (RATE.GT.0.0) ERRATE = ERRATE/RATE                          00006660
260      CONTINUE                                                       00006670
C  APPLY DEAD TIME CORRECTIONS TO RATES                                 00006680
      IF(KIMP.EQ.1) GO TO 113                                           00006690
      LEVELL=5                                                          00006700
      IF(KIMP.EQ.3) LEVELL=7                                            00006710
      IF(LEVENT.GE.LEVELL) GO TO 261                                    00006720
C   LED EVENTS                                                          00006730
      RATE = RATE * CDCOR                                               00006740
      GO TO 113                                                         00006750
 261   CONTINUE                                                         00006760
C     MED EVENTS                                                        00006770
      IF(KIMP.EQ.3) GO TO 262                                           00006780
C   IMP-7                                                               00006790
           DEAD7=1.0                                                    00006800
           IF(LEVENT.EQ.7) DEAD7=GDCOR                                  00006810
           IF(LEVENT.EQ.6.OR.LEVENT.EQ.8) DEAD7=GFCOR                   00006820
           RATE=RATE* DEAD7                                             00006830
      GO TO 113                                                         00006840
  262  CONTINUE                                                         00006850
C  IMP-8                                                                00006860
          DEAD8=1.0                                                     00006870
          IF(LEVENT.EQ.9) DEAD8=GDCOR                                   00006880
          IF(LEVENT.EQ.8.OR.LEVENT.EQ.10.OR.LEVENT.EQ.11)               00006890
     2          DEAD8=GFCOR                                             00006900
          RATE=RATE * DEAD8                                             00006910
  113    CONTINUE                                                       00006920
C                                                                       00006930
CP        CALCULATE 'FLUX' RJAY AND 'FLUX ERROR' DELJAY                 00006940
         RIJAY = 0                                                      00006950
         IF (ZMATR(I).GT.0.0) RIJAY = (ZNOBOX(I)/ZMATR(I))*RATE         00006960
C   KEEP THE NEXT ALTERNATIVE?  NO, SAYS R. MCGUIRE, 11/14/77           00006970
C        IF (ZMATR(I).EQ.0.0) RIJAY = (1.0/ZK(I,KIMP))*RATE             00006980
         RJAY(I) = RJAY(I) + RIJAY                                      00006990
         NOREC(I) = NOREC(I) + 1                                        00007000
C                                                                       00007010
            YNOBOX = AMAX1(ZNOBOX(I),1.0)                               00007020
            YMATR  = AMAX1(ZMATR(I) ,1.0)                               00007030
            RJJAY  = RIJAY                                              00007040
            IF (RJJAY.EQ.0.0) RJJAY = (1.0/YMATR)*RATE                  00007050
C   ERRORS CALCULATED HERE OVERESTIMATE ERROR BECAUSE SAME EVENTS       00007060
C   MAY CONTRIBUTE TO RATE, MATRIX, AND/OR BOX COUNTS.                  00007070
         DELJAY(I) = DELJAY(I) + (RJJAY*RJJAY)*                         00007080
     *                (1.0/YNOBOX)                                      00007090
C  ERROR RELAXED AS OF 4/23/80  - BEFORE THATDATE BELOW WAS USED        00007100
C    *               ((1.0/YNOBOX) + (1.0/YMATR) + ERRATE*ERRATE)       00007110
C                                                                       00007120
CP     OD         (END OF BOX LOOP)                                     00007130
270   CONTINUE                                                          00007140
C                                                                       00007150
C   GO BACK TO TEST IF CURRENT DATA STILL WITHIN POINT-TIME             00007160
C   ADD FOR DISK VSN                                                    00007150
C   FOR EOF,EOV FROM DISK FILES, QDAT(KIMP) = FALSE SHOULD EXIT HERE    00007150
      IF(.NOT. QDAT(KIMP)) GO TO 500                                    00007150
      GOTO 10                                                           00007170
CP  OD            (END OF PLOT POINT LOOP)                              00007180
C                                                                       00007190
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00007200
C   END OF LOOP OVER PLOT POINT INTERVAL.                               00007210
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC00007220
C                                                                       00007230
500   CONTINUE                                                          00007240
C     PRINT 501,NYRCNG,IBTWO,IBTHRE                                     00007250
C501   FORMAT(1H ,'FLXPSS EXITING - NYRCNG,IBTWO,IBTHRE= ',3I5)         00007260
      RETURN                                                            00007270
      END                                                               00007280
