CH1   SUBROUTINE FLXPBX                                                 00000010
CH                                                                      00000020
CH2  FUNCTIONAL DESCRIPTION:                                            00000030
CH2   CHECKS LEGALITY OF BIN DEFINITIONS AND DETERMINES PRESENCE        00000040
CH2   OF FORWARD AND BACKWARD CONDITIONS OF A PENETRATING BOX.          00000050
CH                                                                      00000060
CH3  CALLING ROUTINES:  FLXPIN                                          00000070
CH                                                                      00000080
CH4  SUBROUTINES CALLED:  NONE                                          00000090
CH                                                                      00000100
CH5  VARIABLE CROSS REFERENCE:                                          00000110
CH5    NAME         TYPE   I/O        DESCRIPTION                       00000120
CH5   NUMBIN         I*4    I    NUMBER OF REQUESTED BINS               00000130
CH5   JBOX(10,100)   I*4    I    REQUESTED BOXES                        00000140
CH5   NEXTL1         I*4         LOCAL STORAGE OF NEXT EXPECTED BOX     00000150
CH5   NEXTL2         I*4           "      "                             00000160
CH5   QFB(10,100)    L*1    O    FLAG TO INDICATE BOTH FORWARD AND      00000170
CH5                              BACKWARD BOXES OF PENETRATING EVENT.   00000180
CH                                                                      00000190
CH6  METHOD:                                                            00000200
CH6    BACKGROUND:  IN ORDER FOR A FLUX BIN TO BE PROPERLY              00000210
CH6    CALCULATED, IT MUST CONSIST OF BOXES OF THE SAME PARTICLE        00000220
CH6    TYPE WITH ADJACENT ENERGY RANGES.  THIS DEFINES A LEGAL          00000230
CH6    BIN.  (NOTE THAT THE ELECTRON BOXES ARE NOT TREATED AS           00000240
CH6    FLUX, SINCE THERE ARE PLOTTED AS COUNTS/SEC).                    00000250
CH6    ALSO, CERTAIN PENETRATING BOXES HAVE BOTH FORWARD AND            00000260
CH6    BACKWARD COMPONENTS SEPARATELY DEFINED (ALPHA BOXES              00000270
CH6    42-49, PROTON BOXES 60-65).  TO PROPERLY ACCOUNT FOR BOTH        00000280
CH6    DIRECTIONS IN A BIN REQUEST, THE GEOMETRY FACTOR HAS TO          00000290
CH6    BE INCREASED BY A FACTOR OF 2.                                   00000300
CH5  THIS ROUTINE SERVES TWO FUNCTIONS:                                 00000310
CH5     (1) TO ENSURE THAT NO BIN CONTAINS ILLEGAL COMBOS OF BOXES.     00000320
CH5     (2) TO SET UP THE QFB ARRAY, WHICH IS USED TO SIGNAL THE        00000330
CH5         PROCESSING ROUTINE (FLXPA) THAT A                           00000340
CH5         PENETRATING BOX IS BEING ACCUMULATED WITH BOTH FORWARD      00000350
CH5         AND BACKWARD ELEMENTS TOGETHER (AND HENCE THE GEOMETRY      00000360
CH5         FACTOR SHOULD BE DOUBLED).                                  00000370
CH5  THE FOLLOWING COMBINATIONS OF ADJACENT BOXES ARE ALLOWED           00000380
CH5  FOR ANY DEFINED BIN:  (ONLY)                                       00000390
CH5     1,2,3,4,5,6,12,13,14,15                                         00000400
CH5     7,8,9,10,11,16,17,18,19                                         00000410
CH5     30,31,32,33,34,35                                               00000420
CH5     36,37,38,39,40,41                                               00000430
CH5     (48,49),50,51,52,53,54,55,56                                    00000440
CH5     (42,43),(44,45)                                                 00000450
CH5     (60,61),(62,63),(64,65)                                         00000460
CH5     72,73,74,75,76                                                  00000470
CH5     THE PAIRS IN PARENTHESES ARE THE FORWARD AND BACKWARD PAIRS     00000480
CH5  ALLUDED TO IN PART (2) ABOVE.  IN BIN COMBINATIONS, EITHER         00000490
CH5  OR BOTH OF THE PAIR MAY BE USED.                                   00000500
CH5  FOR LOW GAIN BOXES (20-28, 111-120), NO CHECKING ON INPUT.         00000510
CH                                                                      00000520
CH7  PROGRAMMER:  J. CHILDS, 2/77.                                      00000530
CH                                                                      00000540
CH8  MODIFICATION:  J. CHILDS, 11/78 -- IF ILLEGAL BOX COMBINATION      00000550
CH8                 DETECTED, MESSAGE PRINTED ONLY (NO ABEND).          00000560
CH8  EWR 6/79 RESET NEXT TO ISOLATE BOX 67 AND 68 = PR+ALPHA            00000570
CH                                                                      00000580
CH8  MODIFICATION, 11/86,  P. SCHUSTER;  IMPLEMENT MCGUIRE TASK         00000590
CH8                        CHANGES                                      00000600
CH                                                                      00000610
CH9  IMP-6/7/8, FLUX PLOT, FLXPBX, V2A.   (FOR FLEXPLOT PROGRAM)        00000620
CH**********************************************************************00000630
C                                                                       00000640
      SUBROUTINE FLXPBX                                                 00000650
C                                                                       00000660
      IMPLICIT LOGICAL*1(Q),INTEGER*2(H)                                00000670
C*******  25 -> 100   144 -> 500                                        00000680
      COMMON /BINS/   NUMBIN,JBOX(10,100),IMP(100),JFRAME(100),         00000690
     *                JCHAR(100),XNORM(100),JPRTBN(100),ELOBN(100),     00000700
     *                EUPBN(100),QBOX(500,3),QFB(10,100)                00000710
C*******  LOOP INDEX BECOMES I25 VARIABLE FROM NEW COMMON BLOCK LOOPS   00000720
      COMMON/LOOPS/ICOUNT(50),I144,I25,I50,I6,IFR80                     00000730
      INTEGER*2 NEXT(2,144)/                                            00000740
     * 2, 2,  3, 3,  4, 4,  5, 5,  6, 6, 12,12,  8, 8,  9, 9, 10,10,    00000750
     *11,11, 16,16, 133,133, 134,134, 135,135,  137,137, 46,46, 47,47,  00000760
     * 57,57,                                                           00000770
     * 58,58, 21,21, 22,22, 23,23,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,   00000780
     * 0, 0,  0, 0, 31,31, 32,32, 33,33, 34,34, 35,35,  0, 0, 37,37,    00000790
     *38,38, 39,39, 40,40, 41,41,  0, 0, 42,44,  0, 0, 44,44,  0, 0,    00000800
     * 17,17,  18,18, 48,50,  0, 0, 51,51, 52,52, 53,53, 54,54, 55,55,  00000810
     *56,56,  0, 0, 19,19, 59,59,  0, 0, 60,62,  0, 0, 62,64,  0, 0,    00000820
     *64,64,  0, 0,  0, 0, 70,70, 68,68,  0, 0,  0, 0,  0, 0, 73,73,    00000830
     *74,74, 75,75, 76,76,  0, 0, 108*0,                                00000840
     * 13,13, 14,14, 136,136, 15,15, 0,0, 10*0, 8 * 0/                  00000850
C                                                                       00000860
C   FOR EACH BIN, CHECK THE BOXES THEREIN - IF THE EXPECTED NEXT BOX    00000870
C   VALUE DOES NOT MATCH THE ACTUAL NEXT VALUE, REJECT THE COMBINATION  00000880
C   AND STOP THE PROGRAM.                                               00000890
CP  FOR EACH BIN REQUESTED                                              00000900
      DO 30 K=1,NUMBIN                                                  00000910
CP     FOR EACH BOX REQUESTED                                           00000920
        DO 20 J=1,10                                                    00000930
          L = JBOX(J,K)                                                 00000940
          IF (L.EQ.0) GOTO 30                                           00000950
C         SKIP LOW GAIN BOXES:                                          00000960
CP        IF (NOT LOW GAIN BOX)                                         00000970
          IF ((L.GE.20.AND.L.LE.28).OR.(L.GE.111.AND.L.LE.120)) GOTO 20 00000980
C                                                                       00000990
CP           ADJUST BOX TO FIRST OF FORWARD-BACKWARD PAIR               00001000
          IF (L.EQ.43.OR.L.EQ.45.OR.L.EQ.49.OR.L.EQ.61.OR.L.EQ.63.      00001010
     *        OR.L.EQ.65) L = L - 1                                     00001020
      IF(L.EQ.70) L=L-3                                                 00001030
          IF (J.EQ.1) GOTO 10                                           00001040
CP           IF ILLEGAL PAIR DETECTED                                   00001050
          IF (L.EQ.NEXTL1.OR.L.EQ.NEXTL2) GOTO 10                       00001060
C           BAD COMBINATION NOW DETECTED.                               00001070
CP              PRINT MESSAGE                                           00001080
            PRINT 1000,K,(JBOX(I,K),I=1,10)                             00001090
1000        FORMAT('1 ILLEGAL BOX COMBINATION DETECTED IN BIN',I3,      00001100
     *             '.   BOXES ARE:',10I3)                               00001110
C                                                                       00001120
CP           FI                                                         00001130
CP           SET NEW COMPARAND BOXES                                    00001140
 10       NEXTL1 = NEXT(1,L)                                            00001150
          NEXTL2 = NEXT(2,L)                                            00001160
CP        FI                                                            00001170
 20       CONTINUE                                                      00001180
 30     CONTINUE                                                        00001190
CP                                                                      00001200
C   TEST FOR FIRST OF A SET OF PENETRATING FORWARD AND BACKWARD BOX     00001210
C   COMBINATIONS.  WHENEVER FOUND, IF THE CORRESPONDING BOX IS          00001220
C   ALSO FOUND IN THE SAME BIN, THEN SET THE QFB VALUES TO TRUE.        00001230
CP  INITIALIZE QFB ARRAY TO FALSE                                       00001240
      DO 50 K=1,I25                                                     00001250
        DO 50 J=1,10                                                    00001260
50        QFB(J,K) = .FALSE.                                            00001270
C                                                                       00001280
CP  FOR EACH BIN REQUESTED                                              00001290
      DO 60 K=1,NUMBIN                                                  00001300
CP     FOR EACH BOX REQUESTED                                           00001310
        DO 60 J=1,9                                                     00001320
        L = JBOX(J,K)                                                   00001330
        IF (L.EQ.0) GOTO 60                                             00001340
CP        IF (BOX IS BACKWARD PENETRATING BOX)                          00001350
        IF (L.EQ.42.OR.L.EQ.44.OR.L.EQ.48.OR.L.EQ.60.OR.L.EQ.62.        00001360
     *      OR.L.EQ.64 .OR. L .EQ.67)  GOTO 55                          00001370
        GOTO 60                                                         00001380
CP           IF (NEXT BOX IS CORRESPONDING FORWARD BOX)                 00001390
  55   CONTINUE                                                         00001400
      IF(JBOX(J+1,K) .NE. 70 .AND. L.EQ.67) GO TO 60                    00001410
      IF(JBOX(J+1,K) .EQ. 70 .AND. L.EQ.67) QFB(J,K)=.TRUE.             00001420
      IF(JBOX(J+1,K) .EQ. 70 .AND. L.EQ.67) QFB(J+1,K)=.TRUE.           00001430
        IF (JBOX(J+1,K).NE.L+1) GOTO 60                                 00001440
CP              SET QFB FLAG TO TRUE FOR BOTH THIS AND NEXT BOX         00001450
        QFB(J,K) = .TRUE.                                               00001460
        QFB(J+1,K) = .TRUE.                                             00001470
CP           FI                                                         00001480
CP        FI                                                            00001490
 60     CONTINUE                                                        00001500
C                                                                       00001510
      RETURN                                                            00001520
      END                                                               00001530
