function findnexttickfreq, l, i
  i = i + 2
  if i gt 24 then return, 0
  if (l / float(i)) mod 1 eq 0 then return, i
  return, findnexttickfreq(l, i)
end  

pro plotter_event, ev
  @plotter_common

  widget_control, ev.id, get_uvalue = uval
  
  if uval eq 'b_prev' then begin
      plotter_loadframe, curFile - 1
      return
  endif

  if uval eq 'b_next' then begin
      plotter_loadframe, curFile + 1
      return
  endif

  if uval eq 'b_settype' then begin
      graphType = 1 - graphType

      if graphType eq 0 then $
          widget_control, ev.id, set_value = 'Graph type: MLT' $
      else $
          widget_control, ev.id, set_value = 'Graph type: Magnetic Longitude'
      
      plotter_plot
      return
  endif

  if uval eq 'b_slider' then begin
      v = 0
      widget_control, ev.id, get_value = v
      v = fix(v[0])
      widget_control, w_distlabel, set_value = 'Max radius: ' + zeroPad(v, 0)
      rdist = v
      plotter_plot
      return
  endif

  if uval eq 'b_makeall' then begin
      for i = 0, n_elements(clkList) - 1 do begin
          plotter_loadframe, i
          plotter_plot, hardcopy = 1
      endfor
      return
  endif         

  if uval eq 'b_numlines' then begin
      if lineFreq eq 4 then lineFreq = 8 $
      else if lineFreq eq 8 then lineFreq = 12 $
      else if lineFreq eq 12 then lineFreq = 24 $
      else lineFreq = 4
      
      widget_control, ev.id, set_value = 'Radial lines: ' + zeroPad(lineFreq, 0)
      if (lineFreq / float(tickFreq)) mod 1 eq 0 then plotter_plot $
      else uval = 'b_numlabels'
  endif

  if uval eq 'b_numlabels' then begin
      tickFreq = findnexttickfreq(lineFreq, tickFreq)
      widget_control, w_labels, set_value = 'Tick labels: ' + zeroPad(tickFreq, 0)
      plotter_plot
      return
  endif

  if uval eq 'b_saveimage' then begin
      plotter_plot, hardcopy = 1
  endif

  if uval eq 'd_main' then begin
      if ev.press eq 1 then begin
          larad = atan(ev.y - 300, ev.x - 280)
          plotter_plot
          return
      endif
      return
  endif      
end
