pro moonfits,start_time=start_time,nframes=nframes,sensor=sensor,quick=quick

; make FITS files for moon brightness measurements

; last updated: 20-Aug-2001

; process keyword parameters
if(keyword_set(start_time)) then start=start_time else start = [2000,145,6,0]
if(keyword_set(nframes)) then nf=nframes else nf=1
if(keyword_set(sensor)) then sens = sensor else sens = 0
if(keyword_set(quick)) then use_quick = 1 else use_quick = 0

; get the UDF key and open the file
if (use_quick) then begin
    case sens of
        0: begin
            key = udf_key(vinstquick('IMES0IMG'))
        end

        1: begin
            key = udf_key(vinstquick('IMES1IMG'))
        end

        2: begin
            key = udf_key(vinstquick('IMES2IMG'))
        end
    endcase

endif else begin
    case sens of
        0: begin
            key = udf_key(vinst('IMES0IMG'))
        end

        1: begin
            key = udf_key(vinst('IMES1IMG'))
        end

        2: begin
            key = udf_key(vinst('IMES2IMG'))
        end
    endcase
endelse

fh  = udf_open(key,start)

; open a report file
openw, luout, 'report.dat', /get_lun

; do it
for i=0,nf-1 do begin
    d=udf_read(fh)
    fitsfile = 'e' + string(d.btime.year,d.btime.doy,d.btime.hour,d.btime.min,format='(i4,i3.3,i2.2,i2.2)')+ '.fits'
;;    fitsfile = 'n' + string(d.nadir_count[0],format='(i5.5)') + '.fits'

    case sens of
        0: begin
            writefits,fitsfile,d.skymap_sensor_0
        end

        1: begin
            writefits,fitsfile,d.skymap_sensor_1
        end

        2: begin
            writefits,fitsfile,d.skymap_sensor_2
        end

    endcase

    printf, luout, fitsfile, format='(a)'
    printf, luout, d.btime.year,d.btime.doy,d.btime.hour,$
      d.btime.min,d.btime.sec,$
      format='(I4,"/",I3.3,"/",I2.2,":",I2.2,":",I2.2)'
    printf, luout, string(sensor,format='(i1)')

endfor

udf_close,fh

close, luout
free_lun, luout


end
