function zeropad, num, l
  n = fix(num)
  x = strmid(strcompress(string(n)), 1, 1000)
  while(strlen(x) lt l) do x = '0' + x
  return, x
end

function itoa, i
  return, zeropad(i, 0)
end

function ftoa, i, n
  ipart = itoa(i)
  fpart = abs(i mod 1.0D)
  fpart = fpart * 10L ^ n
  fpart = zeropad(fpart, n)
  return, ipart + '.' + fpart
end


pro mooncount_event, ev
  @mooncount_common

  widget_control, ev.id, get_uvalue = info

  if info eq 'draw1' then begin
      ; mouse button down
      if ev.type eq 0 then begin
          if ev.press eq 2 then begin
              isDragging = 1
              dragY = ev.y
              return
          end
          if ev.press eq 4 then begin
              doBGsub = not doBGsub
          end              
      end

      ; mouse button up
      if ev.type eq 1 then begin
          if ev.release eq 2 then begin
              isDragging = 0
              return
          end
      end

      ; mouse movement
      if isDragging then begin              
          viewY = viewY - (ev.y - dragY) * 3
          viewY = (viewY > 0) < 1139
          dragY = ev.y
          wset, h_draw1
          Device, copy = [0, viewY, 450, 660, 0, 0, 1]
          return
      end
      
      wset, h_draw1
      Device, copy = [0, viewY, 450, 660, 0, 0, 1]
      x = (ev.x) / 3
      y = (ev.y + viewY) / 3
      
      x = (x < (149 - radius1)) > radius1
      y = (y < (599 - radius2)) > radius2
      
      x0 = x - radius1
      x1 = x + radius1
      y0 = y - radius1
      y1 = y + radius1
      
      x0_ = x0 * 3
      x1_ = x1 * 3 + 2
      y0_ = y0 * 3
      y1_ = y1 * 3 + 2
      
;          xx0 = x - radius2
;          xx1 = x + radius2
      xx0 = x0
      xx1 = x1
      yy0 = y - radius2
      yy1 = y + radius2
      
      xx0_ = xx0 * 3
      xx1_ = xx1 * 3 + 2
      yy0_ = yy0 * 3
      yy1_ = yy1 * 3 + 2
      
      c = 64
      if doBGsub then c = 255
      plots, [xx0_, xx0_, xx1_, xx1_, xx0_], $
             [yy0_, yy1_, yy1_, yy0_, yy0_] - viewY, /device, color = c * (1L + 256)
      plots, [x0_, x0_, x1_, x1_, x0_], $
             [y0_, y1_, y1_, y0_, y0_] - viewY, /device, color = 255 + 64 * 256L
      
      slice = dispdata[xx0:xx1, yy0:yy1]
      
      w = (xx1-xx0+1)
      h = (yy1-yy0+1)
      
      bgSize = radius2 - radius1

      dslice = data[xx0:xx1, yy0:yy1]

      bglev = 0
      bgavg = 0
      if doBGsub then begin
          for i=0, w-1 do begin
              bg = [dslice[i, 0:(bgSize - 1)], dslice[i, (h - bgSize):(h - 1)]]
              tmp = mean(bg)
              bglev = bglev + tmp
              dslice[i, 0:(h-1)] = dslice[i, 0:(h-1)] - tmp
          end
          bgavg = bglev / w
          slice = alog10((dslice > 0) + 1) / maxbrightlog * 255
      end

      
      scale = floor((190/w) < (450/h))
      bigW = w * scale
      bigH = h * scale

      ; find centroid
      xtotal = 0
      ytotal = 0 

      dslice = dslice > 0

      j0 = bgSize
      j1 = h - bgSize - 1
      for i = 0, w - 1 do begin
          xtotal = xtotal + i * total(dslice[i, j0:j1])
      end
      
      for j = j0, j1 do begin
          ytotal = ytotal + j * total(dslice[0:(w - 1), j])
      end
      n = total(dslice[0:(w - 1), j0:j1])
      avg = mean(dslice[0:(w - 1), j0:j1])
      xcenter = xtotal / n + xx0
      ycenter = ytotal / n + yy0
      
      xc = xcenter - xx0
      yc = ycenter - yy0
      
      bigslice = rebin(slice, bigW, bigH, /sample) > 0.01
      
      wset, h_draw2
      tv, bigslice, (190 - bigW) / 2, (450 - bigH) / 2
      plots, [(190 - bigW) / 2, (190 + bigW) / 2 - 1], $
             [225 - scale * (radius1 + .5), 225 - scale * (radius1 + .5)] - 1, $
             /device, color = 255
      plots, [(190 - bigW) / 2, (190 + bigW) / 2 - 1], $
             [225 + scale * (radius1 + .5), 225 + scale * (radius1 + .5)] - 1, $
             /device, color = 255

      plots, [(190 - bigW) / 2 + scale * (xc + .5)], $
             [(450 - bigH) / 2 + scale * (yc + .5)], /device, psym = 7, $
             symsize = 1, color = 255 * 65536L

      xstr = itoa(x)
      ystr = itoa(y)

      xcstr = ftoa(xcenter, 2)
      ycstr = ftoa(ycenter, 2)   
      
      avgstr = ftoa(avg, 3)
      ast = '*'
      if doBGsub then ast = ''

      bglevstr = '[right click]'      
      if doBGsub then bglevstr = ftoa(bgavg, 3)

      widget_control, w_label2, set_value = '(x, y) = (' + xstr + ', ' + ystr + ')'
      
      widget_control, w_label3, set_value = 'Centroid = (' + xcstr + ', ' + ycstr + ')'
      
      widget_control, w_label4, set_value = 'Avg. brightness = ' + avgstr + ast
      
      widget_control, w_label5, set_value = 'BG level = ' + bglevstr

      if ev.type eq 0 then $
          if ev.press eq 1 then begin
              count1 = (radius1 * 2 + 1) ^ 2
              count2 = (radius1 * 2 + 1) * (radius2 * 2 + 1) - count1
              if not doBGsub then count2 = 0
              get_lun, f
              if not file_test('out.txt') then begin
                  openw, f, 'out.txt'
                  printf, f, 'year    DOY    Julian Date    phase   range     x    y     xc      yc     count   bg_lev  #pix  #bgp    time stamp'
                  printf, f, '----  -------  ------------  ------  --------  ---  ---  ------  ------  -------  ------  ----  ----  --------------'
              endif else openw, f, 'out.txt', /append
;              printf, f, x, y, xcenter, ycenter, avg, bgavg
              jul = julday(1, floor(date_doy), date_year, (date_doy mod 1.0D) * 24)
              printf, f, format = '(I4, F9.3, F14.4, F8.2, F10.1, I5, I5, F8.2, ' + $
                                  'F8.2, F9.3, F8.3, I6, I6, "  ", A14)', $
                      date_year, date_doy, jul, phase, range, x, y, xcenter, ycenter, avg, bgavg, $
                      count1, count2, date_str
              close, f
              free_lun, f
              mc_loadframe, [next_year, next_doy, next_hour, next_min]

          end
      return
  end

  if info eq 'slider2' or info eq 'slider3' then begin
      wset, h_draw2
      polyfill, [-1, -1, 2, 2], [-1, 2, 2, -1], /normal, color = 192 * (1 + 256 + 65536)
      
      widget_control, w_slider2, get_value = v0
      widget_control, w_slider3, get_value = v1
      
      radius1 = v0
      radius2 = v0 + v1      

      return
  end

  if info eq 'text1' then begin
      error = 0
      widget_control, w_text1, get_value = x

      if strlen(x) lt 14 then error = 1
      if strmid(x, 4, 1) ne '/' then error = 1
      if strmid(x, 8, 1) ne '/' then error = 1
      if strmid(x, 11, 1) ne ':' then error = 1
      year = fix(strmid(x, 0, 4))
      doy = fix(strmid(x, 5, 3))
      hour = fix(strmid(x, 9, 2))
      min = fix(strmid(x, 12, 2))
      if year lt 2000 or year gt 2100 then error = 1
      if doy lt 1 or doy gt 366 then error = 1
      if hour lt 0 or hour gt 23 then error = 1
      if min lt 0 or min gt 59 then error = 1

      if error eq 1 then begin
          widget_control, w_text1, set_value = date_str
          return
      end

      print, 'Loading ', year, doy, hour, min

      mc_loadframe, [year, doy, hour, min]      
  end
end
