function zeropad, i, l
  n = fix(i)
  x = strmid(strcompress(string(n)), 1, 1000)
  while(strlen(x) lt l) do x = '0' + x
  return, x
end

function fromBin, s
  j = 0L
  m = 1L
  for i = 0L, 15 do begin
      n = strmid(s, 15 - i, 1)
      j = j + n * m
      m = m * 2
  end
  return, j
end

pro mooncount
  @mooncount_common

  curx = 0
  cury = 0
  
  curs = ['0000000000000000', $
          '0000000000000000', $
          '0010000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000', $
          '0000000000000000']
  
  curs = fromBin(curs)
  
  w_base = widget_base(xsize = 690, ysize = 679)

  w_label1 = widget_label(w_base, xoffset = 10, yoffset = 10, $
                          value = 'Date:')

  w_text1 = widget_text(w_base, scr_xsize = 120, xoffset = 10, yoffset = 32, $
                        value = '2002/180/00:00', /editable, uvalue = 'text1')

  w_button1 = widget_button(w_base, xsize = 65, ysize = 31, xoffset = 135, yoffset = 32, $
                            value = 'Go')

  w_slider2 = widget_slider(w_base, xoffset = 10, yoffset = 70, value = 3, minimum = 1, $
                            xsize = 190, maximum = 10, /suppress_value, uvalue = 'slider2', $
                            scroll = 1)

  w_slider3 = widget_slider(w_base, xoffset = 10, yoffset = 94, value = 5, minimum = 1, $
                            xsize = 190, maximum = 32, /suppress_value, uvalue = 'slider3', $
                            scroll = 1)

  w_slider1 = widget_slider(w_base, xoffset = 659, ysize = 660, yoffset = 10, value = 570, $
                           maximum = 1139, minimum = 0, /vertical, /suppress_value, $
                           uvalue = 'slider1')
  
  w_draw1 = widget_draw(w_base, xsize = 449, ysize = 660, $
                        xoffset = 210, yoffset = 10, uvalue = 'draw1', $
                        /motion_events, /button_events)

  w_draw2 = widget_draw(w_base, xsize = 190, ysize = 450, $
                        xoffset = 10, yoffset = 220, uvalue = 'draw2')

  w_label2 = widget_label(w_base, xsize = 190, xoffset = 10, yoffset = 120, $
                          value = '(x, y) = (n/a, n/a)')
   
  w_label3 = widget_label(w_base, xsize = 190, xoffset = 10, yoffset = 136, $
                          value = 'Centroid = (n/a, n/a)')
   
  w_label4 = widget_label(w_base, xsize = 190, xoffset = 10, yoffset = 152, $
                          value = 'Avg. brightness = n/a')
   
  w_label5 = widget_label(w_base, xsize = 190, xoffset = 10, yoffset = 168, $
                          value = 'BG level = [right click]')
   
                                ; display window
  widget_control, w_base, /realize
    
  device, cursor_image = curs, cursor_xy = [4, 12]
  
  device, retain = 2
  
  widget_control, w_draw1, get_value = h_draw1
  widget_control, w_draw2, get_value = h_draw2

  wset, h_draw2
  polyfill, [-1, -1, 2, 2], [-1, 2, 2, -1], /normal, color = 192 * (1 + 256 + 65536)
  
                                ; setup invisible graphics buffers
  window, 1, /Pixmap, XSize = 450, YSize = 1800
  
  viewY = 570
  doBGsub = 0
  radius1 = 3
  radius2 = 8 

  mc_loadframe, [2002, 180, 0, 0]

  isDragging = 0

                                ; initialize event handler
  xmanager, 'mooncount', w_base
end
