function zeropad, i, l
  n = fix(i)
  x = strmid(strcompress(string(n)), 1, 1000)
  while(strlen(x) lt l) do x = '0' + x
  return, x
end

function itoa, i
  return, zeropad(i, 0)
end

pro mc_loadframe, date
  @mooncount_common

  year = date[0]
  doy = date[1]

  if (year mod 4) eq 0 then ndays = 366 else ndays = 365

  doy = doy + 2
  if doy gt ndays then begin
      doy = doy mod ndays
      year = year + 1
  endif

  print, year, doy

  date = [date, 59]

  data = fltarr(150, 600)

  key = udf_key(vinst('IMES2IMG'))
  fh = udf_open(key, date, [year, doy, 23, 59], baseunit = 1)
  d = udf_read(fh)
  data(0:49, 0:599) = d.skymap_sensor_2
  udf_close, fh

  key = udf_key(vinst('IMES1IMG'))
  fh = udf_open(key, date, [year, doy, 23, 59], baseunit = 1)
  d = udf_read(fh)
  data(50:99, 0:599) = d.skymap_sensor_1
  udf_close, fh

  key = udf_key(vinst('IMES0IMG'))
  fh = udf_open(key, date, [year, doy, 23, 59], baseunit = 1)
  d = udf_read(fh)
  data(100:149, 0:599) = d.skymap_sensor_0

  dispdata = alog10(data + 1)
  maxbrightlog = max(dispdata)
  dispdata = dispdata / maxbrightlog * 255
  dispdataBig = rebin(dispdata, 450, 1800, /sample)
  wset, 1
  tv, dispdataBig

  wset, h_draw1
  Device, copy = [0, viewY, 450, 660, 0, 0, 1]

  date_str = zeropad(d.btime.year,4)+'/'+zeropad(d.btime.doy,3)+$
            '/'+zeropad(d.btime.hour,2)+':'+zeropad(d.btime.min,2)

  date_year = fix(d.btime.year)
  date_doy = double(d.btime.doy) + (double(d.btime.hour) + (double(d.btime.min) / 60.0)) / 24.0

  widget_control, w_text1, set_value = date_str

  s0 = udf_read(fh)
  next_year = s0.btime.year
  next_doy = s0.btime.doy
  next_hour = s0.btime.hour
  next_min = s0.btime.min
  udf_close, fh

  ; get phase information
  jdmid = calc_jd(date[0],date[1],date[2],date[3],59,0) - (180.0/86400.0)
  jdorb = calc_jd(date[0],date[1],date[2],date[3],59,0) - (300.0/86400.0)

  caldat,jdmid+2400000.0,emonth,eday,eyear,eh,em,es
  edoy=getdoy(eyear,emonth,eday)
  caldat,jdorb+2400000.0,omonth,oday,oyear,oh,om,os
  odoy=getdoy(oyear,omonth,oday)

  syear = date[0]
  sdoy = date[1]
  shour = date[2]
  smin = date[3]
  ssec = 0

  jdtemp = calc_jd(syear, sdoy, shour, smin, ssec, 0) + 2400000.0d0
  jdtemp = jdtemp - (15.0/1440.0) ; back up 15 minute
  caldat, jdtemp, new_month, new_day, new_year, new_hour, new_minute, new_second
  syear = fix(new_year)
  sdoy = fix(getdoy(new_year, new_month, new_day))
  shour = fix(new_hour)
  smin = fix(new_minute)
  ssec = fix(new_second)


  korb = udf_key(vinst('IMOORBIT'))
  forb = udf_open(korb,[syear, sdoy, shour, smin],[syear, sdoy+1, shour, smin], baseunit = 1)

  if ( not udf_eof(forb)) then orb1 = udf_read(forb)
  jorb1 = load_jdate(orb1.btime)
  orb2 = orb1

  ; find bracketing records
  jd = jdmid
  while ( load_jdate(orb2.btime) le jd) do begin
      orb1 = orb2
      if ( not udf_eof(forb)) then orb2 = udf_read(forb)
  endwhile
  
  jorb1 = load_jdate(orb1.btime)
  jorb2 = load_jdate(orb2.btime)

  gci_satellite_pos = fltarr(3)
  gci_solar_pos     = fltarr(3)
  gci_lunar_pos     = fltarr(3)

  gci_satellite_pos[0] = interpol([orb1.gci_satellite_pos__x,orb2.gci_satellite_pos__x],[jorb1,jorb2],jd) * 6378.0
  gci_satellite_pos[1] = interpol([orb1.gci_satellite_pos__y,orb2.gci_satellite_pos__y],[jorb1,jorb2],jd) * 6378.0
  gci_satellite_pos[2] = interpol([orb1.gci_satellite_pos__z,orb2.gci_satellite_pos__z],[jorb1,jorb2],jd) * 6378.0
  gci_solar_pos[0] = interpol([orb1.gci_solar_pos__x,orb2.gci_solar_pos__x],[jorb1,jorb2],jd)
  gci_solar_pos[1] = interpol([orb1.gci_solar_pos__y,orb2.gci_solar_pos__y],[jorb1,jorb2],jd)
  gci_solar_pos[2] = interpol([orb1.gci_solar_pos__z,orb2.gci_solar_pos__z],[jorb1,jorb2],jd)
  gci_lunar_pos[0] = interpol([orb1.gci_lunar_pos__x,orb2.gci_lunar_pos__x],[jorb1,jorb2],jd)
  gci_lunar_pos[1] = interpol([orb1.gci_lunar_pos__y,orb2.gci_lunar_pos__y],[jorb1,jorb2],jd)
  gci_lunar_pos[2] = interpol([orb1.gci_lunar_pos__z,orb2.gci_lunar_pos__z],[jorb1,jorb2],jd)
  moon2sun = -gci_lunar_pos + gci_solar_pos
  moon2sc  = -gci_lunar_pos + gci_satellite_pos
  moon2sunmag = vmag(moon2sun[0],moon2sun[1],moon2sun[2])
  moon2scmag  = vmag(moon2sc[0],moon2sc[1],moon2sc[2])
  dot = transpose(moon2sun)#moon2sc
  phase = acos( ( dot / (moon2sunmag * moon2scmag) ) ) * !RADEG

  range = moon2scmag

  udf_close, forb
end
