function findr, yy, dd, hh, mm
    ss = 0

    jdmid = calc_jd(yy,dd,hh,mm,ss,0) - (180.0/86400.0)
    jdorb = calc_jd(yy,dd,hh,mm,ss,0) - (300.0/86400.0)

    caldat,jdmid+2400000.0,emonth,eday,eyear,eh,em,es
    edoy=getdoy(eyear,emonth,eday)
    caldat,jdorb+2400000.0,omonth,oday,oyear,oh,om,os
    odoy=getdoy(oyear,omonth,oday)
    
                                ; get the orbit data and determine the
                                ; phase angle
    korb = udf_key(vinst('IMOORBIT'))
    forb = udf_open(korb,[oyear, odoy, oh, om],[oyear, odoy+1, oh, om])


    if ( not udf_eof(forb)) then orb1 = udf_read(forb)
    jorb1 = load_jdate(orb1.btime)
    orb2 = orb1

; find bracketing records
    jd = jdmid
    while ( load_jdate(orb2.btime) le jd) do begin
        orb1 = orb2
        if ( not udf_eof(forb)) then orb2 = udf_read(forb)
    endwhile

    jorb1 = load_jdate(orb1.btime)
    jorb2 = load_jdate(orb2.btime)


;;print, jorb1, jorb2, jd

; time-interpolate the required orbit data
    gci_satellite_pos = fltarr(3)
    gci_lunar_pos     = fltarr(3)


    gci_satellite_pos[0] = interpol([orb1.gci_satellite_pos__x,orb2.gci_satellite_pos__x],[jorb1,jorb2],jd) * 6378.0
    gci_satellite_pos[1] = interpol([orb1.gci_satellite_pos__y,orb2.gci_satellite_pos__y],[jorb1,jorb2],jd) * 6378.0
    gci_satellite_pos[2] = interpol([orb1.gci_satellite_pos__z,orb2.gci_satellite_pos__z],[jorb1,jorb2],jd) * 6378.0
    gci_lunar_pos[0] = interpol([orb1.gci_lunar_pos__x,orb2.gci_lunar_pos__x],[jorb1,jorb2],jd)
    gci_lunar_pos[1] = interpol([orb1.gci_lunar_pos__y,orb2.gci_lunar_pos__y],[jorb1,jorb2],jd)
    gci_lunar_pos[2] = interpol([orb1.gci_lunar_pos__z,orb2.gci_lunar_pos__z],[jorb1,jorb2],jd)

    udf_close,forb
    
    moon2sc  = -gci_lunar_pos + gci_satellite_pos
    moon2scmag  = vmag(moon2sc[0],moon2sc[1],moon2sc[2])

    return, moon2scmag
end

pro getrange
  infile = '../2002180-2002351.txt'
  outfile = 'out.txt'
  
  buffer = ''
  
  get_lun, f
  get_lun, ff
  openr, f, infile
  openw, ff, outfile

  printf, ff, 'year    DOY    Julian Date    phase   range     x    y     xc      yc     count   bg_lev  #pix  #bgp    time stamp'
  printf, ff, '----  -------  ------------  ------  --------  ---  ---  ------  ------  -------  ------  ----  ----  --------------'

  readf, f, buffer
  readf, f, buffer

  jul = 0D
  date_str = ''
  tmp = ''

  while(not eof(f)) do begin
      readf, f, format = '(I4, F9.3, F14.4, F8.2, I5, I5, F8.2, ' + $
             'F8.2, F9.3, F8.3, I6, I6, A2, A14)', $
             date_year, date_doy, jul, phase, x, y, xcenter, ycenter, $
             avg, bgavg, count1, count2, tmp, date_str
      year = fix(strmid(date_str, 0, 4))
      doy = fix(strmid(date_str, 5, 3))
      hour = fix(strmid(date_str, 9, 2))
      min = fix(strmid(date_str, 13, 2))
      print, '[' + date_str + '] ...'
      range = findr(year, doy, hour, min)
      printf, ff, format = '(I4, F9.3, F14.4, F8.2, F10.1, I5, I5, F8.2, ' + $
             'F8.2, F9.3, F8.3, I6, I6, A2, A14)', $
             date_year, date_doy, jul, phase, range, x, y, xcenter, ycenter, $
             avg, bgavg, count1, count2, tmp, date_str

  end

  close, f
  close, ff
  free_lun, f
  free_lun, ff
end
