pro view_setup_tab, w_tab
  @view_common

  tab_view_outer = widget_base(w_tab, title = 'View')
  tab_view_inner = widget_tab(tab_view_outer, scr_xsize = 250, scr_ysize = 282,$
                          xoffset = 2, yoffset = 4)

  tab_view_grid = widget_base(tab_view_inner, title = 'Grid')

  w_view_base0 = widget_base(tab_view_grid, xsize = 248, ysize = 24, /nonexclusive, $
                             xoffset = 0, yoffset = 0)

  w_button_lines = widget_button(w_view_base0, xsize = 240, ysize = 21, $
				   value = 'Magnetic longitude lines', $
				   uvalue = 'lines')

  w_view_base1 = widget_base(tab_view_grid, xsize = 232, ysize = 50, /nonexclusive, $
                             xoffset = 20, yoffset = 22)

  w_button_dotted0 = widget_button(w_view_base1, xsize = 220, ysize = 22, $
				  value = 'Dotted', sensitive = 0, $
				  uvalue = 'dotted0')

  w_button_fewer0 = widget_button(w_view_base1, xsize = 220, ysize = 22, $
				  value = 'Draw fewer lines', sensitive = 0, $
				  uvalue = 'fewer0')

  w_color0 = widget_draw(tab_view_grid, xoffset = 23, yoffset = 74, $
                         xsize = 34, ysize = 34)

  w_slider_r0 = widget_slider(tab_view_grid, xoffset = 59, yoffset = 74, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 100, uvalue = 'color0', $
			      sensitive = 0)
  w_slider_g0 = widget_slider(tab_view_grid, xoffset = 59, yoffset = 86, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 150, uvalue = 'color0', $
			      sensitive = 0)
  w_slider_b0 = widget_slider(tab_view_grid, xoffset = 59, yoffset = 98, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 220, uvalue = 'color0', $
			      sensitive = 0)
  

  rcoffs = 112

  w_view_base2 = widget_base(tab_view_grid, xsize = 248, ysize = 24, /nonexclusive, $
                             xoffset = 0, yoffset = 0 + rcoffs)

  w_button_circles = widget_button(w_view_base2, xsize = 240, ysize = 21, $
				   value = 'Radial circles', uvalue = 'circles')

  w_view_base3 = widget_base(tab_view_grid, xsize = 232, ysize = 76, /nonexclusive, $
                             xoffset = 20, yoffset = 22 + rcoffs)

  w_button_dotted1 = widget_button(w_view_base3, xsize = 220, ysize = 22, $
				  value = 'Dotted', sensitive = 0, $
				  uvalue = 'dotted1')

  w_button_fewer1 = widget_button(w_view_base3, xsize = 220, ysize = 22, $
				  value = 'Draw fewer circles', sensitive = 0, $
				  uvalue = 'fewer1')

  w_button_samecolor = widget_button(w_view_base3, xsize = 220, ysize = 22, $
		                     value = 'Same color as lines', $
				     sensitive = 0, uvalue = 'samecolor')

  w_color1 = widget_draw(tab_view_grid, xoffset = 23, yoffset = 100 + rcoffs, $
                         xsize = 34, ysize = 34)

  w_slider_r1 = widget_slider(tab_view_grid, xoffset = 59, yoffset = 100 + rcoffs, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 100, uvalue = 'color1', $
			      sensitive = 0)
  w_slider_g1 = widget_slider(tab_view_grid, xoffset = 59, yoffset = 112 + rcoffs, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 150, uvalue = 'color1', $
			      sensitive = 0)
  w_slider_b1 = widget_slider(tab_view_grid, xoffset = 59, yoffset = 124 + rcoffs, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 220, uvalue = 'color1', $
			      sensitive = 0)

  ; -------------------------------------------------------------------------
  tab_view_labels = widget_base(tab_view_inner, title = 'Labels', xsize = 244)
  
  w_view_base4 = widget_base(tab_view_labels, xsize = 248, ysize = 24, /nonexclusive, $
                             xoffset = 0, yoffset = 0)

  w_button_labels = widget_button(w_view_base4, xsize = 220, ysize = 21, $
		                  value = 'Distance labels', $
				  uvalue = 'labels')
  
  w_view_base5 = widget_base(tab_view_labels, xsize = 232, ysize = 24, /nonexclusive, $
                             xoffset = 20, yoffset = 22)

  w_button_fewer2 = widget_button(w_view_base5, xsize = 220, ysize = 22, $
				  value = 'Fewer labels', sensitive = 0, $
				  uvalue = 'fewer2')

  w_color2 = widget_draw(tab_view_labels, xoffset = 23, yoffset = 52, $
                         xsize = 34, ysize = 34)

  w_slider_r2 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 52, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 0, uvalue = 'color2', $
			      sensitive = 0)
  w_slider_g2 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 64, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 0, uvalue = 'color2', $
			      sensitive = 0)
  w_slider_b2 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 76, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 0, uvalue = 'color2', $
			      sensitive = 0)
  
  w_color3 = widget_draw(tab_view_labels, xoffset = 23, yoffset = 90, $
                         xsize = 34, ysize = 34)

  w_slider_r3 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 90, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 255, uvalue = 'color3', $
			      sensitive = 0)
  w_slider_g3 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 102, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 255, uvalue = 'color3', $
			      sensitive = 0)
  w_slider_b3 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 114, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 255, uvalue = 'color3', $
			      sensitive = 0)

  w_color4 = widget_draw(tab_view_labels, xoffset = 23, yoffset = 128, $
                         xsize = 34, ysize = 34)

  w_slider_r4 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 128, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 0, uvalue = 'color4', $
			      sensitive = 0)
  w_slider_g4 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 140, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 0, uvalue = 'color4', $
			      sensitive = 0)
  w_slider_b4 = widget_slider(tab_view_labels, xoffset = 59, yoffset = 152, $
                              xsize = 183, ysize = 10, minimum = 0, /drag, $
			      maximum = 255, value = 0, uvalue = 'color4', $
			      sensitive = 0)
  
  w_label_label_size = widget_label(tab_view_labels, xoffset = 23, $
                              yoffset = 168, xsize = 220, ysize = 14, $
			      value = 'Label size = 12', /align_left, $
			      sensitive = 0)

  w_slider_label_size = widget_slider(tab_view_labels, xoffset = 23, $
                              yoffset = 182, $
                              xsize = 220, ysize = 20, minimum = 6, /drag, $
			      maximum = 32, value = 12, uvalue = 'label_size', $
			      sensitive = 0)

  w_label_label_offs = widget_label(tab_view_labels, xoffset = 23, $
                              yoffset = 206, xsize = 220, ysize = 14, $
			      value = 'Label offset = 0', /align_left, $
			      sensitive = 0)

  w_slider_label_offs = widget_slider(tab_view_labels, xoffset = 23, $
                              yoffset = 220, $
                              xsize = 220, ysize = 20, minimum = 0, /drag, $
			      maximum = 720, value = 0, uvalue = 'label_offs', $
			      sensitive = 0)
  
  ; -------------------------------------------------------------------------
  tab_view_settings = widget_base(tab_view_inner, title = 'Settings', xsize = 244)

  w_button_loaddefault = widget_button(tab_view_settings, xsize = 242, $
                              ysize = 24, xoffset = 2, yoffset = 4, $
			      value = 'Load default', uvalue = 'loaddef')
  
  w_button_savedefault = widget_button(tab_view_settings, xsize = 242, $
                              ysize = 24, xoffset = 2, yoffset = 32, $
			      value = 'Save current as default', uvalue = 'savedef')
  
end
