pro view_setup_defaults
  @view_common

  view_draw_dragging = 0
  
  if ( file_test('view_settings.sav') eq 0) then begin
    view_lines = 0
    view_lines_dotted = 1
    view_lines_fewer = 0 
    view_lines_r = 100
    view_lines_g = 150
    view_lines_b = 220
    view_circles = 0
    view_circles_dotted = 1 
    view_circles_fewer = 0
    view_circles_samecolor = 1
    view_circles_r = 100
    view_circles_g = 150
    view_circles_b = 220
    view_labels = 0
    view_labels_fewer = 0
    view_labels_c_outer = '000000'xul
    view_labels_c_bg = 'ffffff'xul
    view_labels_c_text = '000000'xul
    view_labels_size = 12
    view_labels_offs = 0
  endif else begin
    restore, filename = 'view_settings.sav'
  endelse

  widget_control, w_button_lines, set_button = view_lines
  widget_control, w_button_dotted0, sensitive = view_lines
  widget_control, w_button_fewer0, sensitive = view_lines
  widget_control, w_slider_r0, sensitive = view_lines
  widget_control, w_slider_g0, sensitive = view_lines
  widget_control, w_slider_b0, sensitive = view_lines
  
  widget_control, w_button_dotted0, set_button = view_lines_dotted 
  widget_control, w_button_fewer0, set_button = view_lines_fewer 
  widget_control, w_slider_r0, set_value = view_lines_r
  widget_control, w_slider_g0, set_value = view_lines_g
  widget_control, w_slider_b0, set_value = view_lines_b
  
  widget_control, w_button_circles, set_button = view_circles
  widget_control, w_button_dotted1, sensitive = view_circles
  widget_control, w_button_fewer1, sensitive = view_circles
  widget_control, w_button_samecolor, sensitive = view_circles

  enable_colors = view_circles and not view_circles_samecolor
  widget_control, w_slider_r1, sensitive = enable_colors 
  widget_control, w_slider_g1, sensitive = enable_colors  
  widget_control, w_slider_b1, sensitive = enable_colors      
    
  widget_control, w_button_dotted1, set_button = view_circles_dotted 
  widget_control, w_button_fewer1, set_button = view_circles_fewer 
  widget_control, w_button_samecolor, set_button = view_circles_samecolor 
  widget_control, w_slider_r1, set_value = view_circles_r
  widget_control, w_slider_g1, set_value = view_circles_g
  widget_control, w_slider_b1, set_value = view_circles_b

  widget_control, w_button_labels, set_button = view_labels
  widget_control, w_slider_r2, sensitive = view_labels
  widget_control, w_slider_g2, sensitive = view_labels 
  widget_control, w_slider_b2, sensitive = view_labels 
  widget_control, w_slider_r3, sensitive = view_labels
  widget_control, w_slider_g3, sensitive = view_labels 
  widget_control, w_slider_b3, sensitive = view_labels 
  widget_control, w_slider_r4, sensitive = view_labels
  widget_control, w_slider_g4, sensitive = view_labels 
  widget_control, w_slider_b4, sensitive = view_labels 
  widget_control, w_slider_label_size, sensitive = view_labels  
  widget_control, w_label_label_size, sensitive = view_labels  
  widget_control, w_slider_label_offs, sensitive = view_labels  
  widget_control, w_label_label_offs, sensitive = view_labels 
  widget_control, w_button_fewer2, sensitive = view_labels       
  
  widget_control, w_button_fewer2, set_button = view_labels_fewer 
  
  r = (view_labels_c_outer and '0000ff'xul) / '000001'xul
  g = (view_labels_c_outer and '00ff00'xul) / '000100'xul
  b = (view_labels_c_outer and 'ff0000'xul) / '010000'xul
  widget_control, w_slider_r2, set_value = r  
  widget_control, w_slider_g2, set_value = g  
  widget_control, w_slider_b2, set_value = b

  r = (view_labels_c_bg and '0000ff'xul) / '000001'xul
  g = (view_labels_c_bg and '00ff00'xul) / '000100'xul
  b = (view_labels_c_bg and 'ff0000'xul) / '010000'xul
  widget_control, w_slider_r3, set_value = r  
  widget_control, w_slider_g3, set_value = g  
  widget_control, w_slider_b3, set_value = b

  r = (view_labels_c_text and '0000ff'xul) / '000001'xul
  g = (view_labels_c_text and '00ff00'xul) / '000100'xul
  b = (view_labels_c_text and 'ff0000'xul) / '010000'xul
  widget_control, w_slider_r4, set_value = r  
  widget_control, w_slider_g4, set_value = g  
  widget_control, w_slider_b4, set_value = b
  
  widget_control, w_slider_label_size, set_value = view_labels_size
  s = "Label size = " + zeropad(view_labels_size, 0)
  widget_control, w_label_label_size, set_value = s
    
  widget_control, w_slider_label_offs, set_value = fix(view_labels_offs * 2)
  s = "Label offset = " + zeropad(fix(view_labels_offs), 0)
  widget_control, w_label_label_offs, set_value = s

  widget_control, w_color0, get_value = h_color0
  widget_control, w_color1, get_value = h_color1
  widget_control, w_color2, get_value = h_color2
  widget_control, w_color3, get_value = h_color3
  widget_control, w_color4, get_value = h_color4
 
  wset, h_color0
  c = '010000'xul * view_lines_b + $
      '000100'xul * view_lines_g + $
      '000001'xul * view_lines_r
  polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = c  
  
  wset, h_color1
  c = '010000'xul * view_circles_b + $
      '000100'xul * view_circles_g + $
      '000001'xul * view_circles_r
  polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = c  

  wset, h_color2
  polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = view_labels_c_outer
  wset, h_color3
  polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = view_labels_c_bg 
  wset, h_color4
  polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = view_labels_c_text 
end
